package org.eaglei.datatools.client.ui.widgets;

import java.util.List;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.UIMessages;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;

public class EIResourceListWidget extends EditWidget {

	private static final String CREATE_NEW_VALUE = "<create new>";
	private static final String NO_VALUE = "<none>";
	private static final int CREATE_NEW_INDEX = 1;
	private final ListBox instances = new ListBox();
	private final EIClass range;
	private final boolean shouldHaveLabel;
	private final boolean isPropertyProviderRelated;
	private final NewInnerInstanceListener listener;
	private final FlowPanel valuePanel;
	private StubWidget stubWidget;
	private Anchor allProvidersAnchor;
	private Label stubMessage;
	private final Anchor changeProviderLink;
	
	private static GWTLogger log = GWTLogger.getLogger( "EIResourceListWidget" );

	public EIResourceListWidget(final EIInstance instance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIEntity selectedEntity, final boolean shouldShowLabel,
			final boolean isPropertyProviderRelated, final NewInnerInstanceListener listener) {

		super( instance, propertyEntity, propertyDefinition, isRequired );

		this.range = range;
		this.listener = listener;

		if ( selectedEntity != null && selectedEntity != EIEntity.NULL_ENTITY ) {
			oldValue = selectedEntity.getURI().toString();
			if ( selectedEntity.getLabel().equals( "" ) || selectedEntity.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ) {
				selectedEntity.setLabel( selectedEntity.getURI().toString() );
			}
		}
		shouldHaveLabel = shouldShowLabel;
		if ( !shouldHaveLabel ) {
			widgetPanel.remove( label );
		}

		this.isPropertyProviderRelated = isPropertyProviderRelated;

		valuePanel = new FlowPanel();
		valuePanel.setStyleName( "ResourceListPanel" );
		widgetPanel.add( valuePanel );
		changeProviderLink = new Anchor( DatatoolsUIConstants.CHANGE_PROVIDER );
		stubMessage = new Label( UIMessages.STUB_TO_BE_COMPLETED );
		stubMessage.setStyleName( "commentOnComments" );
		setup();

		intializeInstances( selectedEntity );
	}

	private void intializeInstances(EIEntity selectedEntity) {

		instances.setStyleName( "formDropdown" );
		addDefaultInstanceValues();
		if ( range.equals( EIClass.NULL_CLASS ) ) {
			log.info( "skipping get instances" );
			if ( hasOldValue() ) {
				instances.removeItem( instances.getItemCount() - 1 );
				final String probablyDeletedLabel = "[non-standard link] " + getOldStringValue();
				instances.addItem( probablyDeletedLabel, getOldStringValue() );
				instances.setSelectedIndex( instances.getItemCount() - 1 );
			}
		} else {

			if ( !isInProvider() ) {
				// fill the instance list with all the resources if not in resource provider
				fillListBoxWithResources( false, EIURI.NULL_EIURI, selectedEntity );
			} else {
				// fill the instances list with resources from current resource provider if in resource provider
				fillListBoxWithResources( true, ApplicationState.getInstance().getResourceProviderUri(), selectedEntity );
			}
		}

		instances.addChangeHandler( new ChangeHandler() {
			@Override
			public void onChange(final ChangeEvent arg0) {
				doOnChange( eiInstance, range, propertyEntity, oldValue, instances );
			}
		} );
	}

	/**
	 *loads the list box with the resources
	 * 
	 * @param boolean onlyFromThisProvider if this value is passed true then it only loads the resources from the current resource provider
	 *@param providerEIURI
	 *            if user click "From All labs and organizations" this is passed NULL_EIURI otherwise its passed with resource provider uri
	 * 
	 */
	private void fillListBoxWithResources(final boolean onlyFromThisProvider, final EIURI providerEIURI, final EIEntity selectedEntity) {

		instances.clear();
		instances.addItem( DatatoolsUIConstants.LOADING_MESSAGE, null );

		log.debug( "requesting resource list for " + range.getEntity().getURI() );

		// TODO refine state
		// Note that the boolean is combined with "is this a provider range" (because providers are not associated to providers, but they need to show for provider property to be set)
		// FIXME: Remove this hack when the range for location is fixed.
		EIURI correctedRange = getCorrectRangeUri( range );
		ClientRepositoryToolsManager.INSTANCE.listResourcesForObjectPropertyValue( correctedRange, providerEIURI, EIURI.NULL_EIURI, !isPropertyProviderRelated && onlyFromThisProvider, new RootAsyncCallback<List<EIInstanceMinimal>>() {
			public void onSuccess(final List<EIInstanceMinimal> result) {

				if ( hasOldValue() && onlyFromThisProvider && oldValueMissingFromResult( result ) && !listener.isAddedInstanceEntity( selectedEntity ) ) {

					ClientRepositoryToolsManager.INSTANCE.listResourcesForObjectPropertyValue( range.getEntity().getURI(), providerEIURI, EIURI.NULL_EIURI, false, new RootAsyncCallback<List<EIInstanceMinimal>>() {
						@Override
						public void onSuccess(final List<EIInstanceMinimal> result) {
							setInstancesAndPickLists( false, result, selectedEntity );
							allProvidersAnchor.setText( DatatoolsUIConstants.FROM_ONLY_CURRENT_PROVIDER );
							allProvidersAnchor.setVisible( false );
						}

					} );
				}

				setInstancesAndPickLists( onlyFromThisProvider, result, selectedEntity );
			}

		} );

	}

	private void setInstancesAndPickLists(final boolean onlyFromThisProvider, final List<EIInstanceMinimal> result, final EIEntity selectedEntity) {
		instances.clear();
		instances.addItem( NO_VALUE, null );
		instances.addItem( CREATE_NEW_VALUE, null );
		// Move resources with current provider to beginning of the list ONLY if the list contains resources from all
		if ( !onlyFromThisProvider && ApplicationState.getInstance().hasResourceProvider() ) {
			for (int i = 0, j = result.size() - 1; i < result.size(); i++) {
				if ( result.get( j ).getLab().equals( ApplicationState.getInstance().getResourceProviderEntity() ) ) {
					result.add( 0, result.remove( j ) );
				} else {
					j--;
				}
			}
		}
		
		for (final EIInstanceMinimal instance : result) {
			instances.addItem( formatInstanceForListBox( instance ), instance.getInstanceURI().toString() );
			if ( ApplicationState.getInstance().hasResourceProvider() && instance.getLab().equals( ApplicationState.getInstance().getResourceProviderEntity() ) ) {
				final Element childElement = (Element)instances.getElement().getChild( instances.getItemCount() - 1 );
				childElement.setClassName( "ownlabTxt" );
			}
			if ( instance.getInstanceURI().toString().equals( oldValue ) ) {
				instances.setSelectedIndex( instances.getItemCount() - 1 );
			}
		}
		
		// create a stub widget for the selected 
		log.debug("selected entity" + selectedEntity + "; selected index: " + instances.getSelectedIndex() + "; is added instance? " + listener.isAddedInstanceEntity( selectedEntity ) );
		if ( (instances.getSelectedIndex() == 0 ) && listener.isAddedInstanceEntity( selectedEntity )  ) {
			instances.setSelectedIndex( CREATE_NEW_INDEX );
			addStubWidget( range, selectedEntity, listener.getAddedInstance( selectedEntity ) );
		}
	}

	private boolean oldValueMissingFromResult(List<EIInstanceMinimal> fetchedInstances) {
		final EIURI oldUri = EIURI.create( oldValue );

		for (EIInstanceMinimal instance : fetchedInstances) {
			if ( instance.getInstanceURI().equals( oldUri ) ) {
				return false;
			}
		}

		return true;
	}

	private void addDefaultInstanceValues() {
		instances.addItem( NO_VALUE, null );
		instances.addItem( CREATE_NEW_VALUE, null );
		instances.addItem( DatatoolsUIConstants.LOADING_MESSAGE, null );
	}

	private void doOnChange(final EIInstance instance, final EIClass range, final EIEntity propertyEntity, final String propertyValue, final ListBox subClassList) {
		if ( subClassList.getItemText( subClassList.getSelectedIndex() ).equals( NO_VALUE ) ) {
			removeValue();
			if ( stubWidget != null ) {
				valuePanel.remove( stubMessage );
				listener.onInstanceRemoved( stubWidget.getEIInstance() );
			}
			allProvidersAnchor.setVisible( true );
		} else if ( subClassList.getItemText( subClassList.getSelectedIndex() ).equals( CREATE_NEW_VALUE ) ) {

			ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance( range.getEntity().getURI(), new RootAsyncCallback<EIInstance>() {
				@Override
				public void onSuccess(final EIInstance newInstance) {
					listener.onInstanceAdded( newInstance );

					newInstance.addNonOntologyLiteralProperty( DatatoolsUIConstants.isStubEntity, "True" );
					if ( hasOldValue() ) {
						eiInstance.replaceObjectPropertyValue( propertyEntity, EIURI.create( oldValue ), newInstance.getEntity() );
					} else {
						eiInstance.addObjectProperty( propertyEntity, newInstance.getEntity() );
					}
					updateOldValue( newInstance.getInstanceURI() );
					addStubWidget( range, propertyEntity, newInstance );
				}
			} );

			// }
		} else {
			allProvidersAnchor.setVisible( true );
			if ( stubWidget != null ) {
				listener.onInstanceRemoved( stubWidget.getEIInstance() );
				valuePanel.remove( stubWidget );

			}

			// FIXME total hack for DTOOLS-762: if we're displaying all resources (the toggle message says only current lab or organization), hide the link
			// ideally we do this with information about whether the selected item is in fact from the current lab organization or some other, but not the day of the release
			if ( allProvidersAnchor.getText().equals( DatatoolsUIConstants.FROM_ONLY_CURRENT_PROVIDER ) ) {
				allProvidersAnchor.setVisible( false );
			}

			if ( hasOldValue() ) {
				eiInstance.replaceObjectPropertyValue( propertyEntity, EIURI.create( oldValue ), WidgetUtils.getSelectedEntity( subClassList ) );
			} else {
				eiInstance.addObjectProperty( propertyEntity, WidgetUtils.getSelectedEntity( subClassList ) );
			}
			updateOldValue( WidgetUtils.getSelectedUri( subClassList ) );
		}

	}

	private void setup() {
		// HorizontalPanel innerHoriz = new HorizontalPanel();
		// flowPanel.add( innerHoriz );

		instances.setName( propertyEntity.getURI().toString() + "_instances" );
		valuePanel.add( instances );
		allProvidersAnchor = new Anchor( DatatoolsUIConstants.FROM_ALL_PROVIDERS_LABEL );

		allProvidersAnchor.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				fillResourceListAndToggle();
			}
		} );

		if ( isInProvider() ) {
			valuePanel.add( allProvidersAnchor );
		}

	}

	private boolean isInProvider() {
		if ( ApplicationState.getInstance().hasResourceProvider() ) {
			return true;

		} else {
			return false;
		}
	}

	private void fillResourceListAndToggle() {
		// Note that it is safe to pass in the null entity as the selected entity because it's not possible to switch modes if you have a stub in place
		if ( allProvidersAnchor.getText().equals( DatatoolsUIConstants.FROM_ALL_PROVIDERS_LABEL ) ) {
			fillListBoxWithResources( false, EIURI.NULL_EIURI, EIEntity.NULL_ENTITY );
			allProvidersAnchor.setText( DatatoolsUIConstants.FROM_ONLY_CURRENT_PROVIDER );
		} else {
			fillListBoxWithResources( true, ApplicationState.getInstance().getResourceProviderUri(), EIEntity.NULL_ENTITY );
			allProvidersAnchor.setText( DatatoolsUIConstants.FROM_ALL_PROVIDERS_LABEL );
		}
	}

	private String formatInstanceForListBox(final EIInstanceMinimal valueInstance) {
		return valueInstance.getInstanceLabel() + " <" + valueInstance.getInstanceType().getLabel() + ">" + ( !valueInstance.getLab().equals( EIEntity.NULL_ENTITY ) ? ", " + valueInstance.getLab().getLabel() : "" );
	}

	@Override
	public EditWidget duplicateBlank() {
		return new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, (EIEntity)null, true, isPropertyProviderRelated, listener );
	}

	@Override
	protected void removeValue() {
		if ( hasOldValue() ) {
			if ( stubWidget != null ) {
				valuePanel.remove( stubWidget );
			}
			eiInstance.replaceObjectPropertyValue( propertyEntity, getOldEIURIValue(), null );
			oldValue = null;
		}

	}

	public void disableAsProviderProperty() {
		instances.setEnabled( false );
		allProvidersAnchor.setVisible( false );
		if ( ApplicationState.getInstance().getMode() == Mode.duplicate ) {
			valuePanel.remove( allProvidersAnchor );
			valuePanel.add( changeProviderLink );
			changeProviderLink.addClickHandler( new ClickHandler() {

				@Override
				public void onClick(ClickEvent event) {
					instances.setEnabled( true );
					valuePanel.remove( changeProviderLink );
					valuePanel.add( allProvidersAnchor );
					allProvidersAnchor.setVisible( false );
				}
			} );
		}
	}
	
	private void addStubWidget(final EIClass range, final EIEntity propertyEntity, final EIInstance newInstance) {
		stubWidget = new StubWidget( newInstance, propertyEntity, range, "", true ); // shouldn't need a property definition for the stub widget
		allProvidersAnchor.setVisible( false );
		valuePanel.add( stubMessage );
		valuePanel.add( stubWidget );
	}

	private EIURI getCorrectRangeUri(EIClass currentRange) {
		if ( currentRange.getEntity().getURI().toString().equals( EagleIEntityConstants.EI_LAB ) ) {
			return EIURI.create( EagleIEntityConstants.EI_ORGANIZATION );
		}

		return currentRange.getEntity().getURI();
	}

}
