package org.eaglei.datatools.client.ui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;

public class ObjectWidget extends EditWidget {

	private final ListBox rangePicker = new ListBox();
	private List<EIClass> rangeList = new ArrayList<EIClass>();
	private final EIEntity selectedEntity;
	private EIClass instanceRootClass;
	private List<EIClass> instanceSuperclasses;
	private EditWidget innerWidget;
	private final EIEntity providerEntity;
	private boolean isEnabled = true;
	private final NewInnerInstanceListener listener;
	private final boolean isPropertyProviderRelated;

	private final Map<EIEntity, EIClass> entityRangeMap = new HashMap<EIEntity, EIClass>();

	private static final String NO_VALUE = "<none>";

	private static final GWTLogger log = GWTLogger.getLogger( "ObjectWidget" );

	public ObjectWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final List<EIClass> rangeList, final EIEntity providerEntity, final EIEntity selectedEntity,
			final boolean isPropertyProviderRelated, final NewInnerInstanceListener listener) {
		super( eiInstance, propertyEntity, propertyDefinition, isRequired);
		log.debug( "range list has " + rangeList.size() + " entries" );
		this.rangeList = rangeList;
		Collections.sort( this.rangeList, new Comparator<EIClass>() {

			@Override
			public int compare(EIClass arg0, EIClass arg1) {
				return arg0.getEntity().getLabel().compareTo( arg1.getEntity().getLabel() );
			}

		} );
		this.listener = listener;
		this.selectedEntity = selectedEntity;
		this.isPropertyProviderRelated = isPropertyProviderRelated;
		log.debug( "selected entity is: " + this.selectedEntity );
		this.providerEntity = providerEntity;

		getInstanceRootClass();

	}

	private void setup() {
		rangePicker.setStyleName( "MultiRangeDropbox" );
		widgetPanel.add( rangePicker );
		rangePicker.addItem( NO_VALUE, NO_VALUE );

		for (final EIClass range : rangeList) {
			entityRangeMap.put( range.getEntity(), range );
			rangePicker.addItem( range.getEntity().getLabel(), range.getEntity().getURI().toString() );
			// FIXME: for DTOOLS-818 etc, use the new annotation to see if it's a resource provider, and don't select the range if not
			// BUT only in the case of a resource-providing class; otherwise, this is correct
			// proposal: something awful, like instanceSuperclasses.contains(ResourceProvider.BASE...) && range.isResourceProvider()
			if ( instanceRootClass == null && instanceSuperclasses != null && instanceSuperclasses.contains( range ) ) {
				rangePicker.setSelectedIndex( rangePicker.getItemCount() - 1 );  
			} else if ( instanceRootClass != null && range.getEntity().equals( instanceRootClass.getEntity() ) ) {
				rangePicker.setSelectedIndex( rangePicker.getItemCount() - 1 );
			} else if ( hasResourceProviderUri() && isPropertyProviderRelated ) { // TODO: was still InstanceWidgetUtils.isResourceProviderProperty( range ); why?
				rangePicker.setSelectedIndex( rangePicker.getItemCount() - 1 );
			}
		}

		selectProperValue();

		setRangePickBehavior();
	}

	private void setRangePickBehavior() {
		rangePicker.addChangeHandler( new ChangeHandler() {
			@Override
			public void onChange(final ChangeEvent arg0) {
				if ( rangePicker.getItemText( rangePicker.getSelectedIndex() ).equals( NO_VALUE ) ) {
					if ( hasOldValue() ) {
						removeValue();
					}
					if ( widgetPanel.getWidgetCount() > 2 ) {
						widgetPanel.remove( 2 );
						innerWidget = null;
					}
				} else {
					if ( widgetPanel.getWidgetCount() > 2 ) {
						if ( getInnerWidget().hasOldValue() ) {
							eiInstance.replaceObjectPropertyValue( propertyEntity, getInnerWidget().getOldEIURIValue(), null );
						}
						widgetPanel.remove( 2 );
						innerWidget = null;
					}
					final EIEntity selectedRange = getSelectedRangeEntity();
					updateOldValue( selectedRange.getURI() ); // this is how it used to be
					EIClass selectedRangeClass = entityRangeMap.get( selectedRange );
					if ( selectedRangeClass.isEagleIResource() ) {
						final FlowPanel tempPanel = new FlowPanel();
						tempPanel.setStyleName( "formPanelMultiRange" );
						innerWidget = new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, entityRangeMap.get( selectedRange ), EIEntity.NULL_ENTITY, false, isPropertyProviderRelated, listener );
						tempPanel.add(innerWidget);
						widgetPanel.add( tempPanel );
						if ( isPropertyProviderRelated ) { // TODO: was InstanceWidgetUtils.isResourceProviderProperty( selectedRangeClass ); why?
							( (EIResourceListWidget)innerWidget ).disableAsProviderProperty();
						}
					} else {
						final EIClass range = entityRangeMap.get( selectedRange );
						log.debug( "term widget: selected range " + range );
						final FlowPanel tempPanel = new FlowPanel();
						tempPanel.setStyleName( "formPanelMultiRange" );
						widgetPanel.add( tempPanel );
						// TODO: inner callback to set the inner panel to the term widget created this way
						WidgetUtils.addTermWidgetToPanel( eiInstance, propertyEntity, propertyDefinition, isRequired, range, EIEntity.NULL_ENTITY, tempPanel, false );
					}
				}
			}
		} );
	}

	private void selectProperValue() {
		if ( rangePicker.getSelectedIndex() > 0 ) {
			final EIEntity selectedRange = getSelectedRangeEntity();
			if ( entityRangeMap.get( selectedRange ).isEagleIResource() ) {
				if ( ( selectedEntity == null ) && hasResourceProviderUri() && isPropertyProviderRelated ) {
					log.info( "making provider-property for " + entityRangeMap.get( selectedRange ) + " " + providerEntity );
					eiInstance.addObjectProperty( propertyEntity, providerEntity );
					innerWidget = new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, entityRangeMap.get( selectedRange ), providerEntity, false, isPropertyProviderRelated, listener );
					disable();
				} else {
					innerWidget = new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, entityRangeMap.get( selectedRange ), selectedEntity, false, isPropertyProviderRelated, listener );
					if ( hasResourceProviderUri() && isPropertyProviderRelated ) {
						log.info( "disabling " + propertyEntity.getLabel() + " because it is provider-related and has provider uri" );
						
						disable();
					}
				}
				widgetPanel.add( innerWidget );
			} else {
				final FlowPanel tempPanel = new FlowPanel();
				widgetPanel.add( tempPanel );
				WidgetUtils.addTermWidgetToPanel( eiInstance, propertyEntity, propertyDefinition, isRequired, instanceRootClass, selectedEntity, tempPanel, false );
			}

		} else if ( selectedEntity != null && selectedEntity != EIEntity.NULL_ENTITY ) {
			log.info( "trying to make widget for deleted value" );
			innerWidget = new EIResourceListWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, EIClass.NULL_CLASS, selectedEntity, false, isPropertyProviderRelated, listener );
			widgetPanel.add( innerWidget );
		}
	}

	private void getInstanceRootClass() {
		if ( selectedEntity == null ) {
			log.info( "no selected entity" );
			setup();
			return;
		}

		if ( WidgetUtils.isInstance( selectedEntity ) ) {

			log.debug( "Trying to get superclasses for instance: " + selectedEntity );
			ClientRepositoryToolsManager.INSTANCE.getClassAndSuperclassesForInstanceUri( selectedEntity.getURI(), new RootAsyncCallback<List<EIClass>>() {
				
				@Override
				public void onSuccess(final List<EIClass> result) {
					instanceSuperclasses = result;
					log.debug( "Got superclasses: " + instanceSuperclasses );
					setup();
				}

				@Override
				public void onFailure(final Throwable caught) {
					//FIXME right?
					log.warn( "Server call getRootSuperclassForInstanceUri failed; instance may have been deleted" );
					setup();
				}

			} );
		} else {
			log.debug( "in getInstanceRootClass for " + selectedEntity );

			ClientRepositoryToolsManager.INSTANCE.getRootSuperClass( selectedEntity, new RootAsyncCallback<EIClass>() {
				@Override
				public void onSuccess(final EIClass superclass) {
					instanceRootClass = superclass;
					setup();
				}

			} );

		}
	
	}

	private EIEntity getSelectedRangeEntity() {
		return WidgetUtils.getSelectedEntity( rangePicker );
	}

	protected EditWidget getInnerWidget() {
		if ( innerWidget != null ) {
			return innerWidget;
		} else if ( widgetPanel.getWidgetCount() > 2 ) {
			Widget widget = widgetPanel.getWidget( 2 );
			if ( widget instanceof FlowPanel ) {
				widget = ( (FlowPanel)widget ).getWidget( 0 );
				if ( widget != null ) {
					return (EditWidget)widget;
				}
			}

			if ( widget instanceof EditWidget ) {
				final EditWidget inner = ( (EditWidget)widget );
				return inner;
			} else {
				Window.alert( "Failed to get an editWidget" ); // TODO: remove
			}
		}

		return null;
	}

	@Override
	protected boolean hasOldValue() {
		if (getInnerWidget() == null) {
			return false;
		}
		return getInnerWidget().hasOldValue();
	}

	@Override
	protected void removeValue() {
		if ( getInnerWidget() == null ) {
			return;
		}
		getInnerWidget().removeValue();
	}

	@Override
	public EditWidget duplicateBlank() {
		return new ObjectWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, rangeList, providerEntity, null, isPropertyProviderRelated, listener );
	}

	// TODO: make static in WidgetUtils
	protected boolean hasResourceProviderUri() {
		return ( providerEntity != null ) && ( !providerEntity.getURI().toString().equals( "" ) );
	}

	public void disable() {
		rangePicker.setEnabled( false );
		if ( innerWidget instanceof EIResourceListWidget ) {
			( (EIResourceListWidget)innerWidget ).disableAsProviderProperty();
		}
		isEnabled = false;
	}

	public boolean isDisabled() {
		return !isEnabled;
	}
}
