package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.Layout;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.SharedClassChooser;

import com.google.gwt.user.client.ui.FlowPanel;

public class TermWidget extends EditWidget {

	private final EIClass range;
	private final EIClass selectedClass;
	private final boolean shouldHaveLabel;

	public TermWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIClass selectedClass, final boolean shouldShowLabel) {
		super( eiInstance, propertyEntity, propertyDefinition, isRequired);
		this.range = range;
		this.selectedClass = selectedClass;
		shouldHaveLabel = shouldShowLabel;
		if ( !shouldHaveLabel ) {
			widgetPanel.remove( label );
		}
		setup();
	}

	private void setup() {
		FlowPanel temp = new FlowPanel();
		final SharedClassChooser<OntologyDropdown> classChooser = new SharedClassChooser<OntologyDropdown>( new OntologyDropdown() );
		classChooser.setClass( range, false );
		classChooser.setTextBoxStyle( "textSuggest" );
		if ( selectedClass != null && !EIClass.NULL_CLASS.equals( selectedClass ) ) {
			classChooser.setSelectedEntity( selectedClass.getEntity() );
			updateOldValue( selectedClass.getEntity().getURI() );
		}
		widgetPanel.add( temp );
		temp.add(classChooser);
		temp.addStyleName("floatLeft");
		addTermRequestWidget();
		makeSelectionHandler( classChooser );
	}

	// overridden in subclass for type
	protected void makeSelectionHandler(final SharedClassChooser<OntologyDropdown> classChooser) {
		classChooser.addSelectionListener( new EntitySelectionListener() {
			@Override
			public void onSelection(final EIEntity selectedEntity) {
				classChooser.setTextBoxStyle( "formText" );
				//Do nothing if user selected <none> from the beginning
				if (( selectedEntity.equals( EIEntity.NULL_ENTITY ) || EIEntity.NO_LABEL.equals( selectedEntity.getLabel() ) ) && !hasOldValue()) {
					return;
				}
				if ( hasOldValue() ) {
					if ( selectedEntity.equals( EIEntity.NULL_ENTITY ) || EIEntity.NO_LABEL.equals( selectedEntity.getLabel() ) ) {
						removeValue();
					} else {
						eiInstance.replaceObjectPropertyValue( propertyEntity, EIURI.create( oldValue ), selectedEntity );
					}
				} else {
					eiInstance.addObjectProperty( propertyEntity, selectedEntity );
				}
				updateOldValue( selectedEntity.getURI() );
			}
		} );
	}

	protected void addTermRequestWidget(){
		final TextWidget termRequestWidget = TextWidget.makeTermRequestWidget( eiInstance );
		termRequestWidget.setStyleName("floatLeft");
		// Include the root class of the range in the name
		// in order to differentiate term request fields for testing
		termRequestWidget.setName( range.getEntity().getURI().toString() + "_" + DatatoolsUIConstants.termRequestEntity.getURI().toString() );
		widgetPanel.add( termRequestWidget );
	}
	
	@Override
	protected void removeValue() {
		if ( hasOldValue() ) {
			eiInstance.replaceObjectPropertyValue( propertyEntity, getOldEIURIValue(), null );
		}
	}

	@Override
	public EditWidget duplicateBlank() {
		return new TermWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, range, null, true );
	}
}
