package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.Layout;
import org.eaglei.datatools.client.ui.Validations;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;

public class TextWidget extends EditWidget {

	public static EditWidget makeDatatypeTextWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final String propertyValue) {
		if ( propertyEntity.getLabel().equalsIgnoreCase( "email" ) ) {
			return new ValidatedTextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue );
		} else if ( propertyEntity.equals( EagleIEntityConstants.RESOURCE_DESCRIPTION_ENTITY ) || propertyEntity.getLabel().contains( "Address" )) {
			return TextAreaWidget.makeDatatypeTextArea( eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue );
		} // actually, we need to check for the annotation http://eagle-i.org/ont/datatools/1.0/PropertyGroup_ParagraphExpected on the property
		// but we dont' have that information yet
		return new TextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue, OldValueHandlerFactory.getDatatypeOldValueHandler() );
	}

	public static TextWidget makeLabelTextWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final String propertyValue) {
		return new TextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue, new OldValueHandler() {

			@Override
			public void replaceValue(final EIInstance instance, final EIEntity propertyEntity, final String oldValue, final String newValue) {
				instance.getEntity().setLabel( newValue );
			}

			@Override
			public void addValue(final EIInstance instance, final EIEntity propertyEntity, final String newValue) {
				instance.getEntity().setLabel( newValue );
			}
		} );
	}

	public static TextWidget makeNonOntologyTextWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyValue) {
		return new TextWidget( eiInstance, propertyEntity, "", false, propertyValue, OldValueHandlerFactory.getNonOntologyOldValueHandler() ); 
	}
	
	public static TextWidget makeTermRequestWidget(final EIInstance eiInstance) {
		TextWidget termRequest = makeNonOntologyTextWidget( eiInstance, DatatoolsUIConstants.termRequestEntity, "" );
		termRequest.label.setStyleName( "TermFormLabel" );
		termRequest.valueField.setStyleName( "TermFormText" );
		return termRequest;
	}


	private final TextBox valueField = WidgetUtils.createTextField();
	protected OldValueHandler oldValueHandler;
	//final Label errLabel = new Label();

	protected TextWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final String propertyValue, final OldValueHandler handler) {
		super( eiInstance, propertyEntity, propertyDefinition, isRequired);
		oldValue = propertyValue;
		oldValueHandler = handler;
		shouldShowLabel = true;
		setup();
	}

	protected void setup() {
		valueField.setName( propertyEntity.getURI().toString() );
		if ( hasOldValue() ) {
			valueField.setText( InstanceWidgetUtils.formatText( oldValue ) );
		}
		// widgetPanel.add(propLabel);
		widgetPanel.add( valueField );
		//errLabel.setStyleName( "errorMsg" );
		//widgetPanel.add( errLabel );

		/*if ( propertyEntity.getLabel().equalsIgnoreCase( "phone number" ) ) {
			valueField.setMaxLength( 13 );
			addPhoneValidations();
		} */

		valueField.addValueChangeHandler( getValueChangeHandler() );
	}

	protected ValueChangeHandler<String> getValueChangeHandler() {
		return new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(final ValueChangeEvent<String> changedValue) {
				if ( hasOldValue() ) {
					oldValueHandler.replaceValue( eiInstance, propertyEntity, oldValue, changedValue.getValue() );
				} else {
					oldValueHandler.addValue( eiInstance, propertyEntity, changedValue.getValue() );
				}
				updateOldValue( changedValue.getValue() );
			}
		};
	}

	@Override
	public void removeValue() {
		if ( hasOldValue() ) {
			oldValueHandler.replaceValue( eiInstance, propertyEntity, oldValue, null );
		}
	}

	@Override
	public EditWidget duplicateBlank() {
		return new TextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, "", oldValueHandler );
	}

	protected void setFieldValue(final String newValue) {
		valueField.setValue( newValue );
	}

	protected String getValueText() {
		return valueField.getValue();
	}

	private void addPhoneValidations() {
		valueField.addKeyUpHandler( new KeyUpHandler() {
			@Override
			public void onKeyUp(final KeyUpEvent event) {
				if ( !Validations.OnlyPhoneFormat( valueField.getValue() ) ) {
					valueField.setText( valueField.getText().replace( valueField.getText().toCharArray()[valueField.getText().length() - 1] + "", "" ) );
					return;
				}
				Validations.jsniPhoneValidation( valueField.getElement() );
			}
		} );
	}

	// TODO: move this to the superclass and use name field?
	public void setName(final String name) {
		valueField.setName( name );
	}
}
