/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client;

import java.util.HashMap;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class QueryTokenObject {
    private static final GWTLogger log = GWTLogger.getLogger("QueryTokenObject");
    private static final String MODE_VARIABLE = "mode";
    protected static final String INSTANCE_URI_VARIABLE = "instanceUri";
    protected static final String INSTANCE_LABEL_VARIABLE = "instanceLabel";
    protected static final String TYPE_URI_VARIABLE = "typeUri";
    protected static final String TYPE_LABEL_VARIABLE = "typeLabel";
    protected static final String PROVIDER_URI_VARIABLE = "providerUri";
    protected static final String PROVIDER_LABEL_VARIABLE = "providerLabel";
    protected static final String WORKSPACE_URI_VARIABLE = "workspaceUri";
    protected static final String WORKSPACE_LABEL_VARIABLE = "workspaceLabel";
    protected static final String PAGE_OFFSET_VARIABLE = "offset";
    protected static final String PAGE_LIMIT_VARIABLE = "limit";
    protected static final String SORT_VARIABLE = "sortBy";
    protected static final String FILTER_TYPE_LABEL_VARIABLE = "filterTypeLabel";
    protected static final String FILTER_PROVIDER_LABEL_VARIABLE = "filterProviderLabel";
    protected static final String FILTER_WF_LABEL_VARIABLE = "filterWorkflowLabel";
    protected static final String FILTER_TYPE_URI_VARIABLE = "filterTypeUri";
    protected static final String FILTER_PROVIDER_URI_VARIABLE = "filterProviderUri";
    protected static final String FILTER_WF_URI_VARIABLE = "filterWorkflowUri";
    protected static final String FILTER_BY_OWNER = "strictOwnerFilter";
    private Mode mode = null;
    private EIEntity instanceEntity = EIEntity.NULL_ENTITY;
    private EIURI instanceUri = EIURI.NULL_EIURI;
    private EIEntity typeEntity = EIEntity.NULL_ENTITY;
    private EIURI typeUri = EIURI.NULL_EIURI;
    private String typeLabel = null;
    private EIEntity providerEntity = EIEntity.NULL_ENTITY;
    private EIURI providerUri = EIURI.NULL_EIURI;
    private String providerLabel = null;
    private EIEntity filterProviderEntity = EIEntity.NULL_ENTITY;
    private EIEntity filterTypeEntity = EIEntity.NULL_ENTITY;
    private EIEntity filterWorkflowEntity = EIEntity.NULL_ENTITY;
    private EIEntity workspaceEntity = EIEntity.NULL_ENTITY;
    private Integer offset = 0;
    private Integer pageLimit = DatatoolsUIConstants.DEFAULT_PAGE_SIZE;
    private String sortBy = SortByProperties.label.getParameterName();
    protected static final Mode defaultMode = Mode.workbench;
    private boolean filterByOwner;
    private final HashMap<String, String> variableMap = new HashMap();

    public QueryTokenObject() {
        this.setMode(defaultMode);
    }

    public QueryTokenObject(String tokenString) {
        this.fromString(tokenString);
    }

    public Mode getMode() {
        return this.mode == null ? defaultMode : this.mode;
    }

    public void setMode(Mode mode) {
        if (!Mode.isResourcesList(mode)) {
            this.removePagination();
        } else {
            this.setDefaultPagination();
        }
        this.mode = mode;
        this.variableMap.put(MODE_VARIABLE, mode.toString());
    }

    public void removePagination() {
        this.setOffset(null);
        this.setLimit(null);
        this.setSortBy(null);
    }

    public void setDefaultPagination() {
        this.setOffset(0);
        this.setLimit(DatatoolsUIConstants.DEFAULT_PAGE_SIZE);
        this.setSortBy(SortByProperties.label.getParameterName());
    }

    public EIEntity getInstanceEntity() {
        return this.instanceEntity;
    }

    public void setInstanceEntity(EIEntity instanceEntity) {
        this.instanceEntity = instanceEntity;
        this.addToMap(instanceEntity, INSTANCE_URI_VARIABLE, INSTANCE_LABEL_VARIABLE);
    }

    public EIEntity getTypeEntity() {
        return this.typeEntity;
    }

    public void setTypeEntity(EIEntity typeEntity) {
        this.typeEntity = typeEntity;
        this.addToMap(typeEntity, TYPE_URI_VARIABLE, TYPE_LABEL_VARIABLE);
    }

    public EIEntity getResourceProviderEntity() {
        return this.providerEntity;
    }

    public void setResourceProviderEntity(EIEntity providerEntity) {
        this.providerEntity = providerEntity;
        this.addToMap(providerEntity, PROVIDER_URI_VARIABLE, PROVIDER_LABEL_VARIABLE);
    }

    public EIEntity getWorkspaceEntity() {
        return this.workspaceEntity;
    }

    public void setWorkspaceEntity(EIEntity workspaceEntity) {
        this.workspaceEntity = workspaceEntity;
        this.addToMap(workspaceEntity, WORKSPACE_URI_VARIABLE, WORKSPACE_LABEL_VARIABLE);
    }

    public EIEntity getFilterResourceProviderEntity() {
        return this.filterProviderEntity;
    }

    public void setFilterResourceProviderEntity(EIEntity filterProviderEntity) {
        this.filterProviderEntity = filterProviderEntity;
        this.addToMap(filterProviderEntity, FILTER_PROVIDER_URI_VARIABLE, FILTER_PROVIDER_LABEL_VARIABLE);
    }

    public EIEntity getFilterTypeEntity() {
        return this.filterTypeEntity;
    }

    public void setFilterTypeEntity(EIEntity filterTypeEntity) {
        this.filterTypeEntity = filterTypeEntity;
        this.addToMap(filterTypeEntity, FILTER_TYPE_URI_VARIABLE, FILTER_TYPE_LABEL_VARIABLE);
    }

    public EIEntity getFilterWorkflowEntity() {
        return this.filterWorkflowEntity;
    }

    public void setFilterWorkflowEntity(EIEntity filterWorkflowEntity) {
        this.filterWorkflowEntity = filterWorkflowEntity;
        this.addToMap(filterWorkflowEntity, FILTER_WF_URI_VARIABLE, FILTER_WF_LABEL_VARIABLE);
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
        if (offset == null) {
            this.variableMap.remove(PAGE_OFFSET_VARIABLE);
        } else {
            this.addToMap(PAGE_OFFSET_VARIABLE, offset.toString());
        }
    }

    public Integer getLimit() {
        return this.pageLimit;
    }

    public void setLimit(Integer limit) {
        if (limit == null) {
            this.variableMap.remove(PAGE_LIMIT_VARIABLE);
        } else {
            if (this.pageLimit != limit) {
                this.setOffset(0);
            }
            this.addToMap(PAGE_LIMIT_VARIABLE, limit.toString());
        }
        this.pageLimit = limit;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        if (this.sortBy == null && sortBy != null || this.sortBy != null && !this.sortBy.equals(sortBy)) {
            this.setLimit(DatatoolsUIConstants.DEFAULT_PAGE_SIZE);
            this.setOffset(0);
        }
        this.addToMap(SORT_VARIABLE, sortBy);
        this.sortBy = sortBy;
    }

    protected void addToMap(EIEntity newEntity, String uriVariable, String labelVariable) {
        if (this.hasUri(newEntity)) {
            this.variableMap.put(uriVariable, newEntity.getURI().toString());
            this.variableMap.put(labelVariable, newEntity.getLabel().toString());
        } else {
            this.variableMap.remove(uriVariable);
            this.variableMap.remove(labelVariable);
        }
    }

    protected void addToMap(String label, String value) {
        if (value == null) {
            this.variableMap.remove(label);
        } else {
            this.variableMap.put(label, value);
        }
    }

    public boolean isStrictlyFilteredByOwner() {
        return this.filterByOwner;
    }

    public void setStrictFilterByOwner(boolean filterByOwner) {
        this.filterByOwner = filterByOwner;
        this.addToMap(FILTER_BY_OWNER, filterByOwner + "");
    }

    public String toString() {
        if (this.variableMap.size() == 0) {
            return "";
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("history?");
        for (String key : this.variableMap.keySet()) {
            sbuf.append(key + "=" + this.variableMap.get(key) + "&");
        }
        return sbuf.toString().replaceAll("&$", "");
    }

    public QueryTokenObject fromString(String token) {
        String[] splitArray;
        this.variableMap.clear();
        for (String splitedString : splitArray = token.split("\\?")[1].split("&")) {
            String[] variableFromSplitString = splitedString.split("=");
            if (variableFromSplitString == null || variableFromSplitString.length <= 1) continue;
            this.variableMap.put(variableFromSplitString[0], variableFromSplitString[1]);
        }
        this.initializeEntities();
        this.validate();
        return this;
    }

    private EIEntity getEntityByVariable(String uriName, String labelName) {
        if (this.variableMap != null) {
            String uriValue = this.variableMap.get(uriName);
            if (uriValue == null || uriValue.equals("") || uriValue.equals(EIURI.NULL_EIURI.toString())) {
                return EIEntity.NULL_ENTITY;
            }
            String labelValue = this.variableMap.get(labelName);
            return EIEntity.create((String)uriValue, (String)labelValue);
        }
        return EIEntity.NULL_ENTITY;
    }

    private boolean validate() {
        if (this.hasUri(this.instanceUri) && this.mode == null) {
            this.mode = Mode.view;
            this.setMode(this.mode);
            return true;
        }
        if (this.mode == Mode.edit || this.mode == Mode.view && !this.hasUri(this.instanceUri)) {
            return false;
        }
        if (this.hasLabel(this.typeLabel) && !this.hasUri(this.typeUri)) {
            return false;
        }
        return !this.hasLabel(this.providerLabel) || this.hasUri(this.providerUri);
    }

    protected boolean hasLabelButNoUri(String label, EIURI uri) {
        return this.hasLabel(label) && !this.hasUri(uri);
    }

    protected boolean hasLabel(String label) {
        if (label == null) {
            return false;
        }
        return !label.equals("") && !label.equals("<none>");
    }

    private void initializeEntities() {
        String pageLimitString;
        this.filterTypeEntity = this.getEntityByVariable(FILTER_TYPE_URI_VARIABLE, FILTER_TYPE_LABEL_VARIABLE);
        this.filterProviderEntity = this.getEntityByVariable(FILTER_PROVIDER_URI_VARIABLE, FILTER_PROVIDER_LABEL_VARIABLE);
        this.filterWorkflowEntity = this.getEntityByVariable(FILTER_WF_URI_VARIABLE, FILTER_WF_LABEL_VARIABLE);
        this.instanceEntity = this.getEntityByVariable(INSTANCE_URI_VARIABLE, INSTANCE_LABEL_VARIABLE);
        this.typeEntity = this.getEntityByVariable(TYPE_URI_VARIABLE, TYPE_LABEL_VARIABLE);
        if (this.hasUri(this.typeEntity.getURI())) {
            this.setTypeEntity(this.typeEntity);
        }
        this.providerEntity = this.getEntityByVariable(PROVIDER_URI_VARIABLE, PROVIDER_LABEL_VARIABLE);
        if (this.hasUri(this.providerEntity.getURI())) {
            this.setResourceProviderEntity(this.providerEntity);
        }
        this.instanceUri = this.instanceEntity.getURI();
        this.typeUri = this.typeEntity.getURI();
        this.typeLabel = this.typeEntity.getLabel();
        this.providerUri = this.providerEntity.getURI();
        this.providerLabel = this.providerEntity.getLabel();
        String modeValue = this.variableMap.get(MODE_VARIABLE);
        if (modeValue == null) {
            this.mode = null;
        }
        for (Mode whichMode : Mode.values()) {
            if (!whichMode.toString().equals(modeValue)) continue;
            this.mode = whichMode;
        }
        String offsetString = this.variableMap.get(PAGE_OFFSET_VARIABLE);
        if (offsetString != null) {
            this.offset = Integer.decode(offsetString);
        }
        if ((pageLimitString = this.variableMap.get(PAGE_LIMIT_VARIABLE)) != null) {
            this.pageLimit = Integer.decode(pageLimitString);
        }
        if (this.variableMap.containsKey(SORT_VARIABLE)) {
            this.sortBy = this.variableMap.get(SORT_VARIABLE);
        }
    }

    protected boolean hasUri(EIEntity entity) {
        return this.hasUri(entity.getURI());
    }

    protected boolean hasUri(EIURI uri) {
        return uri != null && !uri.toString().equals("") && uri != EIURI.NULL_EIURI;
    }

    public boolean isPaginated() {
        return this.getOffset() != null && this.getLimit() != null;
    }

    public static enum Mode {
        duplicate,
        edit,
        filter,
        providers,
        list,
        references,
        resources,
        stubs,
        workbench,
        view;


        public static boolean isResourcesList(Mode mode) {
            return mode != edit && mode != view && mode != workbench && mode != duplicate;
        }
    }
}

