/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.Renderer;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

public abstract class NonOntologyPropertiesRenderer
implements Renderer {
    protected EIInstance eiInstance;
    protected FlowPanel nonOntologyOuterPanel;
    protected boolean shouldShowReadOnlyProperties = true;

    protected abstract void drawExtraFields(Map<EIEntity, Set<String>> var1);

    protected abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();

    protected abstract Collection<EIEntity> getNonOntologyResourcePropEntities();

    protected abstract void drawNonOntologyLiteralProperty(EIEntity var1, Set<String> var2, FlowPanel var3);

    protected abstract void drawNonOntologyResourceProperty(EIEntity var1, Set<EIEntity> var2, FlowPanel var3);

    public NonOntologyPropertiesRenderer(EIInstance eiInstance, FlowPanel nonOntologyOuterPanel) {
        this.eiInstance = eiInstance;
        this.nonOntologyOuterPanel = nonOntologyOuterPanel;
        this.renderProperties();
    }

    public void renderProperties() {
        Map instanceNonOntologyLiteralProperties = this.eiInstance.getNonOntologyLiteralProperties();
        this.drawExtraFields(instanceNonOntologyLiteralProperties);
        this.drawReferencedBy();
        this.drawAdminProperties();
    }

    protected void drawAdminProperties() {
        DisclosurePanel nonOntologyPanel = new DisclosurePanel("Information for data curators");
        Map instanceNonOntologyLiteralProperties = this.eiInstance.getNonOntologyLiteralProperties();
        Map instanceNonOntologyResourceProperties = this.eiInstance.getNonOntologyResourceProperties();
        ArrayList entityList = new ArrayList();
        entityList.addAll(this.eiInstance.getReadOnlyLiteralProperties().keySet());
        entityList.addAll(this.eiInstance.getReadOnlyResourceProperties().keySet());
        entityList.addAll(instanceNonOntologyLiteralProperties.keySet());
        entityList.addAll(instanceNonOntologyResourceProperties.keySet());
        FlowPanel innerPanel = new FlowPanel();
        this.createNonOntologyPanel(instanceNonOntologyLiteralProperties, instanceNonOntologyResourceProperties, innerPanel);
        nonOntologyPanel.add((Widget)innerPanel);
        nonOntologyPanel.setStyleName("formPanelInside");
        this.nonOntologyOuterPanel.add((Widget)nonOntologyPanel);
    }

    protected void createNonOntologyPanel(Map<EIEntity, Set<String>> nonOntologyLiteralProperties, Map<EIEntity, Set<EIEntity>> nonOntologyResourceProperties, FlowPanel innerPanel) {
        FlowPanel metaPanel = new FlowPanel();
        FlowPanel otherPanel = new FlowPanel();
        this.designPanel(metaPanel, "Metadata properties:");
        this.designPanel(otherPanel, "Other properties:");
        LabelValuesWidget eagleIUniqueId = new LabelValuesWidget("eagle-i unique ID");
        Anchor id = new Anchor(this.eiInstance.getInstanceURI().toString(), this.eiInstance.getInstanceURI().toString(), "_blank");
        eagleIUniqueId.add((Widget)id);
        innerPanel.add((Widget)eagleIUniqueId);
        if (this.shouldShowReadOnlyProperties) {
            innerPanel.add((Widget)metaPanel);
            innerPanel.add((Widget)otherPanel);
            Map readOnlyLiterals = this.eiInstance.getReadOnlyLiteralProperties();
            Map readOnlyResources = this.eiInstance.getReadOnlyResourceProperties();
            this.drawReadOnlyProperties(null, metaPanel, readOnlyLiterals, readOnlyResources);
        }
        FlowPanel panelToUse = this.shouldShowReadOnlyProperties ? otherPanel : innerPanel;
        for (EIEntity propEntity : nonOntologyLiteralProperties.keySet()) {
            this.drawNonOntologyLiteralProperty(propEntity, nonOntologyLiteralProperties.get(propEntity), panelToUse);
        }
        for (EIEntity propEntity : nonOntologyResourceProperties.keySet()) {
            this.drawNonOntologyResourceProperty(propEntity, nonOntologyResourceProperties.get(propEntity), panelToUse);
        }
    }

    private void designPanel(FlowPanel panel, String header) {
        panel.setStyleName("formPanel");
        Label propHeader = new Label(header);
        propHeader.setStyleName("nonOntologyPropertyLabel");
        panel.add((Widget)propHeader);
    }

    protected void drawReferencedBy() {
        Anchor referencedBy = new Anchor("Referenced by...");
        referencedBy.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.references, NonOntologyPropertiesRenderer.this.eiInstance.getEntity(), EIEntity.NULL_ENTITY, ApplicationState.getInstance().getResourceProviderEntity());
            }
        });
        FlowPanel referencePanel = new FlowPanel();
        referencePanel.add((Widget)referencedBy);
        referencePanel.setStyleName("formPanelRow");
        referencedBy.setStyleName("referencedBy");
        this.nonOntologyOuterPanel.add((Widget)referencePanel);
    }

    private void drawReadOnlyProperties(Map<EIEntity, String> labelMap, FlowPanel metaPanel, Map<EIEntity, String> readOnlyLiterals, Map<EIEntity, EIEntity> readOnlyResources) {
        for (EIEntity propEntity : readOnlyLiterals.keySet()) {
            this.drawReadOnlyLiteralProperty(propEntity, this.makeSetFromSingle(readOnlyLiterals.get(propEntity)), labelMap, metaPanel);
        }
        for (EIEntity propEntity : readOnlyResources.keySet()) {
            this.drawReadOnlyResourceProperty(propEntity, this.makeSetFromSingleEntity(readOnlyResources.get(propEntity)), labelMap, metaPanel);
        }
    }

    protected HashSet<String> makeSetFromSingle(String value) {
        return new HashSet<String>(Arrays.asList(value));
    }

    protected HashSet<EIURI> makeSetFromSingleURI(EIURI value) {
        return new HashSet<EIURI>(Arrays.asList(value));
    }

    protected HashSet<EIEntity> makeSetFromSingleEntity(EIEntity value) {
        return new HashSet<EIEntity>(Arrays.asList(value));
    }

    protected Widget handleReadOnlyTextProperty(String value) {
        if (value.startsWith("www") || value.startsWith("http")) {
            return new Anchor(InstanceWidgetUtils.formatText((String)value), InstanceWidgetUtils.formatText((String)value), "_blank");
        }
        HTML valueField = new HTML(InstanceWidgetUtils.formatText((String)InstanceWidgetUtils.insertBreaks((String)value)));
        valueField.setStyleName("formLabelValue");
        return valueField;
    }

    protected void drawReadOnlyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, FlowPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (String value : propertyValues) {
            widget.add(this.handleReadOnlyTextProperty(value));
        }
        nonOntologyPanel.add((Widget)widget);
    }

    protected void drawReadOnlyResourceProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap, FlowPanel nonOntologyPanel) {
        String propLabel = labelMap == null || labelMap.get(propertyEntity) == null || labelMap.get(propertyEntity).equals("") ? propertyEntity.getLabel() : labelMap.get(propertyEntity);
        LabelValuesWidget widget = new LabelValuesWidget(propLabel);
        for (EIEntity propEntity : propertyValues) {
            if (propEntity == null || propEntity == EIEntity.NULL_ENTITY) continue;
            widget.add(this.handleReadOnlyTextProperty(propEntity.getLabel()));
        }
        nonOntologyPanel.add((Widget)widget);
    }
}

