/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.datatools.client.ui.ResourceProviderCache;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class Workbench
extends Composite
implements ResourceProviderCache.ResourceProviderCacheListener {
    private final ResourceProviderCache providerCache;
    private FlowPanel mainPanel;
    private FocusPanel addProviderPanel;
    private FocusPanel workWithProvidersPanel;
    private FocusPanel workWithResourcesPanel;
    private FocusPanel toDoListPanel;
    private Anchor chooseProviderLink;
    private FlowPanel chooseProviderPanel;
    private FlowPanel chooseProviderDropdownPanel;
    private ListBox providersList = new ListBox();
    private static final GWTLogger log = GWTLogger.getLogger("Workbench");

    public Workbench(ResourceProviderCache providerCache) {
        this.mainPanel = new FlowPanel();
        this.initWidget((Widget)this.mainPanel);
        this.mainPanel.setStyleName("dtWorkBench");
        this.providerCache = providerCache;
        providerCache.addProviderLoadListener(this);
        this.addProviderPanel = new FocusPanel();
        this.addProviderPanel.add((Widget)new HTML("Create an Organization"));
        this.addProviderPanel.setStyleName("dtWbPanel");
        this.addProviderPanel.addStyleName("dtWbCreateLab");
        this.chooseProviderLink = new Anchor("Work with Organizations");
        this.workWithProvidersPanel = new FocusPanel();
        this.workWithProvidersPanel.add((Widget)new HTML("Browse Organizations in My Institution"));
        this.workWithProvidersPanel.setStyleName("dtWbPanel");
        this.workWithProvidersPanel.addStyleName("dtWbAllLabs");
        this.workWithResourcesPanel = new FocusPanel();
        this.workWithResourcesPanel.add((Widget)new HTML("Browse People & Resources in My Institution "));
        this.workWithResourcesPanel.setStyleName("dtWbPanel");
        this.workWithResourcesPanel.addStyleName("dtWbResources");
        this.toDoListPanel = new FocusPanel();
        this.toDoListPanel.add((Widget)new HTML("Unfinished Tasks"));
        this.toDoListPanel.setStyleName("dtWbPanel");
        this.toDoListPanel.addStyleName("dtWbTodo");
        this.chooseProviderPanel = new FlowPanel();
        this.chooseProviderDropdownPanel = new FlowPanel();
        if (providerCache.isLoading()) {
            this.providersList.addItem("...loading...");
        } else {
            this.populateResourceProvidersList();
        }
        this.chooseProviderPanel.add((Widget)new HTML("Work With My Organizations"));
        this.chooseProviderPanel.add((Widget)this.chooseProviderDropdownPanel);
        this.providersList.setStyleName("dtWbCurrentLabSelect");
        this.chooseProviderDropdownPanel.add((Widget)this.providersList);
        this.chooseProviderDropdownPanel.setStyleName("dtWbCurrentLabsDropdown");
        this.chooseProviderPanel.setStyleName("dtWbPanel");
        this.chooseProviderPanel.addStyleName("dtWbCurrentLab");
        this.mainPanel.add((Widget)this.chooseProviderPanel);
        this.mainPanel.add((Widget)this.addProviderPanel);
        this.mainPanel.add((Widget)this.workWithProvidersPanel);
        this.mainPanel.add((Widget)this.workWithResourcesPanel);
        this.mainPanel.add((Widget)this.toDoListPanel);
        this.addProviderPanel.addClickHandler(this.getAddProviderHandler());
        this.chooseProviderLink.addClickHandler(this.getChooseProviderHandler());
        this.workWithProvidersPanel.addClickHandler(this.getWorkWithProvidersHandler());
        this.workWithResourcesPanel.addClickHandler(this.getPeopleAndResourcesHandler());
        this.toDoListPanel.addClickHandler(this.getToDoListHandler());
    }

    private ClickHandler getWorkWithProvidersHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.providers, EIEntity.NULL_ENTITY, ResourceProvider.RESOURCE_PROVIDER_CLASS_GROUP_ENTITY, EIEntity.NULL_ENTITY);
            }
        };
    }

    private ClickHandler getChooseProviderHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Workbench.this.providerCache.isLoading()) {
                    Window.alert((String)"Resource contributing organizations are still loading. Please wait.");
                }
                Workbench.this.chooseProviderPanel.setVisible(true);
            }
        };
    }

    private ClickHandler getPeopleAndResourcesHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.resources, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY);
            }
        };
    }

    private ClickHandler getAddProviderHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.edit, EIEntity.NULL_ENTITY, ResourceProvider.BASE_RESOURCE_CONTAINER, EIEntity.NULL_ENTITY);
            }
        };
    }

    private ClickHandler getToDoListHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.stubs, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY);
            }
        };
    }

    private void populateResourceProvidersList() {
        this.providersList.clear();
        this.providersList.addItem("select an organization");
        StringBuilder strBuild = new StringBuilder();
        for (EIEntity provider : this.providerCache.getResourceProviderEntities()) {
            strBuild.append(provider.getLabel());
            strBuild.append(" <");
            strBuild.append(this.providerCache.getResourceProviderType(provider).getLabel());
            strBuild.append(">");
            this.providersList.addItem(strBuild.toString(), provider.getURI().toString());
            strBuild.delete(0, strBuild.length());
        }
        this.providersList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                EIURI selectedUri = EIURI.create((String)Workbench.this.providersList.getValue(Workbench.this.providersList.getSelectedIndex()));
                EIEntity selectedEntity = Workbench.this.providerCache.getResourceProvider(selectedUri);
                if (selectedEntity == null || selectedEntity.equals((Object)EIEntity.NULL_ENTITY)) {
                    return;
                }
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.view, selectedEntity, ResourceProvider.BASE_RESOURCE_CONTAINER, selectedEntity);
            }
        });
    }

    @Override
    public void onProvidersLoaded() {
        this.populateResourceProvidersList();
    }

    public void resetSelectedProvider() {
        this.providersList.setSelectedIndex(0);
    }
}

