/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.ActionRedisplay;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.FormRedisplay;
import org.eaglei.datatools.client.ui.OwnershipAction;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;

public class ButtonsPanel
extends Composite {
    private static final int MINIMUM_EDIT_TRANSITIONS = 0;
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    protected Label formControlLabel;
    @UiField
    protected Label wfLabel;
    @UiField
    protected Button workFlowActionButton1;
    @UiField
    protected Button workFlowActionButton2;
    @UiField
    protected Button workFlowActionButton3;
    @UiField
    protected Button workFlowActionButton4;
    @UiField
    protected Button claimReleaseButton;
    @UiField
    protected Button saveButton;
    @UiField
    protected Button editButton;
    @UiField
    protected Button cancelButton;
    @UiField
    protected Button copyResourceButton;
    @UiField
    protected Button deleteButton;
    @UiField
    protected RadioButton onlyThisProvider;
    @UiField
    protected RadioButton all;
    private final EIInstance instance;
    private EIClass rootSuperClass;
    private final FormRedisplay redisplay;
    private OwnershipAction ownershipAction;
    private final Map<Button, WorkFlowTransition> buttonTransitions = new HashMap<Button, WorkFlowTransition>();
    private final List<Button> workFlowButtons;
    private static final GWTLogger log = GWTLogger.getLogger("ButtonsPanel");

    ButtonsPanel(EIInstance anInstance, FormRedisplay aRedisplay) {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.instance = anInstance;
        this.redisplay = aRedisplay;
        this.workFlowButtons = Arrays.asList(this.workFlowActionButton1, this.workFlowActionButton2, this.workFlowActionButton3, this.workFlowActionButton4);
        this.setClaimOrReleaseButtonAction();
        this.setDeleteButtonAction();
        this.setWorkflowButtons();
        this.all.setVisible(false);
        this.onlyThisProvider.setVisible(false);
    }

    public void setProviderRestrictionSelector(final ProviderRestrictionListener listener) {
        this.all.setValue(Boolean.valueOf(false));
        this.onlyThisProvider.setValue(Boolean.valueOf(true));
        this.all.setVisible(false);
        this.onlyThisProvider.setVisible(false);
        this.onlyThisProvider.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                listener.selectOnlyProvider();
            }
        });
        this.all.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                listener.selectAll();
            }
        });
    }

    public void setWorkflowButtons() {
        this.setEditingButtonState();
        this.buttonTransitions.clear();
        List<WorkFlowTransition> legalTransitions = ClientRepositoryToolsManager.INSTANCE.getAllowedTransitions(this.instance);
        log.debug("Found " + (legalTransitions == null ? "null" : Integer.valueOf(legalTransitions.size())) + " legal transitions");
        this.wfLabel.setVisible(false);
        if (legalTransitions != null && legalTransitions.size() > 0) {
            int i = 0;
            for (WorkFlowTransition transition : legalTransitions) {
                if (transition.getFromStateURI().equals((Object)transition.getToStateURI())) {
                    log.debug("skipping " + transition.getName() + " because from and to are same");
                    continue;
                }
                if (!this.wfLabel.isVisible()) {
                    this.wfLabel.setVisible(true);
                }
                final Button currentButton = this.workFlowButtons.get(i);
                currentButton.setVisible(true);
                this.setEnable(currentButton, ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance) && !this.isStub(this.instance));
                currentButton.setText(transition.getName());
                this.buttonTransitions.put(currentButton, transition);
                currentButton.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        ClientRepositoryToolsManager.INSTANCE.transition(ButtonsPanel.this.instance, (WorkFlowTransition)ButtonsPanel.this.buttonTransitions.get(currentButton), new RootAsyncCallback<EIInstance>(){

                            @Override
                            public void onSuccess(EIInstance success) {
                                ButtonsPanel.this.instance.setWFState(success.getWFState());
                                ButtonsPanel.this.redisplay.drawAfterPromote(ButtonsPanel.this.instance);
                            }
                        });
                    }
                });
                ++i;
            }
            while (i < 4) {
                this.hide(this.workFlowButtons.get(i));
                ++i;
            }
        } else {
            this.wfLabel.setVisible(false);
            this.hide(this.workFlowActionButton1);
            this.hide(this.workFlowActionButton2);
            this.hide(this.workFlowActionButton3);
            this.hide(this.workFlowActionButton4);
        }
    }

    private boolean isStub(EIInstance anInstance) {
        return anInstance.getNonOntologyLiteralProperties().containsKey(DatatoolsUIConstants.isStubEntity);
    }

    private void setEditingButtonState() {
        this.setEnable(this.editButton, ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance));
        this.setEnable(this.deleteButton, ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance));
    }

    private void hide(Button button) {
        this.setEnable(button, false);
        button.setVisible(false);
    }

    protected void setEnable(Button workflowButton, boolean enable) {
        workflowButton.setEnabled(enable);
        if (enable) {
            workflowButton.removeStyleName("btnDisabled");
        } else {
            workflowButton.addStyleName("btnDisabled");
        }
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public void setRootSuperClass(EIClass superclass) {
        this.rootSuperClass = superclass;
    }

    public void setClaimOrReleaseButtonAction() {
        this.claimReleaseButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ButtonsPanel.this.claimReleaseButton.getText().equalsIgnoreCase("Claim")) {
                    ButtonsPanel.this.claimOrRelease();
                } else {
                    ButtonsPanel.this.claimOrRelease();
                }
            }
        });
        if (ClientRepositoryToolsManager.INSTANCE.canClaim(this.instance)) {
            this.claimReleaseButton.setText("Claim");
            this.ownershipAction = OwnershipAction.ClaimAction;
        } else if (ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance)) {
            this.claimReleaseButton.setText("Share");
            this.ownershipAction = OwnershipAction.ReleaseAction;
        } else {
            this.ownershipAction = OwnershipAction.ClaimAction;
            this.claimReleaseButton.setText("Claim");
            this.claimReleaseButton.setVisible(true);
            this.setEnable(this.claimReleaseButton, false);
        }
    }

    private void setDeleteButtonAction() {
        final RootAsyncCallback<Void> callback = new RootAsyncCallback<Void>(){

            @Override
            public void onSuccess(Void result) {
                if (ResourceProvider.isResourceProviderType(ButtonsPanel.this.instance.getInstanceType())) {
                    ApplicationState.getInstance().updateResourceProviderCache();
                }
                EIEntity typeEntity = ButtonsPanel.this.rootSuperClass == null ? ButtonsPanel.this.instance.getInstanceType() : ButtonsPanel.this.rootSuperClass.getEntity();
                EIEntity providerEntity = ResourceProvider.isResourceProviderType(ButtonsPanel.this.instance.getInstanceType()) ? EIEntity.NULL_ENTITY : ApplicationState.getInstance().getResourceProviderEntity();
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.list, EIEntity.NULL_ENTITY, typeEntity, providerEntity);
            }
        };
        this.deleteButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)"Are you sure you want to delete this resource?")) {
                    ClientRepositoryToolsManager.INSTANCE.deleteInstance(ButtonsPanel.this.instance.getInstanceURI(), callback);
                }
            }
        });
    }

    private void claimOrRelease() {
        this.ownershipAction.perform(this.instance, new ActionRedisplay(){

            @Override
            public void handleFailedTransition(String error) {
                Window.alert((String)("Action failed; error is " + error));
            }

            @Override
            public void drawAfterClaim(EIInstanceMinimal[] instances, List<EIInstanceMinimal> successes) {
                if (successes.size() == 0) {
                    Window.alert((String)("Unable to claim " + ButtonsPanel.this.instance.getInstanceLabel()));
                } else {
                    ButtonsPanel.this.ownershipAction = ButtonsPanel.this.ownershipAction.toggle();
                    ButtonsPanel.this.claimReleaseButton.setText(ButtonsPanel.this.ownershipAction.getName());
                    EIInstanceMinimal claimedMinimal = instances[0];
                    ButtonsPanel.this.instance.setWFOwner(claimedMinimal.getWFOwner());
                    ButtonsPanel.this.setWorkflowButtons();
                    ButtonsPanel.this.redisplay.drawAfterPromote(ButtonsPanel.this.instance);
                }
            }

            @Override
            public void drawAfterPromote(EIInstanceMinimal[] instances, List<EIInstanceMinimal> failures) {
            }

            @Override
            public void needsRefresh(String message) {
                Window.alert((String)"Resource is out of date.  Please refresh and try again.");
            }
        });
    }

    public void hideAllWorkflowButtons() {
        this.wfLabel.setVisible(false);
        this.hide(this.workFlowActionButton1);
        this.hide(this.workFlowActionButton2);
        this.hide(this.workFlowActionButton3);
        this.hide(this.workFlowActionButton4);
    }

    public boolean isPresenlyOwner() {
        return this.instance.getWFOwner() != null && this.instance.getWFOwner().getURI().equals((Object)ApplicationState.getInstance().getUserURI());
    }

    public static interface ProviderRestrictionListener {
        public void selectOnlyProvider();

        public void selectAll();
    }

    static interface Binder
    extends UiBinder<Widget, ButtonsPanel> {
    }
}

