/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.datatools.client.ui.widgets.OntologyDropdown;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.suggest.client.OntologyDropdownBase;
import org.eaglei.suggest.client.SharedClassChooser;

public class FilterPanel
extends Composite {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    protected FlowPanel subTypeFilter;
    @UiField
    protected Label subTypeLabel;
    @UiField
    protected ListBox statusFilter;
    @UiField
    protected ListBox resourceTypeFilter;
    @UiField
    protected ListBox providerFilter;
    @UiField
    protected Label statusLabel;
    @UiField
    protected Label providerLabel;
    @UiField
    protected Label resourceTypeLabel;
    @UiField
    protected Label filterLabel;
    @UiField
    protected Label totalResources;
    @UiField
    protected RadioButton ownedByMe;
    @UiField
    protected RadioButton all;
    @UiField
    protected Button goButton;
    SharedClassChooser<OntologyDropdown> classChooser;
    private boolean isTopLevel = false;
    private static final GWTLogger log = GWTLogger.getLogger("FilterPanel");
    private final String genericOption = "All";

    protected FilterPanel() {
    }

    public FilterPanel(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterProviderEntity) {
        this.init(filterTypeEntity, filterWorkflowEntity, filterProviderEntity);
        this.initOwnerFilter(filterTypeEntity, filterWorkflowEntity, filterProviderEntity, false);
    }

    public FilterPanel(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterProviderEntity, boolean strictFilterByOwner) {
        this.init(filterTypeEntity, filterWorkflowEntity, filterProviderEntity);
        this.initOwnerFilter(filterTypeEntity, filterWorkflowEntity, filterProviderEntity, strictFilterByOwner);
    }

    private void init(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterProviderEntity) {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.filterLabel.setVisible(true);
        if (filterTypeEntity != null && !filterTypeEntity.equals((Object)EIEntity.NULL_ENTITY)) {
            this.initSubTypeFilter(filterTypeEntity);
        } else {
            this.isTopLevel = true;
            this.resourceTypeFilter.addItem("All");
            this.subTypeFilter.setVisible(false);
            this.subTypeLabel.setVisible(false);
            this.disable((FocusWidget)this.resourceTypeFilter);
        }
        this.initWorkflowFilter(filterWorkflowEntity);
        this.initProviderFilter(filterProviderEntity);
        this.initGoButton();
    }

    public void disable() {
        this.disable((FocusWidget)this.resourceTypeFilter);
        this.disable((FocusWidget)this.providerFilter);
        this.disable((FocusWidget)this.statusFilter);
        this.disable((FocusWidget)this.goButton);
    }

    private void disable(FocusWidget filter) {
        filter.setEnabled(false);
        filter.setStyleName("btnDisabled");
    }

    public void setCount(int numberOfResources) {
        this.totalResources.setText("(" + numberOfResources + ") instances found");
        this.totalResources.setVisible(true);
    }

    private void initOwnerFilter(final EIEntity filterTypeEntity, final EIEntity filterWorkflowEntity, final EIEntity filterProviderEntity, boolean strictFilterByOwner) {
        this.all.setValue(Boolean.valueOf(!strictFilterByOwner));
        this.ownedByMe.setValue(Boolean.valueOf(strictFilterByOwner));
        ClickHandler clickHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApplicationState.getInstance().updateApplicationFilterState(filterTypeEntity, filterWorkflowEntity, filterProviderEntity, FilterPanel.this.ownedByMe.getValue());
            }
        };
        this.ownedByMe.addClickHandler(clickHandler);
        this.all.addClickHandler(clickHandler);
    }

    private void initGoButton() {
        this.goButton.setVisible(true);
        this.goButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                EIEntity filterProviderEntity;
                EIEntity filterTypeEntity;
                if (FilterPanel.this.isTopLevel) {
                    filterTypeEntity = EIEntity.NULL_ENTITY;
                } else {
                    filterTypeEntity = FilterPanel.this.classChooser.getSelectedEntity();
                    if (filterTypeEntity == null || filterTypeEntity == EIEntity.NULL_ENTITY) {
                        filterTypeEntity = ApplicationState.getInstance().hasType() ? ApplicationState.getInstance().getTypeEntity() : EIEntity.NULL_ENTITY;
                    }
                }
                String providerLabel = FilterPanel.this.providerFilter.getItemText(FilterPanel.this.providerFilter.getSelectedIndex());
                if (FilterPanel.this.isGenericOption(providerLabel)) {
                    filterProviderEntity = EIEntity.NULL_ENTITY;
                } else {
                    EIURI providerUri = EIURI.create((String)FilterPanel.this.providerFilter.getValue(FilterPanel.this.providerFilter.getSelectedIndex()));
                    filterProviderEntity = EIEntity.create((EIURI)providerUri, (String)providerLabel);
                }
                WorkFlowConstants wfc = new WorkFlowConstants();
                String statusLabel = FilterPanel.this.statusFilter.getItemText(FilterPanel.this.statusFilter.getSelectedIndex());
                EIEntity filterWorkflowEntity = wfc.getStatusEntity(statusLabel);
                ApplicationState.getInstance().updateApplicationFilterState(filterTypeEntity, filterWorkflowEntity, filterProviderEntity, FilterPanel.this.ownedByMe.getValue());
            }
        });
    }

    private void initWorkflowFilter(EIEntity filterWorkflowEntity) {
        this.statusFilter.setVisible(true);
        this.statusLabel.setVisible(true);
        this.statusFilter.addItem("All");
        for (EIEntity entity : WorkFlowConstants.WORKFLOW_ENTITY_LIST) {
            this.statusFilter.addItem(entity.getLabel(), entity.getURI().toString());
            if (!entity.equals((Object)filterWorkflowEntity)) continue;
            this.statusFilter.setSelectedIndex(this.statusFilter.getItemCount() - 1);
        }
    }

    private void initProviderFilter(final EIEntity filterProviderEntity) {
        this.providerFilter.setVisible(true);
        this.providerLabel.setVisible(true);
        if (ApplicationState.getInstance().getTypeEntity().equals((Object)ResourceProvider.BASE_RESOURCE_CONTAINER)) {
            this.providerFilter.addItem("All");
            this.disable((FocusWidget)this.providerFilter);
            return;
        }
        if (!EIEntity.NULL_ENTITY.equals((Object)filterProviderEntity)) {
            this.providerFilter.addItem(filterProviderEntity.getLabel(), filterProviderEntity.getURI().toString());
        } else {
            this.providerFilter.addItem("All");
        }
        if (!EIEntity.NULL_ENTITY.equals((Object)ApplicationState.getInstance().getResourceProviderEntity())) {
            this.disable((FocusWidget)this.providerFilter);
        } else {
            this.providerFilter.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent arg0) {
                    if (FilterPanel.this.providerFilter.getItemCount() == 1) {
                        FilterPanel.this.providerFilter.removeItem(FilterPanel.this.providerFilter.getItemCount() - 1);
                        FilterPanel.this.providerFilter.addItem("List is loading....");
                        AuthSearchRequest request = new AuthSearchRequest();
                        request.setType(ResourceProvider.BASE_RESOURCE_CONTAINER_URI);
                        request.setPaginated(false);
                        ClientRepositoryToolsManager.INSTANCE.listResources(request, SortByProperties.label, ApplicationState.getInstance().isAcending(), false, ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.stubs, new RootAsyncCallback<List<EIInstanceMinimal>>(){

                            @Override
                            public void onSuccess(List<EIInstanceMinimal> eiInstanceList) {
                                FilterPanel.this.providerFilter.removeItem(FilterPanel.this.providerFilter.getItemCount() - 1);
                                FilterPanel.this.providerFilter.addItem("All");
                                for (EIInstanceMinimal instance : eiInstanceList) {
                                    FilterPanel.this.providerFilter.addItem(instance.getInstanceLabel(), instance.getInstanceURI().toString());
                                    if (!instance.getEntity().equals((Object)filterProviderEntity)) continue;
                                    FilterPanel.this.providerFilter.setSelectedIndex(FilterPanel.this.providerFilter.getItemCount() - 1);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private void initSubTypeFilter(final EIEntity filterTypeEntity) {
        this.resourceTypeFilter.setVisible(false);
        this.resourceTypeLabel.setVisible(false);
        this.classChooser = new SharedClassChooser((OntologyDropdownBase)new OntologyDropdown());
        this.classChooser.setTextBoxStyle("formText");
        this.classChooser.setVisible(false);
        this.filterLabel.setVisible(false);
        this.subTypeFilter.add(this.classChooser);
        this.subTypeLabel.setVisible(false);
        this.subTypeFilter.setVisible(true);
        ClientModelManager.INSTANCE.getClass(ApplicationState.getInstance().getTypeUri(), new ClientModelManager.ClassCallback(){

            public void onSuccess(EIClass result) {
                FilterPanel.this.filterLabel.setVisible(true);
                FilterPanel.this.classChooser.setVisible(true);
                FilterPanel.this.classChooser.setClass(result, false);
                FilterPanel.this.classChooser.setSelectedEntity(filterTypeEntity);
            }
        });
    }

    private boolean isGenericOption(String label) {
        return "All".equals(label);
    }

    static interface Binder
    extends UiBinder<Widget, FilterPanel> {
    }
}

