/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.EditFormRedisplay;
import org.eaglei.datatools.client.ui.EditFormsPanel;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.datatools.client.ui.ViewFormRedisplay;
import org.eaglei.datatools.client.ui.ViewFormsPanel;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.InstancePanel;

public class FormsPanelFactory {
    private static final GWTLogger log = GWTLogger.getLogger("FormsPanelFactory");

    @Deprecated
    private FormsPanelFactory() {
    }

    public static FlowPanel generateNewForm(EIEntity typeEntity) {
        return FormsPanelFactory.generateNewForm(typeEntity.getURI(), FormsPanelFactory.getNewFormRedisplay());
    }

    public static FlowPanel generateNewForm(EIURI typeUri, final EditFormRedisplay redisplay) {
        final FlowPanel vp = new FlowPanel();
        ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(typeUri, new RootAsyncCallback<EIInstance>(){

            @Override
            public void onSuccess(EIInstance newInstance) {
                EditFormsPanel formsPanel = EditFormsPanel.createNewForm(newInstance, redisplay);
                vp.add((Widget)formsPanel);
            }
        });
        return vp;
    }

    public static InstancePanel generateEditForm(EIInstance instance) {
        return FormsPanelFactory.generateEditContents(instance);
    }

    public static FlowPanel generateDuplicateForm(EIInstance instance) {
        FlowPanel vp = new FlowPanel();
        vp.setStyleName("formPanel");
        EditFormsPanel formsPanel = EditFormsPanel.createNewForm(instance, FormsPanelFactory.getNewFormRedisplay());
        vp.add((Widget)formsPanel);
        return vp;
    }

    public static FlowPanel generateViewForm(EIURI uri) {
        final FlowPanel vp = new FlowPanel();
        vp.setStyleName("formPanel");
        ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new RootAsyncCallback<EIInstance>(){

            @Override
            public void onSuccess(EIInstance instance) {
                vp.add((Widget)FormsPanelFactory.generateViewForm(instance));
            }
        });
        return vp;
    }

    @Deprecated
    public static FlowPanel generateEditForm(String eiuri) {
        return FormsPanelFactory.generateEditForm(EIURI.create((String)eiuri));
    }

    public static FlowPanel generateEditForm(EIURI uri) {
        final FlowPanel vp = new FlowPanel();
        vp.setStyleName("formPanel");
        ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new RootAsyncCallback<EIInstance>(){

            @Override
            public void onSuccess(EIInstance instance) {
                vp.add((Widget)FormsPanelFactory.generateEditContents(instance));
            }
        });
        return vp;
    }

    private static InstancePanel generateEditContents(EIInstance instance) {
        EditFormsPanel formsPanel = EditFormsPanel.createEditForm(instance, FormsPanelFactory.getEditFormRedisplay());
        return formsPanel;
    }

    public static FlowPanel generateViewForm(EIInstance instance) {
        FlowPanel vp = new FlowPanel();
        vp.setStyleName("formPanel");
        ViewFormsPanel formsPanel = new ViewFormsPanel(instance, FormsPanelFactory.getViewFormRedisplay());
        vp.add((Widget)formsPanel);
        return vp;
    }

    private static void handleLoginRequired() {
        Window.alert((String)"Please log in.");
    }

    protected static EditFormRedisplay getEditFormRedisplay() {
        return new EditFormRedisplay(){

            @Override
            public void drawAfterSave(EIInstance instance) {
                ApplicationState.getInstance().updateResourceProviderCache();
                EIEntity providerEntity = ResourceProvider.getProperResourceProviderEntity(instance);
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.view, instance.getEntity(), instance.getInstanceType(), providerEntity);
            }

            @Override
            public void drawAfterPromote(EIInstance instance) {
                AbstractEntryPoint.clearDataPanel();
                ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new RootAsyncCallback<EIInstance>(){

                    @Override
                    public void onSuccess(EIInstance fetchedInstance) {
                        FormsPanelFactory.generateEditForm(fetchedInstance);
                    }
                });
            }

            @Override
            public void drawAfterCancel(final EIInstance instance) {
                AbstractEntryPoint.clearDataPanel();
                ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new RootAsyncCallback<EIInstance>(){

                    @Override
                    public void onSuccess(EIInstance fetchedInstance) {
                        FormsPanelFactory.viewAfterUpdate(fetchedInstance);
                    }

                    @Override
                    public void onFailure(Throwable caught) {
                        super.onFailure(caught);
                        FormsPanelFactory.viewAfterUpdate(instance);
                    }
                });
            }

            @Override
            public void drawAfterDuplicate(EIInstance instance) {
                FormsPanelFactory.copyResource(instance.getInstanceURI());
            }
        };
    }

    protected static ViewFormRedisplay getViewFormRedisplay() {
        return new ViewFormRedisplay(){

            @Override
            public void drawAfterPromote(EIInstance instance) {
                AbstractEntryPoint.clearDataPanel();
                ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new RootAsyncCallback<EIInstance>(){

                    @Override
                    public void onSuccess(EIInstance fetchedInstance) {
                        AbstractEntryPoint.showData((Widget)FormsPanelFactory.generateViewForm(fetchedInstance));
                    }
                });
            }

            @Override
            public void drawAfterDuplicate(EIInstance instance) {
                FormsPanelFactory.copyResource(instance.getInstanceURI());
            }

            @Override
            public void drawEdit(EIInstance instance) {
                AbstractEntryPoint.clearDataPanel();
                AbstractEntryPoint.showData((Widget)FormsPanelFactory.generateEditForm(instance));
            }
        };
    }

    public static void copyResource(EIURI instanceId) {
        ClientRepositoryToolsManager.INSTANCE.deepCopyInstance(instanceId, new RootAsyncCallback<EIInstance>(){

            @Override
            public void onSuccess(EIInstance eiInstance) {
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.duplicate, eiInstance.getEntity(), eiInstance.getInstanceType(), ResourceProvider.getProperResourceProviderEntity(eiInstance));
                AbstractEntryPoint.showData((Widget)FormsPanelFactory.generateDuplicateForm(eiInstance));
            }
        });
    }

    protected static EditFormRedisplay getNewFormRedisplay() {
        return new EditFormRedisplay(){

            @Override
            public void drawAfterSave(EIInstance instance) {
                if (ResourceProvider.isResourceProviderType(instance.getInstanceType())) {
                    log.debug("updating resource provider cache");
                    ApplicationState.getInstance().updateResourceProviderCache();
                }
                EIEntity providerEntity = ResourceProvider.getProperResourceProviderEntity(instance);
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.view, instance.getEntity(), instance.getInstanceType(), providerEntity);
            }

            @Override
            public void drawAfterPromote(EIInstance instance) {
                Window.alert((String)"Cannot promote an unsaved new instance");
            }

            @Override
            public void drawAfterCancel(EIInstance instance) {
                Window.alert((String)"shouldn't get here (I think)");
            }

            @Override
            public void drawAfterDuplicate(EIInstance instance) {
                FormsPanelFactory.copyResource(instance.getInstanceURI());
            }
        };
    }

    public static String getWFStateString(EIInstance instance) {
        return instance.getWFState() == null ? "" : instance.getWFState().toString();
    }

    public static void viewAfterSave(boolean showSuccessMsg, EIInstance instance) {
        AbstractEntryPoint.clearDataPanel();
        if (showSuccessMsg) {
            HTML msg = new HTML("<font color='green'>Resource has been saved.</font>");
            AbstractEntryPoint.showData((Widget)msg);
        }
        ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.view, instance.getEntity(), ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getResourceProviderEntity());
    }

    public static void viewAfterUpdate(EIInstance fetchedInstance) {
        ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.view, fetchedInstance.getEntity(), ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getResourceProviderEntity());
    }
}

