/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.datatools.client.ui.ResourceProviderCache;
import org.eaglei.datatools.client.ui.widgets.LeftListRowWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;

public class LeftListPanel
extends FlowPanel
implements ClientRepositoryToolsManager.SessionListener,
ApplicationStateChangeListener,
ResourceProviderCache.ResourceProviderCacheListener {
    private static final String PANEL_SELECTED = "panelSelected";
    private static final String PANEL_NOT_SELECTED = "panelNotSelected";
    private static final EIEntity allTypesEntity = EIEntity.create((EIURI)EIURI.NULL_EIURI, (String)"All Resource Types");
    private boolean signedIn = false;
    private List<EIClass> resourceTypesForProvider;
    private List<EIClass> resourceTypesForBrowse = new ArrayList<EIClass>();
    private EIClass documentType;
    private Map<EIEntity, String> definitions;
    private Map<EIEntity, LeftListRowWidget> providerRows = new HashMap<EIEntity, LeftListRowWidget>();
    private Map<EIEntity, LeftListRowWidget> browseRows = new HashMap<EIEntity, LeftListRowWidget>();
    private final LeftListRowWidget allTypesRow = new LeftListRowWidget(allTypesEntity, "", false);
    private final Anchor switchProvidersLink = new Anchor();
    private final ListBox providersList = new ListBox();
    private final Label providerNameLabel = new Label();
    private final Label resourcesLabel = new Label();
    private final Label peopleAndOrganizationsLabel = new Label();
    private final ResourceProviderCache resourceProviderCache;
    private static final GWTLogger log = GWTLogger.getLogger("LeftListPanel");

    public LeftListPanel(ResourceProviderCache resourceProviderCache) {
        ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
        ApplicationState.getInstance().addApplicationStateListener(this);
        this.resourceProviderCache = resourceProviderCache;
        resourceProviderCache.addProviderLoadListener(this);
        this.signedIn = ApplicationState.getInstance().hasUser();
        if (this.signedIn) {
            this.getResourceTypes();
        }
    }

    @Override
    public void onApplicationStateChange() {
        this.drawFromApplicationState();
    }

    private void drawFromApplicationState() {
        if (!ApplicationState.getInstance().hasUser() && !this.signedIn) {
            this.clear();
            return;
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.workbench) {
            this.setVisible(false);
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.providers || ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.edit && ApplicationState.getInstance().hasResourceProviderType() || ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.filter && ApplicationState.getInstance().hasResourceProviderType()) {
            this.setVisible(false);
        } else if (ApplicationState.getInstance().hasResourceProvider()) {
            this.setVisible(true);
            this.buildProviderPanel();
        } else {
            this.setVisible(true);
            this.buildBrowsePanel();
        }
    }

    private void getResourceTypes() {
        if (ApplicationState.getInstance().getResourceTypesForProvider() == null) {
            ClientModelManager.INSTANCE.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate", new ClientModelManager.ClassesInGroupCallback(){

                public void onSuccess(List<EIClass> classList) {
                    AbstractEntryPoint.hideGlasspane();
                    ApplicationState.getInstance().setResourceTypesForProvider(classList);
                    LeftListPanel.this.resourceTypesForProvider = classList;
                    LeftListPanel.this.getDocumentClass();
                }
            });
        } else {
            this.resourceTypesForProvider = ApplicationState.getInstance().getResourceTypesForProvider();
            this.getDocumentClass();
        }
    }

    private void getDocumentClass() {
        if (ApplicationState.getInstance().getResourceTypesForBrowse() == null) {
            ClientModelManager.INSTANCE.getClass(DatatoolsUIConstants.documentEntity.getURI(), new ClientModelManager.ClassCallback(){

                public void onSuccess(EIClass result) {
                    LeftListPanel.this.resourceTypesForBrowse.addAll(LeftListPanel.this.resourceTypesForProvider);
                    LeftListPanel.this.documentType = result;
                    LeftListPanel.this.resourceTypesForBrowse.add(LeftListPanel.this.documentType);
                    Collections.sort(LeftListPanel.this.resourceTypesForBrowse, new Comparator<EIClass>(){

                        @Override
                        public int compare(EIClass arg0, EIClass arg1) {
                            return arg0.getEntity().compareTo(arg1.getEntity());
                        }
                    });
                    ApplicationState.getInstance().setResourceTypesForBrowse(LeftListPanel.this.resourceTypesForBrowse);
                    LeftListPanel.this.getTypeDefinitions(LeftListPanel.this.resourceTypesForBrowse);
                }
            });
        } else {
            this.resourceTypesForBrowse = ApplicationState.getInstance().getResourceTypesForBrowse();
            this.getTypeDefinitions(this.resourceTypesForBrowse);
        }
    }

    private void getTypeDefinitions(List<EIClass> classes) {
        if (ApplicationState.getInstance().getClassDefinitions() == null) {
            ClientModelManager.INSTANCE.getClassDefinitions(classes, new ClientModelManager.ClassDefinitionCallback(){

                public void onSuccess(List<EIClass> result) {
                    LeftListPanel.this.definitions = new HashMap();
                    for (EIClass eclass : result) {
                        LeftListPanel.this.definitions.put(eclass.getEntity(), eclass.getDefinition());
                    }
                    LeftListPanel.this.createPanel();
                }
            });
        } else {
            this.definitions = ApplicationState.getInstance().getClassDefinitions();
            this.createPanel();
        }
    }

    private void createPanel() {
        this.initializeMapOfRows();
        this.resourcesLabel.setText("Browse Resources");
        this.resourcesLabel.setStyleName("leftListHeader");
        this.peopleAndOrganizationsLabel.setText("Browse People and Organizations");
        this.peopleAndOrganizationsLabel.setStyleName("leftListHeader");
        this.switchProvidersLink.setHTML("switch organizations");
        this.switchProvidersLink.setStyleName("gwt_add_item");
        this.switchProvidersLink.addStyleName("liveLink");
        this.switchProvidersLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                LeftListPanel.this.providersList.setVisible(true);
            }
        });
        this.providerNameLabel.setStyleName("labSelected");
        this.providerNameLabel.addStyleName("liveLink");
        this.providerNameLabel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.view, ApplicationState.getInstance().getResourceProviderEntity(), ResourceProvider.BASE_RESOURCE_CONTAINER, ApplicationState.getInstance().getResourceProviderEntity());
            }
        });
        this.setStyleName("leftPanel");
        if (this.signedIn) {
            this.drawFromApplicationState();
        }
    }

    private void buildBrowsePanel() {
        this.clear();
        this.add((Widget)this.resourcesLabel);
        this.addAllTypesOption();
        this.populateTypeSelectors(this.resourceTypesForBrowse, this.browseRows, false);
        this.add((Widget)this.peopleAndOrganizationsLabel);
        this.populatePersonAndOrganizationSelectors();
        this.selectType(this.browseRows);
    }

    private void buildProviderPanel() {
        this.clear();
        String providerName = ApplicationState.getInstance().hasResourceProvider() ? ApplicationState.getInstance().getResourceProviderEntity().getLabel() : "";
        this.providerNameLabel.setText(providerName);
        this.add((Widget)this.providerNameLabel);
        this.add((Widget)this.switchProvidersLink);
        this.providersList.setVisible(false);
        if (this.resourceProviderCache.isLoading()) {
            this.providersList.addItem("loading...");
        } else {
            this.populateProvidersList();
        }
        this.add((Widget)this.providersList);
        this.addAllTypesOption();
        this.populateTypeSelectors(this.resourceTypesForProvider, this.providerRows, true);
        this.selectType(this.providerRows);
    }

    private void populateProvidersList() {
        if (this.resourceProviderCache.isLoading()) {
            return;
        }
        this.providersList.setStyleName("leftListDropdown");
        this.providersList.clear();
        this.providersList.addItem("select an organization");
        StringBuilder strBuild = new StringBuilder();
        for (EIEntity provider : this.resourceProviderCache.getResourceProviderEntities()) {
            strBuild.append(provider.getLabel());
            strBuild.append(" <");
            strBuild.append(this.resourceProviderCache.getResourceProviderType(provider).getLabel());
            strBuild.append(">");
            this.providersList.addItem(strBuild.toString(), provider.getURI().toString());
            strBuild.delete(0, strBuild.length());
        }
        this.providersList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                EIURI selectedUri = EIURI.create((String)LeftListPanel.this.providersList.getValue(LeftListPanel.this.providersList.getSelectedIndex()));
                EIEntity selectedEntity = LeftListPanel.this.resourceProviderCache.getResourceProvider(selectedUri);
                LeftListPanel.this.providersList.setVisible(false);
                if (selectedEntity == null || selectedEntity.equals((Object)EIEntity.NULL_ENTITY)) {
                    return;
                }
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.view, selectedEntity, ResourceProvider.BASE_RESOURCE_CONTAINER, selectedEntity);
            }
        });
    }

    private void initializeMapOfRows() {
        this.initializeMapOfRowsForResources(this.resourceTypesForProvider, this.providerRows, true);
        this.initializeMapOfRowsForResources(this.resourceTypesForBrowse, this.browseRows, false);
        LeftListRowWidget personRow = new LeftListRowWidget(DatatoolsUIConstants.personEntity, DatatoolsUIConstants.personEntity.getLabel(), false);
        this.browseRows.put(DatatoolsUIConstants.personEntity, personRow);
        LeftListRowWidget organizationRow = new LeftListRowWidget(DatatoolsUIConstants.organizationEntity, DatatoolsUIConstants.organizationEntity.getLabel(), false);
        this.browseRows.put(DatatoolsUIConstants.organizationEntity, organizationRow);
    }

    private void initializeMapOfRowsForResources(List<EIClass> resourceTypesList, Map<EIEntity, LeftListRowWidget> rows, boolean canAdd) {
        for (EIClass eiClass : resourceTypesList) {
            LeftListRowWidget row = new LeftListRowWidget(eiClass, this.definitions.get(eiClass.getEntity()), canAdd);
            rows.put(eiClass.getEntity(), row);
        }
    }

    private void populateTypeSelectors(List<EIClass> resourceTypesList, Map<EIEntity, LeftListRowWidget> rows, boolean shouldHaveAddNew) {
        for (EIClass eiClass : resourceTypesList) {
            this.add((Widget)rows.get(eiClass.getEntity()));
        }
    }

    private void populatePersonAndOrganizationSelectors() {
        this.add((Widget)this.browseRows.get(DatatoolsUIConstants.personEntity));
        this.add((Widget)this.browseRows.get(DatatoolsUIConstants.organizationEntity));
    }

    private void addAllTypesOption() {
        this.add((Widget)this.allTypesRow);
    }

    private void selectType(final Map<EIEntity, LeftListRowWidget> rows) {
        this.unselectAll(rows);
        if (ApplicationState.getInstance().hasResourceProviderType()) {
            return;
        }
        if (!ApplicationState.getInstance().hasType()) {
            this.allTypesRow.setStyleName(PANEL_SELECTED);
        } else {
            EIEntity typeEntity = ApplicationState.getInstance().getTypeEntity();
            ClientRepositoryToolsManager.INSTANCE.getRootSuperClass(typeEntity, new RootAsyncCallback<EIClass>(){

                @Override
                public void onSuccess(EIClass result) {
                    if (rows.containsKey(result.getEntity())) {
                        ((LeftListRowWidget)((Object)rows.get(result.getEntity()))).setStyleName(LeftListPanel.PANEL_SELECTED);
                    }
                }
            });
        }
    }

    private void unselectAll(Map<EIEntity, LeftListRowWidget> rows) {
        for (LeftListRowWidget row : rows.values()) {
            row.setStyleName(PANEL_NOT_SELECTED);
        }
        this.allTypesRow.setStyleName(PANEL_NOT_SELECTED);
    }

    @Override
    public void onLogOut(boolean isSessionExpired) {
        this.signedIn = false;
        this.clear();
    }

    @Override
    public void onLogIn(String username, String userUri) {
        this.signedIn = true;
        if (this.resourceTypesForProvider != null && this.resourceTypesForProvider.size() > 0) {
            this.createPanel();
        } else {
            log.debug("left list panel logging in: about to get resource types");
            this.getResourceTypes();
        }
    }

    @Override
    public void onProvidersLoaded() {
        this.populateProvidersList();
    }
}

