/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;

public class ResourceProvider {
    public static final EIURI BASE_RESOURCE_CONTAINER_URI = EIURI.create((String)"http://eagle-i.org/ont/app/1.0/ClassGroup_ResourceProvider");
    public static final String BASE_RESOURCE_CONTAINER_LABEL = "Organization";
    public static final EIEntity BASE_RESOURCE_CONTAINER = EagleIEntityConstants.EI_ORGANIZATION_ENTITY;
    public static final EIEntity RESOURCE_PROVIDER_CLASS_GROUP_ENTITY = EIEntity.create((EIURI)BASE_RESOURCE_CONTAINER_URI, (String)"Organizations");
    private static Set<EIEntity> providerTypes;
    private static boolean initialized;
    private static final GWTLogger log;

    private ResourceProvider() {
    }

    public static boolean isResourceProviderType(EIEntity entity) {
        if (!initialized) {
            ResourceProvider.initializeProviderTypes();
        }
        return providerTypes == null ? false : providerTypes.contains(entity);
    }

    public static EIEntity getProperResourceProviderEntity(EIInstance instance) {
        EIEntity result = EIEntity.NULL_ENTITY;
        if (ResourceProvider.isResourceProviderType(instance.getInstanceType())) {
            result = instance.getEntity();
        } else if (ApplicationState.getInstance().getResourceProviderEntity() != instance.getEntity()) {
            result = ApplicationState.getInstance().getResourceProviderEntity();
        }
        return result;
    }

    private static void initializeProviderTypes() {
        log.info("getting classes in group");
        ClientModelManager.INSTANCE.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_ResourceProvider", true, new ClientModelManager.ClassesInGroupCallback(){

            public void onSuccess(List<EIClass> result) {
                if (result == null || result.size() == 0) {
                    log.error("Got null or zero size set of provider types from callback.");
                } else {
                    providerTypes = new HashSet(result.size());
                    log.info("got resource-providing classes " + result.size());
                    for (EIClass range : result) {
                        providerTypes.add(range.getEntity());
                    }
                    initialized = true;
                }
            }
        });
    }

    static {
        initialized = false;
        log = GWTLogger.getLogger("ResourceProvider");
        ResourceProvider.initializeProviderTypes();
    }
}

