/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.datatools.client.ui.widgets.StubWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

public class EIResourceListWidget
extends EditWidget {
    private static final String CREATE_NEW_VALUE = "<create new>";
    private static final String NO_VALUE = "<none>";
    private static final int CREATE_NEW_INDEX = 1;
    private final ListBox instances = new ListBox();
    private final EIClass range;
    private final boolean shouldHaveLabel;
    private final boolean isPropertyProviderRelated;
    private final NewInnerInstanceListener listener;
    private final FlowPanel valuePanel;
    private StubWidget stubWidget;
    private Anchor allProvidersAnchor;
    private Label stubMessage;
    private final Anchor changeProviderLink;
    private static GWTLogger log = GWTLogger.getLogger("EIResourceListWidget");

    public EIResourceListWidget(EIInstance instance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIClass range, EIEntity selectedEntity, boolean shouldShowLabel, boolean isPropertyProviderRelated, NewInnerInstanceListener listener) {
        super(instance, propertyEntity, propertyDefinition, isRequired);
        this.range = range;
        this.listener = listener;
        if (selectedEntity != null && selectedEntity != EIEntity.NULL_ENTITY) {
            this.oldValue = selectedEntity.getURI().toString();
            if (selectedEntity.getLabel().equals("") || selectedEntity.getLabel().equals(EIEntity.NULL_ENTITY.getLabel())) {
                selectedEntity.setLabel(selectedEntity.getURI().toString());
            }
        }
        this.shouldHaveLabel = shouldShowLabel;
        if (!this.shouldHaveLabel) {
            this.widgetPanel.remove((Widget)this.label);
        }
        this.isPropertyProviderRelated = isPropertyProviderRelated;
        this.valuePanel = new FlowPanel();
        this.valuePanel.setStyleName("ResourceListPanel");
        this.widgetPanel.add((Widget)this.valuePanel);
        this.changeProviderLink = new Anchor("Change organization.");
        this.stubMessage = new Label("Can be completed after saving.");
        this.stubMessage.setStyleName("commentOnComments");
        this.setup();
        this.intializeInstances(selectedEntity);
    }

    private void intializeInstances(EIEntity selectedEntity) {
        this.instances.setStyleName("formDropdown");
        this.addDefaultInstanceValues();
        if (this.range.equals((Object)EIClass.NULL_CLASS)) {
            log.info("skipping get instances");
            if (this.hasOldValue()) {
                this.instances.removeItem(this.instances.getItemCount() - 1);
                String probablyDeletedLabel = "[non-standard link] " + this.getOldStringValue();
                this.instances.addItem(probablyDeletedLabel, this.getOldStringValue());
                this.instances.setSelectedIndex(this.instances.getItemCount() - 1);
            }
        } else if (!this.isInProvider()) {
            this.fillListBoxWithResources(false, EIURI.NULL_EIURI, selectedEntity);
        } else {
            this.fillListBoxWithResources(true, ApplicationState.getInstance().getResourceProviderUri(), selectedEntity);
        }
        this.instances.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent arg0) {
                EIResourceListWidget.this.doOnChange(EIResourceListWidget.this.eiInstance, EIResourceListWidget.this.range, EIResourceListWidget.this.propertyEntity, EIResourceListWidget.this.oldValue, EIResourceListWidget.this.instances);
            }
        });
    }

    private void fillListBoxWithResources(final boolean onlyFromThisProvider, final EIURI providerEIURI, final EIEntity selectedEntity) {
        this.instances.clear();
        this.instances.addItem("...loading...", null);
        log.debug("requesting resource list for " + this.range.getEntity().getURI());
        EIURI correctedRange = this.getCorrectRangeUri(this.range);
        ClientRepositoryToolsManager.INSTANCE.listResourcesForObjectPropertyValue(correctedRange, providerEIURI, EIURI.NULL_EIURI, !this.isPropertyProviderRelated && onlyFromThisProvider, new RootAsyncCallback<List<EIInstanceMinimal>>(){

            @Override
            public void onSuccess(List<EIInstanceMinimal> result) {
                if (EIResourceListWidget.this.hasOldValue() && onlyFromThisProvider && EIResourceListWidget.this.oldValueMissingFromResult(result) && !EIResourceListWidget.this.listener.isAddedInstanceEntity(selectedEntity)) {
                    ClientRepositoryToolsManager.INSTANCE.listResourcesForObjectPropertyValue(EIResourceListWidget.this.range.getEntity().getURI(), providerEIURI, EIURI.NULL_EIURI, false, new RootAsyncCallback<List<EIInstanceMinimal>>(){

                        @Override
                        public void onSuccess(List<EIInstanceMinimal> result) {
                            EIResourceListWidget.this.setInstancesAndPickLists(false, result, selectedEntity);
                            EIResourceListWidget.this.allProvidersAnchor.setText(DatatoolsUIConstants.FROM_ONLY_CURRENT_PROVIDER);
                            EIResourceListWidget.this.allProvidersAnchor.setVisible(false);
                        }
                    });
                }
                EIResourceListWidget.this.setInstancesAndPickLists(onlyFromThisProvider, result, selectedEntity);
            }
        });
    }

    private void setInstancesAndPickLists(boolean onlyFromThisProvider, List<EIInstanceMinimal> result, EIEntity selectedEntity) {
        this.instances.clear();
        this.instances.addItem(NO_VALUE, null);
        this.instances.addItem(CREATE_NEW_VALUE, null);
        if (!onlyFromThisProvider && ApplicationState.getInstance().hasResourceProvider()) {
            int j = result.size() - 1;
            for (int i = 0; i < result.size(); ++i) {
                if (result.get(j).getLab().equals((Object)ApplicationState.getInstance().getResourceProviderEntity())) {
                    result.add(0, result.remove(j));
                    continue;
                }
                --j;
            }
        }
        for (EIInstanceMinimal instance : result) {
            this.instances.addItem(this.formatInstanceForListBox(instance), instance.getInstanceURI().toString());
            if (ApplicationState.getInstance().hasResourceProvider() && instance.getLab().equals((Object)ApplicationState.getInstance().getResourceProviderEntity())) {
                Element childElement = (Element)this.instances.getElement().getChild(this.instances.getItemCount() - 1);
                childElement.setClassName("ownlabTxt");
            }
            if (!instance.getInstanceURI().toString().equals(this.oldValue)) continue;
            this.instances.setSelectedIndex(this.instances.getItemCount() - 1);
        }
        log.debug("selected entity" + selectedEntity + "; selected index: " + this.instances.getSelectedIndex() + "; is added instance? " + this.listener.isAddedInstanceEntity(selectedEntity));
        if (this.instances.getSelectedIndex() == 0 && this.listener.isAddedInstanceEntity(selectedEntity)) {
            this.instances.setSelectedIndex(1);
            this.addStubWidget(this.range, selectedEntity, this.listener.getAddedInstance(selectedEntity));
        }
    }

    private boolean oldValueMissingFromResult(List<EIInstanceMinimal> fetchedInstances) {
        EIURI oldUri = EIURI.create((String)this.oldValue);
        for (EIInstanceMinimal instance : fetchedInstances) {
            if (!instance.getInstanceURI().equals((Object)oldUri)) continue;
            return false;
        }
        return true;
    }

    private void addDefaultInstanceValues() {
        this.instances.addItem(NO_VALUE, null);
        this.instances.addItem(CREATE_NEW_VALUE, null);
        this.instances.addItem("...loading...", null);
    }

    private void doOnChange(EIInstance instance, final EIClass range, final EIEntity propertyEntity, String propertyValue, ListBox subClassList) {
        if (subClassList.getItemText(subClassList.getSelectedIndex()).equals(NO_VALUE)) {
            this.removeValue();
            if (this.stubWidget != null) {
                this.valuePanel.remove((Widget)this.stubMessage);
                this.listener.onInstanceRemoved(this.stubWidget.getEIInstance());
            }
            this.allProvidersAnchor.setVisible(true);
        } else if (subClassList.getItemText(subClassList.getSelectedIndex()).equals(CREATE_NEW_VALUE)) {
            ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(range.getEntity().getURI(), new RootAsyncCallback<EIInstance>(){

                @Override
                public void onSuccess(EIInstance newInstance) {
                    EIResourceListWidget.this.listener.onInstanceAdded(newInstance);
                    newInstance.addNonOntologyLiteralProperty(DatatoolsUIConstants.isStubEntity, "True");
                    if (EIResourceListWidget.this.hasOldValue()) {
                        EIResourceListWidget.this.eiInstance.replaceObjectPropertyValue(propertyEntity, EIURI.create((String)EIResourceListWidget.this.oldValue), newInstance.getEntity());
                    } else {
                        EIResourceListWidget.this.eiInstance.addObjectProperty(propertyEntity, newInstance.getEntity());
                    }
                    EIResourceListWidget.this.updateOldValue(newInstance.getInstanceURI());
                    EIResourceListWidget.this.addStubWidget(range, propertyEntity, newInstance);
                }
            });
        } else {
            this.allProvidersAnchor.setVisible(true);
            if (this.stubWidget != null) {
                this.listener.onInstanceRemoved(this.stubWidget.getEIInstance());
                this.valuePanel.remove((Widget)this.stubWidget);
            }
            if (this.allProvidersAnchor.getText().equals(DatatoolsUIConstants.FROM_ONLY_CURRENT_PROVIDER)) {
                this.allProvidersAnchor.setVisible(false);
            }
            if (this.hasOldValue()) {
                this.eiInstance.replaceObjectPropertyValue(propertyEntity, EIURI.create((String)this.oldValue), WidgetUtils.getSelectedEntity(subClassList));
            } else {
                this.eiInstance.addObjectProperty(propertyEntity, WidgetUtils.getSelectedEntity(subClassList));
            }
            this.updateOldValue(WidgetUtils.getSelectedUri(subClassList));
        }
    }

    private void setup() {
        this.instances.setName(this.propertyEntity.getURI().toString() + "_instances");
        this.valuePanel.add((Widget)this.instances);
        this.allProvidersAnchor = new Anchor(DatatoolsUIConstants.FROM_ALL_PROVIDERS_LABEL);
        this.allProvidersAnchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EIResourceListWidget.this.fillResourceListAndToggle();
            }
        });
        if (this.isInProvider()) {
            this.valuePanel.add((Widget)this.allProvidersAnchor);
        }
    }

    private boolean isInProvider() {
        return ApplicationState.getInstance().hasResourceProvider();
    }

    private void fillResourceListAndToggle() {
        if (this.allProvidersAnchor.getText().equals(DatatoolsUIConstants.FROM_ALL_PROVIDERS_LABEL)) {
            this.fillListBoxWithResources(false, EIURI.NULL_EIURI, EIEntity.NULL_ENTITY);
            this.allProvidersAnchor.setText(DatatoolsUIConstants.FROM_ONLY_CURRENT_PROVIDER);
        } else {
            this.fillListBoxWithResources(true, ApplicationState.getInstance().getResourceProviderUri(), EIEntity.NULL_ENTITY);
            this.allProvidersAnchor.setText(DatatoolsUIConstants.FROM_ALL_PROVIDERS_LABEL);
        }
    }

    private String formatInstanceForListBox(EIInstanceMinimal valueInstance) {
        return valueInstance.getInstanceLabel() + " <" + valueInstance.getInstanceType().getLabel() + ">" + (!valueInstance.getLab().equals((Object)EIEntity.NULL_ENTITY) ? ", " + valueInstance.getLab().getLabel() : "");
    }

    @Override
    public EditWidget duplicateBlank() {
        return new EIResourceListWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, this.range, null, true, this.isPropertyProviderRelated, this.listener);
    }

    @Override
    protected void removeValue() {
        if (this.hasOldValue()) {
            if (this.stubWidget != null) {
                this.valuePanel.remove((Widget)this.stubWidget);
            }
            this.eiInstance.replaceObjectPropertyValue(this.propertyEntity, this.getOldEIURIValue(), null);
            this.oldValue = null;
        }
    }

    public void disableAsProviderProperty() {
        this.instances.setEnabled(false);
        this.allProvidersAnchor.setVisible(false);
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.duplicate) {
            this.valuePanel.remove((Widget)this.allProvidersAnchor);
            this.valuePanel.add((Widget)this.changeProviderLink);
            this.changeProviderLink.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    EIResourceListWidget.this.instances.setEnabled(true);
                    EIResourceListWidget.this.valuePanel.remove((Widget)EIResourceListWidget.this.changeProviderLink);
                    EIResourceListWidget.this.valuePanel.add((Widget)EIResourceListWidget.this.allProvidersAnchor);
                    EIResourceListWidget.this.allProvidersAnchor.setVisible(false);
                }
            });
        }
    }

    private void addStubWidget(EIClass range, EIEntity propertyEntity, EIInstance newInstance) {
        this.stubWidget = new StubWidget(newInstance, propertyEntity, range, "", true);
        this.allProvidersAnchor.setVisible(false);
        this.valuePanel.add((Widget)this.stubMessage);
        this.valuePanel.add((Widget)this.stubWidget);
    }

    private EIURI getCorrectRangeUri(EIClass currentRange) {
        if (currentRange.getEntity().getURI().toString().equals("http://purl.obolibrary.org/obo/ERO_0000001")) {
            return EIURI.create((String)"http://purl.obolibrary.org/obo/OBI_0000245");
        }
        return currentRange.getEntity().getURI();
    }
}

