/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.datatools.client.rpc.RepositorySecurityService;
import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.jena.FooRepositorySecurityProvider;
import org.eaglei.datatools.jena.RESTRepositoryProvider;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.SecurityProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class AbstractRemoteServiceServlet
extends RemoteServiceServlet
implements RepositorySecurityService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractRemoteServiceServlet.class);
    protected RepositoryProvider repoProvider = null;
    protected FooRepositorySecurityProvider securityProvider;
    protected JenaEIInstanceFactory jenaInstanceFactory;
    protected SecurityProvider generalSecurityProvider;
    protected EIOntModel ontModel;
    protected static ServletContext ctx;

    public void init() {
        log.info((Object)"initializing abstract remote service servlet");
        ctx = this.getServletContext();
        this.initializeSingletons();
        log.info((Object)"init succesful");
    }

    protected void initializeSingletons() {
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.doDependencyInjection((ApplicationContext)ctx);
    }

    protected void doDependencyInjection(ApplicationContext springAppContext) {
        this.ontModel = (EIOntModel)springAppContext.getBean(EIOntModel.class);
        this.jenaInstanceFactory = (JenaEIInstanceFactory)springAppContext.getBean(JenaEIInstanceFactory.class);
        this.generalSecurityProvider = (SecurityProvider)springAppContext.getBean(SecurityProvider.class);
        this.repoProvider = new RESTRepositoryProvider(this.jenaInstanceFactory, this.generalSecurityProvider);
        this.securityProvider = ((RESTRepositoryProvider)this.repoProvider).getDatatoolsSecurityProvider();
    }

    public void logout(Session session) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            this.securityProvider.logout(session);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    protected void handleNullSession(Session session) throws ClientSideRepositoryException {
        if (!this.isValid(session)) {
            throw new ClientSideRepositoryException(RepositoryProviderException.RepositoryProviderExceptionType.INVALID_SESSION);
        }
    }

    protected boolean isValid(Session session) {
        return session != null && session.getSessionId() != null;
    }

    public User login(String user, String password) throws ClientSideRepositoryException {
        try {
            User userObj = this.securityProvider.login(user, password);
            HttpSession httpSession = this.getThreadLocalRequest().getSession();
            httpSession.setAttribute("user", (Object)userObj);
            return userObj;
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public User whoami(Session session) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.securityProvider.whoami(session);
        }
        catch (RepositoryProviderException e) {
            log.error((Object)("whoami exception " + (Object)((Object)e)));
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public boolean isOnline() {
        return this.securityProvider.isOnline();
    }

    public List<Workspace> getWorkspaces(Session session) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.securityProvider.getWorkspaces(session);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    @Override
    public List<WorkFlowTransition> listWorkFlowTransitions(Session session, EIEntity workspaceEntity) throws ClientSideRepositoryException {
        try {
            return this.securityProvider.listWorkFlowTransitions(session, workspaceEntity);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }
}

