package org.eaglei.datatools.client.ui;

import static org.eaglei.ui.gwt.UIConstants.RESOURCE_HAS_STUBS;
import static org.eaglei.ui.gwt.UIConstants.RESOURCE_IS_STUB;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.RDFS_LABEL_ENTITY;
import static org.eaglei.ui.gwt.instance.EagleIEntityConstants.RDF_TYPE_ENTITY;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.widgets.EIEmbeddedResourceViewWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIOntConstants;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.ClassesInGroupCallback;
import org.eaglei.ui.gwt.instance.OntologyPropertiesRenderer;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;
import org.eaglei.ui.gwt.instance.widgets.LabelValuesWidget;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;

public class OntologyPropViewRenderer extends OntologyPropertiesRenderer{

	public OntologyPropViewRenderer( EIInstance eiInstance, FlowPanel ontologyPanel) {
		super(eiInstance, ontologyPanel);
	}

	@Override
	protected void drawDataProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<String> propertyValues) { 
		final LabelValuesWidget widget = new LabelValuesWidget( propertyEntity, propertyDefinition, isRequired );
		ontologyPanel.add( widget );
		for (final String value : propertyValues) {
			widget.add( handleReadOnlyTextProperty( value ) );
		}
	}

	@Override
	protected void drawObjectProperty(final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final Set<EIEntity> propertyValues) {
		if(eiInstance.isPropertyValueAnEmbeddedInstance( propertyEntity )) {
			for (final EIEntity propertyValue : propertyValues) { 
				if ( propertyValue == null || propertyValue == EIEntity.NULL_ENTITY || propertyValue.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ) {
					continue;
				} 
				EIEmbeddedResourceViewWidget embeddedWidget = new EIEmbeddedResourceViewWidget( eiInstance.getEmbeddedInstance( propertyValue ), propertyEntity, propertyDefinition);
				ontologyPanel.add( embeddedWidget );
			}
		} else {
			final LabelValuesWidget widget = new LabelValuesWidget( propertyEntity, propertyDefinition, isRequired );
			ontologyPanel.add( widget );
			boolean hadValue = false;
			for (final EIEntity propertyValue : propertyValues) { 
				if ( propertyValue == null || propertyValue == EIEntity.NULL_ENTITY || propertyValue.getLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ) {
					continue;
				} 
				hadValue = true;
				final String displayValue = eiInstance.isPropertyValueAStub( propertyEntity, propertyValue ) ? "* " + propertyValue.getLabel() : propertyValue.getLabel();
				final Anchor a = new Anchor( InstanceWidgetUtils.formatText( displayValue ) );
				
				if( eiInstance.isPropertyValueAStub( propertyEntity, propertyValue )){
					a.addStyleName( "Stub" );
				}
				widget.add( a );

				a.addClickHandler( new ClickHandler() {
					@Override
					public void onClick(final ClickEvent arg0) {
						//this is to check if entity is Ontology term or Repository instance 
						ClientRepositoryToolsManager.INSTANCE.isModelClassURI( propertyValue.getURI(), new RootAsyncCallback<Boolean>() {
							@Override
							public void onFailure(Throwable caught) {
								//log.error( "there is async error in org.eaglei.datatools.client.ui.ViewFormsPanel#draObjectProperty when calling isModelClassURI(EIURI) Async method " );
							}

							@Override
							public void onSuccess(Boolean result) {
								// if it is ontology entity then open glossary window otherwise get new instance from repository and show it 
								if ( result ) {
									Window.open( InstanceWidgetUtils.getGlossaryURL() + "#t=" + propertyValue.getURI().toString(), "", "" );
								}
								else {
									getInstanceByURI( propertyValue );
								}
							}
						} );
					}

				} );
				if ( !hadValue ) {
					ontologyPanel.remove( widget );
				}
			}
		}

	}

	protected Widget handleReadOnlyTextProperty(final String value) {
		if (value.startsWith("www") || value.startsWith("http")) {
			// For values that have external URIs
			return new Anchor(InstanceWidgetUtils.formatText(value), InstanceWidgetUtils.formatText(value), "_blank");
		} else {
			final HTML valueField = new HTML(InstanceWidgetUtils.formatText( InstanceWidgetUtils.insertBreaks( value )));
			valueField.setStyleName("formLabelValue");
			return valueField;
		}
	}
	
	private void getInstanceByURI(final EIEntity entity) {

		
			ClientRepositoryToolsManager.INSTANCE.getInstance( entity.getURI(), new RootAsyncCallback<EIInstance>() {

				@Override
				public void onSuccess(final EIInstance eiInstance) {
					if ( eiInstance != null  && !EIInstance.NULL_INSTANCE.equals( eiInstance)) {
						EIEntity providerEntity = ResourceProvider.getProperResourceProviderEntity( eiInstance );
						ApplicationState.getInstance().updateApplicationState( Mode.view, eiInstance.getEntity(), eiInstance.getInstanceType(), providerEntity );
					} 
				}
			} );
	}
	

	/* (non-Javadoc)
	 * @see org.eaglei.datatools.client.ui.OntologyPropertiesRenderer#getDataTypeEntities()
	 */
	@Override
	public Collection<EIEntity> getDataTypeEntities() {
		return eiInstance.getDatatypeProperties().keySet();
	}

	/* (non-Javadoc)
	 * @see org.eaglei.datatools.client.ui.OntologyPropertiesRenderer#getObjectTypeEntities()
	 */
	@Override
	public Collection<EIEntity> getObjectTypeEntities() {
		return eiInstance.getObjectProperties().keySet();
	}

	/* (non-Javadoc)
	 * @see org.eaglei.datatools.client.ui.OntologyPropertiesRenderer#addFormTitle(java.lang.String)
	 */
	@Override
	public void addFormTitle(String type) {
		if(eiInstance.isEmbeddedInstance()) {
			return;
		}
		HTML stubsMessage = null;
		if(eiInstance.hasStubs()) {
			stubsMessage = new HTML(RESOURCE_HAS_STUBS);
			
		} else if (eiInstance.isStub()) {
			stubsMessage = new HTML(RESOURCE_IS_STUB);
		}
		if(stubsMessage != null) {
			stubsMessage.setStyleName( "StubMessage" );
			ontologyPanel.add( stubsMessage );
		}
	}

	@Override
	public void fetchConstants() {
		if ( ApplicationState.getInstance().getEmbeddedClasses() == null ) {
			ClientModelManager.INSTANCE.getClassesInGroup( EIOntConstants.CG_EMBEDDED_CLASS, new ClassesInGroupCallback() {
				@Override
				public void onSuccess(final List<EIClass> result) {
					ApplicationState.getInstance().setEmbeddedClassList( result );
					finishSetup();
				}

			} );
		} else {
			finishSetup();
		}
	}
	
	@Override
	protected void addNameProperty(final String labelPrefix) {
		final EIEntity namePropEntity = EIEntity.create( RDFS_LABEL_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel( labelPrefix, RDFS_LABEL_ENTITY.getLabel(), true ) );
		drawDataProperty( namePropEntity, "", true, makeSetFromSingle( eiInstance.getInstanceLabel() ) );
	}

	@Override
	protected void addTypeProperty(final String labelPrefix) {
		final EIEntity typePropEntity = EIEntity.create( RDF_TYPE_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel( labelPrefix, RDF_TYPE_ENTITY.getLabel(), true ) );
		drawObjectProperty( typePropEntity, "", true, makeSetFromSingleEntity( eiInstance.getInstanceType() ) );
	}
}
