package org.eaglei.datatools.client.ui;

import java.util.List;

import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.BulkWorkflowCallback;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;

import com.google.gwt.user.client.Window;

public class OwnershipAction implements Performable {
	public static final OwnershipAction ClaimAction = new OwnershipAction( "claim" );
	public static final OwnershipAction ReleaseAction = new OwnershipAction( "share" );
	final String name;

	private OwnershipAction(final String name) {
		this.name = name;
	}
	
	public String getName() {
		return name;
	}
	
	public OwnershipAction toggle() {
		if (name.equals(ClaimAction.name)) {
			return ReleaseAction;
		} else {
			return ClaimAction;
		}
	}
	
	public void perform(final EIInstance instance, final ActionRedisplay redisplay) {
		perform(EIInstanceMinimal.create(instance), redisplay);
	}
	
	public void perform(final EIInstanceMinimal instance, final ActionRedisplay redisplay) {
		final EIInstanceMinimal[] singleton = new EIInstanceMinimal[] {instance};
		perform( singleton, redisplay );
	}

	public void perform(final EIInstanceMinimal[] instances, final ActionRedisplay redisplay) {
		perform( instances, makeCallback(instances, redisplay) );
	}

	public void perform(final EIInstanceMinimal[] instances, final BulkWorkflowCallback callback) {

			if (name.equals(ClaimAction.name)) {
				ClientRepositoryToolsManager.INSTANCE.claim( instances,  callback);
			} else {
				ClientRepositoryToolsManager.INSTANCE.release( instances,  callback);
			}
	}

	private BulkWorkflowCallback makeCallback(final EIInstanceMinimal[] instances, final ActionRedisplay redisplay) {
		return new BulkWorkflowCallback() {

			@Override
			public void onSuccess(final List<EIInstanceMinimal> successes) {
				redisplay.drawAfterClaim( instances, successes );
			}

			@Override
			public void onFailure(Throwable caught) {
				// TODO: call this
				redisplay.handleFailedTransition(caught.getMessage());
			}

			@Override
			public void needsRefresh(final String message) {
				redisplay.needsRefresh(message);
			}
		};
	}
	
	public boolean isValidFor(final EIInstanceMinimal instance) {
		if (name.equals(ClaimAction.name)) {
			return ClientRepositoryToolsManager.INSTANCE.canClaim(instance);
		} else {
			return ClientRepositoryToolsManager.INSTANCE.canEdit(instance);
		}
	}
}
