package org.eaglei.datatools.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.datatools.client.rpc.RepositorySecurityService;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelService;
import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.server.AbstractRemoteServiceServlet;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;

public class RepositoryToolsModelServlet extends AbstractRemoteServiceServlet implements RepositoryToolsModelService, RepositorySecurityService {

	/**
	 * 
	 */
	private static final Log log = LogFactory.getLog( RepositoryToolsModelServlet.class );
/*	private static final long serialVersionUID = 1L;
	private static final Log log = LogFactory.getLog( RepositoryToolsModelServlet.class );
	private RepositoryProvider repoProvider = null;
	private RepositorySecurityProvider securityProvider;
	private EIOntModel ontModel;
	private static ServletContext ctx;*/

	/*@Override
	// TODO clean this up - no need to distinguish between createProvider and loadDwefaults
	public void init() {
		ctx = getServletContext();
		RepositorySecurityProvider.setServletContext( ctx );
		initializeOntology();
		log.info( "init succesful" );
	}

	
	 * @Override protected void onBeforeRequestDeserialized(String serializedRequest) { // TODO Auto-generated method stub super.onBeforeRequestDeserialized(serializedRequest); }
	 
	protected void initializeOntology() {
		final WebApplicationContext webCtx = WebApplicationContextUtils.getWebApplicationContext( ctx );
		doDependencyInjection( webCtx );
	}

	
	 * Allow test subclasses to override servlet init and invoke this with their own ApplicationContext.
	 

*/
	@Override
	public void createInstance(final Session session, final EIInstance instance, final EIEntity workspaceEntity) throws ClientSideRepositoryException {
		if ( isNull( instance ) ) {
			log.error( "trying to create a null instance" );
			// FIXME throw exception
		}
		handleNullSession( session );
		try {
			repoProvider.createInstance( session, instance, workspaceEntity );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public void createInstances(final Session session, final List<EIInstance> instances, final EIEntity workspaceEntity) throws ClientSideRepositoryException {
		if ( instances == null ) {
			log.error( "trying to create null instances" );
			// FIXME do something
		}
		handleNullSession( session );

		try {
			repoProvider.createInstances( session, instances, workspaceEntity );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public void deleteInstance(final Session session, final EIURI instanceUri) throws ClientSideRepositoryException {

		handleNullSession( session );
		try {
			repoProvider.deleteInstance( session, instanceUri );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}

	}

	@Override
	public void deleteInstances(final Session session, final List<EIURI> instanceUris) throws ClientSideRepositoryException {
		handleNullSession( session );
		try {
			repoProvider.deleteInstances( session, instanceUris );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}

	}

	@Override
	public String getToken(Session session, EIInstance instance) throws ClientSideRepositoryException {
		handleNullSession( session );
		try {
			return repoProvider.getToken( session, instance );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public Map<EIInstance, String> getTokens(Session session, List<EIInstance> instances) throws ClientSideRepositoryException {

		handleNullSession( session );
		try {
			return repoProvider.getTokens( session, instances );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public void updateInstance(final Session session, final EIInstance instance, final String token) throws ClientSideRepositoryException {

		handleNullSession( session );
		try {
			repoProvider.updateInstance( session, instance, token );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}

	}

	@Override
	public void updateInstances(final Session session, Map<EIInstance, String> instancesWithTokens) throws ClientSideRepositoryException {

		handleNullSession( session );
		try {
			repoProvider.updateInstances( session, instancesWithTokens );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}

	}

	

	@Override
	public boolean isOnline() {

		return securityProvider.isOnline();
	}

	@Override
	public List<EIInstanceMinimal> EIQuery(final Session session, final String query) throws ClientSideRepositoryException {
		handleNullSession( session );
		try {
			return repoProvider.EIQuery( session, query );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public EIInstance getEmptyEIInstance(final Session session, final EIURI classUri, final EIEntity instanceEntity) throws ClientSideRepositoryException {

		try {
			return repoProvider.getEmptyEIInstance( session, classUri, instanceEntity );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public EIInstance getEmptyEIInstance(final Session session, final EIURI classUri) throws ClientSideRepositoryException {
		handleNullSession( session );
		try {
			final EIInstance instance = repoProvider.getEmptyEIInstance( session, classUri );
			if ( instance.getInstanceClass() == null || instance.getInstanceClass().equals( EIClass.NULL_CLASS ) ) {
				instance.setInstanceClass( ontModel.getClass( classUri ) );
			}
			return instance;
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public EIInstance deepCopy(final Session session, final EIURI originalUri) throws ClientSideRepositoryException {
		handleNullSession( session );
		try {
			return repoProvider.deepCopy( session, originalUri );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public List<EIURI> getNewInstanceID(final Session session, final int count) throws ClientSideRepositoryException {

		handleNullSession( session );
		try {
			return repoProvider.getNewInstanceID( session, count );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public String query(final Session session, final String sparql) throws ClientSideRepositoryException {

		handleNullSession( session );
		try {
			return repoProvider.query( session, sparql );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public EIInstance getOneInstance(final Session session, final EIURI instanceID, boolean isExtended) throws ClientSideRepositoryException {
		handleNullSession( session );
		try {
			return repoProvider.getOneInstance( session, instanceID, isExtended );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public List<EIInstanceMinimal> listResourcesForObjectPropertyValue(final Session session, final EIURI classUri, final EIURI provider, final EIURI state, final boolean onlyProvider) throws RepositoryProviderException {

		handleNullSession( session );
		try {
			return repoProvider.listResourcesForObjectPropertyValue( session, classUri, provider, state, onlyProvider );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public String retrieveLabel(final Session session, final EIURI uri) throws ClientSideRepositoryException {

		handleNullSession( session );
		try {
			return repoProvider.retrieveLabel( session, uri );
		} catch (final RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public EIClass getRootSuperclassForInstanceUri(final Session session, final EIURI instanceUri) throws ClientSideRepositoryException {
		handleNullSession( session );
		EIInstance instance;
		try {
			instance = repoProvider.getOneInstance( session, instanceUri, true );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
		if ( isNull( instance ) ) {
			return null;
		}
		return getRootSuperClass( instance.getInstanceClass() );
	}

	private boolean isNull(final EIInstance instance) {
		return instance == null || instance.getInstanceURI() == null || EIInstance.NULL_INSTANCE.equals( instance );
	}

	@Override
	public List<EIClass> getClassAndSuperclassesForInstanceUri(final Session session, final EIURI instanceUri) throws ClientSideRepositoryException {
		handleNullSession( session );
		EIInstance instance;
		try {
			instance = repoProvider.getOneInstance( session, instanceUri, true );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
		if ( isNull( instance ) ) {
			// FIXME is this correct?
			return null;
		}
		List<EIClass> classes = ontModel.getSuperClasses( instance.getInstanceType().getURI() );
		if ( classes == null || classes.isEmpty() ) {
			classes = new ArrayList<EIClass>( 1 );
		}
		classes.add( ontModel.getClass( instance.getInstanceType().getURI() ) );
		return classes;
	}

	@Override
	public EIClass getRootSuperClass(final EIClass eclass) {
		EIClass found = eclass;
		while ( found.hasSuperClass() ) {
			found = ontModel.getSuperClass( found );
		}
		return found;
	}

	public boolean isModelClassURI(final String uri) {
		return ontModel.isModelClassURI( uri );
	}

	@Override
	public List<Workspace> getWorkspaces(final Session session) throws ClientSideRepositoryException {
		handleNullSession( session );
		try {
			return securityProvider.getWorkspaces( session );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}

	}

	@Override
	public List<EIProperty> getAllEquivalentClasses(final List<EIProperty> propertiesToPopulate) {
		for (final EIProperty property : propertiesToPopulate) {
			if ( property instanceof EIObjectProperty ) {
				final EIObjectProperty objectProperty = (EIObjectProperty)property;
				log.debug( "equivalent classes for object property " + property );
				final List<EIClass> assertedRanges = objectProperty.getRangeList();
				log.debug( "   had " + ( assertedRanges == null ? "0" : assertedRanges.size() ) + " asserted ranges" );
				for (final EIClass range : assertedRanges) {
					if ( range != null && !range.equals( EIClass.NULL_CLASS ) && range.getEntity() != null && !range.getEntity().equals( EIEntity.NULL_ENTITY ) ) {

						final List<EIEquivalentClass> equivalentClasses = ontModel.getEquivalentClasses( range.getEntity().getURI() );
						if ( equivalentClasses != null ) {
							range.setEquivalentClasses( equivalentClasses );
							for (final EIEquivalentClass equivalence : equivalentClasses) {
								log.debug( "    equivalent class " + ( equivalence.getEquivalentTo() == null ? "empty" : equivalence.getEquivalentTo().size() ) );
							}
						} else { // TODO: remove!
							log.debug( "null classes" );
						}
					}
				}
			}
		}
		return propertiesToPopulate;
	}

	@Override
	public List<EIURI> claim(final Session session, final List<EIURI> uris) throws ClientSideRepositoryException {
		try {
			return repoProvider.claim( session, uris );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public List<EIInstanceMinimal> listResources(final Session session, final AuthSearchRequest queryRequest, final SortByProperties orderBy, final boolean isAscending, final boolean strictOwnerFilter) throws ClientSideRepositoryException {
		try {
			return repoProvider.listResources( session, queryRequest, orderBy, isAscending, strictOwnerFilter );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public List<EIInstanceMinimal> listResources(final Session session, final AuthSearchRequest queryRequest, final SortByProperties orderBy, final boolean isAscending, final boolean strictOwnerFilter, final boolean stubsOnly)
			throws ClientSideRepositoryException {
		try {
			return repoProvider.listResources( session, queryRequest, orderBy, isAscending, strictOwnerFilter, stubsOnly );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public List<EIInstanceMinimal> listReferencingResources(final Session session, final EIURI resourceUri, final AuthSearchRequest queryRequest, final SortByProperties orderBy, final boolean strictOwnerFilter) throws ClientSideRepositoryException {
		try {
			return repoProvider.listReferencingResources( session, resourceUri, queryRequest, orderBy, strictOwnerFilter );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public List<WorkFlowTransition> listWorkFlowTransitions(final Session session, final EIEntity workspaceEntity) throws ClientSideRepositoryException {
		try {
			return securityProvider.listWorkFlowTransitions( session, workspaceEntity );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public List<EIURI> release(final Session session, final List<EIURI> uris) throws ClientSideRepositoryException {
		try {
			return repoProvider.release( session, uris );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public List<EIURI> transition(final Session session, final List<EIURI> uris, final EIEntity transitionEntity) throws ClientSideRepositoryException {
		try {
			return repoProvider.transition( session, uris, transitionEntity );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public Map<EIURI, String> getModifiedDates(Session session, List<EIURI> uris) throws ClientSideRepositoryException {
		try {
			return repoProvider.getModifiedDates( session, uris );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public boolean addLabToUser(Session session, EIURI labUri) throws ClientSideRepositoryException {
		// TODO Auto-generated method stub
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.client.rpc.RepositoryToolsModelService#isModelClassURI(org.eaglei.model.EIURI)
	 */
	@Override
	public boolean isModelClassURI(EIURI uri) {
		return ontModel.isModelClassURI( uri.toString() );
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.provider.InstanceProvider#includeReferencingResources(org.eaglei.security.Session, org.eaglei.model.EIInstance)
	 */
	@Override
	public EIInstance setReferencingResources(Session session, EIInstance instance) throws RepositoryProviderException {
		return repoProvider.setReferencingResources( session, instance );
	}

	public boolean isValid(String sessionId, boolean shouldThrow) throws RepositoryProviderException {
		try {
			return securityProvider.isValid( sessionId, shouldThrow );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	public Session getSession(String sessionId) {
		return securityProvider.getSession( sessionId );
	}

	public HttpClient getHttpClient(Session session) {
		return securityProvider.getHttpClient( session );
	}

}
