/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.rpc;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.User;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.RepositorySecurityService;
import org.eaglei.datatools.client.rpc.RepositorySecurityServiceAsync;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelService;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelServiceAsync;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ModelService;
import org.eaglei.model.gwt.rpc.ModelServiceAsync;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.security.Session;

public class ClientRepositoryToolsManager {
    public static final ClientRepositoryToolsManager INSTANCE = new ClientRepositoryToolsManager();
    private static RepositoryToolsModelServiceAsync repositoryService;
    private static RepositorySecurityServiceAsync securityService;
    private static ModelServiceAsync modelService;
    private Session session;
    private User user;
    private ArrayList<SessionListener> listeners;
    private static final GWTLogger log;

    private ClientRepositoryToolsManager() {
        repositoryService = (RepositoryToolsModelServiceAsync)GWT.create(RepositoryToolsModelService.class);
        securityService = (RepositorySecurityServiceAsync)GWT.create(RepositorySecurityService.class);
        modelService = (ModelServiceAsync)GWT.create(ModelService.class);
    }

    public boolean isLoggedIn() {
        return Session.isValid((Session)this.session);
    }

    public void initializeAfterRefresh() {
        this.session = DatatoolsCookies.getSession();
    }

    private void handleLogOut() {
        this.session = null;
        this.user = null;
        Cookies.removeCookie((String)"datatools_username");
        Cookies.removeCookie((String)"datatools_userUri");
        Cookies.removeCookie((String)"datatools_session");
        log.info("removed cookies");
        if (this.listeners != null) {
            for (SessionListener listener : this.listeners) {
                listener.onLogOut(false);
            }
        }
    }

    public void handleExpiredSession() {
        this.session = null;
        this.user = null;
        Cookies.removeCookie((String)"datatools_username");
        Cookies.removeCookie((String)"datatools_userUri");
        Cookies.removeCookie((String)"datatools_session");
        log.info("removed cookies");
        if (this.listeners != null) {
            for (SessionListener listener : this.listeners) {
                listener.onLogOut(true);
            }
        }
    }

    public void addSessionListener(SessionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void logOut() {
        if (!this.isLoggedIn()) {
            return;
        }
        securityService.logout(this.session, (AsyncCallback)new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                ClientRepositoryToolsManager.this.handleLogOut();
            }

            public void onSuccess(Void result) {
                ClientRepositoryToolsManager.this.session = null;
                ClientRepositoryToolsManager.this.user = null;
                ClientRepositoryToolsManager.this.handleLogOut();
            }
        });
    }

    public void logIn(final String username, String password, final RootAsyncCallback<User> callback) {
        if (this.isLoggedIn()) {
            securityService.whoami(this.session, new AsyncCallback<User>(){

                public void onFailure(Throwable caught) {
                    ClientRepositoryToolsManager.this.user = null;
                    ClientRepositoryToolsManager.this.session = null;
                    callback.onFailure(caught);
                }

                public void onSuccess(User retrievedUser) {
                    log.info("user " + retrievedUser + " had " + ClientRepositoryToolsManager.this.user.getAllowedTransitionsForState(WorkFlowConstants.NEW_URI).size() + " transitions from New");
                    if (ClientRepositoryToolsManager.this.isUserDeniedAccess(retrievedUser)) {
                        ClientRepositoryToolsManager.this.handleAccessDenied(callback);
                    }
                    if (username.equals(retrievedUser.getUserName())) {
                        ClientRepositoryToolsManager.this.session = retrievedUser.getSession();
                        Cookies.setCookie((String)"datatools_session", (String)ClientRepositoryToolsManager.this.session.getSessionId());
                        callback.onSuccess(retrievedUser);
                    } else {
                        ClientRepositoryToolsManager.this.user = null;
                        ClientRepositoryToolsManager.this.session = null;
                        callback.onFailure((Throwable)((Object)new ClientSideRepositoryException("Error logging in: already logged in as different user.  Please log out first.")));
                    }
                }
            });
        } else {
            securityService.login(username, password, new AsyncCallback<User>(){

                public void onFailure(Throwable caught) {
                    ClientRepositoryToolsManager.this.user = null;
                    ClientRepositoryToolsManager.this.session = null;
                    callback.onFailure(caught);
                }

                public void onSuccess(User result) {
                    if (ClientRepositoryToolsManager.this.isUserDeniedAccess(result)) {
                        ClientRepositoryToolsManager.this.handleAccessDenied(callback);
                        return;
                    }
                    ClientRepositoryToolsManager.this.handleSucessfullLogin(username, result);
                    callback.onSuccess(result);
                }
            });
        }
    }

    public void handleSucessfullLogin(String username, User result) {
        this.session = result.getSession();
        String userUri = result.getUserURI().toString();
        this.user = result;
        Cookies.removeCookie((String)"datatools_username");
        Cookies.removeCookie((String)"datatools_userUri");
        Cookies.removeCookie((String)"datatools_session");
        Cookies.removeCookie((String)"datatools_institution_id");
        Cookies.setCookie((String)"datatools_username", (String)username);
        Cookies.setCookie((String)"datatools_userUri", (String)userUri);
        Cookies.setCookie((String)"datatools_session", (String)this.session.getSessionId());
        Cookies.setCookie((String)"datatools_institution_id", (String)this.session.getInstitutionId());
        log.info("set cookies; userUri = " + Cookies.getCookie((String)"datatools_userUri") + " session = " + Cookies.getCookie((String)"datatools_session"));
        if (this.listeners != null) {
            for (SessionListener listener : this.listeners) {
                listener.onLogIn(result.getUserName(), result.getUserURI().toString());
            }
        }
    }

    public void getToken(EIInstance instance, RootAsyncCallback<String> callback) {
        repositoryService.getToken(this.session, instance, callback);
    }

    public void getTokens(List<EIInstance> instances, RootAsyncCallback<Map<EIInstance, String>> callback) {
        repositoryService.getTokens(this.session, instances, callback);
    }

    public void updateInstance(EIInstance eiInstance, String token, RootAsyncCallback<Void> callback) {
        repositoryService.updateInstance(this.session, eiInstance, token, callback);
    }

    public void updateInstances(Map<EIInstance, String> instancesWithTokens, RootAsyncCallback<Void> callback) {
        repositoryService.updateInstances(this.session, instancesWithTokens, callback);
    }

    public void getInstance(EIURI eiURI, RootAsyncCallback<EIInstance> callback) {
        repositoryService.getOneInstance(this.session, eiURI, true, callback);
    }

    public void setReferencingResources(EIInstance instance, RootAsyncCallback<EIInstance> callback) {
        repositoryService.setReferencingResources(this.session, instance, callback);
    }

    public void deleteInstance(EIURI instanceUri, RootAsyncCallback<Void> callback) {
        repositoryService.deleteInstance(this.session, instanceUri, callback);
    }

    public boolean canEdit(EIURI workflowState) {
        return this.user.canEdit(workflowState);
    }

    public boolean canClaim(EIInstance instance) {
        if (ClientRepositoryToolsManager.isNotNull(instance.getWFState())) {
            return !this.instanceHasAnyOwner(instance) && this.canEdit(instance.getWFState().getURI());
        }
        return true;
    }

    public boolean canClaim(EIInstanceMinimal instance) {
        return !this.instanceHasAnyOwner(instance) && this.canEdit(instance.getWFStateUri());
    }

    public boolean canEdit(EIInstanceMinimal instance) {
        return this.instanceHasCurrentOwner(instance) && this.canEdit(instance.getWFStateUri());
    }

    public boolean canEdit(EIInstance instance) {
        if (ClientRepositoryToolsManager.isNotNull(instance.getWFState())) {
            return this.instanceHasCurrentOwner(instance) && this.canEdit(instance.getWFState().getURI());
        }
        return true;
    }

    public void listResourcesForObjectPropertyValue(EIURI classUri, EIURI provider, EIURI state, boolean onlyProvider, RootAsyncCallback<List<EIInstanceMinimal>> callback) {
        repositoryService.listResourcesForObjectPropertyValue(this.session, classUri, provider, state, onlyProvider, callback);
    }

    public void listResources(AuthSearchRequest queryRequest, SortByProperties orderBy, boolean isAscending, boolean strictOwnerFilter, boolean stubsOnly, RootAsyncCallback<List<EIInstanceMinimal>> callback) {
        repositoryService.listResources(this.session, queryRequest, orderBy, isAscending, strictOwnerFilter, stubsOnly, callback);
    }

    public void listReferencingResources(EIURI resourceUri, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter, RootAsyncCallback<List<EIInstanceMinimal>> callback) {
        repositoryService.listReferencingResources(this.session, resourceUri, queryRequest, orderBy, strictOwnerFilter, callback);
    }

    public void getNewInstanceID(int count, RootAsyncCallback<List<EIURI>> callback) {
        repositoryService.getNewInstanceID(this.session, count, callback);
    }

    public void createInstances(final List<EIInstance> instances, final RootAsyncCallback<List<EIInstance>> callback) {
        repositoryService.createInstances(this.session, instances, ApplicationState.getInstance().getWorkspaceEntity(), (AsyncCallback)new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(Void result) {
                log.info("creation succeeded");
                for (EIInstance instance : instances) {
                    instance.setWFState(WorkFlowConstants.DRAFT_ENTITY);
                }
                callback.onSuccess(instances);
            }
        });
    }

    public void createInstance(final EIInstance instance, final RootAsyncCallback<EIInstance> callback) {
        log.info("creating instance " + instance.getEntity() + " with type " + instance.getInstanceClass());
        repositoryService.createInstance(this.session, instance, ApplicationState.getInstance().getWorkspaceEntity(), (AsyncCallback)new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(Void result) {
                log.info("creation succeeded");
                instance.setWFState(WorkFlowConstants.DRAFT_ENTITY);
                callback.onSuccess(instance);
            }
        });
    }

    public void getEmptyEIInstance(final EIURI classUri, EIEntity instanceEntity, final RootAsyncCallback<EIInstance> callback) {
        repositoryService.getEmptyEIInstance(this.session, classUri, instanceEntity, new AsyncCallback<EIInstance>(){

            public void onFailure(Throwable caught) {
                log.warn("failed to get empty instance with class " + classUri);
                callback.onFailure(caught);
            }

            public void onSuccess(EIInstance instance) {
                instance.setWFOwner(ClientRepositoryToolsManager.this.user.getUserEntity());
                instance.setWFState(WorkFlowConstants.DRAFT_ENTITY);
                callback.onSuccess(instance);
            }
        });
    }

    public void getEmptyEIInstance(EIURI classUri, RootAsyncCallback<EIInstance> callback) {
        repositoryService.getEmptyEIInstance(this.session, classUri, callback);
    }

    public void deepCopyInstance(EIURI originalUri, RootAsyncCallback<EIInstance> callback) {
        repositoryService.deepCopy(this.session, originalUri, callback);
    }

    public void whoami(final RootAsyncCallback<User> callback) {
        if (securityService == null) {
            securityService = (RepositorySecurityServiceAsync)GWT.create(RepositorySecurityService.class);
        }
        Session session = DatatoolsCookies.getSession();
        securityService.whoami(session, new AsyncCallback<User>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(User userInfo) {
                if (userInfo != null && !userInfo.equals((Object)ClientRepositoryToolsManager.this.user)) {
                    ClientRepositoryToolsManager.this.user = userInfo;
                }
                callback.onSuccess(userInfo);
            }
        });
    }

    public void claim(final EIInstanceMinimal instance, final RootAsyncCallback<EIInstance> callback) {
        this.claim(new EIInstanceMinimal[]{instance}, new BulkWorkflowCallback(){

            @Override
            public void onSuccess(List<EIInstanceMinimal> successes) {
                if (successes == null || successes.size() == 0) {
                    callback.onFailure((Throwable)((Object)new ClientSideRepositoryException("claim failed for " + instance.getInstanceLabel())));
                }
                ClientRepositoryToolsManager.this.getInstance(successes.get(0).getInstanceURI(), callback);
            }

            @Override
            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            @Override
            public void needsRefresh(String message) {
                callback.onFailure((Throwable)((Object)new ClientSideRepositoryException(message)));
            }
        });
    }

    public void claim(EIInstanceMinimal[] instances, final BulkWorkflowCallback callback) {
        final HashMap<EIURI, EIInstanceMinimal> instanceUriMap = new HashMap<EIURI, EIInstanceMinimal>();
        for (EIInstanceMinimal instance : instances) {
            instanceUriMap.put(instance.getInstanceURI(), instance);
        }
        repositoryService.getModifiedDates(this.session, new ArrayList<EIURI>(instanceUriMap.keySet()), new AsyncCallback<Map<EIURI, String>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(Map<EIURI, String> result) {
                ArrayList<EIURI> unchangedUris = new ArrayList<EIURI>();
                ArrayList<EIURI> outdatedUris = new ArrayList<EIURI>();
                ClientRepositoryToolsManager.this.partitionOKUris(instanceUriMap, result, unchangedUris, outdatedUris);
                if (outdatedUris.size() > 0) {
                    callback.needsRefresh(outdatedUris.size() + " resources have been edited since first load");
                    return;
                }
                repositoryService.claim(ClientRepositoryToolsManager.this.session, unchangedUris, new AsyncCallback<List<EIURI>>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(List<EIURI> result) {
                        ArrayList<EIInstanceMinimal> successes = new ArrayList<EIInstanceMinimal>();
                        for (EIURI succeededUri : result) {
                            EIInstanceMinimal succeeded = (EIInstanceMinimal)instanceUriMap.get(succeededUri);
                            succeeded.setWFOwner(ClientRepositoryToolsManager.this.user.getUserEntity());
                            successes.add(succeeded);
                        }
                        callback.onSuccess(successes);
                    }
                });
            }
        });
    }

    protected void partitionOKUris(Map<EIURI, EIInstanceMinimal> instanceUriMap, Map<EIURI, String> uriModificationDateMap, List<EIURI> unchangedUris, List<EIURI> outdatedUris) {
        DateTimeFormat dateFormat = DateTimeFormat.getFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        for (EIURI uri : instanceUriMap.keySet()) {
            Date instanceModification;
            Date repositoryModification;
            String repositoryDateString = uriModificationDateMap.get(uri);
            if (repositoryDateString == null) {
                log.warn("no modification date from repository for " + uri);
                continue;
            }
            String instanceDateString = instanceUriMap.get(uri).getModifiedDate();
            if (instanceDateString == null) {
                outdatedUris.add(uri);
                return;
            }
            if (instanceDateString.indexOf("^") != -1) {
                instanceDateString = instanceDateString.substring(0, instanceDateString.indexOf("^"));
            }
            if ((repositoryModification = dateFormat.parse(repositoryDateString)).after(instanceModification = dateFormat.parse(instanceDateString))) {
                outdatedUris.add(uri);
                continue;
            }
            unchangedUris.add(uri);
        }
    }

    public void release(final EIInstanceMinimal instance, final RootAsyncCallback<EIInstance> callback) {
        this.release(new EIInstanceMinimal[]{instance}, new BulkWorkflowCallback(){

            @Override
            public void onSuccess(List<EIInstanceMinimal> successes) {
                if (successes == null || successes.size() == 0) {
                    callback.onFailure((Throwable)((Object)new ClientSideRepositoryException("release failed for " + instance.getInstanceLabel())));
                }
                ClientRepositoryToolsManager.this.getInstance(successes.get(0).getInstanceURI(), callback);
            }

            @Override
            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            @Override
            public void needsRefresh(String message) {
                callback.onFailure((Throwable)((Object)new ClientSideRepositoryException(message)));
            }
        });
    }

    public void release(EIInstanceMinimal[] instances, final BulkWorkflowCallback callback) {
        final HashMap<EIURI, EIInstanceMinimal> instanceUriMap = new HashMap<EIURI, EIInstanceMinimal>();
        for (EIInstanceMinimal instance : instances) {
            instanceUriMap.put(instance.getInstanceURI(), instance);
        }
        repositoryService.release(this.session, new ArrayList<EIURI>(instanceUriMap.keySet()), new AsyncCallback<List<EIURI>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(List<EIURI> result) {
                ArrayList<EIInstanceMinimal> successes = new ArrayList<EIInstanceMinimal>();
                for (EIURI succeededUri : result) {
                    EIInstanceMinimal succeeded = (EIInstanceMinimal)instanceUriMap.get(succeededUri);
                    succeeded.setWFOwner(EIEntity.NULL_ENTITY);
                    successes.add(succeeded);
                }
                callback.onSuccess(successes);
            }
        });
    }

    public static boolean isNotNull(EIEntity entity) {
        return entity != null && !EIEntity.NULL_ENTITY.equals((Object)entity);
    }

    public static boolean isNotNull(EIInstance instance) {
        return instance != null && !EIInstance.NULL_INSTANCE.equals(instance);
    }

    public boolean instanceHasCurrentOwner(EIInstance instance) {
        return ClientRepositoryToolsManager.isNotNull(instance.getWFOwner()) && instance.getWFOwner().equals((Object)this.user.getUserEntity());
    }

    public boolean instanceHasCurrentOwner(EIInstanceMinimal instance) {
        return ClientRepositoryToolsManager.isNotNull(instance.getWFOwner()) && instance.getWFOwner().equals((Object)this.user.getUserEntity());
    }

    public boolean instanceHasAnyOwner(EIInstance instance) {
        return ClientRepositoryToolsManager.isNotNull(instance.getWFOwner());
    }

    public boolean instanceHasAnyOwner(EIInstanceMinimal instance) {
        return ClientRepositoryToolsManager.isNotNull(instance.getWFOwner());
    }

    public void transition(final EIInstance instance, WorkFlowTransition transition, final RootAsyncCallback<EIInstance> callback) {
        this.transition(new EIInstanceMinimal[]{EIInstanceMinimal.create((EIInstance)instance)}, transition, new BulkWorkflowCallback(){

            @Override
            public void onSuccess(List<EIInstanceMinimal> successes) {
                if (successes == null || successes.size() == 0) {
                    callback.onFailure((Throwable)((Object)new ClientSideRepositoryException("claim failed for " + instance.getInstanceLabel())));
                }
                ClientRepositoryToolsManager.this.getInstance(successes.get(0).getInstanceURI(), callback);
            }

            @Override
            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            @Override
            public void needsRefresh(String message) {
                callback.onFailure((Throwable)((Object)new ClientSideRepositoryException(message)));
            }
        });
    }

    public void transition(EIInstanceMinimal[] eiInstanceMinimals, final WorkFlowTransition transition, final BulkWorkflowCallback callback) {
        if (transition == null) {
            log.error("null transition!");
            callback.onFailure((Throwable)((Object)new ClientSideRepositoryException("Invalid parameter")));
        }
        final HashMap<EIURI, EIInstanceMinimal> instanceUriMap = new HashMap<EIURI, EIInstanceMinimal>();
        for (EIInstanceMinimal instance : eiInstanceMinimals) {
            instanceUriMap.put(instance.getInstanceURI(), instance);
        }
        repositoryService.transition(this.session, new ArrayList<EIURI>(instanceUriMap.keySet()), transition.getEntity(), new AsyncCallback<List<EIURI>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(List<EIURI> result) {
                ArrayList<EIInstanceMinimal> successes = new ArrayList<EIInstanceMinimal>();
                for (EIURI succeededUri : result) {
                    EIInstanceMinimal succeeded = (EIInstanceMinimal)instanceUriMap.get(succeededUri);
                    succeeded.setWFState(WorkFlowConstants.WORKFLOW_URI_MAP.get(transition.getToStateURI()));
                    succeeded.setWFOwner(EIEntity.NULL_ENTITY);
                    successes.add(succeeded);
                }
                callback.onSuccess(successes);
            }
        });
    }

    public void retrieveLabel(EIURI uri, RootAsyncCallback<String> callback) {
        repositoryService.retrieveLabel(this.session, uri, callback);
    }

    public void getRootSuperclassForInstanceUri(EIURI instanceUri, RootAsyncCallback<EIClass> callback) {
        repositoryService.getRootSuperclassForInstanceUri(this.session, instanceUri, callback);
    }

    public void getClassAndSuperclassesForInstanceUri(EIURI instanceUri, RootAsyncCallback<List<EIClass>> callback) {
        repositoryService.getClassAndSuperclassesForInstanceUri(this.session, instanceUri, callback);
    }

    public List<WorkFlowTransition> getAllowedTransitions() {
        return this.user.getAllowedTransitions();
    }

    public List<WorkFlowTransition> getAllowedTransitions(EIInstance instance) {
        return this.getAllowedTransitions(instance.getWFState());
    }

    public List<WorkFlowTransition> getAllowedTransitions(EIInstanceMinimal instance) {
        return this.getAllowedTransitions(instance.getWFState());
    }

    private List<WorkFlowTransition> getAllowedTransitions(EIEntity workflowState) {
        if (ClientRepositoryToolsManager.isNotNull(workflowState)) {
            return this.user.getAllowedTransitionsForState(workflowState.getURI());
        }
        return this.user.getAllowedTransitionsForState(WorkFlowConstants.DRAFT_URI);
    }

    public void getRootSuperClass(final EIEntity eiEntity, final RootAsyncCallback<EIClass> callback) {
        modelService.getSuperClasses(eiEntity.getURI(), (AsyncCallback)new AsyncCallback<List<EIClass>>(){

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onSuccess(List<EIClass> result) {
                if (result == null || result.isEmpty()) {
                    modelService.getClass(eiEntity.getURI(), (AsyncCallback)new AsyncCallback<EIClass>(){

                        public void onFailure(Throwable caught) {
                            callback.onFailure(caught);
                        }

                        public void onSuccess(EIClass result) {
                            callback.onSuccess(result);
                        }
                    });
                } else {
                    callback.onSuccess(result.get(result.size() - 1));
                }
            }
        });
    }

    public void getEquivalentClasses(List<EIProperty> propertiesToPopulate, RootAsyncCallback<List<EIProperty>> callback) {
        repositoryService.getAllEquivalentClasses(propertiesToPopulate, callback);
    }

    public void isModelClassURI(EIURI eiuri, RootAsyncCallback<Boolean> callback) {
        repositoryService.isModelClassURI(eiuri, callback);
    }

    private boolean isUserDeniedAccess(User thisUser) {
        List creates = thisUser.getAllowedTransitionsForState(WorkFlowConstants.NEW_URI);
        log.info("user " + thisUser + " had " + (creates == null ? "null" : Integer.valueOf(creates.size())) + " transitions from New");
        return creates == null || creates.size() == 0;
    }

    private void handleAccessDenied(RootAsyncCallback<User> callback) {
        log.info("disabling login");
        this.user = null;
        this.session = null;
        Window.alert((String)"Error logging in: user not authorized for data tool.");
        Window.Location.assign((String)WidgetUtils.getSearchURL());
    }

    static {
        log = GWTLogger.getLogger("ClientRepositoryToolsManager");
    }

    public static interface BulkWorkflowCallback {
        public void onSuccess(List<EIInstanceMinimal> var1);

        public void onFailure(Throwable var1);

        public void needsRefresh(String var1);
    }

    public static interface SessionListener {
        public void onLogIn(String var1, String var2);

        public void onLogOut(boolean var1);
    }
}

