/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.ButtonsPanel;
import org.eaglei.datatools.client.ui.DatatoolsInstancePanel;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.EditFormRedisplay;
import org.eaglei.datatools.client.ui.NonOntlogyPropEditRenderer;
import org.eaglei.datatools.client.ui.OntologyPropEditRenderer;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

public class EditFormsPanel
extends DatatoolsInstancePanel
implements NewInnerInstanceListener {
    private final List<EIInstance> newInnerInstances = new ArrayList<EIInstance>();
    private String editToken;
    private final EditFormType formType;
    private final EditFormRedisplay formRedisplayCallbacks;
    private static final GWTLogger log = GWTLogger.getLogger("EditFormsPanel");

    public static EditFormsPanel createEditForm(EIInstance instance, EditFormRedisplay displayCallbacks) {
        return new EditFormsPanel(instance, displayCallbacks, EditFormType.Edit);
    }

    public static EditFormsPanel createNewForm(EIInstance instance, EditFormRedisplay displayCallbacks) {
        return new EditFormsPanel(instance, displayCallbacks, EditFormType.New);
    }

    private EditFormsPanel(EIInstance instance, EditFormRedisplay displayCallbacks, EditFormType formType) {
        super(instance, displayCallbacks);
        this.ontologyPropRenderer = new OntologyPropEditRenderer(this.eiInstance, this.ontologyPanel, this);
        this.renderer = new NonOntlogyPropEditRenderer(this.eiInstance, this.nonOntologyOuterPanel);
        this.buttonPanel.setRootSuperClass(this.eiInstance.getRootSuperType());
        this.shouldShowReadOnlyProperties = true;
        this.formRedisplayCallbacks = displayCallbacks;
        this.formType = formType;
        this.setButtonState();
        if (!this.isNewForm()) {
            this.getEditToken();
        }
        if (ResourceProvider.isResourceProviderType(instance.getInstanceType())) {
            log.debug("setting app state resource provider to '" + instance.getEntity() + "'");
            ApplicationState.getInstance().setResourceProviderEntity(instance.getEntity());
        }
        if (this.buttonPanel.getSaveButton().isEnabled()) {
            this.buttonPanel.getSaveButton().addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    EditFormsPanel.this.save();
                }
            });
        }
        if (this.buttonPanel.getCancelButton().isEnabled()) {
            this.buttonPanel.getCancelButton().addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    EditFormsPanel.this.cancel();
                }
            });
        }
        this.buttonPanel.setProviderRestrictionSelector(new ButtonsPanel.ProviderRestrictionListener(){

            @Override
            public void selectAll() {
            }

            @Override
            public void selectOnlyProvider() {
            }
        });
    }

    public boolean isNewForm() {
        return this.formType == EditFormType.New;
    }

    protected void save() {
        if (!this.checkLabels()) {
            Window.alert((String)"Name is a required field for main resource and for linked and embedded resources.");
            return;
        }
        this.saveNewInnerInstances();
    }

    private void saveMainInstance() {
        if (this.isNewForm()) {
            this.saveNewForm();
        } else {
            if (this.eiInstance.getNonOntologyLiteralProperties().containsKey(DatatoolsUIConstants.isStubEntity)) {
                this.eiInstance.replaceNonOntologyLiteralPropertyAllValues(DatatoolsUIConstants.isStubEntity, new HashSet());
            }
            ClientRepositoryToolsManager.INSTANCE.updateInstance(this.eiInstance, this.editToken, new RootAsyncCallback<Void>(){

                @Override
                public void onSuccess(Void result) {
                    EditFormsPanel.this.formRedisplayCallbacks.drawAfterSave(EditFormsPanel.this.eiInstance);
                }

                @Override
                public void onFailure(Throwable caught) {
                    super.onFailure(caught);
                    EditFormsPanel.this.formRedisplayCallbacks.drawAfterCancel(EditFormsPanel.this.eiInstance);
                }
            });
        }
    }

    private void saveNewInnerInstances() {
        if (this.newInnerInstances.size() == 0) {
            this.saveMainInstance();
        } else {
            this.deduplicate();
            log.info("saving new inner instances");
            ClientRepositoryToolsManager.INSTANCE.createInstances(this.newInnerInstances, new RootAsyncCallback<List<EIInstance>>(){

                @Override
                public void onSuccess(List<EIInstance> result) {
                    log.info("saved inner instances; now saving main");
                    EditFormsPanel.this.saveMainInstance();
                }
            });
        }
    }

    private void deduplicate() {
        ArrayList<EIInstance> ignore = new ArrayList<EIInstance>();
        for (EIInstance instance : this.newInnerInstances) {
            if (ignore.contains(instance)) continue;
            for (EIInstance otherInstance : this.newInnerInstances) {
                if (ignore.contains(otherInstance) || !this.isDuplicate(instance, otherInstance)) continue;
                EIEntity property = this.eiInstance.findPropertyForInstance(otherInstance.getEntity());
                this.eiInstance.replaceObjectPropertyValue(property, otherInstance.getInstanceURI(), instance.getEntity());
                ignore.add(otherInstance);
            }
        }
        this.newInnerInstances.removeAll(ignore);
    }

    private boolean isDuplicate(EIInstance instance, EIInstance otherInstance) {
        if (instance == otherInstance || instance.getEntity().equals((Object)otherInstance.getEntity())) {
            return false;
        }
        return instance.getInstanceType().equals((Object)otherInstance.getInstanceType()) && instance.getInstanceLabel().equals(otherInstance.getInstanceLabel());
    }

    private boolean checkLabels() {
        if (this.isMissingLabel(this.eiInstance)) {
            return false;
        }
        for (EIInstance inner : this.newInnerInstances) {
            if (!this.isMissingLabel(inner)) continue;
            return false;
        }
        for (EIInstance inner : this.eiInstance.getEmbeddedInstanceList()) {
            if (!this.isMissingLabel(inner) || !inner.getObjectProperties().isEmpty() || !inner.getDatatypeProperties().isEmpty() || inner.getInstanceClass().equals((Object)inner.getRootSuperType())) continue;
            return false;
        }
        return true;
    }

    private boolean isMissingLabel(EIInstance instance) {
        return instance.getInstanceLabel() == null || instance.getInstanceLabel().trim().equals("");
    }

    private void saveNewForm() {
        ClientRepositoryToolsManager.INSTANCE.createInstance(this.eiInstance, new RootAsyncCallback<EIInstance>(){

            @Override
            public void onSuccess(EIInstance saved) {
                EditFormsPanel.this.formRedisplayCallbacks.drawAfterSave(saved);
            }
        });
    }

    private void cancel() {
        if (this.formType == EditFormType.New) {
            if (ResourceProvider.isResourceProviderType(this.eiInstance.getInstanceType())) {
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.workbench, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY);
            } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.duplicate) {
                History.back();
            } else {
                EIEntity typeEntity = this.eiInstance.getRootSuperType().getEntity();
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.list, EIEntity.NULL_ENTITY, typeEntity, ApplicationState.getInstance().getResourceProviderEntity());
            }
        } else {
            ClientRepositoryToolsManager.INSTANCE.getInstance(this.eiInstance.getInstanceURI(), new RootAsyncCallback<EIInstance>(){

                @Override
                public void onSuccess(EIInstance fetched) {
                    EditFormsPanel.this.formRedisplayCallbacks.drawAfterCancel(fetched);
                }

                @Override
                public void onFailure(Throwable caught) {
                    EditFormsPanel.this.formRedisplayCallbacks.drawAfterCancel(EditFormsPanel.this.eiInstance);
                }
            });
        }
    }

    @Override
    protected void setButtonState() {
        this.buttonPanel.saveButton.setVisible(true);
        if (this.formType == EditFormType.New) {
            this.buttonPanel.copyResourceButton.setVisible(false);
            this.buttonPanel.cancelButton.setVisible(true);
        } else {
            this.buttonPanel.copyResourceButton.setVisible(true);
            this.buttonPanel.cancelButton.setVisible(true);
            this.buttonPanel.hideAllWorkflowButtons();
        }
        this.buttonPanel.editButton.setVisible(false);
        this.buttonPanel.claimReleaseButton.setVisible(false);
        this.buttonPanel.deleteButton.setVisible(false);
    }

    private void getEditToken() {
        ClientRepositoryToolsManager.INSTANCE.getToken(this.eiInstance, new RootAsyncCallback<String>(){

            @Override
            public void onSuccess(String token) {
                EditFormsPanel.this.editToken = token;
            }
        });
    }

    @Override
    public void onInstanceAdded(EIInstance newInstance) {
        this.newInnerInstances.add(newInstance);
    }

    @Override
    public void onInstanceRemoved(EIInstance newInstance) {
        this.newInnerInstances.remove(newInstance);
    }

    @Override
    public boolean isAddedInstanceEntity(EIEntity entity) {
        for (EIInstance inner : this.newInnerInstances) {
            if (!inner.getEntity().equals((Object)entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EIInstance getAddedInstance(EIEntity entity) {
        for (EIInstance inner : this.newInnerInstances) {
            if (!inner.getEntity().equals((Object)entity)) continue;
            return inner;
        }
        return EIInstance.NULL_INSTANCE;
    }

    public static interface PropertiesLoadedListener {
        public void onPropertiesLoaded();
    }

    static enum EditFormType {
        Edit,
        New,
        Dialog;

    }
}

