/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.widgets.EditWidgetCollection;
import org.eaglei.datatools.client.ui.widgets.TermWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class WidgetUtils {
    private static final GWTLogger log = GWTLogger.getLogger("WidgetUtils");

    public static TextBox createTextField() {
        TextBox textField = new TextBox();
        textField.setStyleName("formText");
        return textField;
    }

    public static TextBox createTextFieldForResourceWidget() {
        TextBox textField = new TextBox();
        textField.setStyleName("textSuggest");
        return textField;
    }

    public static void addTermWidgetToPanel(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIEntity selectedClassEntity, final EditWidgetCollection fields, final boolean showLabel) {
        if (selectedClassEntity == null || selectedClassEntity.equals((Object)EIEntity.NULL_ENTITY)) {
            fields.addWidget(new TermWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, range, EIClass.NULL_CLASS, showLabel));
        } else {
            ClientModelManager.INSTANCE.getClass(selectedClassEntity.getURI(), new ClientModelManager.ClassCallback(){

                public void onSuccess(EIClass result) {
                    log.info("got root superclass for " + selectedClassEntity.getURI() + " Superclass is " + result);
                    fields.addWidget(new TermWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, range, result, showLabel));
                }
            });
        }
    }

    public static void addTermWidgetToPanel(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final EIClass range, final EIEntity selectedClassEntity, final FlowPanel tempPanel, final boolean showLabel) {
        if (selectedClassEntity == null || selectedClassEntity.equals((Object)EIEntity.NULL_ENTITY)) {
            tempPanel.add((Widget)new TermWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, range, EIClass.NULL_CLASS, showLabel));
        } else {
            ClientModelManager.INSTANCE.getClass(selectedClassEntity.getURI(), new ClientModelManager.ClassCallback(){

                public void onSuccess(EIClass result) {
                    log.info("got class for " + selectedClassEntity + " class is " + result);
                    tempPanel.add((Widget)new TermWidget(eiInstance, propertyEntity, propertyDefinition, isRequired, range, result, showLabel));
                }
            });
        }
    }

    public static FlowPanel createRadioButon(final EIInstance instance, final EIEntity propertyEntity, String propertyDefinition, boolean isRequired, final String originalValue) {
        FlowPanel fPanel = new FlowPanel();
        FlowPanel checkBoxPanel = new FlowPanel();
        CheckBox checkBox = new CheckBox();
        fPanel.setStyleName("formPanelRow");
        checkBoxPanel.setStyleName("formPanelSubRowItem");
        if (originalValue != null) {
            Boolean booleanValue = Boolean.valueOf(originalValue);
            if (booleanValue == Boolean.FALSE && originalValue.toLowerCase().startsWith("yes")) {
                booleanValue = Boolean.TRUE;
            }
            log.info("original value: " + originalValue + "; parsed value " + booleanValue);
            checkBox.setValue(booleanValue);
        }
        fPanel.add((Widget)InstanceWidgetUtils.createLabel((EIEntity)propertyEntity, (String)propertyDefinition, (boolean)isRequired));
        checkBoxPanel.add((Widget)checkBox);
        fPanel.add((Widget)checkBoxPanel);
        checkBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> arg0) {
                Boolean oldValue = (Boolean)arg0.getValue() == false;
                instance.replaceDatatypePropertyValue(propertyEntity, oldValue.toString(), ((Boolean)arg0.getValue()).toString());
                instance.replaceDatatypePropertyValue(propertyEntity, originalValue, ((Boolean)arg0.getValue()).toString());
            }
        });
        return fPanel;
    }

    public static boolean isInstanceUri(String selectedUri) {
        if (selectedUri == null || selectedUri.equals("") || selectedUri.equals(EIURI.NULL_EIURI.toString())) {
            return false;
        }
        return selectedUri.indexOf("/i/") != -1;
    }

    public static boolean isInstance(EIEntity selectedEntity) {
        if (selectedEntity == null || selectedEntity.equals((Object)EIEntity.NULL_ENTITY)) {
            return false;
        }
        return selectedEntity.getURI().toString().indexOf("/i/") != -1;
    }

    public static EIEntity getSelectedEntity(ListBox listBox) {
        int selectedIndex = listBox.getSelectedIndex();
        return EIEntity.create((EIURI)WidgetUtils.getSelectedUri(listBox), (String)listBox.getItemText(selectedIndex));
    }

    @Deprecated
    public static EIURI getSelectedUri(ListBox listBox) {
        EIURI selectedUri = EIURI.create((String)listBox.getValue(listBox.getSelectedIndex()));
        return selectedUri;
    }

    public static String formatDate(String dt) {
        String date = "";
        if (dt != null && !dt.equals("")) {
            date = dt.substring(0, dt.indexOf("T"));
        }
        return date;
    }

    public static String lowerCaseFirst(String original) {
        char first = original.charAt(0);
        return Character.toLowerCase(first) + original.substring(1);
    }

    public static String getHelpURL() {
        return WidgetUtils.replaceURLWithString("/datatools/", "/help/HelpAddInformation/eagle-i.htm");
    }

    public static String getChangePasswordURL() {
        return WidgetUtils.replaceURLWithString("/datatools/", "/repository/editUser.html");
    }

    private static String replaceURLWithString(String target, String replacement) {
        String url = GWT.getHostPageBaseURL();
        String urlToReturn = url.replace(target, replacement);
        return urlToReturn;
    }

    public static String getSearchURL() {
        String url = GWT.getHostPageBaseURL();
        String node = InstanceWidgetUtils.getNodeNameFromURL();
        log.debug("node name = " + node + "; url = " + url);
        if (node != null) {
            String searchUrl = url.replace(node + ".", "search.").replace("/datatools/", "") + "/central/";
            return searchUrl;
        }
        return "http://search.eagle-i.net";
    }

    public static interface InstanceSaveCallback {
        public void updateState(EIInstance var1);

        public void reset();
    }
}

