/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.ActionRedisplay;
import org.eaglei.datatools.client.ui.OwnershipAction;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.WorkflowUtils;
import org.eaglei.datatools.client.ui.listeners.RowDeletionListener;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;

public class GridRowWidget
extends FlowPanel {
    private static final int CHECKBOX_COLUMN = 7;
    private static final int ACTIONS_FIRST_COLUMN = 4;
    private static final int STATUS_COLUMN = 3;
    private static final int DATE_COLUMN = 2;
    private static final int TYPE_COLUMN = 1;
    private static final int NAME_COLUMN = 0;
    private static final String LIVE_LINK = "liveLink";
    private static final String UNCLAIM_LABEL = "<a>share</a>";
    private static final String CLAIM_LABEL = "<a>claim</a>";
    private static final int CLAIM_OR_SHARE_POSITION = 0;
    private static final String EDIT_LABEL = "<a>edit</a>";
    private static final int EDIT_POSITION = 1;
    private static final String DELETE_LABEL = "<a>delete</a>";
    private static final int DELETE_POSITION = 2;
    private EIInstanceMinimal instance;
    private int rowIndex;
    private final ActionRedisplay redisplay;
    private final RowDeletionListener listener;
    private final HTML[] formActions = new HTML[]{new HTML(), new HTML(), new HTML()};
    private CheckBox checkBox;
    private static final GWTLogger log = GWTLogger.getLogger("GridRowWidget");

    public GridRowWidget(final EIInstanceMinimal instance, RowDeletionListener deletionListener) {
        this.listener = deletionListener;
        this.redisplay = new ActionRedisplay(){

            public void drawAfterClaim(EIInstanceMinimal instance2) {
                if (ApplicationState.getInstance().isStrictlyFilteredByOwner() && !GridRowWidget.this.instanceHasOwner(instance2)) {
                    GridRowWidget.this.listener.onRowDeletion(instance2);
                }
                GridRowWidget.this.redrawActions();
            }

            public void drawAfterPromote(EIInstanceMinimal instance2) {
                GridRowWidget.this.redrawActions();
            }

            @Override
            public void drawAfterClaim(EIInstanceMinimal[] instances, List<EIInstanceMinimal> successes) {
                if (successes == null || successes.size() == 0) {
                    String failMessage = "Claim failed for $RESOURCES$; they may already be owned by someone else.".replace("$RESOURCES$", instance.getInstanceLabel()).replace("they", "it");
                    Window.alert((String)failMessage);
                } else {
                    EIInstanceMinimal claimedMinimal = successes.get(0);
                    instance.setWFOwner(claimedMinimal.getWFOwner());
                    this.drawAfterClaim(instance);
                }
            }

            @Override
            public void handleFailedTransition(String error) {
                Window.alert((String)"Action failed.");
            }

            @Override
            public void drawAfterPromote(EIInstanceMinimal[] instances, List<EIInstanceMinimal> successes) {
                if (successes == null || successes.size() == 0) {
                    String failMessage = "Operation $TRANSITION$ failed for $RESOURCES$.".replace("$TRANSITION$", "").replace("$RESOURCES$", instance.getInstanceLabel()).replace("they", "it");
                    Window.alert((String)failMessage);
                } else {
                    EIInstanceMinimal claimedMinimal = successes.get(0);
                    instance.setWFState(claimedMinimal.getWFState());
                    this.drawAfterPromote(instance);
                }
            }

            @Override
            public void needsRefresh(String message) {
                Window.alert((String)"Resource is out of date.  Please refresh and try again.");
            }
        };
        this.init(instance);
    }

    private void init(EIInstanceMinimal instance) {
        this.instance = instance;
        this.setStyleName("dtListGridRow");
        HTML instanceLabel = new HTML("<a>" + instance.getInstanceLabel() + "<a>");
        this.makeClickable(instance.getEntity(), instance.getInstanceType(), instanceLabel);
        instanceLabel.setStyleName(LIVE_LINK);
        if (!this.isNull(instance.getLab())) {
            FlowPanel firstCell = new FlowPanel();
            HTML providerLabel = new HTML("<i><a>" + instance.getLab().getLabel() + "<a></i>");
            providerLabel.setStyleName("dtListGridRowLab");
            this.makeClickable(instance.getLab(), ResourceProvider.BASE_RESOURCE_CONTAINER, providerLabel);
            providerLabel.setStyleName(LIVE_LINK);
            firstCell.add((Widget)instanceLabel);
            firstCell.add((Widget)providerLabel);
            this.addWithStyle((Widget)firstCell, 0);
        } else {
            this.addWithStyle((Widget)instanceLabel, 0);
        }
        this.addWithStyle((Widget)new Label(instance.getInstanceType().getLabel()), 1);
        String date = instance.getCreationDate();
        Label dateLabel = new Label(" ");
        if (date != null) {
            dateLabel = new Label(WidgetUtils.formatDate(date));
        }
        this.addWithStyle((Widget)dateLabel, 2);
        Label status = new Label(this.isNull(instance.getWFState()) ? " " : instance.getWFState().getLabel());
        this.addWithStyle((Widget)status, 3);
        for (HTML widget : this.formActions) {
            widget.setStyleName(LIVE_LINK);
        }
        if (ClientRepositoryToolsManager.INSTANCE.canClaim(instance) || ClientRepositoryToolsManager.INSTANCE.canEdit(instance)) {
            this.addWithStyle((Widget)this.formActions[0], 4);
            this.addWithStyle((Widget)this.formActions[1], 5);
            this.addWithStyle((Widget)this.formActions[2], 6);
            this.checkBox = new CheckBox();
            this.checkBox.setVisible(this.shouldDisplayCheckBox());
            this.addWithStyle((Widget)this.checkBox, 7);
            this.redrawActions();
        } else if (instance.getWFOwner() != null && !EIEntity.NULL_ENTITY.equals((Object)instance.getWFOwner())) {
            log.debug(instance.getInstanceLabel() + " is already claimed by differnt owner : the owner is  " + instance.getWFOwner().getLabel());
            this.addWithStyle((Widget)new Label("current editor is " + instance.getWFOwner().getLabel()), 456);
        }
    }

    private void makeClickable(final EIEntity entityToDisplay, final EIEntity typeOfEntityToDisplay, HTML label) {
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EIEntity updatedProviderEntity = GridRowWidget.this.getUpdatedProviderEntity(entityToDisplay);
                log.info("updated provider entity: " + updatedProviderEntity);
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.view, entityToDisplay, typeOfEntityToDisplay, updatedProviderEntity);
            }
        });
    }

    public EIInstanceMinimal getInstance() {
        return this.instance;
    }

    public CheckBox getCheckBox() {
        return this.checkBox;
    }

    public HTML[] getFormActions() {
        return this.formActions;
    }

    private boolean shouldDisplayCheckBox() {
        if (ApplicationState.getInstance().hasResourceProviderType()) {
            return false;
        }
        return ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance) || ClientRepositoryToolsManager.INSTANCE.canClaim(this.instance);
    }

    private void setClaimOrRelease() {
        if (ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance)) {
            this.formActions[0] = new HTML(UNCLAIM_LABEL);
            this.formActions[0].setStyleName(LIVE_LINK);
            this.formActions[0].addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    GridRowWidget.this.releaseAction();
                }
            });
        } else if (ClientRepositoryToolsManager.INSTANCE.canClaim(this.instance)) {
            this.formActions[0] = new HTML(CLAIM_LABEL);
            this.formActions[0].setStyleName(LIVE_LINK);
            this.formActions[0].addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    GridRowWidget.this.claimAction();
                }
            });
        }
    }

    private void setEdit() {
        if (ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance)) {
            this.formActions[1] = new HTML(EDIT_LABEL);
            this.formActions[1].setStyleName(LIVE_LINK);
            this.formActions[1].addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.edit, GridRowWidget.this.instance.getEntity(), GridRowWidget.this.instance.getInstanceType(), GridRowWidget.this.getUpdatedProviderEntity(GridRowWidget.this.instance.getEntity()));
                }
            });
        } else {
            this.formActions[1] = new HTML();
        }
    }

    private void setDelete() {
        if (ClientRepositoryToolsManager.INSTANCE.canEdit(this.instance)) {
            this.formActions[2] = new HTML(DELETE_LABEL);
            this.formActions[2].setStyleName(LIVE_LINK);
            this.formActions[2].addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    if (Window.confirm((String)"Are you sure you want to delete this resource?")) {
                        ClientRepositoryToolsManager.INSTANCE.deleteInstance(GridRowWidget.this.instance.getInstanceURI(), new RootAsyncCallback<Void>(){

                            @Override
                            public void onSuccess(Void result) {
                                if (GridRowWidget.this.listener != null) {
                                    GridRowWidget.this.listener.onRowDeletion(GridRowWidget.this.instance);
                                }
                            }
                        });
                    }
                }
            });
        } else {
            this.formActions[2] = new HTML();
        }
    }

    public boolean instanceHasOwner(EIInstanceMinimal minimal) {
        return WorkflowUtils.isNotNull(minimal.getWFOwner());
    }

    public boolean instanceHasOwner() {
        return this.instanceHasOwner(this.instance);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    private void claimAction() {
        OwnershipAction.ClaimAction.perform(this.instance, this.redisplay);
    }

    private void releaseAction() {
        OwnershipAction.ReleaseAction.perform(this.instance, this.redisplay);
    }

    public void updateStateData() {
        String statusText = this.isNull(this.instance.getWFState()) ? " " : this.instance.getWFState().getLabel();
        ((Label)this.getWidget(3)).setText(statusText);
        this.redrawActions();
    }

    public void redrawActions() {
        this.remove((Widget)this.getFormActions()[0]);
        this.remove((Widget)this.getFormActions()[1]);
        this.remove((Widget)this.getFormActions()[2]);
        if (this.checkBox != null) {
            this.remove((Widget)this.checkBox);
        }
        this.setEdit();
        this.setDelete();
        this.setClaimOrRelease();
        this.addWithStyle((Widget)this.getFormActions()[0], 4);
        this.addWithStyle((Widget)this.getFormActions()[1], 5);
        this.addWithStyle((Widget)this.getFormActions()[2], 6);
        if (this.checkBox != null) {
            this.addWithStyle((Widget)this.checkBox, 7);
        }
        if (this.checkBox != null) {
            this.checkBox.setVisible(this.shouldDisplayCheckBox());
        }
    }

    private EIEntity getUpdatedProviderEntity(EIEntity instanceEntity) {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.filter && !ApplicationState.getInstance().getFilterResourceProviderEntity().equals((Object)EIEntity.NULL_ENTITY)) {
            return ApplicationState.getInstance().hasResourceProviderType() ? instanceEntity : ApplicationState.getInstance().getResourceProviderEntity();
        }
        if (ResourceProvider.isResourceProviderType(this.instance.getInstanceType())) {
            return instanceEntity;
        }
        log.debug("app has provider? " + ApplicationState.getInstance().hasResourceProvider() + "; app state provider: ApplicationState.getInstance().getResourceProviderEntity() " + "; instance provider " + this.instance.getLab());
        if (ApplicationState.getInstance().hasResourceProvider()) {
            return ApplicationState.getInstance().getResourceProviderEntity();
        }
        if (this.instance.getLab().getLabel().equals("<none>")) {
            return EIEntity.NULL_ENTITY;
        }
        return this.instance.getLab();
    }

    private boolean isNull(EIEntity entity) {
        return entity == null || entity.equals((Object)EIEntity.NULL_ENTITY);
    }

    private void addWithStyle(Widget widget, int column) {
        this.add(widget);
        String style = "gridRowColumn" + column;
        widget.addStyleName("gridRowColumn");
        widget.addStyleName(style);
    }
}

