/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.datatools.client.ui.widgets.OntologyDropdown;
import org.eaglei.datatools.client.ui.widgets.TextWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.OntologyDropdownBase;
import org.eaglei.suggest.client.SharedClassChooser;

public class TermWidget
extends EditWidget {
    private final EIClass range;
    private final EIClass selectedClass;
    private final boolean shouldHaveLabel;

    public TermWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, EIClass range, EIClass selectedClass, boolean shouldShowLabel) {
        super(eiInstance, propertyEntity, propertyDefinition, isRequired);
        this.range = range;
        this.selectedClass = selectedClass;
        this.shouldHaveLabel = shouldShowLabel;
        if (!this.shouldHaveLabel) {
            this.widgetPanel.remove((Widget)this.label);
        }
        this.setup();
    }

    private void setup() {
        FlowPanel temp = new FlowPanel();
        SharedClassChooser classChooser = new SharedClassChooser((OntologyDropdownBase)new OntologyDropdown());
        classChooser.setClass(this.range, false);
        classChooser.setTextBoxStyle("textSuggest");
        if (this.selectedClass != null && !EIClass.NULL_CLASS.equals((Object)this.selectedClass)) {
            classChooser.setSelectedEntity(this.selectedClass.getEntity());
            this.updateOldValue(this.selectedClass.getEntity().getURI());
        }
        this.widgetPanel.add((Widget)temp);
        temp.add((Widget)classChooser);
        temp.addStyleName("floatLeft");
        this.addTermRequestWidget();
        this.makeSelectionHandler((SharedClassChooser<OntologyDropdown>)classChooser);
    }

    protected void makeSelectionHandler(final SharedClassChooser<OntologyDropdown> classChooser) {
        classChooser.addSelectionListener(new EntitySelectionListener(){

            public void onSelection(EIEntity selectedEntity) {
                classChooser.setTextBoxStyle("formText");
                if ((selectedEntity.equals((Object)EIEntity.NULL_ENTITY) || "<none>".equals(selectedEntity.getLabel())) && !TermWidget.this.hasOldValue()) {
                    return;
                }
                if (TermWidget.this.hasOldValue()) {
                    if (selectedEntity.equals((Object)EIEntity.NULL_ENTITY) || "<none>".equals(selectedEntity.getLabel())) {
                        TermWidget.this.removeValue();
                    } else {
                        TermWidget.this.eiInstance.replaceObjectPropertyValue(TermWidget.this.propertyEntity, EIURI.create((String)TermWidget.this.oldValue), selectedEntity);
                    }
                } else {
                    TermWidget.this.eiInstance.addObjectProperty(TermWidget.this.propertyEntity, selectedEntity);
                }
                TermWidget.this.updateOldValue(selectedEntity.getURI());
            }
        });
    }

    protected void addTermRequestWidget() {
        TextWidget termRequestWidget = TextWidget.makeTermRequestWidget(this.eiInstance);
        termRequestWidget.setStyleName("floatLeft");
        termRequestWidget.setName(this.range.getEntity().getURI().toString() + "_" + DatatoolsUIConstants.termRequestEntity.getURI().toString());
        this.widgetPanel.add((Widget)termRequestWidget);
    }

    @Override
    protected void removeValue() {
        if (this.hasOldValue()) {
            this.eiInstance.replaceObjectPropertyValue(this.propertyEntity, this.getOldEIURIValue(), null);
        }
    }

    @Override
    public EditWidget duplicateBlank() {
        return new TermWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, this.range, null, true);
    }
}

