/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.Workspace;
import org.eaglei.datatools.client.rpc.RepositorySecurityService;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelService;
import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.server.AbstractRemoteServiceServlet;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;

public class RepositoryToolsModelServlet
extends AbstractRemoteServiceServlet
implements RepositoryToolsModelService,
RepositorySecurityService {
    private static final Log log = LogFactory.getLog(RepositoryToolsModelServlet.class);

    public void createInstance(Session session, EIInstance instance, EIEntity workspaceEntity) throws ClientSideRepositoryException {
        if (this.isNull(instance)) {
            log.error((Object)"trying to create a null instance");
        }
        this.handleNullSession(session);
        try {
            this.repoProvider.createInstance(session, instance, workspaceEntity);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public void createInstances(Session session, List<EIInstance> instances, EIEntity workspaceEntity) throws ClientSideRepositoryException {
        if (instances == null) {
            log.error((Object)"trying to create null instances");
        }
        this.handleNullSession(session);
        try {
            this.repoProvider.createInstances(session, instances, workspaceEntity);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public void deleteInstance(Session session, EIURI instanceUri) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            this.repoProvider.deleteInstance(session, instanceUri);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public void deleteInstances(Session session, List<EIURI> instanceUris) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            this.repoProvider.deleteInstances(session, instanceUris);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public String getToken(Session session, EIInstance instance) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.repoProvider.getToken(session, instance);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public Map<EIInstance, String> getTokens(Session session, List<EIInstance> instances) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.repoProvider.getTokens(session, instances);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public void updateInstance(Session session, EIInstance instance, String token) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            this.repoProvider.updateInstance(session, instance, token);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public void updateInstances(Session session, Map<EIInstance, String> instancesWithTokens) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            this.repoProvider.updateInstances(session, instancesWithTokens);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    @Override
    public boolean isOnline() {
        return this.securityProvider.isOnline();
    }

    public List<EIInstanceMinimal> EIQuery(Session session, String query) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.repoProvider.EIQuery(session, query);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public EIInstance getEmptyEIInstance(Session session, EIURI classUri, EIEntity instanceEntity) throws ClientSideRepositoryException {
        try {
            return this.repoProvider.getEmptyEIInstance(session, classUri, instanceEntity);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public EIInstance getEmptyEIInstance(Session session, EIURI classUri) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            EIInstance instance = this.repoProvider.getEmptyEIInstance(session, classUri);
            if (instance.getInstanceClass() == null || instance.getInstanceClass().equals((Object)EIClass.NULL_CLASS)) {
                instance.setInstanceClass(this.ontModel.getClass(classUri));
            }
            return instance;
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public EIInstance deepCopy(Session session, EIURI originalUri) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.repoProvider.deepCopy(session, originalUri);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public List<EIURI> getNewInstanceID(Session session, int count) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.repoProvider.getNewInstanceID(session, count);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public String query(Session session, String sparql) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.repoProvider.query(session, sparql);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public EIInstance getOneInstance(Session session, EIURI instanceID, boolean isExtended) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.repoProvider.getOneInstance(session, instanceID, isExtended);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public List<EIInstanceMinimal> listResourcesForObjectPropertyValue(Session session, EIURI classUri, EIURI provider, EIURI state, boolean onlyProvider) throws RepositoryProviderException {
        this.handleNullSession(session);
        try {
            return this.repoProvider.listResourcesForObjectPropertyValue(session, classUri, provider, state, onlyProvider);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public String retrieveLabel(Session session, EIURI uri) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.repoProvider.retrieveLabel(session, uri);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    @Override
    public EIClass getRootSuperclassForInstanceUri(Session session, EIURI instanceUri) throws ClientSideRepositoryException {
        EIInstance instance;
        this.handleNullSession(session);
        try {
            instance = this.repoProvider.getOneInstance(session, instanceUri, true);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
        if (this.isNull(instance)) {
            return null;
        }
        return this.getRootSuperClass(instance.getInstanceClass());
    }

    private boolean isNull(EIInstance instance) {
        return instance == null || instance.getInstanceURI() == null || EIInstance.NULL_INSTANCE.equals(instance);
    }

    @Override
    public List<EIClass> getClassAndSuperclassesForInstanceUri(Session session, EIURI instanceUri) throws ClientSideRepositoryException {
        EIInstance instance;
        this.handleNullSession(session);
        try {
            instance = this.repoProvider.getOneInstance(session, instanceUri, true);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
        if (this.isNull(instance)) {
            return null;
        }
        ArrayList<EIClass> classes = this.ontModel.getSuperClasses(instance.getInstanceType().getURI());
        if (classes == null || classes.isEmpty()) {
            classes = new ArrayList<EIClass>(1);
        }
        classes.add(this.ontModel.getClass(instance.getInstanceType().getURI()));
        return classes;
    }

    @Override
    public EIClass getRootSuperClass(EIClass eclass) {
        EIClass found = eclass;
        while (found.hasSuperClass()) {
            found = this.ontModel.getSuperClass(found);
        }
        return found;
    }

    public boolean isModelClassURI(String uri) {
        return this.ontModel.isModelClassURI(uri);
    }

    @Override
    public List<Workspace> getWorkspaces(Session session) throws ClientSideRepositoryException {
        this.handleNullSession(session);
        try {
            return this.securityProvider.getWorkspaces(session);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    @Override
    public List<EIProperty> getAllEquivalentClasses(List<EIProperty> propertiesToPopulate) {
        for (EIProperty property : propertiesToPopulate) {
            if (!(property instanceof EIObjectProperty)) continue;
            EIObjectProperty objectProperty = (EIObjectProperty)property;
            log.debug((Object)("equivalent classes for object property " + property));
            List assertedRanges = objectProperty.getRangeList();
            log.debug((Object)("   had " + (assertedRanges == null ? "0" : Integer.valueOf(assertedRanges.size())) + " asserted ranges"));
            for (EIClass range : assertedRanges) {
                if (range == null || range.equals((Object)EIClass.NULL_CLASS) || range.getEntity() == null || range.getEntity().equals((Object)EIEntity.NULL_ENTITY)) continue;
                List equivalentClasses = this.ontModel.getEquivalentClasses(range.getEntity().getURI());
                if (equivalentClasses != null) {
                    range.setEquivalentClasses(equivalentClasses);
                    for (EIEquivalentClass equivalence : equivalentClasses) {
                        log.debug((Object)("    equivalent class " + (equivalence.getEquivalentTo() == null ? "empty" : Integer.valueOf(equivalence.getEquivalentTo().size()))));
                    }
                    continue;
                }
                log.debug((Object)"null classes");
            }
        }
        return propertiesToPopulate;
    }

    public List<EIURI> claim(Session session, List<EIURI> uris) throws ClientSideRepositoryException {
        try {
            return this.repoProvider.claim(session, uris);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public List<EIInstanceMinimal> listResources(Session session, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean isAscending, boolean strictOwnerFilter) throws ClientSideRepositoryException {
        try {
            return this.repoProvider.listResources(session, queryRequest, orderBy, isAscending, strictOwnerFilter);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public List<EIInstanceMinimal> listResources(Session session, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean isAscending, boolean strictOwnerFilter, boolean stubsOnly) throws ClientSideRepositoryException {
        try {
            return this.repoProvider.listResources(session, queryRequest, orderBy, isAscending, strictOwnerFilter, stubsOnly);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public List<EIInstanceMinimal> listReferencingResources(Session session, EIURI resourceUri, AuthSearchRequest queryRequest, SortByProperties orderBy, boolean strictOwnerFilter) throws ClientSideRepositoryException {
        try {
            return this.repoProvider.listReferencingResources(session, resourceUri, queryRequest, orderBy, strictOwnerFilter);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    @Override
    public List<WorkFlowTransition> listWorkFlowTransitions(Session session, EIEntity workspaceEntity) throws ClientSideRepositoryException {
        try {
            return this.securityProvider.listWorkFlowTransitions(session, workspaceEntity);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public List<EIURI> release(Session session, List<EIURI> uris) throws ClientSideRepositoryException {
        try {
            return this.repoProvider.release(session, uris);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public List<EIURI> transition(Session session, List<EIURI> uris, EIEntity transitionEntity) throws ClientSideRepositoryException {
        try {
            return this.repoProvider.transition(session, uris, transitionEntity);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public Map<EIURI, String> getModifiedDates(Session session, List<EIURI> uris) throws ClientSideRepositoryException {
        try {
            return this.repoProvider.getModifiedDates(session, uris);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public boolean addLabToUser(Session session, EIURI labUri) throws ClientSideRepositoryException {
        return false;
    }

    @Override
    public boolean isModelClassURI(EIURI uri) {
        return this.ontModel.isModelClassURI(uri.toString());
    }

    public EIInstance setReferencingResources(Session session, EIInstance instance) throws RepositoryProviderException {
        return this.repoProvider.setReferencingResources(session, instance);
    }

    public boolean isValid(String sessionId, boolean shouldThrow) throws RepositoryProviderException {
        try {
            return this.securityProvider.isValid(sessionId, shouldThrow);
        }
        catch (RepositoryProviderException e) {
            throw new ClientSideRepositoryException(e, e.getExceptionType());
        }
    }

    public Session getSession(String sessionId) {
        return this.securityProvider.getSession(sessionId);
    }

    public HttpClient getHttpClient(Session session) {
        return this.securityProvider.getHttpClient(session);
    }
}

