/**
 * The eagle-i consortium
 * Harvard University
 * Feb 8, 2011
 */
package org.eaglei.datatools.client.status;

import org.eaglei.services.repository.RepositoryProviderException;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public class ClientSideRepositoryException extends RepositoryProviderException implements IsSerializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public ClientSideRepositoryException() {
		this(RepositoryErrorMessages.FAILED_MESSAGE, null, RepositoryProviderExceptionType.GENERAL);
	}
	
	public ClientSideRepositoryException(RepositoryProviderExceptionType type) {
		this(RepositoryErrorMessages.getErrorMessageForExceptionType(type), null, type);
	}

	public ClientSideRepositoryException(final String message) {
		this(message, null, RepositoryProviderExceptionType.GENERAL);
	}
	
	public ClientSideRepositoryException(final String message, RepositoryProviderExceptionType type) {
		this(message, null, type);
	}

	public ClientSideRepositoryException(final Throwable cause) {
		this(RepositoryErrorMessages.FAILED_MESSAGE, cause, RepositoryProviderExceptionType.GENERAL);
	}
	
	public ClientSideRepositoryException(final Throwable cause, RepositoryProviderExceptionType type) {
		this(RepositoryErrorMessages.getErrorMessageForExceptionType(type), cause, type);
	}

	public ClientSideRepositoryException(final String message, final Throwable cause) {
		this(message, cause, RepositoryProviderExceptionType.GENERAL);
	}
	
	public ClientSideRepositoryException(String message, final Throwable cause, RepositoryProviderExceptionType type) {
		super( message, cause, type );
	}
	
}
