package org.eaglei.datatools.client.ui.widgets;

import java.util.List;
import java.util.Set;

import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.widgets.TypeWidget.TypeChangeHandler;
import org.eaglei.datatools.client.ui.Layout;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.ClientModelManager.PropertyCallback;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

/**
 * Widget to create a new resource instance from a form. It is displayed when the user clicks on <create new> from the Resource picklist.
 */
public class StubWidget extends EditWidget {

	private TextWidget widgetName;
	private TypeWidget widgetType;
	private EIClass range;
	private EIInstance eiInstance;

	private static final GWTLogger log = GWTLogger.getLogger( "StubWidget" );

	StubWidget(EIInstance eiInstance, EIEntity propertyEntity, EIClass range, String propertyDefinition, boolean isRequired) {
		super( eiInstance, propertyEntity, propertyDefinition, isRequired );
		this.range = range;
		this.eiInstance = eiInstance;
		this.setStyleName( "StubForm" );
		setup();
	}

	private void setup() {
		final EIEntity namePropEntity = EIEntity.create( EagleIEntityConstants.RDFS_LABEL_ENTITY.getURI(), InstanceWidgetUtils.getExtendedPropertyLabel( range.getEntity().getLabel(), EagleIEntityConstants.RDFS_LABEL_ENTITY.getLabel(), isRequired ) );
		final String originalLabel = eiInstance.getInstanceLabel().equals( EIEntity.NULL_ENTITY.getLabel() ) ? "" : eiInstance.getInstanceLabel();
		widgetName = TextWidget.makeLabelTextWidget( eiInstance, namePropEntity, propertyDefinition, isRequired, originalLabel);

		setResourceProviderProperties();
		widgetType = new TypeWidget( eiInstance, propertyEntity, range, null, new TypeChangeHandler() {
			@Override
			public void onTypeChange() {
				setResourceProviderProperties();
			}
		} );

		setShouldShowLabel( false );

		widgetPanel.add( widgetName );
		widgetPanel.add( widgetType );
	}

	private void setResourceProviderProperties() {
		if ( !ApplicationState.getInstance().hasResourceProvider() ) {
			return; // Do not bother to set if there's no resource provider
		}

		ClientModelManager.INSTANCE.getProperties( eiInstance.getInstanceClass(), new PropertyCallback() {
			@Override
			public void onSuccess(final EIClass result) {
				for (EIProperty property : result.getProperties()) {
					if ( property instanceof EIObjectProperty ) {
						final String providerAnnotation = "http://eagle-i.org/ont/app/1.0/PropertyGroup_RelatedResourceProvider"; 
						Set<String> annotations = property.getAnnotations();
						if ( annotations.contains( providerAnnotation ) ) {
							log.debug( "provider-annotated" );
							log.info( "setting provider on stub to '" + ApplicationState.getInstance().getResourceProviderEntity() + "' property " + property.getEntity().getLabel() );
							eiInstance.addObjectProperty( property.getEntity(), ApplicationState.getInstance().getResourceProviderEntity() );
						}

					}
				}
			}
		} );
	}

	public EIInstance getEIInstance() {
		return eiInstance;
	}

	@Override
	public void setShouldShowLabel(final boolean shouldShowLabel) {
		if ( !shouldShowLabel ) {
			// We do not intend to show the label again for Stub Widget
			widgetPanel.remove( label );
		}
	}

	@Override
	public EditWidget duplicateBlank() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected void removeValue() {

	}

}
