package org.eaglei.datatools.client.ui.widgets;

import org.eaglei.datatools.client.ui.Validations;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;

public class ValidatedTextWidget extends TextWidget {

	public ValidatedTextWidget(final EIInstance eiInstance, final EIEntity propertyEntity, final String propertyDefinition, final boolean isRequired, final String propertyValue) {
		super( eiInstance, propertyEntity, propertyDefinition, isRequired, propertyValue, OldValueHandlerFactory.getDatatypeOldValueHandler() );
	}

	@Override
	protected ValueChangeHandler<String> getValueChangeHandler() {
		return new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(final ValueChangeEvent<String> changedValue) {
				/* if ( !validate() ) {
					oldValueHandler.replaceValue( eiInstance, propertyEntity, oldValue, "" );
				} else */ if ( hasOldValue() ) {
					oldValueHandler.replaceValue( eiInstance, propertyEntity, oldValue, changedValue.getValue() );
				} else {
					oldValueHandler.addValue( eiInstance, propertyEntity, changedValue.getValue() );
				}
				updateOldValue( changedValue.getValue() );
			}
		};
	}

	@Override
	public EditWidget duplicateBlank() {
		return new ValidatedTextWidget( eiInstance, propertyEntity, propertyDefinition, isRequired, "" );
	}
	//FIXME commented out errLabel - it's throwing alignment off; uncomment if/when we reenable validation
	private boolean validate() {
		// TODO: any better way of doing this so someone can tab away & come back?
		// Maybe validate the *instance values* when we save?
		if ( !Validations.IsEmailBox( getValueText() ) && !getValueText().equals( "" ) ) {
			//errLabel.setText( "Only emails are allowed" );
			setFieldValue( "" );
			return false;
		} else {
			//errLabel.setText( "" );
			return true;
		}
	}
}
