/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.User;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.EagleiGlassPane;
import org.eaglei.datatools.client.ui.LeftListPanel;
import org.eaglei.datatools.client.ui.LoginLogoutPanel;
import org.eaglei.datatools.client.ui.MainController;
import org.eaglei.datatools.client.ui.ResourceProviderCache;
import org.eaglei.datatools.client.ui.TopPanel;
import org.eaglei.datatools.client.ui.Workbench;
import org.eaglei.datatools.client.ui.widgets.BreadcrumbWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.NewFooterPanel;

public abstract class AbstractEntryPoint
implements EntryPoint {
    protected static String currentUser;
    protected FlowPanel mainDiv;
    protected FlowPanel datatoolsDiv1;
    protected static FlowPanel datatoolsDiv2;
    protected FlowPanel datatoolsTitleDiv;
    protected HTML datatoolsTitle;
    protected FlowPanel mainPanel;
    protected static boolean isRefresh;
    protected TopPanel topPanel;
    protected boolean initialized = false;
    protected LeftListPanel leftList;
    protected MainController mainController;
    protected static final FlowPanel dataPanel;
    protected LoginLogoutPanel loginLogout;
    protected static final EagleiGlassPane glasspane;
    protected ResourceProviderCache providerCache = null;
    protected static GWTLogger log;
    protected static Workbench workbench;
    protected BreadcrumbWidget breadcrumbs;

    protected abstract void initialize();

    public void onModuleLoad() {
        this.initialized = false;
        log.info("making new main controller");
        if (!Window.Location.getHash().equals("")) {
            isRefresh = true;
        }
        this.mainController = new MainController();
        RootPanel footerSlot = RootPanel.get((String)"footer_container");
        String version = footerSlot.getElement().getInnerText();
        footerSlot.getElement().setInnerText("");
        NewFooterPanel footerPanel = new NewFooterPanel(version);
        footerSlot.add((Widget)footerPanel);
        datatoolsDiv2 = new FlowPanel();
        datatoolsDiv2.setStyleName("datatoolsContent2");
        this.datatoolsDiv1 = new FlowPanel();
        this.datatoolsDiv1.setStyleName("datatoolsWrapper");
        this.mainDiv = new FlowPanel();
        this.mainDiv.setStyleName("wrapper");
        this.datatoolsTitleDiv = new FlowPanel();
        this.datatoolsTitleDiv.setStyleName("searchClickBar0");
        this.datatoolsTitle = new HTML("<img src='/datatools/images/datatools-lefttop.jpg' alt='Search' width='44' height='157' border='0' />");
        this.mainDiv.add((Widget)this.datatoolsDiv1);
        this.datatoolsTitleDiv.add((Widget)this.datatoolsTitle);
        this.datatoolsDiv1.add((Widget)this.datatoolsTitleDiv);
        this.datatoolsDiv1.add((Widget)datatoolsDiv2);
        this.mainDiv.add((Widget)this.datatoolsDiv1);
        RootPanel.get((String)"main_container").add((Widget)this.mainDiv);
        currentUser = DatatoolsCookies.getUserName();
        if (currentUser != null) {
            ClientRepositoryToolsManager.INSTANCE.whoami(new RootAsyncCallback<User>(){

                @Override
                public void onSuccess(User userInfo) {
                    if (userInfo == null) {
                        log.debug("failed to get any user info from whoami");
                        AbstractEntryPoint.this.handleNotLoggedIn();
                        AbstractEntryPoint.this.initialize();
                        return;
                    }
                    AbstractEntryPoint.setUser(userInfo);
                    String user = userInfo.getUserName();
                    if (user == null) {
                        log.debug("did whoami; user null, removing cookies");
                        AbstractEntryPoint.this.handleNotLoggedIn();
                        AbstractEntryPoint.this.initialize();
                        return;
                    }
                    if (!user.equals(currentUser)) {
                        log.debug("did whoami; user not same as current user, removing cookies");
                        AbstractEntryPoint.this.handleNotLoggedIn();
                        AbstractEntryPoint.this.initialize();
                        return;
                    }
                    log.debug("did whoami: confirms signed in as " + user);
                    AbstractEntryPoint.this.initialize();
                }

                @Override
                public void onFailure(Throwable caught) {
                    log.debug("other failure in whoami");
                    AbstractEntryPoint.this.handleNotLoggedIn();
                    AbstractEntryPoint.this.initialize();
                }
            });
        } else if (!this.initialized) {
            this.initialize();
            return;
        }
    }

    public static void showGlasspane() {
        glasspane.add((Widget)new Image("images/ajax-loader.gif"));
        glasspane.show();
    }

    public static void hideGlasspane() {
        glasspane.hide();
    }

    public static boolean isGlasspaneShowing() {
        return glasspane.isShowing();
    }

    public static void clearDataPanel() {
        dataPanel.clear();
    }

    public static void handleLoginRequired() {
        AbstractEntryPoint.clearDataPanel();
        Window.alert((String)"Your session has expired. Please sign in.");
        for (int index = 0; index < datatoolsDiv2.getWidgetCount(); ++index) {
            if (datatoolsDiv2.getWidget(index) instanceof BreadcrumbWidget) {
                datatoolsDiv2.getWidget(index).setVisible(false);
                continue;
            }
            if (!(datatoolsDiv2.getWidget(index) instanceof LoginLogoutPanel)) continue;
            datatoolsDiv2.remove(datatoolsDiv2.getWidget(index));
        }
        LoginLogoutPanel loginLogout = new LoginLogoutPanel();
        loginLogout.setStyleName("floatRight");
        datatoolsDiv2.add((Widget)loginLogout);
    }

    public static void showData(Widget widget) {
        AbstractEntryPoint.clearDataPanel();
        AbstractEntryPoint.hideGlasspane();
        dataPanel.add(widget);
    }

    public static void setUser(User user) {
        currentUser = user.getUserName();
    }

    public static void setIsRefresh(boolean refreshing) {
        isRefresh = refreshing;
    }

    public static void addWelcomeUserText() {
    }

    protected void showLoginPanel() {
        if (this.loginLogout == null) {
            this.loginLogout = new LoginLogoutPanel();
            this.loginLogout.setStyleName("floatRight");
            datatoolsDiv2.add((Widget)this.loginLogout);
        }
    }

    private void handleNotLoggedIn() {
        ApplicationState.getInstance().setUser(EIEntity.NULL_ENTITY);
        DatatoolsCookies.removeCookies();
        currentUser = null;
        ClientRepositoryToolsManager.INSTANCE.logOut();
    }

    public static void showWorkbench() {
        workbench.resetSelectedProvider();
        AbstractEntryPoint.showData((Widget)workbench);
    }

    public void addTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new TopPanel();
            RootPanel.get((String)"header_container").add((Widget)this.topPanel);
        }
    }

    public String attachUserToState() {
        String userUri = DatatoolsCookies.getUserUri();
        if (currentUser == null) {
            userUri = null;
        }
        if (userUri != null) {
            ApplicationState.getInstance().setUser(EIEntity.create((EIURI)EIURI.create((String)userUri), (String)currentUser));
            log.debug("User uri " + ApplicationState.getInstance().getUserURI() + "; label " + ApplicationState.getInstance().getUserID());
        }
        return userUri;
    }

    public void setRefreshFlag() {
        if (!Window.Location.getHash().equals("")) {
            isRefresh = true;
            log.debug("token from window: " + Window.Location.getHash());
        }
    }

    static {
        dataPanel = new FlowPanel();
        glasspane = new EagleiGlassPane();
        log = GWTLogger.getLogger("AbstractEntryPoint");
        workbench = null;
    }
}

