/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.status;

import java.io.Serializable;
import java.util.HashMap;
import org.eaglei.services.repository.RepositoryProviderException;

public class RepositoryErrorMessages
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String INVALID_SESSION_MESSAGE = "No valid session information was found.";
    public static final String UNAUTHORIZED_MESSAGE = "Could not authenticate user. Re-enter username and/or password.";
    public static final String UNAVAILABLE_MESSAGE = "The repository is currently unavailable.";
    public static final String FAILED_MESSAGE = "Could not complete operation";
    public static final String STALE_TOKEN_MESSAGE = "This resource is being edited or has recently changed. Is it open in another window? Cancel and try editing again.";
    public static final String CONFIGURATION_MESSAGE = "The server application is not correctly configured. Please contact the system administrator.";
    public static final String BAD_REQUEST_MESSAGE = "Bad request";
    public static final String CONFLICT_MESSAGE = "Conflict (likely stale token)";
    public static final String FORBIDDEN_MESSAGE = "Forbidden";
    public static final String INTERNAL_SERVER_ERROR_MESSAGE = "The repository is currently unavailable.";
    public static final String NOT_ACCEPTABLE_MESSAGE = "Request was not accepted by the repository.";
    public static final String NOT_FOUND_MESSAGE = "Not found";
    public static final String GONE_MESSAGE = "Resource is no longer in the repository.";
    private static final HashMap<RepositoryProviderException.RepositoryProviderExceptionType, String> messageMap = new HashMap(9);

    public static String getErrorMessageForExceptionType(RepositoryProviderException.RepositoryProviderExceptionType type) {
        return messageMap.get(type);
    }

    static {
        messageMap.put(RepositoryProviderException.RepositoryProviderExceptionType.BAD_REQUEST, BAD_REQUEST_MESSAGE);
        messageMap.put(RepositoryProviderException.RepositoryProviderExceptionType.CONFLICT, CONFLICT_MESSAGE);
        messageMap.put(RepositoryProviderException.RepositoryProviderExceptionType.FORBIDDEN, FORBIDDEN_MESSAGE);
        messageMap.put(RepositoryProviderException.RepositoryProviderExceptionType.GONE, GONE_MESSAGE);
        messageMap.put(RepositoryProviderException.RepositoryProviderExceptionType.INTERNAL_SERVER_ERROR, "The repository is currently unavailable.");
        messageMap.put(RepositoryProviderException.RepositoryProviderExceptionType.INVALID_SESSION, INVALID_SESSION_MESSAGE);
        messageMap.put(RepositoryProviderException.RepositoryProviderExceptionType.NOT_ACCEPTABLE, NOT_ACCEPTABLE_MESSAGE);
        messageMap.put(RepositoryProviderException.RepositoryProviderExceptionType.NOT_FOUND, NOT_FOUND_MESSAGE);
        messageMap.put(RepositoryProviderException.RepositoryProviderExceptionType.UNAUTHORIZED, UNAUTHORIZED_MESSAGE);
    }
}

