/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.WorkFlowTransition;
import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.ActionRedisplay;
import org.eaglei.datatools.client.ui.FilterPanel;
import org.eaglei.datatools.client.ui.OwnershipAction;
import org.eaglei.datatools.client.ui.Performable;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.datatools.client.ui.WorkflowUtils;
import org.eaglei.datatools.client.ui.listeners.RowDeletionListener;
import org.eaglei.datatools.client.ui.widgets.EIConfirmationPopup;
import org.eaglei.datatools.client.ui.widgets.GridRowWidget;
import org.eaglei.datatools.client.ui.widgets.PaginationWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;

public class EIResourcesGrid
extends Composite
implements RowDeletionListener {
    private static final String GRID_ROW_COLUMN_HEADER = "gridRowColumnHeader";
    private static final String[] RESOURCE_COLUMN_NAMES = SortByProperties.getColumnNames();
    private static final Map<String, Comparator<EIInstanceMinimal>> resourceSorters = new HashMap<String, Comparator<EIInstanceMinimal>>();
    public static final String DATATOOLS_FILTER = "DatatoolsFilter";
    private List<EIInstanceMinimal> instances = new ArrayList<EIInstanceMinimal>();
    private final Map<EIInstanceMinimal, GridRowWidget> instanceRowMap = new HashMap<EIInstanceMinimal, GridRowWidget>();
    private final Map<String, WorkFlowTransition> actionTransitionMap = new HashMap<String, WorkFlowTransition>();
    private FilterPanel filterPanel;
    private final FlowPanel resources = new FlowPanel();
    private final FlowPanel innerPanel = new FlowPanel();
    private PaginationWidget topPaginationWidget;
    private PaginationWidget bottomPaginationWidget;
    private final FlowPanel nonGridContentPanel = new FlowPanel();
    private final FlowPanel pageHeaderPanel = new FlowPanel();
    private final FlowPanel subPageHeaderPanel = new FlowPanel();
    private static final GWTLogger log = GWTLogger.getLogger("EIResourcesGrid");

    public EIResourcesGrid() {
        this.initialize();
        this.drawFromApplicationState();
    }

    public EIResourcesGrid(List<EIInstanceMinimal> instances) {
        log.info("Creating grid with " + instances.size() + " instances");
        this.instances = instances;
        this.initialize();
        log.info("Creating pagination widgets");
        this.topPaginationWidget = new PaginationWidget(ApplicationState.getInstance().getOffset(), instances.size(), ApplicationState.getInstance().getLimit());
        this.bottomPaginationWidget = new PaginationWidget(ApplicationState.getInstance().getOffset(), instances.size(), ApplicationState.getInstance().getLimit());
        this.resources.remove((Widget)this.nonGridContentPanel);
        this.drawFromApplicationState();
    }

    private void initialize() {
        this.initWidget((Widget)this.innerPanel);
        if (resourceSorters.size() == 0) {
            this.initializeSorters();
        }
        this.filterPanel = new FilterPanel(ApplicationState.getInstance().hasFilterTypeEntity() ? ApplicationState.getInstance().getFilterTypeEntity() : ApplicationState.getInstance().getTypeEntity(), ApplicationState.getInstance().getFilterWorkflowEntity(), ApplicationState.getInstance().getFilterResourceProviderEntity(), ApplicationState.getInstance().isStrictlyFilteredByOwner());
        this.resources.getElement().setClassName("listGrid");
        Label pageHeaderLabel = this.getHeaderLabel();
        for (WorkFlowTransition transition : ClientRepositoryToolsManager.INSTANCE.getAllowedTransitions()) {
            if (!this.isUsefulTransition(transition)) continue;
            this.actionTransitionMap.put(this.getName(transition), transition);
        }
        this.subPageHeaderPanel.setStyleName("pageHeaderContainer");
        if (!ApplicationState.getInstance().hasResourceProviderType() && !this.instances.isEmpty()) {
            ListBox actionList = this.makeListBoxOfActions();
            FlowPanel subPageHeaderRight = new FlowPanel();
            subPageHeaderRight.setStyleName("pageHeaderRight");
            subPageHeaderRight.add((Widget)actionList);
            this.subPageHeaderPanel.add((Widget)subPageHeaderRight);
        }
        this.pageHeaderPanel.setStyleName("pageCategory");
        this.pageHeaderPanel.add((Widget)pageHeaderLabel);
        this.innerPanel.add((Widget)this.filterPanel);
        this.innerPanel.add((Widget)this.pageHeaderPanel);
        this.innerPanel.add((Widget)this.subPageHeaderPanel);
        this.innerPanel.add((Widget)this.resources);
        this.nonGridContentPanel.setStyleName("resourcesHeaderPanel");
        Label emptyHeader = new Label(this.getEmptyListMessage());
        this.nonGridContentPanel.add((Widget)emptyHeader);
        this.resources.add((Widget)this.nonGridContentPanel);
    }

    private String getName(WorkFlowTransition transition) {
        if (transition.getName().contains("Return to Draft")) {
            EIEntity fromEntity = WorkFlowConstants.WORKFLOW_URI_MAP.get(transition.getFromStateURI());
            return transition.getName() + " from " + fromEntity.getLabel();
        }
        return transition.getName();
    }

    private boolean isUsefulTransition(WorkFlowTransition transition) {
        log.debug("checking if " + transition.getName() + " is useful");
        return !transition.getFromStateURI().equals((Object)transition.getToStateURI()) && !transition.getFromStateURI().equals((Object)WorkFlowConstants.NEW_URI);
    }

    private String getEmptyListMessage() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            return "No resources refer to " + ApplicationState.getInstance().getInstanceEntity().getLabel();
        }
        return "To see a list of resources, click the resource type, such as Instrument, or filter by Status or Laboratory above.";
    }

    private void drawFromApplicationState() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.resources) {
            return;
        }
        if (!QueryTokenObject.Mode.isResourcesList(ApplicationState.getInstance().getMode())) {
            this.resources.clear();
            return;
        }
        if (!ApplicationState.getInstance().isPaginated()) {
            this.filterPanel.setCount(this.instances.size());
        }
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            this.filterPanel.disable();
        }
        if (this.instances.size() == 0) {
            this.resources.remove((Widget)this.nonGridContentPanel);
            this.resources.clear();
            Label noInstances = new Label(this.getNoResourcesMessage());
            this.resources.add((Widget)noInstances);
            return;
        }
        this.resources.clear();
        this.subPageHeaderPanel.add((Widget)this.topPaginationWidget);
        this.setGridHeaders();
        this.updateGrid(0, this.instances);
        this.resources.add((Widget)this.bottomPaginationWidget);
    }

    private String getNoResourcesMessage() {
        if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            return "No resources refer to " + ApplicationState.getInstance().getInstanceEntity().getLabel();
        }
        return "No resources found";
    }

    private void setGridHeaders() {
        FlowPanel header = new FlowPanel();
        int i = 0;
        for (final SortByProperties orderBy : SortByProperties.values()) {
            final String columnName = orderBy.getColumnName();
            Anchor label = new Anchor(columnName);
            final FlowPanel headerPanel = new FlowPanel();
            headerPanel.setStyleName(GRID_ROW_COLUMN_HEADER);
            headerPanel.addStyleName(GRID_ROW_COLUMN_HEADER + i++);
            if (orderBy.getParameterName() == ApplicationState.getInstance().getSortBy()) {
                headerPanel.addStyleName("gridRowColumnHeaderSelected");
            }
            headerPanel.add((Widget)label);
            header.add((Widget)headerPanel);
            label.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    boolean isAsc = ApplicationState.getInstance().isAcending();
                    log.debug("sorting by " + columnName);
                    if (!ApplicationState.getInstance().isPaginated()) {
                        EIResourcesGrid.this.sortGrid(EIResourcesGrid.this.instances, (Comparator)resourceSorters.get(columnName));
                    } else if (!orderBy.getParameterName().equals(ApplicationState.getInstance().getSortBy())) {
                        ApplicationState.getInstance().updatePaging(orderBy.getParameterName(), 0, ApplicationState.getInstance().getLimit());
                    } else {
                        ApplicationState.getInstance().setAcending(!isAsc);
                        ApplicationState.getInstance().updatePaging(orderBy.getParameterName(), 0, ApplicationState.getInstance().getLimit());
                        headerPanel.setStyleName("gridRowColumnHeaderSelectedDesc");
                    }
                }
            });
        }
        FlowPanel headerPanel456 = new FlowPanel();
        headerPanel456.setStyleName(GRID_ROW_COLUMN_HEADER);
        headerPanel456.addStyleName("gridRowColumnHeader456");
        FlowPanel headerPanel7 = new FlowPanel();
        headerPanel7.setStyleName(GRID_ROW_COLUMN_HEADER);
        headerPanel7.addStyleName("gridRowColumnHeader7");
        if (!ApplicationState.getInstance().hasResourceProviderType()) {
            CheckBox selectAllCheckBox = this.makeCheckBoxToSelectAll();
            headerPanel7.add((Widget)selectAllCheckBox);
        }
        header.add((Widget)headerPanel456);
        header.add((Widget)headerPanel7);
        this.resources.add((Widget)header);
        header.setStyleName("dtListGridHeader");
    }

    private CheckBox makeCheckBoxToSelectAll() {
        CheckBox checkBox = new CheckBox("");
        checkBox.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CheckBox selectAllCheckBox = (CheckBox)event.getSource();
                for (EIInstanceMinimal eiInstance : EIResourcesGrid.this.instances) {
                    GridRowWidget row = (GridRowWidget)((Object)EIResourcesGrid.this.instanceRowMap.get(eiInstance));
                    CheckBox chkBox = row.getCheckBox();
                    if (chkBox == null) continue;
                    chkBox.setValue(selectAllCheckBox.getValue());
                }
            }
        });
        return checkBox;
    }

    private void removeRow(EIInstanceMinimal toRemove) {
        if (this.instanceRowMap.containsKey(toRemove)) {
            this.resources.remove((Widget)this.instanceRowMap.get(toRemove));
            this.instanceRowMap.remove(toRemove);
            this.instances.remove(toRemove);
        }
        this.filterPanel.setCount(this.instances.size());
    }

    private void sortGrid(List<EIInstanceMinimal> eiInstanceList, Comparator<EIInstanceMinimal> sorter) {
        Collections.sort(this.instances, sorter);
        for (EIInstanceMinimal instance : eiInstanceList) {
            this.resources.remove((Widget)this.instanceRowMap.get(instance));
            this.resources.add((Widget)this.instanceRowMap.get(instance));
        }
    }

    private void updateGrid(int initialRowNumber, List<EIInstanceMinimal> eiInstanceList) {
        for (EIInstanceMinimal instance : eiInstanceList) {
            GridRowWidget gridRowWidget = new GridRowWidget(instance, this);
            this.instanceRowMap.put(instance, gridRowWidget);
            this.resources.add((Widget)gridRowWidget);
        }
    }

    private Label getHeaderLabel() {
        String labelContent = "";
        if (ApplicationState.getInstance().hasType()) {
            labelContent = ApplicationState.getInstance().getTypeEntity().getLabel();
        } else if (ApplicationState.getInstance().getFilterTypeEntity() != EIEntity.NULL_ENTITY) {
            labelContent = ApplicationState.getInstance().getFilterTypeEntity().getLabel();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.references) {
            labelContent = "Resources that reference " + ApplicationState.getInstance().getInstanceEntity().getLabel();
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.stubs) {
            labelContent = "Unfinished Tasks";
        } else if (!this.instances.isEmpty()) {
            labelContent = "All Resource Types";
        }
        Label headerLabel = new Label(labelContent);
        headerLabel.setStyleName("pageHeader");
        return headerLabel;
    }

    private void initializeSorters() {
        resourceSorters.put(RESOURCE_COLUMN_NAMES[0], new Comparator<EIInstanceMinimal>(){

            @Override
            public int compare(EIInstanceMinimal arg0, EIInstanceMinimal arg1) {
                return arg0.getInstanceLabel().compareToIgnoreCase(arg1.getInstanceLabel());
            }
        });
        resourceSorters.put(RESOURCE_COLUMN_NAMES[1], new Comparator<EIInstanceMinimal>(){

            @Override
            public int compare(EIInstanceMinimal arg0, EIInstanceMinimal arg1) {
                return arg0.getInstanceType().getLabel().compareToIgnoreCase(arg1.getInstanceType().getLabel());
            }
        });
        resourceSorters.put(RESOURCE_COLUMN_NAMES[2], new Comparator<EIInstanceMinimal>(){

            @Override
            public int compare(EIInstanceMinimal arg0, EIInstanceMinimal arg1) {
                return arg0.getCreationDate().compareToIgnoreCase(arg1.getCreationDate());
            }
        });
        resourceSorters.put(RESOURCE_COLUMN_NAMES[3], new Comparator<EIInstanceMinimal>(){

            @Override
            public int compare(EIInstanceMinimal arg0, EIInstanceMinimal arg1) {
                return arg0.getWFState().getLabel().compareToIgnoreCase(arg1.getWFState().getLabel());
            }
        });
    }

    private ListBox makeListBoxOfActions() {
        final ListBox actionList = new ListBox();
        actionList.addItem("Actions");
        ArrayList<String> actionNames = new ArrayList<String>(this.actionTransitionMap.keySet());
        Collections.sort(actionNames);
        for (String actionName : actionNames) {
            actionList.addItem(actionName);
        }
        actionList.addItem("Claim");
        actionList.addItem("Share");
        actionList.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                final String selectedText = actionList.getItemText(actionList.getSelectedIndex());
                final List<EIInstanceMinimal> checkedInstances = EIResourcesGrid.this.getCheckedInstances();
                ActionRedisplay redisplay = new ActionRedisplay(){

                    @Override
                    public void drawAfterClaim(EIInstanceMinimal[] instances, List<EIInstanceMinimal> successes) {
                        for (EIInstanceMinimal eiInstance : successes) {
                            if (EIResourcesGrid.this.instanceMeetsFilterCriteria(eiInstance)) {
                                GridRowWidget row = (GridRowWidget)((Object)EIResourcesGrid.this.instanceRowMap.get(eiInstance));
                                row.redrawActions();
                                continue;
                            }
                            EIResourcesGrid.this.removeRow(eiInstance);
                        }
                        AbstractEntryPoint.hideGlasspane();
                    }

                    @Override
                    public void handleFailedTransition(String error) {
                        AbstractEntryPoint.hideGlasspane();
                        Window.alert((String)"Operation $TRANSITION$ failed for $RESOURCES$.".replace("$TRANSITION$", selectedText).replace("$RESOURCES$", EIResourcesGrid.this.getNames(checkedInstances)));
                    }

                    @Override
                    public void drawAfterPromote(EIInstanceMinimal[] instances, List<EIInstanceMinimal> successes) {
                        AbstractEntryPoint.hideGlasspane();
                        for (EIInstanceMinimal eiInstance : successes) {
                            if (EIResourcesGrid.this.instanceMeetsFilterCriteria(eiInstance)) {
                                GridRowWidget row = (GridRowWidget)((Object)EIResourcesGrid.this.instanceRowMap.get(eiInstance));
                                row.getInstance().setWFOwner(eiInstance.getWFOwner());
                                row.getInstance().setWFState(eiInstance.getWFState());
                                row.updateStateData();
                                continue;
                            }
                            EIResourcesGrid.this.removeRow(eiInstance);
                        }
                    }

                    @Override
                    public void needsRefresh(String message) {
                        Window.alert((String)"Some resources were out of date.  Please refresh and try again.");
                        AbstractEntryPoint.hideGlasspane();
                    }
                };
                if (checkedInstances.size() == 0) {
                    Window.alert((String)"Select resources and choose an action.");
                    actionList.setSelectedIndex(0);
                    return;
                }
                if (EIResourcesGrid.this.actionTransitionMap.containsKey(selectedText)) {
                    WorkFlowTransition transition = (WorkFlowTransition)EIResourcesGrid.this.actionTransitionMap.get(selectedText);
                    EIResourcesGrid.this.bulkOperation(transition, checkedInstances, EIResourcesGrid.this.makeWorkflowCallback(checkedInstances.toArray(new EIInstanceMinimal[checkedInstances.size()]), redisplay));
                } else if (selectedText.equalsIgnoreCase("Claim")) {
                    EIResourcesGrid.this.bulkClaimOrRelease(redisplay, OwnershipAction.ClaimAction, checkedInstances, EIResourcesGrid.this.makeOwnershipCallback(new EIInstanceMinimal[checkedInstances.size()], redisplay));
                } else if (selectedText.equalsIgnoreCase("Share")) {
                    EIResourcesGrid.this.bulkClaimOrRelease(redisplay, OwnershipAction.ReleaseAction, checkedInstances, EIResourcesGrid.this.makeOwnershipCallback(new EIInstanceMinimal[checkedInstances.size()], redisplay));
                }
                actionList.setSelectedIndex(0);
            }
        });
        return actionList;
    }

    private String getNames(List<EIInstanceMinimal> checkedInstances) {
        StringBuilder sb = new StringBuilder();
        for (EIInstanceMinimal checked : checkedInstances) {
            sb.append(checked.getInstanceLabel() + " ");
        }
        return sb.toString();
    }

    protected void makeConfirmationDialog(List<EIInstanceMinimal> instanceList, String name, String errorMessage, ClientRepositoryToolsManager.BulkWorkflowCallback callback, Performable performable) {
        log.debug("making confirmation dialog for " + name + " and " + instanceList.size() + " instances");
        VerticalPanel vpanel = this.makeVerticalPanelWithHeading(name + " the following resources:");
        ScrollPanel scrPanel = this.getScrollPanelWithDimensionsSet();
        FlexTable flexTable = this.getFlextableWithHeadingSet();
        ArrayList<EIInstanceMinimal> validInstances = new ArrayList<EIInstanceMinimal>();
        ArrayList<EIInstanceMinimal> stubInstances = new ArrayList<EIInstanceMinimal>();
        int instanceCount = 0;
        for (EIInstanceMinimal instance : instanceList) {
            if (performable.isValidFor(instance)) {
                validInstances.add(instance);
                log.debug("valid instance " + instance.getInstanceLabel());
                flexTable.setText(instanceCount + 2, 0, instance.getInstanceLabel());
                flexTable.setText(instanceCount + 2, 1, instance.getInstanceType().getLabel());
                flexTable.setText(instanceCount + 2, 2, instance.getWFState().getLabel());
                ++instanceCount;
                continue;
            }
            if (!instance.isStub()) continue;
            log.debug("stub instance");
            stubInstances.add(instance);
        }
        String stubWarningMessage = stubInstances.size() > 0 ? this.makeErrorMessage("Please finish reviewing $RESOURCES$ before trying to $ACTION$.", "$RESOURCES$", stubInstances).replace("$ACTION$", name.toLowerCase()) : null;
        log.debug("stub warning message: " + stubWarningMessage);
        if (instanceCount == 0) {
            if (stubInstances.size() > 0) {
                Window.alert((String)stubWarningMessage);
            } else {
                Window.alert((String)errorMessage);
            }
            return;
        }
        if (validInstances.size() > 0) {
            log.debug("valid instances: " + validInstances.size() + "; stubs? " + stubInstances.size());
            EIConfirmationPopup popup = new EIConfirmationPopup("100%", "100%", stubWarningMessage);
            popup.addConfirmClickHandler(this.makeHandlerforBulkOperation(callback, performable, validInstances, popup));
            vpanel.add((Widget)scrPanel);
            scrPanel.add((Widget)flexTable);
            popup.add((Widget)vpanel);
            popup.show();
        }
    }

    private String makeErrorMessage(String bulkMessage, String toReplace, List<EIInstanceMinimal> stubInstances) {
        log.debug("making error message from: " + bulkMessage);
        StringBuilder instanceNames = new StringBuilder(stubInstances.get(0).getInstanceLabel());
        if (stubInstances.size() > 1) {
            for (EIInstanceMinimal minimal : stubInstances.subList(1, stubInstances.size())) {
                instanceNames.append(", " + minimal.getInstanceLabel());
            }
        }
        return bulkMessage.replace(toReplace, instanceNames);
    }

    protected boolean instanceMeetsFilterCriteria(EIInstanceMinimal eiInstance) {
        if (ApplicationState.getInstance().isStrictlyFilteredByOwner()) {
            return WorkflowUtils.isNotNull(eiInstance.getWFOwner());
        }
        return true;
    }

    protected List<EIInstanceMinimal> getCheckedInstances() {
        ArrayList<EIInstanceMinimal> instanceList = new ArrayList<EIInstanceMinimal>();
        for (EIInstanceMinimal eiInstance : this.instances) {
            GridRowWidget row = this.instanceRowMap.get(eiInstance);
            if (row.getCheckBox() == null || !row.getCheckBox().isVisible() || !row.getCheckBox().getValue().booleanValue()) continue;
            instanceList.add(eiInstance);
        }
        return instanceList;
    }

    protected void bulkClaimOrRelease(ActionRedisplay redisplay, OwnershipAction claimOrReleaseAction, List<EIInstanceMinimal> checkedInstances, ClientRepositoryToolsManager.BulkWorkflowCallback bulkWorkflowCallback) {
        this.makeConfirmationDialog(checkedInstances, claimOrReleaseAction.getName(), "You cannot $ACTION$ any of the selected resources.".replace("$ACTION$", claimOrReleaseAction.getName().toLowerCase()), bulkWorkflowCallback, claimOrReleaseAction);
    }

    protected ClientRepositoryToolsManager.BulkWorkflowCallback makeWorkflowCallback(final EIInstanceMinimal[] instances, final ActionRedisplay redisplay) {
        return new ClientRepositoryToolsManager.BulkWorkflowCallback(){

            @Override
            public void onSuccess(List<EIInstanceMinimal> failures) {
                redisplay.drawAfterPromote(instances, failures);
            }

            @Override
            public void needsRefresh(String message) {
                redisplay.needsRefresh(message);
            }

            @Override
            public void onFailure(Throwable caught) {
                redisplay.handleFailedTransition(caught.getMessage());
            }
        };
    }

    protected ClientRepositoryToolsManager.BulkWorkflowCallback makeOwnershipCallback(final EIInstanceMinimal[] instances, final ActionRedisplay redisplay) {
        return new ClientRepositoryToolsManager.BulkWorkflowCallback(){

            @Override
            public void onSuccess(List<EIInstanceMinimal> failures) {
                redisplay.drawAfterClaim(instances, failures);
            }

            @Override
            public void needsRefresh(String message) {
                redisplay.needsRefresh(message);
            }

            @Override
            public void onFailure(Throwable caught) {
                redisplay.handleFailedTransition(caught.getMessage());
            }
        };
    }

    protected void bulkOperation(final WorkFlowTransition transition, List<EIInstanceMinimal> selectedInstances, ClientRepositoryToolsManager.BulkWorkflowCallback callback) {
        this.makeConfirmationDialog(selectedInstances, transition.getName(), "You cannot $ACTION$ any of the selected resources.".replace("$ACTION$", transition.getName().toLowerCase()), callback, new Performable(){

            @Override
            public void perform(EIInstanceMinimal[] instances, ClientRepositoryToolsManager.BulkWorkflowCallback callback) {
                ClientRepositoryToolsManager.INSTANCE.transition(instances, transition, callback);
            }

            @Override
            public boolean isValidFor(EIInstanceMinimal instance) {
                return !instance.isStub() && transition.getFromStateURI().equals((Object)instance.getWFStateUri()) && ClientRepositoryToolsManager.INSTANCE.canEdit(instance);
            }
        });
    }

    private VerticalPanel makeVerticalPanelWithHeading(String headingString) {
        VerticalPanel vpanel = new VerticalPanel();
        Label heading = new Label(headingString);
        heading.setStyleName("dataPanelLabel");
        vpanel.add((Widget)heading);
        return vpanel;
    }

    private ClickHandler makeHandlerforBulkOperation(final ClientRepositoryToolsManager.BulkWorkflowCallback callback, final Performable performable, final List<EIInstanceMinimal> instanceList, final PopupPanel popup) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                performable.perform(instanceList.toArray(new EIInstanceMinimal[instanceList.size()]), callback);
                popup.hide();
                AbstractEntryPoint.showGlasspane();
            }
        };
    }

    private FlexTable getFlextableWithHeadingSet() {
        FlexTable flexTable = new FlexTable();
        flexTable.setStyleName("dataPanel");
        flexTable.setHTML(1, 0, "<b>Resource Name</b>");
        flexTable.setHTML(1, 1, "<b>Type</b>");
        flexTable.setHTML(1, 2, "<b>Status</b>");
        return flexTable;
    }

    private ScrollPanel getScrollPanelWithDimensionsSet() {
        ScrollPanel scrPanel = new ScrollPanel();
        scrPanel.setHeight("270px");
        scrPanel.setWidth("1000px");
        scrPanel.setHorizontalScrollPosition(-1);
        return scrPanel;
    }

    @Override
    public void onRowDeletion(EIInstanceMinimal instance) {
        if (ResourceProvider.isResourceProviderType(instance.getInstanceType())) {
            ApplicationState.getInstance().updateResourceProviderCache();
        }
        this.removeRow(instance);
    }
}

