/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.SortByProperties;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.AuthSearchRequest;

public class ResourceProviderCache
implements ClientRepositoryToolsManager.SessionListener {
    private final Map<String, EIInstanceMinimal> providerMap = new HashMap<String, EIInstanceMinimal>();
    private final Map<EIURI, EIInstanceMinimal> providerURIMap = new HashMap<EIURI, EIInstanceMinimal>();
    private boolean loading = true;
    private boolean loadStarted = false;
    private final List<ResourceProviderCacheListener> listeners;
    private static final GWTLogger log = GWTLogger.getLogger("ResourceProviderCache");

    public ResourceProviderCache() {
        log.debug("making new resource provider cache");
        this.listeners = new ArrayList<ResourceProviderCacheListener>();
        ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
    }

    public void update() {
        if (this.loadStarted) {
            return;
        }
        this.loading = true;
        this.loadStarted = true;
        log.debug("resource provider cache getting providers");
        AuthSearchRequest request = new AuthSearchRequest();
        request.setType(ResourceProvider.BASE_RESOURCE_CONTAINER_URI);
        request.setPaginated(false);
        ClientRepositoryToolsManager.INSTANCE.listResources(request, SortByProperties.label, ApplicationState.getInstance().isAcending(), false, false, new RootAsyncCallback<List<EIInstanceMinimal>>(){

            @Override
            public void onSuccess(List<EIInstanceMinimal> result) {
                ResourceProviderCache.this.providerMap.clear();
                for (EIInstanceMinimal instance : result) {
                    ResourceProviderCache.this.providerMap.put(instance.getInstanceLabel(), instance);
                    ResourceProviderCache.this.providerURIMap.put(instance.getInstanceURI(), instance);
                }
                ResourceProviderCache.this.loading = false;
                ResourceProviderCache.this.loadStarted = false;
                ResourceProviderCache.this.notifyListeners();
            }
        });
    }

    public List<String> getResourceProviderLabels() {
        ArrayList<String> labels = new ArrayList<String>(this.providerMap.keySet());
        Collections.sort(labels);
        return labels;
    }

    public List<EIEntity> getResourceProviderEntities() {
        ArrayList<EIEntity> providerEntities = new ArrayList<EIEntity>();
        for (String label : this.getResourceProviderLabels()) {
            providerEntities.add(this.providerMap.get(label).getEntity());
        }
        return providerEntities;
    }

    public EIEntity getResourceProvider(String providerLabel) {
        if (!this.providerMap.containsKey(providerLabel)) {
            log.warn("trying to get nonexistent entry '" + providerLabel + "'");
        }
        return this.providerMap.get(providerLabel).getEntity();
    }

    public EIEntity getResourceProviderType(EIEntity provider) {
        if (!this.providerMap.containsKey(provider.getLabel())) {
            log.warn("trying to get nonexistent entry '" + provider.getLabel() + "'");
        }
        return this.providerMap.get(provider.getLabel()).getInstanceType();
    }

    public EIEntity getResourceProvider(EIURI providerUri) {
        if (!this.providerURIMap.containsKey(providerUri)) {
            log.warn("trying to get nonexistent uri '" + providerUri + "'");
        }
        return this.providerURIMap.get(providerUri).getEntity();
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void addProviderLoadListener(ResourceProviderCacheListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (ResourceProviderCacheListener listener : this.listeners) {
            listener.onProvidersLoaded();
        }
    }

    @Override
    public void onLogIn(String username, String userUri) {
        this.update();
    }

    @Override
    public void onLogOut(boolean isSessionExpired) {
        this.listeners.clear();
    }

    public static interface ResourceProviderCacheListener {
        public void onProvidersLoaded();
    }
}

