/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.ResourceProvider;
import org.eaglei.model.EIEntity;

public class BreadcrumbWidget
extends HorizontalPanel
implements ApplicationStateChangeListener {
    private final Anchor workbenchLink;
    private Anchor providerLink;
    private Anchor resourcesLink;
    private EIEntity providerEntity = EIEntity.NULL_ENTITY;
    private static final String nextCrumb = "  >  ";
    private static final GWTLogger log = GWTLogger.getLogger("BreadcrumbWidget");

    public BreadcrumbWidget() {
        this.setStyleName("breadcrumb_container");
        this.workbenchLink = new Anchor("Workbench");
        this.workbenchLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BreadcrumbWidget.this.hideFollowing(BreadcrumbWidget.this.workbenchLink);
                BreadcrumbWidget.this.providerEntity = EIEntity.NULL_ENTITY;
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.workbench, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY, EIEntity.NULL_ENTITY);
            }
        });
        this.add((Widget)this.workbenchLink);
        this.addNextCrumb();
        this.providerLink = new Anchor("");
        this.providerLink.setVisible(false);
        this.providerLink.setEnabled(false);
        this.providerLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BreadcrumbWidget.this.hideFollowing(BreadcrumbWidget.this.providerLink);
                log.debug("updating resource provider to " + BreadcrumbWidget.this.providerEntity);
                ApplicationState.getInstance().updateApplicationState(QueryTokenObject.Mode.view, BreadcrumbWidget.this.providerEntity, ResourceProvider.BASE_RESOURCE_CONTAINER, BreadcrumbWidget.this.providerEntity);
            }
        });
        this.add((Widget)this.providerLink);
        this.addNextCrumb();
        this.resourcesLink = new Anchor("Resources");
        this.resourcesLink.setVisible(false);
        this.resourcesLink.setEnabled(false);
        this.add((Widget)this.resourcesLink);
    }

    @Override
    public void onApplicationStateChange() {
        log.debug("breadcrumb widget app state changed");
        this.providerEntity = ApplicationState.getInstance().getResourceProviderEntity();
        if (ApplicationState.getInstance().hasResourceProvider()) {
            log.debug("has lab");
            this.providerLink.setText(ApplicationState.getInstance().getResourceProviderEntity().getLabel());
            this.providerLink.setVisible(true);
            this.providerLink.setEnabled(true);
            this.showPrevious(this.providerLink);
            this.hideFollowing(this.providerLink);
        } else if (ApplicationState.getInstance().getMode() == QueryTokenObject.Mode.workbench) {
            log.debug("workbench mode");
            this.workbenchLink.setVisible(true);
            this.hideFollowing(this.workbenchLink);
        } else {
            log.debug("no resource provider");
            this.providerLink.setText("");
            this.providerLink.setVisible(false);
            this.providerLink.setEnabled(false);
            this.hideFollowing(this.providerLink);
        }
        if (this.providerEntity != EIEntity.NULL_ENTITY && QueryTokenObject.Mode.isResourcesList(ApplicationState.getInstance().getMode())) {
            String label = ApplicationState.getInstance().getTypeEntity().equals((Object)EIEntity.NULL_ENTITY) ? "Resources" : ApplicationState.getInstance().getTypeEntity().getLabel();
            this.resourcesLink.setText(label);
            this.resourcesLink.setVisible(true);
            this.resourcesLink.setEnabled(true);
            this.showPrevious(this.resourcesLink);
        }
    }

    public void reset() {
        this.hideFollowing(this.workbenchLink);
        this.providerLink.setText("");
        this.providerLink.setVisible(false);
        this.providerLink.setEnabled(false);
        this.hideFollowing(this.providerLink);
        this.resourcesLink.setText("");
        this.resourcesLink.setVisible(false);
        this.resourcesLink.setEnabled(false);
    }

    private void addNextCrumb() {
        Label nextWidgetLabel = new Label(nextCrumb);
        nextWidgetLabel.setStyleName("breadCrumbArrow");
        this.add((Widget)nextWidgetLabel);
        nextWidgetLabel.setVisible(false);
    }

    private void showPrevious(Anchor anchor) {
        if (this.getWidgetIndex((Widget)anchor) > 0) {
            this.getWidget(this.getWidgetIndex((Widget)anchor) - 1).setVisible(true);
        }
    }

    private void hideFollowing(Anchor clickedAnchor) {
        int clickedWidgetIndex = this.getWidgetIndex((Widget)clickedAnchor);
        for (int i = clickedWidgetIndex + 1; i < this.getWidgetCount(); ++i) {
            this.getWidget(i).setVisible(false);
        }
    }
}

