/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.ui.OntologyPropEditRenderer;
import org.eaglei.datatools.client.ui.listeners.NewInnerInstanceListener;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

public class EIEmbeddedResourceEditWidget
extends EditWidget
implements NewInnerInstanceListener {
    private static final GWTLogger log = GWTLogger.getLogger("EIEmbeddedResourceEditWidget");
    private DisclosurePanel embeddedPanel;
    private EIInstance embeddedInstance;
    private EIEntity embeddedClass;
    private NewInnerInstanceListener listener;
    private final List<EIInstance> newInnerInstances = new ArrayList<EIInstance>();

    public EIEmbeddedResourceEditWidget(EIInstance outerInstance, EIInstance embeddedInstance, EIEntity embeddedClass, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, boolean showLabel, NewInnerInstanceListener listener) {
        super(outerInstance, propertyEntity, propertyDefinition, isRequired);
        log.debug("Outer instance is: " + outerInstance);
        log.debug("Embedded instance is: " + embeddedInstance);
        this.embeddedClass = embeddedClass;
        this.isRequired = isRequired;
        this.shouldShowLabel = showLabel;
        this.listener = listener;
        if (embeddedInstance != null && !EIInstance.NULL_INSTANCE.equals(embeddedInstance)) {
            this.setup(embeddedInstance);
        } else {
            this.getEmptyEmbeddedInstance();
        }
    }

    private void getEmptyEmbeddedInstance() {
        ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(this.embeddedClass.getURI(), new RootAsyncCallback<EIInstance>(){

            @Override
            public void onSuccess(EIInstance newInstance) {
                newInstance.setEmbedded(true);
                EIEmbeddedResourceEditWidget.this.eiInstance.addEmbeddedInstance(EIEmbeddedResourceEditWidget.this.propertyEntity, newInstance);
                EIEmbeddedResourceEditWidget.this.setup(newInstance);
            }
        });
    }

    private void setup(EIInstance embeddedInstance) {
        this.embeddedInstance = embeddedInstance;
        this.embeddedPanel = new DisclosurePanel(this.propertyEntity.getLabel());
        this.embeddedPanel.setTitle(this.propertyDefinition);
        Anchor clearAllLink = new Anchor("clear all");
        FlowPanel mainPanel = new FlowPanel();
        FlowPanel ontologyPanel = new FlowPanel();
        this.addLinkClickHandler(clearAllLink, ontologyPanel, this);
        mainPanel.add((Widget)ontologyPanel);
        mainPanel.add((Widget)clearAllLink);
        new OntologyPropEditRenderer(this.embeddedInstance, ontologyPanel, this);
        this.embeddedPanel.setContent((Widget)mainPanel);
        this.widgetPanel.add((Widget)this.embeddedPanel);
        this.setShouldShowLabel(false);
    }

    private void addLinkClickHandler(Anchor clearAllLink, final FlowPanel ontologyPanel, final NewInnerInstanceListener currentListener) {
        clearAllLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                ontologyPanel.clear();
                EIEmbeddedResourceEditWidget.this.clearEmbeddedInstance();
                new OntologyPropEditRenderer(EIEmbeddedResourceEditWidget.this.embeddedInstance, ontologyPanel, currentListener);
            }
        });
    }

    @Override
    public EditWidget duplicateBlank() {
        return new EIEmbeddedResourceEditWidget(this.eiInstance, EIInstance.NULL_INSTANCE, this.embeddedClass, this.propertyEntity, this.propertyDefinition, this.isRequired, false, this.listener);
    }

    @Override
    protected void removeValue() {
        this.clearEmbeddedInstance();
    }

    @Override
    public void setShouldShowLabel(boolean shouldShowLabel) {
        if (!shouldShowLabel) {
            this.widgetPanel.remove((Widget)this.label);
        }
    }

    private void clearEmbeddedInstance() {
        this.embeddedInstance.setInstanceLabel("");
        this.embeddedInstance.setInstanceClass(this.embeddedInstance.getRootSuperType());
        this.embeddedInstance.getDatatypeProperties().clear();
        this.embeddedInstance.getObjectProperties().clear();
        this.listener.onInstanceRemoved(this.embeddedInstance);
        for (EIInstance inner : this.newInnerInstances) {
            this.listener.onInstanceRemoved(inner);
        }
    }

    @Override
    public void onInstanceAdded(EIInstance newInstance) {
        this.newInnerInstances.add(newInstance);
        this.listener.onInstanceAdded(newInstance);
    }

    @Override
    public void onInstanceRemoved(EIInstance newInstance) {
        this.newInnerInstances.remove(newInstance);
        this.listener.onInstanceRemoved(newInstance);
    }

    @Override
    public EIInstance getAddedInstance(EIEntity entity) {
        return this.listener.getAddedInstance(entity);
    }

    @Override
    public boolean isAddedInstanceEntity(EIEntity entity) {
        return this.listener.isAddedInstanceEntity(entity);
    }
}

