/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.google.gwt.user.client.Window;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.datatools.client.ui.widgets.OntologyDropdown;
import org.eaglei.datatools.client.ui.widgets.TermWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.SharedClassChooser;
import org.eaglei.ui.gwt.instance.EagleIEntityConstants;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class TypeWidget
extends TermWidget {
    private final TypeChangeHandler typeChangeHandler;
    private final EIClass originalSuperclass;

    public TypeWidget(EIInstance eiInstance, EIEntity propertyEntity, EIClass range, EIClass selectedClass, TypeChangeHandler typeChangeHandler) {
        super(eiInstance, propertyEntity, "", true, range, selectedClass, true);
        this.typeChangeHandler = typeChangeHandler;
        this.originalSuperclass = range;
        this.setShouldShowLabel(true);
    }

    @Override
    protected void makeSelectionHandler(SharedClassChooser<OntologyDropdown> classChooser) {
        classChooser.addSelectionListener(new EntitySelectionListener(){

            public void onSelection(EIEntity selectedEntity) {
                if (selectedEntity.equals((Object)EIEntity.NULL_ENTITY)) {
                    TypeWidget.this.eiInstance.setInstanceType(TypeWidget.this.originalSuperclass.getEntity());
                    TypeWidget.this.eiInstance.setInstanceClass(TypeWidget.this.originalSuperclass);
                    TypeWidget.this.typeChangeHandler.onTypeChange();
                } else {
                    ClientModelManager.INSTANCE.getClass(selectedEntity.getURI(), new ClientModelManager.ClassCallback(){

                        public void onSuccess(EIClass result) {
                            if (result.isInferred()) {
                                TypeWidget.this.eiInstance.setInstanceType(TypeWidget.this.originalSuperclass.getEntity());
                                TypeWidget.this.eiInstance.setInstanceClass(TypeWidget.this.originalSuperclass);
                                Window.alert((String)"This is an inferred type. You cannot assign it directly to a resource.");
                                TypeWidget.this.typeChangeHandler.onTypeChange();
                            } else {
                                TypeWidget.this.eiInstance.setInstanceType(result.getEntity());
                                TypeWidget.this.eiInstance.setInstanceClass(result);
                                TypeWidget.this.typeChangeHandler.onTypeChange();
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    protected String getLabel() {
        String labelPrefix = this.originalSuperclass.getEntity().getLabel();
        return InstanceWidgetUtils.getExtendedPropertyLabel((String)labelPrefix, (String)EagleIEntityConstants.RDF_TYPE_ENTITY.getLabel(), (boolean)true);
    }

    @Override
    protected void removeValue() {
    }

    @Override
    public EditWidget duplicateBlank() {
        return null;
    }

    @Override
    protected void addTermRequestWidget() {
        if (!this.eiInstance.isStub() && !this.eiInstance.isEmbeddedInstance()) {
            super.addTermRequestWidget();
        }
    }

    public static interface TypeChangeHandler {
        public void onTypeChange();
    }
}

