/**
 * 
 */
package org.eaglei.datatools.datamanagment.client;

import java.util.ArrayList;
import java.util.List;

import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.QueryTokenObject.Mode;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.DataManagmentManager;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.client.ui.EIResourcesGrid;
import org.eaglei.datatools.client.ui.LoginLogoutPanel;
import org.eaglei.datatools.client.ui.widgets.EIPopup;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.PopupPanel;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
public class RepairPanel extends FlowPanel implements ClientRepositoryToolsManager.SessionListener  {

	private Label selectLabel = new Label( "Select the Rescources to be repaired(type in URI's in feilds):" );
	private Label fixLabel = new Label( "Repair By:" );

	private Label selectSubjectLabel = new Label( "Resource type:" );
	private Label selectPredicateLabel = new Label( "which has predicate:" );
	private Label selectObjectLabel = new Label( "whose predicate value is:" );

	private RDFTextPanel selectSubjectTextBox = new RDFTextPanel();
	private RDFTextPanel selectPredicateTextBox = new RDFTextPanel();
	private RDFObjectTextPanel selectObjectTextBox = new RDFObjectTextPanel();

	ListBox repairByListBox = new ListBox();
	ListBox serverListBox = new ListBox();

	private Label fixObjectLabel = new Label( "value:" );
	private RDFObjectTextPanel fixObjectTextBox = new RDFObjectTextPanel();

	private Label fixPredicateLabel = new Label( "predicate:" );
	private TextBox fixPredicateTextBox = new TextBox();

	private Button diagnoseBtn = new Button( "Diagnose" );
	private Button startRepairBtn = new Button( "Start Repair" );

	private List<EIInstanceMinimal> InstanceListToRepair;

	private RootAsyncCallback<Integer> callback;
	EIPopup popupPanel;

	public RepairPanel()  {
		ClientRepositoryToolsManager.INSTANCE.addSessionListener( this );
		FlowPanel table = new FlowPanel();
		 popupPanel = new EIPopup();
		table.setStyleName( "filterwidget" );
		// flexTable.addStyleName( "dtListGridRow" );

		table.add( makeRepairPanel() );
		table.add( makeFixPanel() );

		FlowPanel row3 = new FlowPanel();
		row3.addStyleName( "dtListGridRow" );
		row3.add( diagnoseBtn );
		row3.add( startRepairBtn );
		table.add( row3 );
		addServersToListBox();

		this.add( serverListBox );
		this.add( table );

		makeDiagnoseButtonEventHandler();
		makeRepairButtonEventHandler();
		addServerListBoxEventHandler();

		callback = new RootAsyncCallback<Integer>() {
			@Override
			public void onSuccess(Integer result) {
				Window.alert( "instance repaired sucessfully" );
				AbstractEntryPoint.hideGlasspane();
			}
		};

	}

	private void addServerListBoxEventHandler() {
		serverListBox.addChangeHandler( new ChangeHandler(){

			@Override
			public void onChange(ChangeEvent event) {
				AbstractEntryPoint.showGlasspane();
				ClientRepositoryToolsManager.INSTANCE.logOut();
			
			}

		} );
	}

	private void addServersToListBox() {
		serverListBox.addItem( "harvard" );
		serverListBox.addItem( "upr" );
		serverListBox.addItem( "msm" );
		serverListBox.addItem( "jsu" );
		serverListBox.addItem( "montana" );
		serverListBox.addItem( "ohsu" );
		serverListBox.addItem( "dartmouth" );
		serverListBox.addItem( "hawaii" );
		serverListBox.addItem( "alaska" );
	}

	private void makeDiagnoseButtonEventHandler() {
		diagnoseBtn.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				AbstractEntryPoint.showGlasspane();
				try {
					makeRPCallToGetResource();
				} catch (ClientSideRepositoryException e) {
					Window.alert( e.getLocalizedMessage() );
					AbstractEntryPoint.hideGlasspane();
				}
			}
		} );
	}

	private void makeRepairButtonEventHandler() {
		startRepairBtn.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				if ( repairByListBox.getSelectedIndex() == 0 ) {
					makeRPCCalltoReplacePredicate();
				} else if ( repairByListBox.getSelectedIndex() == 1 ) {
					makeRPCCalltoReplaceObject();
				} else if ( repairByListBox.getSelectedIndex() == 2 ) {
					makeRPCCalltoReplaceObjectAndPredicate();
				} else if ( repairByListBox.getSelectedIndex() == 3 ) {
					makeRPCCalltoDelete();
				} else if ( repairByListBox.getSelectedIndex() == 4 ) {
					makeRPCCalltoReplaceObjectByRegex();
				}
				AbstractEntryPoint.showGlasspane();

			}

		} );
	}

	private FlowPanel makeFixPanel() {
		FlowPanel row2 = new FlowPanel();
		row2.addStyleName( "dtListGridRow" );
		HorizontalPanel fixByHPanel = new HorizontalPanel();
		row2.add( fixLabel );

		fixLabel.addStyleName( "gridRowColumn" );
		fixLabel.addStyleName( "gridRowColumn0" );
		// flexTable.add( fixByHPanel );

		repairByListBox.addItem( "changing predicate:" );
		repairByListBox.addItem( "changing value:" );
		repairByListBox.addItem( "changing both" );
		repairByListBox.addItem( "deleting the triple" );
		repairByListBox.addItem( "using regular expresions to replace part of the text" );
		repairByListBox.setWidth( "200px" );
		row2.add( repairByListBox );
		repairByListBox.addStyleName( "gridRowColumn" );
		repairByListBox.addStyleName( "gridRowColumn1" );

		row2.add( fixPredicateLabel );
		row2.add( fixPredicateTextBox );
		fixPredicateLabel.addStyleName( "gridRowColumn" );
		fixPredicateLabel.addStyleName( "gridRowColumn3" );

		fixPredicateTextBox.addStyleName( "gridRowColumn" );
		fixPredicateTextBox.addStyleName( "gridRowColumn4" );

		row2.add( fixObjectLabel );
		row2.add( fixObjectTextBox );
		fixObjectLabel.addStyleName( "gridRowColumn" );
		fixObjectLabel.addStyleName( "gridRowColumn7" );

		fixObjectTextBox.addStyleName( "gridRowColumn" );

		// flexTable.add( fixObjectVerticalPanel );
		// flexTable.add( fixPredicateVerticalPanel );
		fixPredicateLabel.setVisible( false );
		fixPredicateTextBox.setVisible( false );

		fixObjectLabel.setVisible( false );
		fixObjectTextBox.setVisible( false );

		repairByListBox.addChangeHandler( new ChangeHandler() {

			@Override
			public void onChange(ChangeEvent event) {
				fixPredicateLabel.setVisible( false );
				fixPredicateTextBox.setVisible( false );

				fixObjectLabel.setVisible( false );
				fixObjectTextBox.setVisible( false );

				if ( repairByListBox.getSelectedIndex() == 0 ) {

					fixPredicateLabel.setVisible( true );
					fixPredicateTextBox.setVisible( true );

				} else if ( repairByListBox.getSelectedIndex() == 1 ) {

					fixObjectLabel.setVisible( true );
					fixObjectTextBox.setVisible( true );

				} else if ( repairByListBox.getSelectedIndex() == 2 ) {
					fixPredicateLabel.setVisible( true );
					fixPredicateTextBox.setVisible( true );

					fixObjectLabel.setVisible( true );
					fixObjectTextBox.setVisible( true );

				} else if ( repairByListBox.getSelectedIndex() == 4 ) {
					fixObjectLabel.setVisible( true );
					fixObjectTextBox.setVisible( true );
					fixObjectTextBox.getRegexCheckBox().setValue( true );
				}
			}

		} );
		return row2;
	}

	private FlowPanel makeRepairPanel() {
		FlowPanel row1 = new FlowPanel();
		row1.addStyleName( "dtListGridRow" );
		HorizontalPanel repairHPanel = new HorizontalPanel();
		repairHPanel.add( selectLabel );
		selectLabel.addStyleName( "gridRowColumn" );
		selectLabel.addStyleName( "gridRowColumn0" );
		row1.add( selectLabel );

		VerticalPanel subjectVerticalPanel = new VerticalPanel();
		row1.add( selectSubjectLabel );
		selectSubjectLabel.addStyleName( "gridRowColumn" );
		selectSubjectLabel.addStyleName( "gridRowColumn1" );
		row1.add( selectSubjectTextBox );
		selectSubjectTextBox.addStyleName( "gridRowColumn" );
		selectSubjectTextBox.addStyleName( "gridRowColumn2" );

		// flexTable.add( subjectVerticalPanel );

		VerticalPanel predicateVerticalPanel = new VerticalPanel();
		row1.add( selectPredicateLabel );
		selectPredicateLabel.addStyleName( "gridRowColumn" );
		selectPredicateLabel.addStyleName( "gridRowColumn3" );
		row1.add( selectPredicateTextBox );
		selectPredicateTextBox.addStyleName( "gridRowColumn" );
		selectPredicateTextBox.addStyleName( "gridRowColumn4" );
		// flexTable.add( predicateVerticalPanel );

		VerticalPanel objectVerticalPanel = new VerticalPanel();
		row1.add( selectObjectLabel );
		row1.add( selectObjectTextBox );
		selectObjectLabel.addStyleName( "gridRowColumn" );
		selectObjectLabel.addStyleName( "gridRowColumn5" );

		selectObjectTextBox.addStyleName( "gridRowColumn" );
		selectObjectTextBox.addStyleName( "gridRowColumn6" );
		// row1.add( objectVerticalPanel );
		return row1;
	}

	private void makeRPCallToGetResource() throws ClientSideRepositoryException {

		if ( selectObjectTextBox.getRegexCheckBox().getValue() ) {
			DataManagmentManager.getInstance().getDataManagmentService().getResourcesToRepairByRegex( EIURI.create( selectSubjectTextBox.getTextBox().getText().trim() ), EIURI.create( selectPredicateTextBox.getTextBox().getText().trim() ),
					selectObjectTextBox.getTextBox().getText().trim(), new RootAsyncCallback<List<EIInstanceMinimal>>() {
						public void onSuccess(List<EIInstanceMinimal> result) {
							InstanceListToRepair = result;
							ApplicationState.getInstance().setMode( Mode.list );
							EIResourcesGrid grid = new EIResourcesGrid( result );

							DataManagment.showData( grid );
							AbstractEntryPoint.hideGlasspane();
						}
					} );
		} else {
			DataManagmentManager.getInstance().getDataManagmentService().getResourcesToRepair( EIURI.create( selectSubjectTextBox.getTextBox().getText().trim() ), EIURI.create( selectPredicateTextBox.getTextBox().getText().trim() ),
					selectObjectTextBox.getTextBox().getText().trim(), selectObjectTextBox.getLiteralCheckBox().getValue(), new RootAsyncCallback<List<EIInstanceMinimal>>() {
						public void onSuccess(List<EIInstanceMinimal> result) {
							InstanceListToRepair = result;
							ApplicationState.getInstance().setMode( Mode.list );
							EIResourcesGrid grid = new EIResourcesGrid( result );

							DataManagment.showData( grid );
							AbstractEntryPoint.hideGlasspane();
						}
					} );
		}

	}

	private void makeRPCCalltoReplaceObject() {
		try {
			DataManagmentManager.getInstance().getDataManagmentService().replaceObject( EIURI.create( selectSubjectTextBox.getTextBox().getText().trim() ), EIURI.create( selectPredicateTextBox.getTextBox().getText().trim() ),
					selectObjectTextBox.getTextBox().getText().trim(), fixObjectTextBox.getTextBox().getText().trim(), selectObjectTextBox.getLiteralCheckBox().getValue(), callback );
		} catch (ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}

	}

	private void makeRPCCalltoReplacePredicate() {
		try {
			DataManagmentManager.getInstance().getDataManagmentService().replacePredicate( EIURI.create( selectSubjectTextBox.getTextBox().getText().trim() ), EIURI.create( selectPredicateTextBox.getTextBox().getText().trim() ),
					EIURI.create( fixPredicateTextBox.getText().trim() ), selectObjectTextBox.getTextBox().getText(), selectObjectTextBox.getLiteralCheckBox().getValue(), callback );
		} catch (ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}
	}

	private void makeRPCCalltoReplaceObjectByRegex() {
		try {
			DataManagmentManager.getInstance().getDataManagmentService().replaceObjectByRegex( EIURI.create( selectSubjectTextBox.getTextBox().getText().trim() ), EIURI.create( selectPredicateTextBox.getTextBox().getText().trim() ),
					selectObjectTextBox.getTextBox().getText().trim(), fixObjectTextBox.getTextBox().getText().trim(), callback );
		} catch (ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}

	}

	private void makeRPCCalltoDelete() {
		try {
			DataManagmentManager.getInstance().getDataManagmentService().deleteTriple( EIURI.create( selectSubjectTextBox.getTextBox().getText().trim() ), EIURI.create( selectPredicateTextBox.getTextBox().getText().trim() ),
					selectObjectTextBox.getTextBox().getText().trim(), fixObjectTextBox.getLiteralCheckBox().getValue(), callback );
		} catch (ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}
	}

	private void makeRPCCalltoReplaceObjectAndPredicate() {
		try {
			DataManagmentManager.getInstance().getDataManagmentService().replaceObjectAndPredicate( EIURI.create( selectSubjectTextBox.getTextBox().getText().trim() ), EIURI.create( selectPredicateTextBox.getTextBox().getText().trim() ),
					EIURI.create( fixPredicateTextBox.getText().trim() ), selectObjectTextBox.getTextBox().getText().trim(), fixObjectTextBox.getTextBox().getText().trim(), selectObjectTextBox.getLiteralCheckBox().getValue(), callback );
		} catch (ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}
	}

	private List<EIURI> getListEIURIFromInstanceMinimalList() {
		final List<EIURI> lstEIURI = new ArrayList<EIURI>();
		for (EIInstanceMinimal instanceMinimal : InstanceListToRepair) {
			lstEIURI.add( instanceMinimal.getInstanceURI() );
		}
		return lstEIURI;
	}

	/* (non-Javadoc)
	 * @see org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.SessionListener#onLogIn(java.lang.String, java.lang.String)
	 */
	@Override
	public void onLogIn(String username, String userUri) {
		AbstractEntryPoint.hideGlasspane();
		popupPanel.hide();
		
	}

	/* (non-Javadoc)
	 * @see org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.SessionListener#onLogOut(boolean)
	 */
	@Override
	public void onLogOut(boolean isSessionExpired) {
		//popupPanel.clear();
		
		popupPanel = new EIPopup();

		popupPanel.add( new LoginLogoutPanel() );
		popupPanel.setPopupPosition( 500, 300 );
		popupPanel.show();
		
	}

}
