/**s
 * 
 */
package org.eaglei.datatools.datamanagment.server;

import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.client.rpc.DataManagmentService;
import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.jena.DataManagmentProvider;
import org.eaglei.datatools.server.AbstractRemoteServiceServlet;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.BulkCurationQueryBuilder;
import org.eaglei.model.jena.QueryBuilder;
import org.eaglei.model.jena.QueryBuilder.RDFobjectType;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
public class DataManagmentServlet extends AbstractRemoteServiceServlet implements DataManagmentService {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static final Log log = LogFactory.getLog( DataManagmentServlet.class );
	private QueryBuilder queryBuilder;
	private DataManagmentProvider dataManagmentProvider;

	@Override
	public void init() {
		super.init();
		queryBuilder = BulkCurationQueryBuilder.getInstance();
		dataManagmentProvider = new DataManagmentProvider( this.jenaInstanceFactory, this.generalSecurityProvider );
	}
	
	@Override
	public List<EIInstanceMinimal> getResourcesToRepair(EIURI subjectURI, EIURI predicateURI, String objectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
		try {

			String query = queryBuilder.diagnoseQuery( subjectURI, predicateURI, objectString, getObjectTypeByBoolean( isObjectLiteral ) );
			return repoProvider.EIQuery( getRepositorySession(), query );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public List<EIInstanceMinimal> getResourcesToRepairByRegex(EIURI typeURI, EIURI predicateURI, String regex) throws ClientSideRepositoryException {
		try {

			String query = queryBuilder.diagnoseQueryByRegex( typeURI, predicateURI, regex );
			return repoProvider.EIQuery( getRepositorySession(), query );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}

	}

	private Session getRepositorySession() {
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		User userObj = (User)httpSession.getAttribute( "user" );
		Session session = userObj.getSession();
		return session;
	}

	@Override
	public Integer replaceObject(EIURI typeURI, EIURI predicateURI, String oldObjectString, String newObjectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
		try {
			int count = 0;
			Session session = getRepositorySession();
			String addNewObjectquery = queryBuilder.getQueryToAddObject( typeURI, predicateURI, oldObjectString, newObjectString, getObjectTypeByBoolean( isObjectLiteral ) );
			String deleteOldObjectquery = queryBuilder.getQueryToDelteTriple( typeURI, predicateURI, oldObjectString, getObjectTypeByBoolean( isObjectLiteral ) );
			dataManagmentProvider.replaceResource( session, addNewObjectquery, deleteOldObjectquery );
			return new Integer( count );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public Integer replacePredicate(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String objectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
		try {
			int count = 0;
			Session session = getRepositorySession();
			String addNewPredicatequery = queryBuilder.getQueryToAddPredicate( typeURI, oldPredicateURI, newPredicateURI, objectString, getObjectTypeByBoolean( isObjectLiteral ) );
			String deleteOldObjectquery = queryBuilder.getQueryToDelteTriple( typeURI, oldPredicateURI, objectString, getObjectTypeByBoolean( isObjectLiteral ) );
			dataManagmentProvider.replaceResource( session, addNewPredicatequery, deleteOldObjectquery );
			return new Integer( count );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public Integer replaceObjectAndPredicate(EIURI typeURI, EIURI oldPredicateURI, EIURI newPredicateURI, String oldObjectString, String newObjectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
		try {
			int count = 0;
			Session session = getRepositorySession();
			String addNewObjectAndPredicatequery = queryBuilder.getQueryToAddPredicateAndObject( typeURI, oldPredicateURI, newPredicateURI, oldObjectString, newObjectString, getObjectTypeByBoolean( isObjectLiteral ) );
			String deleteOldObjectquery = queryBuilder.getQueryToDelteTriple( typeURI, oldPredicateURI, oldObjectString, getObjectTypeByBoolean( isObjectLiteral ) );
			dataManagmentProvider.replaceResource( session, addNewObjectAndPredicatequery, deleteOldObjectquery );
			return new Integer( count );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	@Override
	public Integer replaceObjectByRegex(EIURI typeURI, EIURI predicateURI, String regex, String replaceRegex) throws ClientSideRepositoryException {
		try {
			int count = 0;
			Session session = getRepositorySession();
			String constructQryByRegex = queryBuilder.getConstructQueryByRegex( typeURI, predicateURI, regex );
			dataManagmentProvider.replaceResourceByRegex( session, constructQryByRegex, regex, replaceRegex );
			return new Integer( 0 );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}

	}

	@Override
	public Integer deleteTriple(EIURI typeURI, EIURI predicateURI, String oldObjectString, Boolean isObjectLiteral) throws ClientSideRepositoryException {
		try {
			int count = 0;
			Session session = getRepositorySession();
			String deletequery = queryBuilder.getQueryToDelteTriple( typeURI, predicateURI, oldObjectString, getObjectTypeByBoolean( isObjectLiteral ) );
			dataManagmentProvider.deleteTriple( session, deletequery );
			return new Integer( count );
		} catch (RepositoryProviderException e) {
			throw new ClientSideRepositoryException( e, e.getExceptionType() );
		}
	}

	private RDFobjectType getObjectTypeByBoolean(Boolean isObjectLiteral) {
		if ( isObjectLiteral ) {
			return RDFobjectType.objectIsLiteral;
		} else {
			return RDFobjectType.objectIsResource;
		}
	}

	/* (non-Javadoc)
	 * @see org.eaglei.datatools.client.rpc.DataManagmentService#switchServer(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public Session switchServer(String nodeName, String userName, String password) {
		return null;
	}
}
