/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.datamanagment.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.config.DatatoolsConfiguration;

public class DataManagmentConfiguration
extends DatatoolsConfiguration {
    DatatoolsConfiguration.Props props;
    private static final String DEFAULT_CONFIGURATION = "datatools.prop";
    private static final Log logger = LogFactory.getLog(DataManagmentConfiguration.class);

    public DataManagmentConfiguration() {
        URL configURL = this.getClass().getClassLoader().getResource(DEFAULT_CONFIGURATION);
        try {
            if (configURL == null) {
                logger.error((Object)"Could not locate datatools.prop on classpath");
                throw new FileNotFoundException("Could not locate datatools.prop on classpath");
            }
            File configFile = new File(configURL.toURI());
            logger.debug((Object)("loading configuration file: " + configFile));
            this.config.load(new FileReader(configFile));
        }
        catch (IOException fne) {
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error loading configuration from datatools.prop " + e));
            throw new RuntimeException(e);
        }
    }

    public String getNodeRepositoryURL(String node) {
        return this.config.getProperty(DatatoolsConfiguration.Props.RepositoryNetworkURL.propKey.replace("datatools", node));
    }

    public String getNodeRepositoryURI(String node) {
        return this.config.getProperty(DatatoolsConfiguration.Props.RepositoryNetworkURI.propKey.replace("datatools", node));
    }

    public String[] getNodes() {
        String[] nodes = this.config.getProperty("eagle-i.nodes").split("#");
        return nodes;
    }
}

