/**
 * 
 */
package org.eaglei.datatools.datamanagment.client;



import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author "Sravan Cheriyala" Started Mar 29, 2011
 */
public class RDFTextPanel extends FlowPanel {
	@UiField
	 TextBox textBox;
	@UiField
	 CheckBox allCheckBox;
	

	private static RDFTextPanelUiBinder uiBinder = GWT.create( RDFTextPanelUiBinder.class );

	public interface RDFTextPanelUiBinder extends UiBinder<Widget, RDFTextPanel> {
	}

	public RDFTextPanel() {
		add( uiBinder.createAndBindUi( this ) );
		disableTextBoxWhenAllSelected();
	}

	public TextBox getTextBox() {
		return textBox;
	}

	public CheckBox getAllCheckBox() {
		return allCheckBox;
	}

	public void disableTextBoxWhenAllSelected()
	{
		allCheckBox.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				textBox.setEnabled( !allCheckBox.getValue() );
			}
		} );
	}
	
}
