/**
 * 
 */
package org.eaglei.datatools.datamanagment.client;

import java.util.List;

import org.eaglei.datatools.User;
import org.eaglei.datatools.client.AbstractEntryPoint;
import org.eaglei.datatools.client.ApplicationState;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.DataManagmentServiceFactory;
import org.eaglei.datatools.client.rpc.RootAsyncCallback;
import org.eaglei.datatools.client.status.ClientSideRepositoryException;
import org.eaglei.datatools.client.ui.LoginLogoutPanel;
import org.eaglei.datatools.client.ui.widgets.EIPopup;
import org.eaglei.datatools.jena.BulkCurationTriple;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.RepositoryProviderException.RepositoryProviderExceptionType;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author "Sravan Cheriyala" Started Mar 17, 2011
 */
public class RepairPanel extends FlowPanel implements ClientRepositoryToolsManager.SessionListener {
	private static final GWTLogger log = GWTLogger.getLogger( "RepairPanel" );

	private static RepairPanelUiBinder uiBinder = GWT.create( RepairPanelUiBinder.class );

	interface RepairPanelUiBinder extends UiBinder<Widget, RepairPanel> {
	}

	@UiField
	protected RDFTextPanel selectTypeTextBox;
	@UiField
	protected RDFTextPanel selectPredicateTextBox;
	@UiField
	protected RDFObjectTextPanel selectObjectTextBox;
	@UiField
	protected ListBox repairByListBox;
	@UiField
	protected ListBox serverListBox;
	@UiField
	protected Label fixObjectLabel;
	@UiField
	protected RDFObjectTextPanel fixObjectTextBox;
	@UiField
	protected Label fixPredicateLabel;
	@UiField
	protected RDFTextPanel fixPredicateTextBox;
	@UiField
	protected Button diagnoseButton;
	@UiField
	protected Button startRepairButton;

	// private List<EIInstanceMinimal> InstanceListToRepair;

	private static final int CHANGE_PREDICATE = 0;
	private static final int CHANGE_OBJECT = 1;
	private static final int CHANGE_BOTH = 2;
	private static final int CHANGE_REGEX = 3;
	private static final int ADD_TRIPLE = 4;
	private static final int DELTE_TRIPLE = 5;
	private boolean isServerChanged = false;

	private final RootAsyncCallback<Integer> callback;
	EIPopup popupPanel;

	public RepairPanel() {
		add( uiBinder.createAndBindUi( this ) );
		ClientRepositoryToolsManager.INSTANCE.addSessionListener( this );
		popupPanel = new EIPopup();

		// flexTable.addStyleName( "dtListGridRow" );

		setUpFixPanel();

		serverListBox.addItem( "Select Institution" );
		serverListBox.addItem( "harvard" );
		serverListBox.addItem( "upr" );
		serverListBox.addItem( "msm" );
		serverListBox.addItem( "jsu" );
		serverListBox.addItem( "montana" );
		serverListBox.addItem( "ohsu" );
		serverListBox.addItem( "dartmouth" );
		serverListBox.addItem( "hawaii" );
		serverListBox.addItem( "alaska" );

		makeDiagnoseButtonEventHandler();
		makeRepairButtonEventHandler();
		addServerListBoxEventHandler();

		callback = new RootAsyncCallback<Integer>() {
			@Override
			public void onSuccess(final Integer result) {
				Window.alert( "instance repaired sucessfully" );
				AbstractEntryPoint.hideGlasspane();
			}
		};

	}

	private void addServerListBoxEventHandler() {
		serverListBox.addChangeHandler( new ChangeHandler() {

			@Override
			public void onChange(final ChangeEvent event) {
				//first is just a 'select server' label 
				if(serverListBox.getSelectedIndex()==0)
				{
					return;
				}
				isServerChanged = true;
				
				
				makeRPCCalltoSwitchServer( serverListBox.getValue( serverListBox.getSelectedIndex() ) );
			}

		} );
	}

	private void makeDiagnoseButtonEventHandler() {
		diagnoseButton.addClickHandler( new ClickHandler() {
			@Override
			public void onClick(final ClickEvent event) {
				if(serverListBox.getSelectedIndex()==0)
				{
					Window.alert( "Institution is not selected" );
					return;
				}
				
				AbstractEntryPoint.showGlasspane();
				try {
					makeRPCCallToGetResources();
				} catch (final ClientSideRepositoryException e) {
					Window.alert( e.getLocalizedMessage() );
					AbstractEntryPoint.hideGlasspane();
				}
			}
		} );
	}

	private void makeRepairButtonEventHandler() {

		startRepairButton.addClickHandler( new ClickHandler() {

			@Override
			public void onClick(final ClickEvent event) {
				if ( repairByListBox.getSelectedIndex() == CHANGE_PREDICATE ) {
					makeRPCCalltoReplacePredicate();
				} else if ( repairByListBox.getSelectedIndex() == CHANGE_OBJECT ) {
					makeRPCCalltoReplaceObject();
				} else if ( repairByListBox.getSelectedIndex() == CHANGE_BOTH ) {
					makeRPCCalltoReplaceObjectAndPredicate();
				} else if ( repairByListBox.getSelectedIndex() == CHANGE_REGEX ) {
					makeRPCCalltoReplaceObjectByRegex();
				} else if ( repairByListBox.getSelectedIndex() == DELTE_TRIPLE ) {
					makeRPCCalltoDelete();
				} else if ( repairByListBox.getSelectedIndex() == ADD_TRIPLE ) {
					makeRPCCalltoAdd();
				}

				AbstractEntryPoint.showGlasspane();

			}

		} );
	}

	private void setUpFixPanel() {

		repairByListBox.addItem( "changing predicate:" );
		repairByListBox.addItem( "changing object:" );
		repairByListBox.addItem( "changing both" );
		repairByListBox.addItem( "using regular expresions" );
		repairByListBox.addItem( "adding triple" );
		repairByListBox.addItem( "deleting the triple" );

		// flexTable.add( fixObjectVerticalPanel );
		// flexTable.add( fixPredicateVerticalPanel );
		fixPredicateLabel.setVisible( false );
		fixPredicateTextBox.setVisible( false );

		fixObjectLabel.setVisible( false );
		fixObjectTextBox.setVisible( false );

		repairByListBox.addChangeHandler( new ChangeHandler() {
			@Override
			public void onChange(final ChangeEvent event) {
				fixPredicateLabel.setVisible( false );
				fixPredicateTextBox.setVisible( false );

				fixObjectLabel.setVisible( false );
				fixObjectTextBox.setVisible( false );

				if ( repairByListBox.getSelectedIndex() == CHANGE_PREDICATE ) {

					fixPredicateLabel.setVisible( true );
					fixPredicateTextBox.setVisible( true );

				} else if ( repairByListBox.getSelectedIndex() == CHANGE_OBJECT ) {

					fixObjectLabel.setVisible( true );
					fixObjectTextBox.setVisible( true );

				} else if ( repairByListBox.getSelectedIndex() == CHANGE_BOTH || repairByListBox.getSelectedIndex() == ADD_TRIPLE ) {
					fixPredicateLabel.setVisible( true );
					fixPredicateTextBox.setVisible( true );

					fixObjectLabel.setVisible( true );
					fixObjectTextBox.setVisible( true );

				} else if ( repairByListBox.getSelectedIndex() == CHANGE_REGEX ) {
					fixObjectLabel.setVisible( true );
					fixObjectTextBox.setVisible( true );
				}

			}

		} );

	}

	// Type can be all; predicate can be all; object can be all for non-regex
	private void makeRPCCallToGetResources() throws ClientSideRepositoryException {

		if ( selectObjectTextBox.getRegexCheckBox().getValue() ) {

			DataManagmentServiceFactory
					.getInstance()
					.getDataManagmentService()
					.getResourcesToRepairByRegex( DatatoolsCookies.getSession(), checkIfAllSelectedAndgetParam( selectTypeTextBox ), checkIfAllSelectedAndgetParam( selectPredicateTextBox ), getStringFromPanel( selectObjectTextBox ),
							new RootAsyncCallback<List<BulkCurationTriple>>() {
								@Override
								public void onSuccess(final List<BulkCurationTriple> result) {
									final DataManagementGrid grid = new DataManagementGrid( result );

									DataManagment.showData( grid );
									AbstractEntryPoint.hideGlasspane();
								}
							} );
		} else {
			DataManagmentServiceFactory
					.getInstance()
					.getDataManagmentService()
					.getResourcesToRepair( DatatoolsCookies.getSession(), checkIfAllSelectedAndgetParam( selectTypeTextBox ), checkIfAllSelectedAndgetParam( selectPredicateTextBox ), checkIfAllSelectedAndgetParamForObject( selectObjectTextBox ),
							selectObjectTextBox.getLiteralCheckBox().getValue(), new RootAsyncCallback<List<BulkCurationTriple>>() {
								@Override
								public void onSuccess(final List<BulkCurationTriple> result) {
									final DataManagementGrid grid = new DataManagementGrid( result );
									DataManagment.showData( grid );
									AbstractEntryPoint.hideGlasspane();
								}
							} );
		}

	}

	// Type can be all; predicate can be all; object is specified
	private void makeRPCCalltoReplaceObject() {
		try {
			DataManagmentServiceFactory
					.getInstance()
					.getDataManagmentService()
					.replaceObject( DatatoolsCookies.getSession(), checkIfAllSelectedAndgetParam( selectTypeTextBox ), checkIfAllSelectedAndgetParam( selectPredicateTextBox ), getStringFromPanel( selectObjectTextBox ),
							selectObjectTextBox.getLiteralCheckBox().getValue(), getStringFromPanel( fixObjectTextBox ), fixObjectTextBox.getLiteralCheckBox().getValue(), callback );
		} catch (final ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}

	}

	// Type can be all; predicate is specified; object can be all
	private void makeRPCCalltoReplacePredicate() {
		try {
			DataManagmentServiceFactory
					.getInstance()
					.getDataManagmentService()
					.replacePredicate( DatatoolsCookies.getSession(), checkIfAllSelectedAndgetParam( selectTypeTextBox ), getEIURIFromPanel( selectPredicateTextBox ), EIURI.create( fixPredicateTextBox.getTextBox().getText().trim() ),
							checkIfAllSelectedAndgetParamForObject( selectObjectTextBox ), selectObjectTextBox.getLiteralCheckBox().getValue(), callback );
		} catch (final ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}
	}

	// Type can be all; predicate can be all; object is a regex
	private void makeRPCCalltoReplaceObjectByRegex() {
		try {

			DataManagmentServiceFactory
					.getInstance()
					.getDataManagmentService()
					.replaceObjectByRegex( DatatoolsCookies.getSession(), checkIfAllSelectedAndgetParam( selectTypeTextBox ), checkIfAllSelectedAndgetParam( selectPredicateTextBox ), getStringFromPanel( selectObjectTextBox ),
							getStringFromPanel( fixObjectTextBox ), callback );
		} catch (final ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}
	}

	// Type can be all; predicate can be all; object can be all
	// FIXME yikes this is dangerous! how can we limit?

	private void makeRPCCalltoDelete() {
		try {
			DataManagmentServiceFactory
					.getInstance()
					.getDataManagmentService()
					.deleteTriple( DatatoolsCookies.getSession(), checkIfAllSelectedAndgetParam( selectTypeTextBox ), checkIfAllSelectedAndgetParam( selectPredicateTextBox ), checkIfAllSelectedAndgetParamForObject( selectObjectTextBox ),
							selectObjectTextBox.getLiteralCheckBox().getValue(), callback );
		} catch (final ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}
	}

	//
	private void makeRPCCalltoAdd() {
		try {
			DataManagmentServiceFactory
					.getInstance()
					.getDataManagmentService()
					.addTriple( DatatoolsCookies.getSession(), checkIfAllSelectedAndgetParam( selectTypeTextBox ), getEIURIFromPanel( selectPredicateTextBox ), EIURI.create( fixPredicateTextBox.getTextBox().getText().trim() ),
							getStringFromPanel( selectObjectTextBox ), selectObjectTextBox.getLiteralCheckBox().getValue(), getStringFromPanel( fixObjectTextBox ), fixObjectTextBox.getLiteralCheckBox().getValue(), callback );
		} catch (final ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}
	}

	// Type can be all; predicate and object have to be specific
	private void makeRPCCalltoReplaceObjectAndPredicate() {
		try {
			DataManagmentServiceFactory
					.getInstance()
					.getDataManagmentService()
					.replaceObjectAndPredicate( DatatoolsCookies.getSession(), checkIfAllSelectedAndgetParam( selectTypeTextBox ), getEIURIFromPanel( selectPredicateTextBox ), EIURI.create( fixPredicateTextBox.getTextBox().getText().trim() ),
							getStringFromPanel( selectObjectTextBox ), selectObjectTextBox.getLiteralCheckBox().getValue(), getStringFromPanel( fixObjectTextBox ), fixObjectTextBox.getLiteralCheckBox().getValue(), callback );
		} catch (final ClientSideRepositoryException cle) {
			AbstractEntryPoint.hideGlasspane();
			Window.alert( cle.getLocalizedMessage() );
		}
	}

	private void makeRPCCalltoSwitchServer(final String nodeName) {

		DataManagmentServiceFactory.getInstance().getDataManagmentAuthService().switchServer( nodeName, new RootAsyncCallback<User>() {
			@Override
			public void onSuccess(final User result) {
				AbstractEntryPoint.showGlasspane();
				ClientRepositoryToolsManager.INSTANCE.handleSucessfullLogin( result.getUserName(), result );
				AbstractEntryPoint.hideGlasspane();
			}

			@Override
			public void onFailure(Throwable caught) {
				if ( caught instanceof ClientSideRepositoryException ) {
					ClientSideRepositoryException clientException = (ClientSideRepositoryException)caught;
					handleInvalidSession( clientException );
				} else {
					super.onFailure( caught );
				}

			}

			private void handleInvalidSession(ClientSideRepositoryException clientException) {
				if ( isInvalidSessionException( clientException ) ) {
					logoutAndShowLoginBox();
				}
			}

		} );
	}

	private boolean isInvalidSessionException(ClientSideRepositoryException clientException) {
		return clientException.getExceptionType() == RepositoryProviderExceptionType.INVALID_SESSION;
	}

	private void logoutAndShowLoginBox() {
		AbstractEntryPoint.showGlasspane();
		ClientRepositoryToolsManager.INSTANCE.logOut();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.SessionListener#onLogIn(java.lang.String, java.lang.String)
	 */
	@Override
	public void onLogIn(final String username, final String userUri) {
		AbstractEntryPoint.hideGlasspane();
		popupPanel.hide();
		
		

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.SessionListener#onLogOut(boolean)
	 */
	@Override
	public void onLogOut(final boolean isSessionExpired) {
		// popupPanel.clear();
		if ( isServerChanged ) {
			popupPanel = new EIPopup();
			popupPanel.add( new LoginLogoutPanel() );
			popupPanel.setPopupPosition( 500, 300 );
			popupPanel.show();
			isServerChanged=false;
		}

	}

	// EIURI.NULL_EIURI means all
	private EIURI checkIfAllSelectedAndgetParam(final RDFTextPanel panel) {
		if ( panel.getAllCheckBox().getValue() ) {
			return EIURI.NULL_EIURI;
		} else {
			return getEIURIFromPanel( panel );
		}
	}

	// FIXME this might go away; right now it has to be a string because the calls for resource and literal are combined
	// null means all
	private String checkIfAllSelectedAndgetParamForObject(final RDFTextPanel panel) {
		if ( panel.getAllCheckBox().getValue() ) {
			return null;
		} else {
			return panel.getTextBox().getText().trim();
		}
	}

	private EIURI getEIURIFromPanel(final RDFTextPanel panel) {
		return EIURI.create( panel.getTextBox().getText().trim() );
	}

	private String getStringFromPanel(final RDFTextPanel panel) {
		return panel.getTextBox().getText().trim();
	}

}
