/**
 * 
 */
package org.eaglei.datatools.datamanagment.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.config.DatatoolsConfiguration;

/**
 * @author "Sravan Cheriyala" Started Mar 30, 2011
 */
public class DataManagmentConfiguration extends DatatoolsConfiguration {
	Props props;
	private static final String DEFAULT_CONFIGURATION = "datatools.prop";
	private static final Log logger = LogFactory.getLog( DataManagmentConfiguration.class );

	public DataManagmentConfiguration() {
		final URL configURL = this.getClass().getClassLoader().getResource( DEFAULT_CONFIGURATION );

		try {
			if ( configURL == null ) {
				logger.error( "Could not locate " + DEFAULT_CONFIGURATION + " on classpath" );
				throw new FileNotFoundException( "Could not locate " + DEFAULT_CONFIGURATION + " on classpath" );
			}
			File configFile = new File( configURL.toURI() );
			logger.debug( "loading configuration file: " + configFile );
			config.load( new FileReader( configFile ) );
		} catch (IOException fne) {

		} catch (URISyntaxException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RuntimeException e) {
			logger.error( "Error loading configuration from " + DEFAULT_CONFIGURATION + " " + e );
			throw new RuntimeException( e );
		}
	}

	public String getNodeRepositoryURL(String node) {
		return config.getProperty( props.RepositoryNetworkURL.propKey.replace( "datatools", node ) );
	}

	public String getNodeRepositoryURI(String node) {
		return config.getProperty( props.RepositoryNetworkURI.propKey.replace( "datatools", node ) );
	}
	
	public String[] getNodes(){
		String[] nodes =config.getProperty( "eagle-i.nodes" ).split( "#" );
		return nodes;
	}

}
