<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
<%--
   -  "Portal" (or frame-content) page to submit feedback to a JIRA
   -  instance.
   -
   -  @author Carsten Schulz
   -  Started Mar 2011, @version $Id: $
  --%>
<%@ page import="java.util.Collection" %>
<%@ page import="java.util.Collections" %>
<%@ page import="java.util.List" %>
<%@ page import="org.eaglei.feedback.FeedbackBean" %>

<jsp:useBean id = "fbean" class="org.eaglei.feedback.FeedbackBean" scope="page" />
<jsp:setProperty name="fbean" property="*"/> 

<%--
    Logger log = LogManager.getLogger("org.eaglei.feedback.ui.feedback.jsp");
--%>
<%
	String submit = request.getParameter("submit");
	String currentURL = "";
	String ticketID = "";
	boolean isFine = false;
	boolean isPosted = false;
	
	if (request.getParameter("currenturl") != null)
	{
		currentURL = request.getParameter("currenturl");
		currentURL = currentURL.replaceAll("ui:pound","#");
		currentURL = currentURL.replaceAll("ui:question","?");
		currentURL = currentURL.replaceAll("ui:and","&");
	}
    // present the form, with existing values filled in
    
    if (submit == null) {
        // execute the requested changes
    	System.out.println("\tsubmit: " + "null");
    } else {
    	System.out.println("\tsubmit: " + submit);
    }
    
    String method = request.getMethod();
    if (method == null) {
        // execute the requested changes
    	System.out.println("\tmethod: " + "null");
    } else {
    	System.out.println("\tmethod: " + method);
    	if (method.equals("POST")){
			isPosted = true;
     		isFine = fbean.createIssue();
			ticketID = fbean.getIssueKey();
     	}
    }
%>

  <head>
    <title>Eagle-I submit feedback</title>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <style>
    <!--
	body {
		font: 13px/1.231 arial,helvetica,clean,sans-serif;
	}
	h2 {
		font-size:14px;
	}
	.textfield {
		width:270px;
		height:20px;
		padding:5px;
	}
	
	.select {
		width:282px;
		height:30px;
		padding:5px;
	}
	
	.textBox {
		width:340px;
		height:170px;
		padding:5px;
	}
	
	.red {
		color:#990000;
		font-weight:bold;
	}
	-->
    </style>
  </head><body>
  
<%--	<form method="POST" action="feedback.jsp" accept-charset="<%= acceptCharset %>"> --%>
<%
	if (isFine)
	{
		isFine = false;
		isPosted = false;
%>
Thank you for helping us with your feedback, your issue has been submitted.  If you have any questions, your reference ID is <%= ticketID %>.
<script language="javascript">
	parent.currentURL = parent.location.href;
</script>
<%
	}else
	{
		String currentName = fbean.getName();
		String currentEmail = fbean.getEmail();
		String currentPhone = fbean.getPhone();
		String currentInstitution = fbean.getInstitution();
		String currentSubject = fbean.getSummary();
		String currentComments = fbean.getDescription();
		String currentQuestion = fbean.getQuestion();
		
		if (currentName == null)
		{
			currentName = "";
		}
		
		if (currentEmail == null)
		{
			currentEmail = "";
		}
		
		if (currentPhone == null)
		{
			currentPhone = "";
		}
%>
		<form method="POST" action="feedback.jsp" name="feedback" >
        <table width="850" border="0" cellspacing="5" cellpadding="0">
  <tr>
    <td colspan="4" align="left" valign="top">We appreciate your interest in the eagle-i search application.  Please use the form below to submit a question, comment or other feedback.  The Resource Navigator at your institution will contact you within 2 business days.<br />
<br />
If you are looking for general information about the eagle-i Network or eagle-i Consortium, please visit <a href="http://www.eagle-i.org" target="_blank">www.eagle-i.org</a>. </td>
    </tr>
  <tr>
    <td colspan="4" align="left" valign="top">
<%
	if (isPosted)
	{
%>
	<span class="red">There was a problem with your feedback form.  Please try submitting again.</span>
    <%
	}
%>
<!--    <br /><br /><%= currentURL %>--></td>
    </tr>
  <tr>
    <td width="21%" align="left" valign="top"><strong>Name: <span class="red">*</span></strong></td>
    <td width="34%" align="left" valign="top"><input type="text" name="name" size="80" class="textfield" value="<%= currentName %>" /></td>
    <td width="3%" rowspan="7" align="left" valign="top">&nbsp;</td>
    <td width="42%" align="left" valign="top"><strong>Comments: <span class="red">*</span></strong></td>
  </tr>
  <tr>
    <td width="21%" align="left" valign="top"><strong>Email Address: <span class="red">*</span></strong></td>
    <td width="34%" align="left" valign="top"><input type="text" name="email" size="80" class="textfield" value="<%= currentEmail %>" /></td>
    <td width="42%" rowspan="6" align="left" valign="top"><textarea name="description" cols="40" rows="25" class="textBox"><%= currentComments %></textarea></td>
    </tr>
  <tr>
    <td width="21%" align="left" valign="top"><strong>Phone:</strong></td>
    <td width="34%" align="left" valign="top"><input type="text" name="phone" size="80" class="textfield" value="<%= currentPhone %>" /></td>
    </tr>
  <tr>
    <td width="21%" align="left" valign="top"><strong>Institution: <span class="red">*</span></strong></td>
    <td width="34%" align="left" valign="top"><select name="institution" class="select">
      <%-- TODO: get list from bean --%>
      <%-- <jsp:getProperty name="fbean" property="institution" /> --%>
      <option value="">Select your Institution</option>
      <option selected="selected" value="10220">University of Alaska </option>
      <option value="10221">Dartmouth College </option>
      <option value="10222">Harvard University </option>
      <option value="10224">Jackson State University </option>
      <option value="10226">Morehouse School of Medicine </option>
      <option value="10225">Montana State University </option>
      <option value="10227">Oregon Health and Science University </option>
      <option value="10223">University of Hawaii at Manoa </option>
    </select></td>
    </tr>
  <tr>
    <td colspan="2" align="left" valign="top"></td>
    </tr>
  <tr>
    <td width="21%" align="left" valign="top"><strong>Subject: <span class="red">*</span></strong></td>
    <td width="34%" align="left" valign="top"><input type="text" name="summary" size="80" class="textfield" value="<%= currentSubject %>" /></td>
    </tr>
  <tr>
    <td width="21%" align="left" valign="top"><strong>I have a question or feedback about: <br />
(select one)</strong></td>
    <td width="34%" align="left" valign="top"><select name="question" class="select">
      <option value="" selected="selected">Select a question</option>
      <option value="The eagle-i Consortium">The eagle-i Consortium</option>
      <option value="Using the eagle-i search application">Using the eagle-i search application</option>
      <option value="Reporting a bug">Reporting a bug</option>
      <option value="Requesting a new feature">Requesting a new feature</option>
      <option value="Entering resources into the eagle-i web application">Entering resources into the eagle-i web application</option>
      <option value="Incorrect, missing or out-of-date information">Incorrect, missing or out-of-date information</option>
      <option value="A topic not listed here">A topic not listed here</option>
    </select></td>
    </tr>
  <tr>
    <td class="red">* Required</td>
    <td align="right">&nbsp;</td>
    <td align="right">&nbsp;</td>
    <td align="right">
      <input name="url" type="hidden" value="<%= currentURL %>" />
      <input name="agent" type="hidden" value="" />
      <button name="submit" value="submit" type="submit">Submit</button></td>
    </tr>
</table>

	 </form>
<script language="javascript">

	for (var i=0;i<document.feedback.institution.length;i++)
	{
		if (document.feedback.institution[i].value == "<%= currentInstitution %>")
			document.feedback.institution[i].selected = true;
	}

	for (var i=0;i<document.feedback.question.length;i++)
	{
		if (document.feedback.question[i].value == "<%= currentQuestion %>")
			document.feedback.question[i].selected = true;
	}
	
	document.feedback.agent.value = navigator.userAgent;
	

</script>
<%
	}
%>
  </body>
</html>
