package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EISubClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EISuperClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.PropertyCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstancesCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.IdCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.NewInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.SharedClassChooser;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * This is a utility class for creating form and form fields
 * 
 * @author pp101
 * 
 */
public class FormUtils extends VerticalPanel {
	public static String								formName			= "";
	public static EIURI									subType				= null;
	public static String								dialogFormName		= "";
	public static EIURI									dialogSubType;
	private static boolean								isView;
	public static boolean								isDialog;
	public static SharedClassChooser<OntologyDropdown>	classChooser;
	public static List<TextBox>							dataList			= new ArrayList<TextBox>();
	public static List<ListBox>							objList				= new ArrayList<ListBox>();
	public static Map<EIEntity, Set<String>>			nonOntLiteralList	= new HashMap<EIEntity, Set<String>>();
	public static Map<EIEntity, Set<EIURI>>				nonOntResourceList	= new HashMap<EIEntity, Set<EIURI>>();
	public static List<TextBox>							dataListDialog		= new ArrayList<TextBox>();
	public static List<ListBox>							objListDialog		= new ArrayList<ListBox>();
	final static VerticalPanel							formFieldsPanel		= new VerticalPanel();
	final static VerticalPanel							dialogFieldsPanel	= new VerticalPanel();
	public static boolean								isPhoneValid		= true;
	public static boolean								isEmailValid		= true;
	/**
	 * Creates a Text field from the given entity value is passed when the
	 * formType is 'edit'
	 * 
	 * @param entity
	 * @param value
	 */
	public static VerticalPanel createTextField(final EIEntity entity, final Set<String> values, final String propertyLabel, boolean isPresent) {
		final VerticalPanel vPanel = new VerticalPanel();
		final HorizontalPanel hPanel = new HorizontalPanel();
		vPanel.add(hPanel);
		Label label = new Label(propertyLabel);
		final Label errLabel = new Label();
		errLabel.setStyleName("errorMsg");
		label.setStyleName("formLabel");
		hPanel.add(label);
		if (values != null) {
			int item = 0;
			for (final String value : values) {
				final HorizontalPanel hp = new HorizontalPanel();
				Label l = new Label("");
				l.setStyleName("formLabel");
				final TextBox textBox = new TextBox();
				textBox.setStyleName("formText");
				textBox.setValue(formatText(value));
				textBox.setName(entity.getURI() + "|" + entity.getLabel());
				if (isDialog)
					dataListDialog.add(textBox);
				else
					dataList.add(textBox);
				if (propertyLabel.equalsIgnoreCase("phone number")) {
					addPhoneValidations(propertyLabel, errLabel, textBox);
				} else if (propertyLabel.equalsIgnoreCase("email")) {
					addEmailValidations(propertyLabel, errLabel, textBox);
				}
				if (item > 0) {
					hp.add(l);
					hp.add(textBox);
					Label deleteField = new Label("-");
					hp.add(deleteField);
					deleteField.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent arg0) {
							vPanel.remove(hp);
							dataList.remove(textBox);
						}
					});
					vPanel.add(hp);
				} else {
					// Widget to add more fields for a particular type
					Label addField = new Label("+");
					addField.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent arg0) {
							VerticalPanel vtemp = createTextField(entity, values, "", true);
							HorizontalPanel hptem = (HorizontalPanel) vtemp.getWidget(0);
							final Label temperrLabel = new Label();
							temperrLabel.setStyleName("errorMsg");
							hptem.add(temperrLabel);
							TextBox txttemp = (TextBox) hptem.getWidget(1);
							if (propertyLabel.equalsIgnoreCase("phone number")) {
								addPhoneValidations(propertyLabel, temperrLabel, txttemp);
							} else if (propertyLabel.equalsIgnoreCase("email")) {
								addEmailValidations(propertyLabel, temperrLabel, txttemp);
							}
							vPanel.add(vtemp);
							vPanel.setStyleName("formFieldGroup");
						}
					});
					hPanel.add(textBox);
					hPanel.add(addField);
					hPanel.add(errLabel);
				}
				item++;
			}
		} else {
			final TextBox textBox = new TextBox();
			textBox.setStyleName("formText");
			hPanel.add(textBox);
			hPanel.add(errLabel);
			boolean isValid = true;
			textBox.addValueChangeHandler(new ValueChangeHandler<String>() {
				@Override
				public void onValueChange(ValueChangeEvent<String> event) {
					textBox.setValue(formatText(event.getValue()));
					textBox.setName(entity.getURI() + "|" + entity.getLabel());
					dataList.add(textBox);
					if (isDialog)
						dataListDialog.add(textBox);
					else
						dataList.add(textBox);
				}
			});
			if (propertyLabel.equalsIgnoreCase("phone number")) {
				// if errLabel contains text, the validation failed
				if (!addPhoneValidations(propertyLabel, errLabel, textBox).getText().equals("")) {
					isValid = false;
				}
			} else if (propertyLabel.equalsIgnoreCase("email")) {
				if (!addEmailValidations(propertyLabel, errLabel, textBox).getText().equals("") || !isValid) {
					isValid = false;
				}
			}
			// Only if validation from previous fields succeeds
			if (isValid && !isPresent) {
				// Widget to add more fields for a particular type
				if (!propertyLabel.equals("Term request")) {
					Label addField = new Label("+");
					hPanel.add(addField);
					addField.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent arg0) {
							vPanel.setStyleName("formFieldGroup");
							VerticalPanel vtemp = createTextField(entity, values, "", true);
							HorizontalPanel hptem = (HorizontalPanel) vtemp.getWidget(0);
							final Label temperrLabel = new Label();
							temperrLabel.setStyleName("errorMsg");
							hptem.add(temperrLabel);
							TextBox txttemp = (TextBox) hptem.getWidget(1);
							if (propertyLabel.equalsIgnoreCase("phone number")) {
								addPhoneValidations(propertyLabel, temperrLabel, txttemp);
							} else if (propertyLabel.equalsIgnoreCase("email")) {
								addEmailValidations(propertyLabel, temperrLabel, txttemp);
							}
							vPanel.add(vtemp);
						}
					});
				}
			} else {
				Label deleteField = new Label("-");
				if (!propertyLabel.equals("Term request")) {
					hPanel.add(deleteField);
					deleteField.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent arg0) {
							vPanel.remove(hPanel);
							if (isDialog)
								dataListDialog.remove(textBox);
							else
								dataList.remove(textBox);
						}
					});
				}
			}
		}
		return vPanel;
	}
	private static Label addPhoneValidations(String propertyLabel, final Label errLabel, TextBox textBox) {
		textBox.addKeyUpHandler(new KeyUpHandler() {
			@Override
			public void onKeyUp(KeyUpEvent event) {
				TextBox txtFeild = (TextBox) event.getSource();
				if (!Validations.OnlyNumbersAllowed(txtFeild.getValue())) {
					errLabel.setText("Only numbers are allowed in this feild");
					txtFeild.setText(txtFeild.getText().replace(txtFeild.getText().toCharArray()[txtFeild.getText().length() - 1] + "", ""));
					isPhoneValid = false;
				} else {
					errLabel.setText("");
					isPhoneValid = true;
				}
			}
		});
		return errLabel;
	}
	private static Label addEmailValidations(String propertyLabel, final Label errLabel, TextBox textBox) {
		textBox.addBlurHandler(new BlurHandler() {
			@Override
			public void onBlur(BlurEvent event) {
				TextBox txtFeild = (TextBox) event.getSource();
				if (!Validations.IsEmailBox(txtFeild.getValue())) {
					errLabel.setText("Only emails are allowed");
					isEmailValid = false;
				} else {
					errLabel.setText("");
					isEmailValid = true;
				}
			}
		});
		return errLabel;
	}
	public static VerticalPanel createLabelforView(final EIEntity entity, final Set<String> values, String propertyLabel, boolean isPresent) {
		final VerticalPanel vPanel = new VerticalPanel();
		final HorizontalPanel hPanel = new HorizontalPanel();
		vPanel.add(hPanel);
		Label label = new Label(propertyLabel);
		label.setStyleName("formLabel");
		int item = 0;
		if (values != null) {
			hPanel.add(label);
			for (final String value : values) {
				final HorizontalPanel hp = new HorizontalPanel();
				Label l = new Label("");
				l.setStyleName("formLabel");
				Anchor resourceURL = null; // For values that have external URIs
				Label valueField = new Label();
				valueField.setStyleName("formLabelValue");
				if (value.startsWith("www") || value.startsWith("http")) {
					resourceURL = new Anchor(formatText(value), formatText(value), "_blank");
				} else
					valueField.setText(formatText(value));
				if (item > 0) {
					hp.add(l);
					hp.add(resourceURL == null ? valueField : resourceURL);
					vPanel.add(hp);
				} else {
					hPanel.add(resourceURL == null ? valueField : resourceURL);
				}
				item++;
			}
		} else {
			hPanel.add(new Label(""));
		}
		return vPanel;
	}
	/**
	 * Creates a RadioButton
	 * 
	 * @param lbl
	 * @param uri
	 */
	public static HorizontalPanel createRadioButon(final EIEntity entity, String value) {
		HorizontalPanel hPanel = new HorizontalPanel();
		Label label = new Label(entity.getLabel());
		label.setStyleName("formLabel");
		CheckBox checkBox = new CheckBox();
		hPanel.add(label);
		hPanel.add(checkBox);
		return hPanel;
	}
	/**
	 * Every form will have ' ' & 'Sub-Type' fields even though they are not
	 * defined in the ontology When the user selects an item from the Sub-type
	 * drop down, the properties displayed on the form will change depending
	 * upon the class of the selected item
	 * 
	 * @param EIClass
	 */
	public static VerticalPanel displayDefaultFields(final EIClass eClass, final String nameValue, final String eagleIURI, EIURI subTypeUri, final boolean isTypeView) {
		final VerticalPanel vPanel = new VerticalPanel();
		HorizontalPanel namepanel = new HorizontalPanel();
		if (!nameValue.equals(""))
			formName = nameValue;
		isView = isTypeView;
		TextBox name = new TextBox();
		name.setStyleName("formText");
		name.setValue(nameValue);
		if (isView) {
			name.setEnabled(false);
		}
		Label lb = new Label("Resource Name");
		lb.setStyleName("formLabel");
		Label required = new Label("*");
		required.setStyleName("fieldRequired");
		namepanel.add(required);
		namepanel.add(lb);
		namepanel.add(name);
		
		vPanel.add(namepanel);
		name.addValueChangeHandler(new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> arg0) {
				if (isDialog)
					dialogFormName = arg0.getValue();
				else
					formName = arg0.getValue();
			}
		}); 
		if (subTypeUri != null) {
			try {
				ClientOntologyToolsManager.INSTANCE.getEIClass(subTypeUri, new EIClassCallback() {
					@Override
					public void onFailure(String result) {
						// TODO Auto-generated method stub
					}
					@Override
					public void onSuccess(EIClass result) {
						vPanel.add(createTermWidget(eClass, result, null,null));
					}
				});
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else
			vPanel.add(createTermWidget(eClass, null, null,null));
		return vPanel;
	}
	/**
	 * This method deals with an Object type property. Data in the drop down
	 * list is populated based on whether or not the property class is an
	 * eagle-i resource
	 * 
	 * @param range
	 * @param propertyEntity
	 * @param propertyValue
	 * @return
	 */
	public static VerticalPanel handleObjectProperty(final List<EIClass> rangeList, final EIEntity propertyEntity, final Set<EIURI> propertyValues) {
		
		//TODO -- Refactor this method.  
		
		final VerticalPanel vPanel = new VerticalPanel();
		if (propertyValues != null) { // For Edit/View Form
			if(rangeList.size() == 1) {
				if(isView){
					final List<EIURI> list = new ArrayList<EIURI>();
					list.addAll(propertyValues);
					for (final EIURI uri:list) {
						ClientRepositoryToolsManager.INSTANCE.retrieveLabel(uri, new ResultsCallback(){
							@Override
							public void onSuccess(String[] arg0) {
								// TODO Auto-generated method stub
								
							}
							@Override
							public void onSuccess(String arg0) {
								String propLabel;
								if (list.indexOf(uri) > 0) {
									propLabel = "";
								} else
									propLabel = propertyEntity.getLabel();
								HorizontalPanel hPanel = new HorizontalPanel();
								Label label = new Label(propLabel);
								label.setStyleName("formLabel");
								hPanel.add(label);
								Anchor a = new Anchor(arg0,uri.toString(),"_blank");
								hPanel.add(a);
								vPanel.add(hPanel);
							}
							@Override
							public void loginRequired() {
								// TODO Auto-generated method stub
							}
						});
					}
				} else { //Edit 
					if (rangeList.get(0).isEagleIResource()) {
						final List<EIURI> list = new ArrayList<EIURI>();
						list.addAll(propertyValues);
						for (final EIURI uri:list) {
							try {
								ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new EIInstanceCallback() {
									@Override
									public void onSuccess(final EIInstance eiInstance) {
										ClientOntologyToolsManager.INSTANCE.getEIClass(eiInstance.getInstanceType().getURI(), new EIClassCallback() {
											@Override
											public void onSuccess(EIClass result) {
												String propLabel;
												if (list.indexOf(uri) > 0) {
													propLabel = "";
												} else
													propLabel = propertyEntity.getLabel();
												vPanel.add(createWidgetForEIResource(result, propertyEntity, eiInstance.getInstanceLabel(), propLabel));
											}
											@Override
											public void onFailure(String result) {
												// TODO Auto-generated method stub
											}
										});
									}
									@Override
									public void loginRequired() {
										// TODO Auto-generated method stub
									}
								});
							} catch (Exception e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					} else { //Not an Eagle-i resource
						final EIURI uriArray[] = (EIURI[]) propertyValues.toArray(new EIURI[0]);
						final List<EIURI> list = new ArrayList<EIURI>();
						list.addAll(propertyValues);
						for (final EIURI uri:list) {
							ClientOntologyToolsManager.INSTANCE.getEIClass(uri, new EIClassCallback() {
								@Override
								public void onSuccess(final EIClass eClass) { 
									String propLabel;
									if (list.indexOf(uri) > 0) {
										propLabel = "";
									} else
										propLabel = propertyEntity.getLabel();
									vPanel.add(createTermWidget(rangeList.get(0), eClass, propertyEntity,propLabel));
								}
								@Override
								public void onFailure(String result) {
								}
							});
						}
					}
				}
			} else { //Multiple ranges
				if(isView){
					final List<EIURI> list = new ArrayList<EIURI>();
					list.addAll(propertyValues);
					for (final EIURI uri:list) {
						ClientRepositoryToolsManager.INSTANCE.retrieveLabel(uri, new ResultsCallback(){
							@Override
							public void onSuccess(String[] arg0) {
								// TODO Auto-generated method stub
								
							}
							@Override
							public void onSuccess(String arg0) {
								String propLabel;
								if (list.indexOf(uri) > 0) {
									propLabel = "";
								} else
									propLabel = propertyEntity.getLabel();
								HorizontalPanel hPanel = new HorizontalPanel();
								Label label = new Label(propLabel);
								label.setStyleName("formLabel");
								hPanel.add(label);
								Anchor a = new Anchor(arg0,uri.toString(),"_blank");
								hPanel.add(a);
								vPanel.add(hPanel);
							}
	
							@Override
							public void loginRequired() {
								// TODO Auto-generated method stub
							}
						});
					}
				} else { //Edit
					for(final EIClass range:rangeList){
						final EIURI uriArray[] = (EIURI[]) propertyValues.toArray(new EIURI[0]);
						for (int i = 0; i < uriArray.length; i++) {
							try {
								ClientRepositoryToolsManager.INSTANCE.getInstance(uriArray[i], new EIInstanceCallback(){
									@Override
									public void onSuccess(final EIInstance eiInstance) {
										if(range.getEntity().getLabel().equals(eiInstance.getInstanceType().getLabel())){
											String propLabel = propertyEntity.getLabel();
											if(rangeList.indexOf(range) > 0)
												propLabel = "";
											if(range.isEagleIResource()){
												vPanel.add(createWidgetForEIResource(range, propertyEntity, eiInstance.getInstanceLabel(),propLabel));
											} else {
												vPanel.add(createTermWidget(range, null, propertyEntity,propLabel));
											}
										} else {
											EIClass eclass = new EIClass(EIEntity.create(eiInstance.getInstanceType().getURI(), eiInstance.getInstanceType().getLabel()), true, true, true, true, true);
											if(eclass.hasSuperClass()) {
												ClientOntologyToolsManager.INSTANCE.getSuperClass(eclass, new EISuperClassCallback() {
													
													@Override
													public void onSuccess(EIClass result) { 
														String propLabel = propertyEntity.getLabel();
														if(rangeList.indexOf(range) > 0)
															propLabel = "";
														if(result.getEntity().getLabel().equals(range.getEntity().getLabel())){
															if(range.isEagleIResource()){
																vPanel.add(createWidgetForEIResource(range, propertyEntity, eiInstance.getInstanceLabel(), propLabel));
															} else {
																vPanel.add(createTermWidget(range, result, propertyEntity,propLabel));
															}
														} else { // No value (propertyValues) present for the range
															if(range.isEagleIResource())
																vPanel.add(createWidgetForEIResource(range, propertyEntity, "", propLabel));
															else
																vPanel.add(createTermWidget(range, null, propertyEntity,propLabel));
														}
													}
												});
											}
										}
									}
									@Override
									public void loginRequired() {
										// TODO Auto-generated method stub
										
									}
								});
							} catch (Exception e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					}
				}
			}
		} else { // For New form
			if (rangeList.size() == 1) {
				if (rangeList.get(0).isEagleIResource()) {
					vPanel.add(createWidgetForEIResource(rangeList.get(0), propertyEntity, "", propertyEntity.getLabel()));
				} else {
					vPanel.add(createTermWidget(rangeList.get(0), null, propertyEntity,null));
				}
			} else {
				VerticalPanel vp = new VerticalPanel();
				String label = "";
				for (EIClass range : rangeList) {
					if (rangeList.indexOf(range) == 0)
						label = propertyEntity.getLabel();
					else
						label = ""; 
					if(range.isEagleIResource())
						vp.add(createWidgetForEIResource(range, propertyEntity, "", label));
					else
						vp.add(createTermWidget(range, null, propertyEntity,label));
				}
				vPanel.add(vp);
			}
		}
		
		return vPanel;
	}
	/**
	 * Gets the class properties and displays appropriate UI field based on the
	 * property type
	 * 
	 * @param eClass
	 * @param VerticalPanel
	 *            - if this is the main formPanel pass null, if it is a 'create
	 *            new' term widget panel, pass the panel
	 * @return
	 */
	public static VerticalPanel displayFormFields(final EIClass eClass, final EIInstance instance, boolean isTypeView) {
		isView = isTypeView;
		final Map<EIEntity, Set<String>> dataTypeProperties = instance == null ? null : instance.getDatatypeProperties();
		final Map<EIEntity, Set<EIURI>> objectTypeProperties = instance == null ? null : instance.getObjectProperties();
		if (isDialog)
			dialogFieldsPanel.clear();
		else
			formFieldsPanel.clear();
		final VerticalPanel vp = new VerticalPanel();
		DeferredCommand.addCommand(new Command() {
			@Override
			public void execute() {
				ClientOntologyToolsManager.INSTANCE.getProperties(eClass, new PropertyCallback() {
					@Override
					public void onSuccess(EIClass result) {
						List<EIProperty> propList = result.getProperties();
						boolean hasRangeAsLab = false;
						for (final EIProperty property : propList) {
							if (property instanceof EIDatatypeProperty) {
								if (((EIDatatypeProperty) property).getTypeLabel().equals("boolean")) {
									if (!isView)
										vp.add(createRadioButon(property.getEntity(), ""));
									else {
										// Window.alert(property.get)
									}
								} else {
									Set<String> values = null;
									if (dataTypeProperties != null && dataTypeProperties.containsKey(property.getEntity())) {
										values = dataTypeProperties.get(property.getEntity() 	);
									}
									if (!isView)
										vp.add(createTextField(property.getEntity(), values, property.getEntity().getLabel(), false));
									else
										vp.add(createLabelforView(property.getEntity(), values, property.getEntity().getLabel(), false));
								}
							} else if (property instanceof EIObjectProperty) {
								if ("laboratory".equalsIgnoreCase(((EIObjectProperty) property).getRange().getEntity().getLabel()) || "core laboratory".equalsIgnoreCase(((EIObjectProperty) property).getRange().getEntity().getLabel())) {
									hasRangeAsLab = true;
								}
								Set<EIURI> values = null;
								if (objectTypeProperties != null && objectTypeProperties.containsKey(property.getEntity())) {
									values = objectTypeProperties.get(property.getEntity());
								}
								List<EIClass> rL = ((EIObjectProperty) property).getRangeList();
								vp.add(handleObjectProperty(((EIObjectProperty) property).getRangeList(), property.getEntity(), values));
							}
						}
						// add hard-coded datatype properties
						/*
						 * Label = Comments property =
						 * http://www.w3.org/2000/01/rdf-schema#comments Label =
						 * Curator's comments property =
						 * http://purl.obolibrary.org/obo/IAO_0000232
						 */
						Log.info("about to make comments entities");
						EIEntity comments = EIEntity.create(WorkFlowConstants.COMMENTS, "Comment");
						EIEntity curatorComments = EIEntity.create(WorkFlowConstants.CURATOR_NOTE, "Curator note");
						if (!isView) {
							final Map<EIEntity,Set<String>> nonOntologyLiteralProp = instance!=null?instance.getNonOntologyLiteralProperties():null;
							if(instance!=null) {
								//nonOntologyLiteralProp = instance.getNonOntologyLiteralProperties();
								
								Log.info("about to add comments fields");
								Set<String> commentsStr = null; 
								Set<String> curatorCommentsStr = null;
								if(nonOntologyLiteralProp != null)
									for(final EIEntity entity:nonOntologyLiteralProp.keySet()){ 
										if(entity.getLabel().equalsIgnoreCase("comment")) {
											commentsStr = nonOntologyLiteralProp.get(entity);
										} else if(entity.getURI().toString().equals(WorkFlowConstants.CURATOR_NOTE)) {
											curatorCommentsStr = nonOntologyLiteralProp.get(entity);
										}
									}
								vp.add(createTextArea(comments, commentsStr));
								vp.add(createTextArea(curatorComments, curatorCommentsStr));
							} else {
								Set<String> values = null;
								vp.add(createTextArea(comments, values));
								vp.add(createTextArea(curatorComments, values));
							}
						}
						if (!"laboratory".equalsIgnoreCase(eClass.getEntity().getLabel()) && !"core laboratory".equalsIgnoreCase(eClass.getEntity().getLabel()) && !hasRangeAsLab && !FormsPanel.labUri.equals("")) {
							final HorizontalPanel hp = new HorizontalPanel();
							final Label labName = new Label("has Lab");
							labName.setStyleName("formLabel");
							final ListBox lb = new ListBox();
							lb.setName("http://purl.obolibrary.org/obo/ERO_0000001|has Lab");
							try {
								ClientRepositoryToolsManager.INSTANCE.getInstance(EIURI.create(FormsPanel.labUri), new EIInstanceCallback() {
									@Override
									public void loginRequired() {
									}
									@Override
									public void onSuccess(EIInstance eiInstance) {
										lb.addItem(eiInstance.getInstanceLabel(), eiInstance.getInstanceURI().toString());
										lb.setEnabled(false);
										hp.add(labName);
										hp.add(lb);
										vp.add(hp);
										objList.add(lb);
									}
								});
							} catch (Exception e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}
					}

					/**
					 * Creates a text area for adding Comments & Curators Comments
					 * @param entity
					 * @param values
					 * @return
					 */
					private HorizontalPanel createTextArea(final EIEntity entity,final Set<String> values) {
						HorizontalPanel hp = new HorizontalPanel();
						final Label lbl = new Label(entity.getLabel());
						lbl.setStyleName("formLabel");
						if(entity.getURI().toString().equals(WorkFlowConstants.CURATOR_NOTE)) {
							ClientRepositoryToolsManager.INSTANCE.retrieveLabel(entity.getURI(), new ResultsCallback(){
								@Override
								public void onSuccess(String[] arg0) {
									// TODO Auto-generated method stub
									
								}
								@Override
								public void onSuccess(String arg0) {
									lbl.setText(arg0);
								}
								@Override
								public void loginRequired() {
									// TODO Auto-generated method stub
								}
							});
						}
						
						final TextArea ta = new TextArea();  
						if(values!=null) { 
							for(String value:values){ 
								ta.setText(value);
							}
						}
						
						ta.addValueChangeHandler(new ValueChangeHandler<String>() {
							@Override
							public void onValueChange(ValueChangeEvent<String> event) {
								if(values==null) { // For New form
									TextBox tb = new TextBox(); 
									tb.setValue(event.getValue());
									tb.setName(entity.getURI() + "|" + entity.getLabel());
									dataList.add(tb);
									if (isDialog)
										dataListDialog.add(tb);
									else
										dataList.add(tb);
								} else { //For edit form
									Set<String> values = nonOntLiteralList.get(entity);
									values.clear();
									values.add(event.getValue());
								}
							}
						});
						hp.add(lbl); 
						hp.add(ta);
						return hp;
					}
				});
			}
		});
		if (isDialog) {
			dialogFieldsPanel.add(vp);
			return dialogFieldsPanel;
		} else {
			formFieldsPanel.add(vp);
			return formFieldsPanel;
		}
	}
	/**
	 * Displays the properties that are removed from the new Ontology but still
	 * have some values associated
	 * 
	 * @param instance
	 * @return
	 */
	public static DisclosurePanel displayNonOntologyProperties(final EIInstance instance) {
		DisclosurePanel mainPanel = new DisclosurePanel("Information for data curators");
		final VerticalPanel metaPanel = new VerticalPanel();
		final VerticalPanel otherPanel = new VerticalPanel();
		final VerticalPanel vp = new VerticalPanel();
		HorizontalPanel h = new HorizontalPanel();
		h.setStyleName("formPanel"); 
		Label uriLabel = new Label("eagle-i unique ID");
		uriLabel.setStyleName("formLabel");
		Anchor id = new Anchor(instance.getInstanceURI().toString(),instance.getInstanceURI().toString(),"_blank");
		h.add(uriLabel);
		h.add(id);
		vp.add(h);
		vp.add(metaPanel);
		vp.add(otherPanel);
		
		metaPanel.setStyleName("formPanel");
		otherPanel.setStyleName("formPanel");
		nonOntLiteralList = instance == null ? null : instance.getNonOntologyLiteralProperties();
		nonOntResourceList = instance == null ? null : instance.getNonOntologyResourceProperties();
		
		if(isView){
			Label metaProps = new Label("Metadata properties:");
			metaProps.setStyleName("nonOntologyPropertyLabel");
			metaPanel.add(metaProps);
			for(final EIEntity entity : instance.getReadOnlyLiteralProperties().keySet()) {
				final Set<String> set = new HashSet<String>(); 
				set.add(instance.getReadOnlyLiteralProperties().get(entity));
				ClientRepositoryToolsManager.INSTANCE.retrieveLabel(instance.getReadOnlyResourceProperties().get(entity), new ResultsCallback(){
					@Override
					public void onSuccess(String[] arg0) {
						// TODO Auto-generated method stub
					}
					@Override
					public void onSuccess(String arg0) {
						if(arg0.equals(""))
							arg0 = entity.getLabel();
						metaPanel.add(createLabelforView(entity, set, arg0, false));
					}
					@Override
					public void loginRequired() {
						// TODO Auto-generated method stub
					}
					
				});
				
			}
			
			for (final EIEntity entity : instance.getReadOnlyResourceProperties().keySet()) {
				final HorizontalPanel hp = new HorizontalPanel();
				final Label l = new Label(entity.getLabel());
				l.setStyleName("formLabel");
				
				ClientRepositoryToolsManager.INSTANCE.retrieveLabel(instance.getReadOnlyResourceProperties().get(entity), new ResultsCallback(){
					@Override
					public void onSuccess(String[] arg0) {
					}
					@Override
					public void onSuccess(String arg0) {
						if(arg0.equals(""))
							arg0 = entity.getLabel();
						Anchor val = new Anchor(arg0, instance.getReadOnlyResourceProperties().get(entity).toString(), "_blank");
						hp.add(l);
						hp.add(val);
						metaPanel.add(hp);
					}
					@Override
					public void loginRequired() {
					}
				});
			}

			
			DeferredCommand.addCommand(new Command() {
				@Override
				public void execute() {
					Label otherProps = new Label("Other properties:");
					otherProps.setStyleName("nonOntologyPropertyLabel");
					otherPanel.add(otherProps);
					for(final EIEntity entity : nonOntLiteralList.keySet()) {  
						if(!instance.getReadOnlyLiteralProperties().containsKey(entity)) {
							ClientRepositoryToolsManager.INSTANCE.retrieveLabel(entity.getURI(), new ResultsCallback(){
								@Override
								public void onSuccess(String[] arg0) {
								}
								@Override
								public void onSuccess(String arg0) { 
									if(arg0.equals(""))
										arg0 = entity.getLabel();	
									otherPanel.add(createLabelforView(entity, nonOntLiteralList.get(entity), arg0, false));
								}
								@Override
								public void loginRequired() {
									// TODO Auto-generated method stub
									
								}
							});
						}
					}
							
					for (final EIEntity entity : nonOntResourceList.keySet()) {
						if(!instance.getReadOnlyResourceProperties().containsKey(entity)) {
							Set<EIURI> uriList = nonOntResourceList.get(entity);
							final HorizontalPanel hp = new HorizontalPanel();
							for(final EIURI uri:uriList) { 
								ClientRepositoryToolsManager.INSTANCE.retrieveLabel(uri, new ResultsCallback(){

									@Override
									public void onSuccess(String[] arg0) {
										
									}
									@Override
									public void onSuccess(String arg0) { 
										Label l = new Label(entity.getLabel());
										l.setStyleName("formLabel");
										if(arg0.equals(""))
											arg0 = entity.getLabel();
										Anchor val = new Anchor(arg0, uri.toString(), "_blank");
										hp.add(l);
										hp.add(val);
									}
									@Override
									public void loginRequired() {
										// TODO Auto-generated method stub
										
									}
								});
							}
							otherPanel.add(hp);
						}
					}
					
				}
			});
			
		} else {
			for(final EIEntity entity : nonOntLiteralList.keySet()) {
				if(!instance.getReadOnlyLiteralProperties().containsKey(entity) && (!entity.getURI().toString().equals(WorkFlowConstants.COMMENTS) && !entity.getURI().toString().equals(WorkFlowConstants.CURATOR_NOTE) )) {
					HorizontalPanel hp = new HorizontalPanel(); 
					Label lbl = new Label(entity.getLabel());
					lbl.setStyleName("formLabel");
					TextBox t = new TextBox();
					t.setStyleName("formText");
					Set<String> values = nonOntLiteralList.get(entity);
					if (values != null) {
						String value = values.iterator().next();
						t.setValue(value);
					}
					t.addValueChangeHandler(new ValueChangeHandler<String>() {
						@Override
						public void onValueChange(ValueChangeEvent<String> arg0) {
							Set<String> set = nonOntLiteralList.get(entity);
							set.clear();
							set.add(arg0.getValue());
						}
					});
					hp.add(lbl);
					hp.add(t);
					otherPanel.add(hp);
				}
			}
			
			for (final EIEntity entity : nonOntResourceList.keySet()) {
				if(!instance.getReadOnlyResourceProperties().containsKey(entity)) {
					for (EIURI uri : nonOntResourceList.get(entity)) {
						final HorizontalPanel hp = new HorizontalPanel();
						final Label l = new Label(entity.getLabel());
						l.setStyleName("formLabel");
						TextBox t = new TextBox();
						t.setStyleName("formText");
						t.setValue(uri.toString());
						hp.add(l);
						hp.add(t);
						t.addValueChangeHandler(new ValueChangeHandler<String>() {
							@Override
							public void onValueChange(ValueChangeEvent<String> arg0) {
								Set<EIURI> set = nonOntResourceList.get(entity);
								set.clear();
								set.add(EIURI.create(arg0.getValue()));
							}
						});
						otherPanel.add(hp);
					}
				}
			}
		}
	
		mainPanel.add(vp);
		return mainPanel;
	}
	/**
	 * Creates a Term widget that displays the subclasses in a hierarchical form
	 * in a drop down list
	 * 
	 * @param rangeURI
	 * @param propertyEntity
	 * @return
	 */
	
	// Check for Resource URI and sub-type uri. If same no superclass
	
	public static VerticalPanel createTermWidget(final EIClass range, final EIClass selectedClass, final EIEntity propertyEntity, String label) {
		final HorizontalPanel hPanel = new HorizontalPanel();
		final VerticalPanel vPanel = new VerticalPanel();
		Label pLabel = new Label();
		final ListBox lb = new ListBox();
		if (propertyEntity != null) {
			if(label==null)
				pLabel.setText(propertyEntity.getLabel());
			else 
				pLabel.setText(label);
			lb.setName(propertyEntity.getURI() + "|" + propertyEntity.getLabel());
		} else
			// Special case for Sub-type field
			pLabel.setText("Type");
		pLabel.setStyleName("formLabel");
		classChooser = new SharedClassChooser<OntologyDropdown>(new OntologyDropdown());
		classChooser.setTextBoxStyle("formText");
		
		if (!isView) {
			hPanel.add(pLabel);
			if (!isDialog && propertyEntity == null){
				if(selectedClass!=null)
					subType = selectedClass.getEntity().getURI();
				else
					subType = range.getEntity().getURI();
			}
			
			classChooser.setClass(range, false);
			// If the value is not selected from the term widget list, set the default value to parent type
			if (propertyEntity != null) { // Not for sub-types
				if (selectedClass != null) {
					classChooser.setSelectedEntity(selectedClass.getEntity());
					lb.addItem(selectedClass.getEntity().getURI().toString());
					objList.add(lb);
				} else {
					lb.addItem(range.getEntity().getURI().toString());
					objList.add(lb);
				}
			} else if (selectedClass != null) // For Subtype field in new form
				classChooser.setSelectedEntity(selectedClass.getEntity());
			hPanel.add(classChooser);
		} else {
			if (selectedClass != null) {
				hPanel.add(pLabel);
				classChooser.setClass(selectedClass, false); 
				hPanel.add(classChooser);
			}
			classChooser.setEnabled(false);
		}
		classChooser.addSelectionListener(new EntitySelectionListener() {
			@Override
			public void onSelection(EIEntity selectedEntity) {
				if (!isView) {
					if (propertyEntity != null) {
						if (lb.getItemCount() > 0)
							lb.removeItem(0);
						lb.addItem(selectedEntity.getURI().toString());
						objList.add(lb);
					} else {
						if (isDialog)
							dialogFieldsPanel.clear();
						else
							formFieldsPanel.clear();
						if (!isDialog)
							subType = selectedEntity.getURI();
						else
							dialogSubType = selectedEntity.getURI();
						ClientOntologyToolsManager.INSTANCE.getEIClass(selectedEntity.getURI(), new EIClassCallback() {
							@Override
							public void onFailure(String result) {
								// TODO Auto-generated method stub
							}
							@Override
							public void onSuccess(EIClass result) {
								displayFormFields(result, FormsPanel.eiInstance, false);
							}
						});
					}
				}
			}
		});
		EIEntity termRequestEntity = EIEntity.create("http://eagle-i.org/ont/datatools/1.0/has_term_request", "has term request");
		if (!isView) {
			hPanel.add(createTextField(termRequestEntity, null, "Term request", false));
			
			if(propertyEntity!=null) {
				Label addNew = new Label("+");
				addNew.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent arg0) {
						vPanel.setStyleName("formFieldGroup");
						vPanel.add(createTermWidget(range, selectedClass, propertyEntity, ""));
					}
				});
				
				Label removeItem = new Label("-");
				removeItem.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent arg0) {
						vPanel.remove(hPanel);
						if (isDialog)
							objListDialog.remove(lb);
						else
							objList.remove(lb);
					}
				});
				if(label.equals(""))
					hPanel.add(removeItem);
				else
					hPanel.add(addNew);
			}
		}
		vPanel.add(hPanel);
		return vPanel;
	}
	/**
	 * If the property class is an eagle-i resource, then this method is called
	 * to craete a drop down list populated with data obtained by querying the
	 * instances
	 * 
	 * @param rangeURI
	 * @param propertyEntity
	 * @param propertyValue
	 * @return
	 */
	private static VerticalPanel createWidgetForEIResource(final EIClass range, final EIEntity propertyEntity, final String propertyValue, final String propLabel) {
		final HorizontalPanel hPanel = new HorizontalPanel();
		final VerticalPanel vp = new VerticalPanel();
		final ListBox subClassList = new ListBox();
		subClassList.addItem("<select>", null);
		subClassList.setWidth("70");
		final Label lbl = new Label(propLabel);
		lbl.setStyleName("formLabel");
		final TextBox valueBox = new TextBox();
		valueBox.setStyleName("formText");
		if ("".equals(propertyValue)) {
			valueBox.setStyleName("textSuggest");
			valueBox.setValue(range.getEntity().getLabel());
		} else
			valueBox.setValue(propertyValue);
		final Label addField = new Label("+");
		addField.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				vp.setStyleName("formFieldGroup");
				HorizontalPanel hp = new HorizontalPanel();
				hp.add(createWidgetForEIResource(range, propertyEntity, propertyValue, ""));
				vp.add(hp);
			}
		});
		valueBox.addValueChangeHandler(new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> arg0) {
				boolean itemFound = false;
				for (int i = 0; i < subClassList.getItemCount(); i++) {
					if (arg0.getValue().equals(subClassList.getItemText(i))) {
						itemFound = true;
						break;
					}
				}
				if (!itemFound) {
					Window.alert(WorkFlowConstants.NOT_IN_LIST);
					valueBox.setFocus(true);
				}
			}
		});
		subClassList.setName(propertyEntity.getURI() + "|" + propertyEntity.getLabel());
		if (isDialog)
			objListDialog.add(subClassList);
		else
			objList.add(subClassList);
		subClassList.addChangeHandler(new ChangeHandler() {
			@Override
			public void onChange(ChangeEvent arg0) {
				if (subClassList.getItemText(subClassList.getSelectedIndex()) == "<select>") {
					Window.alert(WorkFlowConstants.INVALID_VALUE + propertyEntity.getLabel());
				}
				valueBox.setValue(subClassList.getItemText(subClassList.getSelectedIndex()));
			}
		});
		ClientRepositoryToolsManager.INSTANCE.getResourcesOfClass(MainPanel.userUri, range.getEntity().getURI(), new EIInstancesCallback() {
			public void onSuccess(final List<EIInstance> result) {
				/*
				 * if (result.size() == 0) { subClassList.clear(); }
				 */
				for (EIInstance instance : result) {
					String instanceLabel = instance.getEntity().getLabel();
					if ((range.getEntity().getLabel().equalsIgnoreCase("laboratory") || range.getEntity().getLabel().equalsIgnoreCase("core laboratory")) && FormsPanel.labUri.equals(instance.getInstanceURI().toString())) {
						subClassList.clear();
						subClassList.addItem(instanceLabel, instance.getInstanceURI().toString());
						subClassList.setEnabled(false);
						valueBox.setText(instanceLabel);
						valueBox.setEnabled(false);
					} else {
						subClassList.addItem(instanceLabel + " <" + instance.getInstanceType().getLabel() + ">", instance.getInstanceURI().toString());
						if (instanceLabel.equals(propertyValue))
							subClassList.setSelectedIndex(subClassList.getItemCount() - 1);
					}
				}
				hPanel.setSpacing(25);
				final Anchor link = new Anchor();
				if (!isView) {
					hPanel.add(lbl);
					hPanel.add(valueBox);
					hPanel.add(subClassList);
					hPanel.add(link);
					hPanel.add(addField);
				} else {
					if (!propertyValue.equals("")) {
						Label label = new Label(propLabel);
						label.setStyleName("formLabel");
						hPanel.add(label);
						hPanel.add(new Label(propertyValue));
					}
				}
				link.setHTML("Create new");
				link.setStyleName("formText");
				link.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent arg0) {
						createDialog(range, subClassList, valueBox);
					}
				});
			}
			@Override
			public void loginRequired() {
				handleLoginRequired();
			}
		});
		vp.add(hPanel);
		return vp;
	}
	
	/**
	 * Creates a popup window to create a new resource
	 * 
	 * @param range
	 * @param propertyValue
	 * @param subClassList
	 */
	private static void createDialog(final EIClass range, final ListBox subClassList, final TextBox textBox) {
		final HorizontalPanel hpanel = new HorizontalPanel();
		final PopupPanel window = new PopupPanel();
		final VerticalPanel vPanel = new VerticalPanel();
		final Button save = new Button("Save");
		final Button closeButton = new Button("Close");
		window.setModal(true);
		//window.setStyleName("dialogWindow");
		isDialog = true;
		ClientOntologyToolsManager.INSTANCE.getEIClass(range.getEntity().getURI(), new EIClassCallback() {
			@Override
			public void onSuccess(EIClass result) {
				Log.info("forms panel got EIClass for: " + result.getEntity().getLabel());
				vPanel.add(FormUtils.displayDefaultFields(result, "", "", null, false));
				vPanel.add(FormUtils.displayFormFields(result, FormsPanel.eiInstance, false));
				DeferredCommand.addCommand(new Command() {
					@Override
					public void execute() {
						hpanel.add(save);
						hpanel.add(closeButton);
						vPanel.add(hpanel);
					}
				});
			}
			@Override
			public void onFailure(String result) {
				// TODO Auto-generated method stub
			}
		});
		
		closeButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				window.hide();
				
			}
		});
		
		save.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				try {
					ClientRepositoryToolsManager.INSTANCE.getNewInstanceID(1, new IdCallback() {
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
						@Override
						public void onSuccess(List<EIURI> list) {
							EIURI uri = range.getEntity().getURI();
							if (FormUtils.dialogSubType != null)
								uri = FormUtils.dialogSubType;
							ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(uri, EIEntity.create(list.get(0), dialogFormName), new EIInstanceCallback() {
								@Override
								public void onSuccess(final EIInstance instance) {
									Map<EIEntity, Set<String>> dataMap = new HashMap<EIEntity, Set<String>>();
									for (TextBox tb : FormUtils.dataListDialog) {
										String name = tb.getName();
										Log.info("extracting " + name + " for save");
										EIEntity entity = EIEntity.create(name.substring(0, name.indexOf("|")), name.substring(name.indexOf("|") + 1));
										Log.info("   with entity " + entity);
										if (dataMap.containsKey(entity)) {
											Set<String> st = dataMap.get(entity);
											st.add(tb.getText());
										} else {
											Set<String> st = new HashSet<String>();
											st.add(tb.getText());
											dataMap.put(entity, st);
										}
									}
									for (EIEntity entity : dataMap.keySet()) {
										for (String value : dataMap.get(entity)) {
											instance.addDatattypePropertyToInstance(entity, value);
										}
									}
									Map<EIEntity, Set<EIURI>> objMap = new HashMap<EIEntity, Set<EIURI>>();
									for (ListBox lb : FormUtils.objListDialog) {
										String name = lb.getName();
										EIEntity entity = EIEntity.create(name.substring(0, name.indexOf("|")), name.substring(name.indexOf("|") + 1));
										if (!lb.getValue(lb.getSelectedIndex()).equals("")) {
											if (objMap.containsKey(entity)) {
												Set<EIURI> st = objMap.get(entity);
												st.add(EIURI.create(lb.getValue(lb.getSelectedIndex())));
											} else {
												Set<EIURI> st = new HashSet<EIURI>();
												st.add(EIURI.create(lb.getValue(lb.getSelectedIndex())));
												objMap.put(entity, st);
											}
										}
									}
									for (EIEntity entity : objMap.keySet()) {
										for (EIURI uri : objMap.get(entity)) {
											instance.addObjectPropertyToInstance(entity, uri);
										}
									}
									ClientRepositoryToolsManager.INSTANCE.createInstance(instance, new NewInstanceCallback() {
										@Override
										public void onSuccess(Object o) {
											isDialog = false;
											if (dialogFormName != null && dialogFormName != "") {
												subClassList.clear();
												// Populate the list with the newly added resource
												ClientRepositoryToolsManager.INSTANCE.getResourcesOfClass(MainPanel.userUri, range.getEntity().getURI(), new EIInstancesCallback() {
													public void onSuccess(List<EIInstance> result) {
														for (EIInstance instance : result) {
															String instanceLabel = instance.getEntity().getLabel();
															subClassList.addItem(instanceLabel, instance.getInstanceURI().toString());
															if (dialogFormName.equals(instanceLabel)) {
																textBox.setValue(dialogFormName);
																subClassList.setSelectedIndex(subClassList.getItemCount() - 1);
																dialogFormName = "";
															}
														}
													}
													@Override
													public void loginRequired() {
														handleLoginRequired();
													}
												});
											}
											window.hide();
										}
										@Override
										public void loginRequired() {
										}
									});
								}
								@Override
								public void loginRequired() {
									handleLoginRequired();
								}
							});
						}
					});
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
		int left = (Window.getClientWidth()) / 2;
		int top = (Window.getClientHeight()) / 3;
		window.setWidget(vPanel);
		window.setStyleName("dialogWindow");
		window.setPopupPosition(left, top);
		window.show();
		Style style = window.getElement().getStyle();
		style.clearOverflow();
	}
	private static void handleLoginRequired() {
		// TODO: what's the real behavior?
		Window.alert(WorkFlowConstants.PLEASE_LOGIN);
		// setLoggedOut();
	}
	/**
	 * @return
	 */
	private static String formatText(String value) {
		if (value.indexOf("^") > 0) {
			return value.substring(0, value.indexOf("^"));
		}
		return value;
	}
	public static boolean isFormValid() {
		if (isPhoneValid && isEmailValid) {
			return true;
		} else
			return false;
	}
}
