/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.rpc;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.InvocationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelService;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelServiceAsync;
import org.eaglei.datatools.client.ui.WorkFlowConstants;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.LoggedException;

public class ClientRepositoryToolsManager {
    public static final String DRAFT_STATE = "http://eagle-i.org/ont/repo/1.0/WFS_Draft";
    public static final String CURATION_STATE = "http://eagle-i.org/ont/repo/1.0/WFS_Curation";
    public static final String PUBLISHED_STATE = "http://eagle-i.org/ont/repo/1.0/WFS_Published";
    public static final String WITHDRAWN_STATE = "http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn";
    public static final ClientRepositoryToolsManager INSTANCE = new ClientRepositoryToolsManager();
    private static RepositoryToolsModelServiceAsync modelService;
    private final HashMap<EIURI, EIInstance> mapIdToClass = new HashMap();
    private String sessionId;
    private EIURI userURI;
    private ArrayList<SessionListener> listeners;
    private List<String> editableStates;

    private ClientRepositoryToolsManager() {
        String userUriString = DatatoolsCookies.getUserUri();
        if (userUriString != null) {
            this.userURI = EIURI.create((String)userUriString);
            Log.info((String)("got existing userUri: " + this.userURI));
        }
        this.sessionId = DatatoolsCookies.getSession();
        Log.info((String)("got session ID " + this.sessionId));
        modelService = (RepositoryToolsModelServiceAsync)GWT.create(RepositoryToolsModelService.class);
    }

    public boolean isLoggedIn() {
        return this.sessionId != null;
    }

    private void handleLogOut() {
        this.sessionId = null;
        this.userURI = null;
        Cookies.removeCookie((String)"datatools_username");
        Cookies.removeCookie((String)"datatools_userUri");
        Cookies.removeCookie((String)"datatools_session");
        Log.info((String)"removed cookies");
        if (this.listeners != null) {
            for (SessionListener listener : this.listeners) {
                listener.onLogOut();
            }
        }
    }

    public void addSessionListener(SessionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void logOut() {
        if (!this.isLoggedIn()) {
            return;
        }
        try {
            modelService.logout(this.sessionId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logIn(String username, String password, ResultsCallback callback) {
        boolean USERNAME = false;
        boolean SESSION = true;
        int USER_URI = 2;
        if (this.isLoggedIn()) {
            // empty if block
        }
        try {
            modelService.login(username, password, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateInstance(EIInstance eiInstance, String token, ResultsCallback callback) throws Exception {
        modelService.updateInstance(this.sessionId, eiInstance, token, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getInstance(EIURI eiURI, EIInstanceCallback callback) throws Exception {
        modelService.getInstance(this.sessionId, eiURI, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deleteInstance(EIInstance instance, DeleteInstanceCallback callback) throws Exception {
        modelService.deleteInstance(this.sessionId, instance, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initializeEditableStates(String[] userInfo) {
        Log.info((String)("initializing editable states with " + userInfo.length + " states"));
        WorkFlowConstants wfc = new WorkFlowConstants();
        this.editableStates = new ArrayList();
        if (userInfo.length <= LoginFields.WF_STATE.getValue()) {
            return;
        }
        for (int i = LoginFields.WF_STATE.getValue(); i < userInfo.length; ++i) {
            String state = userInfo[i];
            this.editableStates.add(state);
            this.editableStates.add(wfc.getStatusType(state));
            Log.info((String)("adding editable state " + userInfo[i]));
        }
    }

    public boolean canEdit(String workflowState) {
        if (this.editableStates == null) {
            Log.info((String)"editable states null");
            return false;
        }
        if (workflowState == null) {
            return false;
        }
        Log.info((String)("asking if can edit " + workflowState + "; answer " + this.editableStates.contains(workflowState)));
        return this.editableStates.contains(workflowState);
    }

    public List<String> getEditableStates() {
        return this.editableStates;
    }

    public void getResourcesOfClass(String rnav, EIURI classUri, EIInstancesCallback callback) {
        modelService.getResourcesOfClass(this.sessionId, rnav, classUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getFilterQuery(String user, EIURI classUri, EIURI state, EIURI lab, FilterInstancesCallback callback) throws Exception {
        modelService.getFilterQuery(this.sessionId, user, classUri, state, lab, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getAllResources(String rnav, EIInstancesCallback callback) {
        modelService.getAllResources(this.sessionId, rnav, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private EIInstance getCached(EIInstance c) {
        if (this.mapIdToClass.containsKey(c.getEntity().getURI())) {
            return (EIInstance)this.mapIdToClass.get(c.getEntity().getURI());
        }
        this.mapIdToClass.put(c.getEntity().getURI(), c);
        return c;
    }

    private void updateCached(EIInstance instance, EIURI workFlowState, EIURI owner) {
        EIInstance cached = this.getCached(instance);
        if (workFlowState != null) {
            cached.setWFState(workFlowState);
        }
        if (owner != null) {
            cached.setWFOwner(owner);
        }
    }

    public void getNewInstanceID(int count, IdCallback callback) {
        try {
            modelService.getNewInstanceID(this.sessionId, count, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createInstance(EIInstance instance, NewInstanceCallback callback) {
        try {
            modelService.createInstance(this.sessionId, instance, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getEmptyEIInstance(EIURI classUri, EIEntity instanceEntity, EIInstanceCallback callback) {
        modelService.getEmptyEIInstance(this.sessionId, classUri, instanceEntity, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void query(String sparql, AsyncCallback<StringBuffer> callback) throws Exception {
    }

    public void isOnline(AsyncCallback callback) throws Exception {
    }

    public void whoami(UserCallback callback) throws Exception {
        if (modelService == null) {
            modelService = (RepositoryToolsModelServiceAsync)GWT.create(RepositoryToolsModelService.class);
        }
        String session = DatatoolsCookies.getSession();
        modelService.whoami(session, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void returnToDraft(EIInstance instance, ResultsCallback callback) throws Exception {
        this.promote(instance, DRAFT_STATE, callback);
    }

    public void sendToCuration(EIInstance instance, ResultsCallback callback) throws Exception {
        this.promote(instance, CURATION_STATE, callback);
    }

    public void publish(EIInstance instance, ResultsCallback callback) throws Exception {
        this.promote(instance, PUBLISHED_STATE, callback);
    }

    public void withdraw(EIInstance instance, ResultsCallback callback) throws Exception {
        Log.info((String)("withdrawing " + instance.getInstanceLabel()));
        this.promote(instance, WITHDRAWN_STATE, callback);
    }

    public void bulkPublish(EIInstance[] instanceAry, ResultsCallback callback) throws Exception {
        this.bulkPromote(instanceAry, PUBLISHED_STATE, callback);
    }

    public void bulkWithdraw(EIInstance[] instanceAry, ResultsCallback callback) throws Exception {
        this.bulkPromote(instanceAry, WITHDRAWN_STATE, callback);
    }

    public void bulkReturnToDraft(EIInstance[] instanceAry, ResultsCallback callback) throws Exception {
        this.bulkPromote(instanceAry, DRAFT_STATE, callback);
    }

    public void bulkSendToCuration(EIInstance[] instanceAry, ResultsCallback callback) throws Exception {
        this.bulkPromote(instanceAry, CURATION_STATE, callback);
    }

    public void promote(EIInstance instance, String newState, ResultsCallback callback) throws Exception {
        if (this.isLoggedIn()) {
            Log.info((String)("promoting '" + instance.getInstanceURI().toString() + "' to " + newState));
            modelService.promote(this.sessionId, instance.getInstanceURI().toString(), newState, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void bulkPromote(EIInstance[] aryInstance, String newState, ResultsCallback callback) throws Exception {
        if (this.isLoggedIn()) {
            String[] uriAry = new String[aryInstance.length];
            int i = 0;
            for (EIInstance instance : aryInstance) {
                uriAry[i] = instance.getInstanceURI().toString();
                ++i;
            }
            modelService.bulkPromote(this.sessionId, uriAry, newState, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void claim(EIInstance instance, ResultsCallback callback) throws Exception {
        if (this.isLoggedIn()) {
            Log.info((String)("Calling claim on " + instance.getInstanceLabel() + "; '" + instance.getInstanceURI().toString() + "'"));
            modelService.claim(this.sessionId, instance.getInstanceURI().toString(), "self", (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void getInstancesForLab(String rnav, String labUri, EIInstancesForLabCallback callback) throws Exception {
        modelService.getInstancesForLab(this.sessionId, rnav, labUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getWFStates(String user, WFCallback callback) throws Exception {
        modelService.getWFStates(this.sessionId, user, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void retrieveLabel(EIURI uri, ResultsCallback callback) {
        modelService.retrieveLabel(this.sessionId, uri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleFailure(LoginRequiredCallback callback, Throwable arg0) {
        if (!(arg0 instanceof IncompatibleRemoteServiceException) && !(arg0 instanceof InvocationException)) {
            if (arg0 instanceof LoggedException) {
                Window.alert((String)arg0.getMessage());
            } else {
                callback.loginRequired();
            }
        }
    }

    static /* synthetic */ void access$000(ClientRepositoryToolsManager x0) {
        x0.handleLogOut();
    }

    static /* synthetic */ String access$102(ClientRepositoryToolsManager x0, String x1) {
        x0.sessionId = x1;
        return x0.sessionId;
    }

    static /* synthetic */ EIURI access$202(ClientRepositoryToolsManager x0, EIURI x1) {
        x0.userURI = x1;
        return x0.userURI;
    }

    static /* synthetic */ String access$100(ClientRepositoryToolsManager x0) {
        return x0.sessionId;
    }

    static /* synthetic */ void access$300(ClientRepositoryToolsManager x0, String[] x1) {
        x0.initializeEditableStates(x1);
    }

    static /* synthetic */ ArrayList access$400(ClientRepositoryToolsManager x0) {
        return x0.listeners;
    }

    static /* synthetic */ void access$500(ClientRepositoryToolsManager x0, LoginRequiredCallback x1, Throwable x2) {
        x0.handleFailure(x1, x2);
    }

    static /* synthetic */ void access$600(ClientRepositoryToolsManager x0, EIInstance x1, EIURI x2, EIURI x3) {
        x0.updateCached(x1, x2, x3);
    }

    static /* synthetic */ EIURI access$200(ClientRepositoryToolsManager x0) {
        return x0.userURI;
    }
}

