/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.FilterPanel;
import org.eaglei.datatools.client.ui.FormsPanel;
import org.eaglei.datatools.client.ui.MainPanel;
import org.eaglei.model.EIClass;

public class LeftListPanel
extends VerticalPanel
implements ClientRepositoryToolsManager.SessionListener {
    private boolean signedIn = false;
    public static List<EIClass> resourceTypes;
    public static FlexTable labsTable;
    public static FlexTable resourcesTable;
    public static Anchor labsLink;
    public static Anchor resourcesLink;
    public static boolean isLabsLinkSelected;
    final FlowPanel labsPanel = new FlowPanel();
    final FlowPanel resourcesPanel = new FlowPanel();

    public LeftListPanel() {
        Log.info((String)"making left list panel");
        ClientRepositoryToolsManager.INSTANCE.addSessionListener((ClientRepositoryToolsManager.SessionListener)this);
        this.signedIn = ClientRepositoryToolsManager.INSTANCE.isLoggedIn();
        if (this.signedIn) {
            this.getResourceTypes();
        }
    }

    private void getResourceTypes() {
        Log.info((String)"left panel getting resource types");
        ClientOntologyToolsManager.INSTANCE.getTopLevelClasses((ClientOntologyToolsManager.TopLevelClassesCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createPanel() {
        Log.info((String)"left list panel creating sub-panel");
        labsLink.setHTML("<b> My Laboratories</b>");
        resourcesLink.setHTML("<b>My Resources</b>");
        this.setWidth("100");
        this.setStyleName("leftPanel");
        if (this.signedIn) {
            Label uri;
            Anchor a;
            FlowPanel h;
            Anchor addNewLink = new Anchor("add new");
            this.labsPanel.add((Widget)labsLink);
            this.labsPanel.add((Widget)addNewLink);
            addNewLink.setStyleName("gwt_add_item");
            this.add((Widget)this.labsPanel);
            this.add((Widget)labsTable);
            labsTable.setVisible(false);
            FlowPanel hp = new FlowPanel();
            HashMap mapNoDefClassToUIObject = new HashMap();
            Label l = new Label();
            l.setStyleName("tempIcon");
            Anchor r = new Anchor("All Resource Types");
            r.setStyleName("gwt_super_type");
            hp.add((Widget)l);
            hp.add((Widget)r);
            labsTable.setText(labsTable.getRowCount(), 0, "");
            labsTable.setText(labsTable.getRowCount() - 1, 1, "");
            labsTable.setWidget(labsTable.getRowCount(), 0, (Widget)hp);
            labsTable.setWidget(labsTable.getRowCount() - 1, 2, null);
            for (EIClass eclass : resourceTypes) {
                h = this.createClassLabel(mapNoDefClassToUIObject, eclass);
                labsTable.setWidget(labsTable.getRowCount(), 0, (Widget)h);
                a = new Anchor("add new");
                a.setStyleName("gwt_add_item");
                if (this.signedIn) {
                    labsTable.setWidget(labsTable.getRowCount() - 1, 1, (Widget)a);
                }
                uri = new Label(eclass.getEntity().getURI().toString());
                uri.setVisible(false);
                labsTable.setWidget(labsTable.getRowCount() - 1, 2, (Widget)uri);
            }
            this.setToolTipforClass(mapNoDefClassToUIObject);
            this.resourcesPanel.add((Widget)resourcesLink);
            this.add((Widget)this.resourcesPanel);
            this.add((Widget)resourcesTable);
            resourcesTable.setVisible(false);
            mapNoDefClassToUIObject.clear();
            for (EIClass eclass : resourceTypes) {
                h = this.createClassLabel(mapNoDefClassToUIObject, eclass);
                resourcesTable.setWidget(resourcesTable.getRowCount(), 0, (Widget)h);
                a = new Anchor("add new");
                a.setStyleName("gwt_add_item");
                if (this.signedIn) {
                    resourcesTable.setWidget(resourcesTable.getRowCount() - 1, 1, (Widget)a);
                }
                uri = new Label(eclass.getEntity().getURI().toString());
                uri.setVisible(false);
                resourcesTable.setWidget(resourcesTable.getRowCount() - 1, 2, (Widget)uri);
            }
            this.setToolTipforClass(mapNoDefClassToUIObject);
            addNewLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            labsLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            resourcesLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private FlowPanel createClassLabel(HashMap<EIClass, Anchor> mapNoDefClassToUIObject, EIClass eclass) {
        FlowPanel h = new FlowPanel();
        Label i = new Label();
        i.setStyleName("tempIcon");
        Anchor lbl = new Anchor(eclass.getEntity().getLabel());
        lbl.setStyleName("gwt_super_type");
        if (eclass.getDefinition() == null) {
            mapNoDefClassToUIObject.put(eclass, lbl);
        } else {
            lbl.setTitle(eclass.getDefinition());
        }
        h.add((Widget)i);
        h.add((Widget)lbl);
        return h;
    }

    private void setToolTipforClass(Map<EIClass, Anchor> mapNoDefClassToUIObject) {
        ArrayList<EIClass> listNoDefClasses = new ArrayList<EIClass>(mapNoDefClassToUIObject.keySet());
        ClientOntologyToolsManager.INSTANCE.getClassDefinitions(listNoDefClasses, (ClientOntologyToolsManager.DefinitionsCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onLogOut() {
        this.signedIn = false;
        resourceTypes.clear();
        isLabsLinkSelected = false;
        this.labsPanel.clear();
        this.resourcesPanel.clear();
        labsTable.clear();
        resourcesTable.clear();
        labsLink = new Anchor();
        resourcesLink = new Anchor();
        this.clear();
    }

    public void onLogIn(String username, String userUri) {
        this.signedIn = true;
        Log.info((String)"left list panel logging in: about to get resource types");
        this.getResourceTypes();
    }

    public void doResources() {
        isLabsLinkSelected = false;
        labsTable.setVisible(false);
        resourcesTable.setVisible(true);
        this.labsPanel.setStyleName("panelNotSelected");
        this.resourcesPanel.setStyleName("panelSelected");
        for (int i = 0; i < resourcesTable.getRowCount(); ++i) {
            resourcesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
        }
        MainPanel.handleResources();
    }

    public void doLabs() {
        isLabsLinkSelected = true;
        this.labsPanel.setStyleName("panelSelected");
        this.resourcesPanel.setStyleName("panelNotSelected");
        resourcesTable.setVisible(false);
        MainPanel.handleLabs();
        for (int i = 0; i < labsTable.getRowCount(); ++i) {
            labsTable.getRowFormatter().setStyleName(i, "panelNotSelected");
        }
    }

    public void doAddNewLabLink() {
        int i;
        this.labsPanel.setStyleName("panelSelected");
        for (i = 0; i < labsTable.getRowCount(); ++i) {
            labsTable.getRowFormatter().setStyleName(i, "panelNotSelected");
        }
        for (i = 0; i < resourcesTable.getRowCount(); ++i) {
            resourcesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
        }
        MainPanel.dataPanel.clear();
        MainPanel.dataPanel.add((Widget)new FilterPanel(""));
        MainPanel.dataPanel.add((Widget)new FormsPanel("", "http://purl.obolibrary.org/obo/ERO_0000001").generateNewForm());
    }

    static /* synthetic */ void access$000(LeftListPanel x0) {
        x0.createPanel();
    }

    static {
        labsTable = new FlexTable();
        resourcesTable = new FlexTable();
        labsLink = new Anchor();
        resourcesLink = new Anchor();
    }
}

