package org.eaglei.datatools.client.rpc;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;
import org.eaglei.model.EIProperty;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * The async counterpart of <code>DataToolsModelService</code>.
 * 
 */
public interface OntologyToolsModelServiceAsync {

	void getTopLevelClasses(AsyncCallback<List<EIClass>> callback);
	
	void getEIClass(EIURI uri, AsyncCallback<EIClass> callback);
	
	void getProperties(EIURI classId, AsyncCallback<List<EIProperty>> callback);
	
	void getProperties(EIURI classId, String groupUri,AsyncCallback<List<EIProperty>> callback);

	void getSubClasses(EIURI classId, boolean resolveReference,AsyncCallback<List<EIClass>> callback) ;
	
	void getClassDefinitions(List<EIURI> classURIs ,AsyncCallback<List<String>> callback) ;

	void getSuperClass(EIClass eclass, AsyncCallback<EIClass> callback);
	
	void getRootSuperClass(EIClass eclass, AsyncCallback<EIClass> callback);
}
