package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.DeleteInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.FilterInstancesCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.SharedClassChooser;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.HTMLTable.Cell;

public class MainPanel extends HorizontalPanel implements ClientRepositoryToolsManager.SessionListener {
	public static LeftListPanel		listPanel;
	public static VerticalPanel		dataPanel;
	public static FilterPanel		filterPanel;
	private static ResourcesGrid	grid;
	private boolean					signedIn			= false;
	public static String			userUri;
	public static String			instanceUri;
	public static String			DATATOOLS_FILTER	= "DatatoolsFilter";
	public static String			DATATOOLS_CONTROLS	= "DatatoolsControls";
	public static EIClass			eClass;
	public static EagleiGlassPane	glasspane;
	public static EIURI				labUri;
	private String					tokenBeforeEdit;
	public MainPanel() {
		glasspane = new EagleiGlassPane();
		ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
		signedIn = ClientRepositoryToolsManager.INSTANCE.isLoggedIn();
		userUri = DatatoolsCookies.getUserUri();
		Log.debug("making main panel: signed in? " + signedIn + " user is " + (userUri == null ? "null" : userUri));
		listPanel = new LeftListPanel();
		dataPanel = new VerticalPanel();
		createPanel();
		createHandler();
	}
	/**
	 * Adds left Panel and data panel to the Main panel
	 */
	private void createPanel() {
		dataPanel.setStyleName("dataPanel");
		add(listPanel);
		add(dataPanel);
		getTable().setClassName("mainPanelTable");
		// getWidget(0).get
	}
	/**
	 * This method takes care of handling of events on the left panel and the
	 * Data panel
	 */
	private void createHandler() {
		LeftListPanel.labsTable.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				Cell cell = LeftListPanel.labsTable.getCellForEvent(arg0);
				History.newItem("mylaboratories=" + cell.getRowIndex() + "&" + cell.getCellIndex() + "&" + labUri.toString(),false);
				Datatools.mainPanel.doLabTable(cell.getRowIndex(), cell.getCellIndex(), labUri.toString());
				
			}
		});
		LeftListPanel.resourcesTable.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				final Cell cell = LeftListPanel.resourcesTable.getCellForEvent(arg0);
				History.newItem("myResources=" + cell.getRowIndex() + "&" + cell.getCellIndex(),false);
				Datatools.mainPanel.doSubLinksOfResource(cell.getRowIndex(), cell.getCellIndex());
				
			}
		});
	}
	/**
	 * This is called when the My Laboratories link is clicked
	 */
	public void handleLabs() {
		dataPanel.clear();
		ClientOntologyToolsManager.INSTANCE.getEIClass(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000001"), new EIClassCallback() {
			@Override
			public void onSuccess(final EIClass eClass) {
				LeftListPanel.labsTable.setVisible(false);
				MainPanel.eClass = eClass;
				addFilterPanel(eClass);
				dataPanel.add(filterPanel);
				filterPanel.labFilter.setVisible(false);
				filterPanel.labLabel.setVisible(false);
				MainPanel.this.createResourcesGrid("http://purl.obolibrary.org/obo/ERO_0000001", userUri, "My Laboratories");
			}
			@Override
			public void onFailure(String result) {
			}
		});
		DeferredCommand.addCommand(new Command() {
			@Override
			public void execute() {
			}
		});
	}
	/**
	 * This is called when the My Resources link is clicked
	 */
	public static void handleResources() {
		dataPanel.clear();
		addFilterPanel(null);
		DeferredCommand.addCommand(new Command() {
			@Override
			public void execute() {
				dataPanel.add(filterPanel);
				FlowPanel hp = new FlowPanel();
				hp.setStyleName("resourcesHeaderPanel");
				Label pageHeader = new Label("To see a list of resources that you can view or edit, click the resource type, such as Instrument.");
				hp.add(pageHeader);
				dataPanel.add(hp);
				//createResourcesGrid(null, userUri, "My Resources");
			}
		});
	}
	/**
	 * Creates the resources view in a tabular format
	 * 
	 * @param uri
	 * @param userName
	 */
	private void createResourcesGrid(final String uri, final String userUri, final String labelClicked) {
		grid = new ResourcesGrid(uri, filterPanel, userUri);
		// filterPanel.totalResources=new Label();
		// filterPanel.totalResources.setText("(" + instances.size() +
		// ")  instances found");
		Label pageHeader = new Label(labelClicked);
		pageHeader.setStyleName("pageHeader");
		dataPanel.add(pageHeader);
		dataPanel.add(grid);
		this.addGridHandler();
		//filterPanel.totalResources.setText("(" + grid + ")  instances found");
	}
	/**
	 * Handle Grid click events
	 * 
	 * @param grid
	 */
	private void addGridHandler() {
		grid.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				final Cell cell = grid.getCellForEvent(event);
				instanceUri = grid.getText(cell.getRowIndex(), grid.getCellCount(cell.getRowIndex()) - 1); // gets the
				// instance uri
				// from the last
				// column
				if ("edit".equals(grid.getText(cell.getRowIndex(), cell.getCellIndex()))) {
					//MainPanel.this.setTokenBeforeEdit(History.getToken());
					History.newItem("edit&" + cell.getRowIndex(), false);
					
					Datatools.mainPanel.doEditGrid(cell.getRowIndex());
				} else if ("delete".equals(grid.getText(cell.getRowIndex(), cell.getCellIndex()))) {
					MainPanel.this.doDeleteGrid(cell.getRowIndex());
				} else if ("claim".equals(grid.getText(cell.getRowIndex(), cell.getCellIndex()))) {
					MainPanel.this.doClaimGrid(cell.getRowIndex());
				} else if (cell.getCellIndex() == 0 && cell.getRowIndex() != 0) {
					
					History.newItem("view&" + cell.getRowIndex() + "&" + instanceUri + "&" + grid.getText(cell.getRowIndex(), grid.getCellCount(cell.getRowIndex()) - 2),false);
					
					Datatools.mainPanel.doViewGrid(cell.getRowIndex(),grid.getText(cell.getRowIndex(), grid.getCellCount(cell.getRowIndex()) - 2));
					
				} else if ("withdraw".equals(grid.getText(cell.getRowIndex(), cell.getCellIndex()))) {
					MainPanel.this.doWithdrawGrid(cell.getRowIndex());
				}
			}
		});
	}
	/**
	 * Creates the to filter Panel and adds to the data panel
	 * 
	 * @param eClass
	 */
	private static void addFilterPanel(final EIClass eClass) {
		final SharedClassChooser<OntologyDropdown> classChooser = new SharedClassChooser<OntologyDropdown>(new OntologyDropdown());
		if (eClass != null) {
			classChooser.setTextBoxStyle("formText");
			classChooser.setClass(eClass, false);
			classChooser.setSelectedEntity(eClass.getEntity());
			filterPanel = new FilterPanel(DATATOOLS_FILTER, classChooser);
		} else {
			filterPanel = new FilterPanel(DATATOOLS_FILTER, null);
		}
		filterPanel.goButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				String resourseTypeFilterStr = filterPanel.resourceTypeFilter.getValue(filterPanel.resourceTypeFilter.getSelectedIndex());
				String labelFilterStr = null;
				if (History.getToken().contains("mylaboratories")) {
					labelFilterStr = instanceUri;
				} else {
					labelFilterStr = filterPanel.labFilter.getValue((filterPanel.labFilter.getSelectedIndex()));
				}
				String statusFilterStr = filterPanel.statusFilter.getItemText(filterPanel.statusFilter.getSelectedIndex());
				if (filterPanel.getClassChooser() == null) {
					History.newItem(History.getToken().split("=")[0] + "=" + resourseTypeFilterStr + "&" + labelFilterStr + "&" + statusFilterStr);
				} else {
					if (filterPanel.getClassChooser().getSelectedURI() != null)
						History.newItem(History.getToken().split("=")[0] + "=" + filterPanel.getClassChooser().getSelectedURI().toString() + "&" + labelFilterStr + "&" + statusFilterStr);
					else
						History.newItem(History.getToken().split("=")[0] + "=" + resourseTypeFilterStr + "&" + labelFilterStr + "&" + statusFilterStr);
				}
			}
		});
	}
	/**
	 * This method is called in response to the filter options selected by the
	 * user on the FilterPanel
	 * 
	 * @param instances
	 * @param filterPanel
	 * @param label
	 *            - Text of the resource clicked
	 */
	public void filterGrid(List<EIInstance> instances, FilterPanel filterPanel, String label) {
		dataPanel.clear();
		dataPanel.add(filterPanel);
		grid = new ResourcesGrid(instances);
		this.addGridHandler();
		Label pageHeader = new Label(label);
		pageHeader.setStyleName("pageHeader");
		dataPanel.add(pageHeader);
		dataPanel.add(grid);
	}
	/**
	 * Send the resource to Curation
	 */
	public static void sendToCuration() {
		try {
			Log.info("sending to curation: " + listPanel.getFrmPanel().getEiInstance());
			ClientRepositoryToolsManager.INSTANCE.sendToCuration(listPanel.getFrmPanel().getEiInstance(), new ResultsCallback() {
				@Override
				public void onSuccess(String[] arg0) {
					redraw();
				}
				@Override
				public void onSuccess(String arg0) {
					redraw();
				}
				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
				public void redraw() {
					MainPanel.dataPanel.clear();
					try {
						ClientRepositoryToolsManager.INSTANCE.getInstance(listPanel.getFrmPanel().getEiInstance().getInstanceURI(), new EIInstanceCallback() {
							@Override
							public void onSuccess(EIInstance eiInstance) {
								listPanel.getFrmPanel().setEiInstance(eiInstance);
								Log.info("sent to curation: owner now " + listPanel.getFrmPanel().getEiInstance().getWFOwner());
								FilterPanel fp = new FilterPanel(listPanel.getFrmPanel().getEiInstance().getWFState() == null ? "" : listPanel.getFrmPanel().getEiInstance().getWFState().toString(), listPanel.getFrmPanel().getEiInstance().getWFOwner() != null);
								MainPanel.dataPanel.add(fp);
								fp.editButton.setVisible(true);
								fp.saveButton.setVisible(false);
								MainPanel.dataPanel.add(createSavedMessage("Resource has been sent to curation"));
								FormsPanel frmsPanel = new FormsPanel();
								MainPanel.listPanel.setFrmPanel(frmsPanel);
								MainPanel.dataPanel.add(frmsPanel.generateViewForm(eiInstance));
							}
							@Override
							public void loginRequired() {
								// TODO Auto-generated method stub
							}
						});
					} catch (Exception e) {
						Log.error("could not (re-) get instance");
					}
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/**
	 * Return the resource to draft
	 */
	public static void returnToDraft() {
		try {
			Log.info("returning " + listPanel.getFrmPanel().getEiInstance() + " to draft");
			ClientRepositoryToolsManager.INSTANCE.returnToDraft(listPanel.getFrmPanel().getEiInstance(), new ResultsCallback() {
				@Override
				public void onSuccess(String[] arg0) {
					redraw();
				}
				@Override
				public void onSuccess(String arg0) {
					redraw();
				}
				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
				public void redraw() {
					MainPanel.dataPanel.clear();
					FilterPanel fp = new FilterPanel(listPanel.getFrmPanel().getEiInstance().getWFState() == null ? "" : listPanel.getFrmPanel().getEiInstance().getWFState().toString(), listPanel.getFrmPanel().getEiInstance().getWFOwner() != null);
					MainPanel.dataPanel.add(fp);
					fp.editButton.setVisible(true);
					fp.saveButton.setVisible(false);
					MainPanel.dataPanel.add(createSavedMessage("Resource has been returned to draft"));
					//FormsPanel frmsPanel = new FormsPanel();
					MainPanel.dataPanel.add(listPanel.getFrmPanel().generateViewForm(listPanel.getFrmPanel().getEiInstance()));
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/**
	 * Withdraw the resource
	 */
	public static void withdraw() {
		try {
			Log.info("withdrawing: " + listPanel.getFrmPanel().getEiInstance());
			ClientRepositoryToolsManager.INSTANCE.withdraw(listPanel.getFrmPanel().getEiInstance(), new ResultsCallback() {
				@Override
				public void onSuccess(String[] arg0) {
					redraw();
				}
				@Override
				public void onSuccess(String arg0) {
					redraw();
				}
				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
				public void redraw() {
					MainPanel.dataPanel.clear();
					FilterPanel fp = new FilterPanel(listPanel.getFrmPanel().getEiInstance().getWFState() == null ? "" : listPanel.getFrmPanel().getEiInstance().getWFState().toString(), listPanel.getFrmPanel().getEiInstance().getWFOwner() != null);
					MainPanel.dataPanel.add(fp);
					fp.editButton.setVisible(true);
					fp.saveButton.setVisible(false);
					MainPanel.dataPanel.add(createSavedMessage("Resource has been withdrawn and can no longer be found in search"));
					MainPanel.dataPanel.add(listPanel.getFrmPanel().generateViewForm(listPanel.getFrmPanel().getEiInstance()));
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/**
	 * Publish the resource
	 */
	public static void publish() {
		try {
			Log.info("publishing: " + listPanel.getFrmPanel().getEiInstance());
			ClientRepositoryToolsManager.INSTANCE.publish(listPanel.getFrmPanel().getEiInstance(), new ResultsCallback() {
				@Override
				public void onSuccess(String[] arg0) {
					redraw();
				}
				@Override
				public void onSuccess(String arg0) {
					redraw();
				}
				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
				public void redraw() {
					MainPanel.dataPanel.clear();
					FilterPanel fp = new FilterPanel(listPanel.getFrmPanel().getEiInstance().getWFState() == null ? "" : listPanel.getFrmPanel().getEiInstance().getWFState().toString(), (listPanel.getFrmPanel().getEiInstance().getWFOwner() != null));
					MainPanel.dataPanel.add(fp);
					fp.editButton.setVisible(true);
					fp.saveButton.setVisible(false);
					MainPanel.dataPanel.add(createSavedMessage("Resource has been published"));
					MainPanel.dataPanel.add(listPanel.getFrmPanel().generateViewForm(listPanel.getFrmPanel().getEiInstance()));
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/**
	 * all the bulk workflow operation happens here
	 * 
	 * @param state
	 * @param action
	 */
	public static void bulkOperation(final WorkFlowAction action) {
		try {
			final ArrayList<EIInstance> aryInstanceLst = new ArrayList<EIInstance>();
			WorkFlowConstants wfc = new WorkFlowConstants();
			CheckBox[] aryChkBox = grid.getChkBoxRefAry();
			VerticalPanel vpanel = new VerticalPanel();
			Label heading = new Label("The resources which are being sent to '" + action.getToState() + "' are");
			heading.setStyleName("dataPanelLabel");
			vpanel.add(heading);
			FlexTable flexTable = new FlexTable();
			flexTable.setStyleName("dataPanel");
			flexTable.setHTML(1, 0, "<b>" + "Resource Name" + "</b>");
			flexTable.setHTML(1, 1, "<b>" + "Type" + "</b>");
			flexTable.setHTML(1, 2, "<b>" + "Status" + "</b>");
			boolean somethingSelected = false;
			boolean actionValidForAllItems = true;
			int i = 0;
			for (CheckBox chkBox : aryChkBox) {
				EIInstance eiInstance = grid.getInstanceInGridByRow(i);
				String status = eiInstance.getWFState() == null ? "" : wfc.getStatusTypeByStatusURI(eiInstance.getWFState().toString());
				if (chkBox.getValue()) {
					if (status.equals(action.getFromState())) {
						aryInstanceLst.add(grid.getInstanceInGridByRow(i));
						flexTable.setText(i + 2, 0, eiInstance.getInstanceLabel());
						flexTable.setText(i + 2, 1, eiInstance.getInstanceType().getLabel());
						flexTable.setText(i + 2, 2, status);
						somethingSelected = true;
					} else {
						actionValidForAllItems = false;
					}
					//					if (status.equalsIgnoreCase(state)) {
					//						aryInstanceLst.add(grid.getInstanceInGridByRow(i));
					//						flexTable.setText(i + 2, 0, eiInstance.getInstanceLabel());
					//						flexTable.setText(i + 2, 1, eiInstance.getInstanceType().getLabel());
					//						flexTable.setText(i + 2, 2, status);
					//						somethingSelected = true;
					//					} else
					//						someSelctedButNotState = true;
				}
				i++;
			}
			if (!actionValidForAllItems && !somethingSelected) {
				Window.alert(WorkFlowAction.getAlertMessage(action));
				return;
			} else if (!somethingSelected && actionValidForAllItems) {
				Window.alert(WorkFlowConstants.SELECT_MESSAGE);
				return;
			}
			final EagleIPopup popup = new EagleIPopup();
			Button confirmBtn = new Button("Confirm");
			confirmBtn.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					try {
						ResultsCallback resultCall = new ResultsCallback() {
							@Override
							public void onSuccess(String[] arg0) {
								redraw();
							}
							@Override
							public void onSuccess(String arg0) {
								redraw();
							}
							@Override
							public void loginRequired() {
								// TODO Auto-generated method stub
							}
							public void redraw() {
								HistoryRootPanel.getInstance().changeDisplayByToken(History.getToken(), true);
							}
						};
						popup.hide();
						// TODO: make a bulkAction(WorkFlowAction, EIInstance[]) on ClientRepositoryToolsManager
						if (action.equals(WorkFlowAction.CurationAction)) {
							ClientRepositoryToolsManager.INSTANCE.bulkSendToCuration(aryInstanceLst.toArray(new EIInstance[aryInstanceLst.size()]), resultCall);
						} else if (action.equals(WorkFlowAction.PublishAction)) {
							ClientRepositoryToolsManager.INSTANCE.bulkPublish(aryInstanceLst.toArray(new EIInstance[aryInstanceLst.size()]), resultCall);
						} else if (action.equals(WorkFlowAction.WithdrawAction)) {
							ClientRepositoryToolsManager.INSTANCE.bulkWithdraw(aryInstanceLst.toArray(new EIInstance[aryInstanceLst.size()]), resultCall);
						} else if (action.equals(WorkFlowAction.ReturnToDraftAction)) {
							ClientRepositoryToolsManager.INSTANCE.bulkReturnToDraft(aryInstanceLst.toArray(new EIInstance[aryInstanceLst.size()]), resultCall);
						}
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			});
			flexTable.setWidget(i + 3, 1, confirmBtn);
			FlowPanel fpPanel = new FlowPanel();
			Button cancelButton = new Button("Cancel");
			cancelButton.addClickHandler(new ClickHandler() {
				public void onClick(ClickEvent event) {
					popup.hide();
				}
			});
			fpPanel.add(confirmBtn);
			fpPanel.add(cancelButton);
			//	flexTable.setWidget(i + 3, 3, cancelButton);
			vpanel.add(flexTable);
			Style style = flexTable.getElement().getStyle();
			style.clearOverflow();
			vpanel.add(fpPanel);
			popup.add(vpanel);
			popup.show();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/**
	 * This is called in response to the 'Edit' option selected from the
	 * Filter/Control Panel
	 */
	public static void editResource() {
		dataPanel.clear();
		try {
			ClientRepositoryToolsManager.INSTANCE.getInstance(EIURI.create(instanceUri), new EIInstanceCallback() {
				@Override
				public void onSuccess(EIInstance eiInstance) {
					final String instanceWFState = eiInstance.getWFState() == null ? "" : eiInstance.getWFState().toString();
					FilterPanel fp = new FilterPanel(instanceWFState, (eiInstance.getWFOwner() != null));
					fp.cancelButton.setVisible(true);
					fp.editButton.setVisible(false);
					dataPanel.add(fp);
					FormsPanel frmsPanel = new FormsPanel("", instanceUri);
					dataPanel.add(frmsPanel.generateEditForm(instanceUri));
					listPanel.setFrmPanel(frmsPanel);
				}
				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public static void saveForm() {
		try {
			listPanel.frmPanel.saveForm();
			/*
			 * } else {
			 * Window.alert("Please correct form errors and try again"); }
			 */
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/**
	 * This is called in response to the 'Copy Resource' option selected from
	 * the Filter/Control Panel
	 */
	public static void copyResource() {
		dataPanel.clear();
		FilterPanel fp = new FilterPanel("");
		fp.editButton.setVisible(false);
		fp.cancelButton.setVisible(true);
		dataPanel.add(fp);
		FormsPanel frmsPanel = new FormsPanel("", instanceUri);
		dataPanel.add(frmsPanel.generateEditForm(instanceUri));
		listPanel.setFrmPanel(frmsPanel);
		Timer timer = new Timer() {
			public void run() {
				listPanel.getFrmPanel().setEiInstance(null);
			}
		};
		timer.schedule(2000);
	}
	@Override
	public void onLogOut() {
		Log.info("main panel logging out");
		signedIn = false;
		userUri = null;
		dataPanel.clear();
		listPanel.clear();
		this.clear();
	}
	public static void handleLoginRequired() {
		dataPanel.clear();
		HTML errorMessage = new HTML("<font color='red'><b> Please sign in.</b></font>");
		dataPanel.add(errorMessage);
	}
	@Override
	public void onLogIn(String username, String userUri) {
		// Window.alert("main panel now signed in with username " + username);
		signedIn = true;
		listPanel.clear();
		dataPanel.clear();
		this.userUri = userUri;
		createPanel();
	}
	public void doSubLinksOfResource(final int row, final int column) {
		final String uri = LeftListPanel.resourcesTable.getText(row, 2);
		dataPanel.clear();
		LeftListPanel.resourcesTable.setVisible(true);
		listPanel.labsPanel.setStyleName("panelNotSelected");
		DeferredCommand.addCommand(new Command() {
			@Override
			public void execute() {
				if (!LeftListPanel.resourcesTable.getText(row, column).equals("add new")) {
					setSelectedRowStyle(row, listPanel.resourcesTable);
					listPanel.resourcesPanel.setStyleName("panelNotSelected");
					ClientOntologyToolsManager.INSTANCE.getEIClass(EIURI.create(uri), new EIClassCallback() {
						@Override
						public void onSuccess(EIClass result) {
							addFilterPanel(result);
							dataPanel.add(filterPanel);
							createResourcesGrid(uri, userUri, LeftListPanel.resourcesTable.getText(row, column));
						}
						@Override
						public void onFailure(String result) {
							// TODO Auto-generated method stub
						}
					});
				} else { // add new form
					dataPanel.clear();
					setSelectedRowStyle(row, listPanel.resourcesTable);
					listPanel.resourcesPanel.setStyleName("panelNotSelected");
					FilterPanel fp = new FilterPanel(DATATOOLS_CONTROLS);
					dataPanel.add(fp);
					fp.editButton.setVisible(false);
					fp.copyResourceButton.setVisible(false);
					Label label = new Label("Add New " + LeftListPanel.resourcesTable.getText(row, 0));
					label.setStyleName("pageHeader");
					dataPanel.add(label);
					FormsPanel frmsPanel = new FormsPanel("", uri);
					listPanel.setFrmPanel(frmsPanel);
					dataPanel.add(frmsPanel.generateNewForm());
				}
			}
		});
	}
	/**
	 * This method is called in response to the clicks on the Laboratory Panel
	 * 
	 * @param row
	 * @param column
	 */
	public void doLabTable(final int row, final int column, final String labUriStr) {
		if (LeftListPanel.labsTable.getCellCount(row) > 2) {
			dataPanel.clear();
			final String uri = LeftListPanel.labsTable.getText(row, 2);
			if (!LeftListPanel.labsTable.getText(row, column).equals("add new")) {
				if (listPanel.labsTable.getText(row, 0).equals("All Resource Types")) {
					setSelectedRowStyle(row, listPanel.labsTable);
					listPanel.labsPanel.setStyleName("panelNotSelected");
					dataPanel.clear();
					addFilterPanel(null);
					dataPanel.add(filterPanel);
					Label pageHeader = new Label(LeftListPanel.labsTable.getText(row, column) + " for Lab ");
					pageHeader.setStyleName("pageHeader");
					dataPanel.add(pageHeader);
					grid = new ResourcesGrid(userUri, labUriStr, true);
					listPanel.doLeftMenuforLabs();
					MainPanel.grid = grid;
					addGridHandler();
					if (filterPanel != null && grid.aryInstance != null)
						filterPanel.totalResources.setText("(" + grid.aryInstance.length + ")  instances found");
					dataPanel.add(grid);
				} else {
					setSelectedRowStyle(row, listPanel.labsTable);
					listPanel.labsPanel.setStyleName("panelNotSelected");
					try {
						ClientRepositoryToolsManager.INSTANCE.getFilterQuery(userUri, EIURI.create(uri), null, EIURI.create(labUriStr), new FilterInstancesCallback() {
							@Override
							public void loginRequired() {
								// TODO Auto-generated method stub
							}
							@Override
							public void onSuccess(final List<EIInstance> result) {
								ClientOntologyToolsManager.INSTANCE.getEIClass(EIURI.create(uri), new EIClassCallback() {
									@Override
									public void onSuccess(final EIClass eClass) {
										MainPanel.eClass = eClass;
										addFilterPanel(eClass);
										if (result.isEmpty()) {
											dataPanel.clear();
											dataPanel.add(filterPanel);
											Label pageHeader = new Label(LeftListPanel.labsTable.getText(row, column));
											pageHeader.setStyleName("pageHeader");
											dataPanel.add(pageHeader);
											dataPanel.add(new Label("No resources found"));
										} else {
											dataPanel.clear();
											dataPanel.add(filterPanel);
											filterGrid(result, filterPanel, LeftListPanel.labsTable.getText(row, column));
										}
										listPanel.doLeftMenuforLabs();
									}
									@Override
									public void onFailure(String result) {
									}
								});
							}
						});
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			} else { // add new resource for Lab
				setSelectedRowStyle(row, listPanel.labsTable);
				listPanel.labsPanel.setStyleName("panelNotSelected");
				dataPanel.clear();
				FilterPanel fp = new FilterPanel("");
				dataPanel.add(fp);
				fp.editButton.setVisible(false);
				fp.copyResourceButton.setVisible(false);
				Label label = new Label("Add New " + LeftListPanel.labsTable.getText(row, 0));
				label.setStyleName("pageHeader");
				dataPanel.add(label);
				FormsPanel frmsPanel = new FormsPanel(labUri.toString(), uri);
				dataPanel.add(frmsPanel.generateNewForm());
				listPanel.setFrmPanel(frmsPanel);
			}
		}
	}
	/**
	 * set style of selected row
	 * 
	 * @param row
	 */
	private void setSelectedRowStyle(final int selectedRow, FlexTable table) {
		for (int i = 0; i < table.getRowCount(); i++) {
			if (i == selectedRow)
				table.getRowFormatter().setStyleName(i, "panelSelected");
			else
				table.getRowFormatter().setStyleName(i, "panelNotSelected");
		}
	}
	private static HTML createSavedMessage(String specificMessage) {
		HTML msg = new HTML("<font color='green'>Form is saved.  " + specificMessage + ".</font>");
		return msg;
	}
	public void doFilterPanelGoButton(final String resourceFilterStr, final String labFilterStr, final String statusFilterStr) {
		try {
			EIClass eClass;
			if (resourceFilterStr.equals("All Resources") && labFilterStr.equals("All Laboratories")) {
				eClass = null;
			} else {
				eClass = new EIClass(EIEntity.create(resourceFilterStr, labFilterStr), true, true, true, true, true);
			}
			final SharedClassChooser<OntologyDropdown> classChooser = filterPanel.getClassChooser();
			EIURI resourceUri = null;
			EIURI labUri = null;
			if (!resourceFilterStr.equals("All Resources")) {
				resourceUri = EIURI.create(resourceFilterStr);
			} else {
				if (classChooser != null)
					resourceUri = classChooser.getSelectedURI();
			}
			if (!labFilterStr.equals("All Laboratories")) {
				labUri = EIURI.create(labFilterStr);
			}
			WorkFlowConstants wf = new WorkFlowConstants();
			String status = statusFilterStr;
			if ("Status".equals(status)) {
				status = null;
			}
			glasspane.show();
			glasspane.add(new Image("images/ajax-loader.gif"));
			ClientRepositoryToolsManager.INSTANCE.getFilterQuery(userUri, resourceUri, wf.getStatusURI(status), labUri, new FilterInstancesCallback() {
				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
				@Override
				public void onSuccess(List<EIInstance> result) {
					filterGrid(result, filterPanel, "");
					filterPanel.totalResources.setText("(" + result.size() + ")  instances found");
					filterPanel.changeDisplayAccordingToView(History.getToken());
					glasspane.hide();
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void doFilterPanelGoButtonWhenRefresh(final String resourceFilterStr, final String labFilterStr, final String statusFilterStr) {
		try {
			dataPanel.clear();
			addFilterPanel(null);
			dataPanel.add(filterPanel);
			EIURI resourceUri = null;
			EIURI labUri = null;
			if (!resourceFilterStr.equals("All Resources")) {
				resourceUri = EIURI.create(resourceFilterStr);
			}
			if (!labFilterStr.equals("All Laboratories")) {
				labUri = EIURI.create(labFilterStr);
			}
			WorkFlowConstants wf = new WorkFlowConstants();
			String status = statusFilterStr;
			if ("Status".equals(status)) {
				status = null;
			}
			glasspane.show();
			glasspane.add(new Image("images/ajax-loader.gif"));
			ClientRepositoryToolsManager.INSTANCE.getFilterQuery(userUri, resourceUri, wf.getStatusURI(status), labUri, new FilterInstancesCallback() {
				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
				@Override
				public void onSuccess(List<EIInstance> result) {
					filterPanel.changeDisplayAccordingToView(History.getToken());
					filterGrid(result, filterPanel, "");
					filterPanel.totalResources.setText("(" + result.size() + ")  instances found");
					glasspane.hide();
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void doViewGrid(final int row, final String instancetype) {
		dataPanel.clear();
		try {
			ClientRepositoryToolsManager.INSTANCE.getInstance(EIURI.create(instanceUri), new EIInstanceCallback() {
				@Override
				public void onSuccess(final EIInstance eiInstance) {
					if (instancetype.equals("LaboratoryInstance")) {
						listPanel.doLeftMenuforLabs();
						//Set the lab name on the Left panel
						LeftListPanel.labsTable.setText(0, 0, eiInstance.getInstanceLabel());
						labUri = eiInstance.getInstanceURI();
						LeftListPanel.labsTable.getCellFormatter().setStyleName(0, 0, "labSelected");
					}
					String wfState = eiInstance.getWFState() == null ? "" : eiInstance.getWFState().toString();
					FilterPanel fp = new FilterPanel(wfState, (eiInstance.getWFOwner() != null));
					dataPanel.add(fp);
					fp.copyResourceButton.setVisible(true);
					fp.editButton.setVisible(true);
					fp.saveButton.setVisible(false);
					if (LeftListPanel.isLabsLinkSelected)
						LeftListPanel.labsTable.setVisible(true);
					FormsPanel frmsPanel = new FormsPanel("", instanceUri);
					dataPanel.add(frmsPanel.generateViewForm(eiInstance));
					listPanel.setFrmPanel(frmsPanel);
				}
				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void doClaimGrid(final int row) {
		final EIInstance instance = grid.getInstanceInGridByRow(row - 1);
		try {
			ClientRepositoryToolsManager.INSTANCE.claim(instance, new ResultsCallback() {
				@Override
				public void onSuccess(String[] arg0) {
					// TODO Auto-generated method stub
				}
				@Override
				public void onSuccess(String arg0) {
					Log.info("updating claimed instance " + instance.getInstanceLabel() + " at row " + row);
					Log.info("instance state before get " + instance.getWFState() + "; owner " + instance.getWFOwner());
					// grid.removeRow(cell.getRowIndex());
					try {
						ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
							@Override
							public void onSuccess(EIInstance eiInstance) {
								Log.info(" claimed instance owner now " + eiInstance.getWFOwner());
								Log.info("instance state now " + eiInstance.getWFState());
								grid.createInstanceRow(row, eiInstance);
							}
							@Override
							public void loginRequired() {
								// TODO Auto-generated
								// method stub
							}
						});
					} catch (Exception e) {
						Log.error("could not (re-) get instance");
					}
				}
				@Override
				public void loginRequired() {
					// TODO Auto-generated method stub
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void doDeleteGrid(final int row) {
		final List<EIInstance> instanceList = new ArrayList<EIInstance>(Arrays.asList(grid.aryInstance));//Arrays.asList(grid.aryInstance);
		EIInstance instance = grid.getInstanceInGridByRow(row - 1);
		instanceList.add(instance);
		try {
			ClientRepositoryToolsManager.INSTANCE.deleteInstance(instance, new DeleteInstanceCallback() {
				@Override
				public void onSuccess(Object obj) {
					instanceList.remove(row - 1);
					grid.aryInstance = (EIInstance[]) instanceList.toArray(new EIInstance[0]);
					grid.removeRow(row);
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void doWithdrawGrid(final int row) {
		final EIInstance instance = grid.getInstanceInGridByRow(row - 1);
		try {
			ClientRepositoryToolsManager.INSTANCE.withdraw(instance, new ResultsCallback() {
				@Override
				public void onSuccess(String[] arg0) {
					grid.createInstanceRow(row, instance);
				}
				@Override
				public void onSuccess(String arg0) {
					Log.info("successfully withdrew; removing row");
					grid.createInstanceRow(row, instance);
				}
				@Override
				public void loginRequired() {
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void doEditGrid(int row) {
		EIInstance instance = grid.getInstanceInGridByRow(row - 1);
		String instanceWFState = instance.getWFState() == null ? "" : instance.getWFState().toString();
		dataPanel.clear();
		FilterPanel fp = new FilterPanel(instanceWFState, (instance.getWFOwner() != null));
		dataPanel.add(fp);
		fp.copyResourceButton.setVisible(true);
		fp.editButton.setVisible(false);
		fp.cancelButton.setVisible(true);
		FormsPanel frmsPanel = new FormsPanel("", instanceUri);
		listPanel.setFrmPanel(frmsPanel);
		dataPanel.add(frmsPanel.generateEditForm(instanceUri));
	}
	public String getTokenBeforeEdit() {
		return tokenBeforeEdit;
	}
	public void setTokenBeforeEdit(String tokenBeforeEdit) {
		this.tokenBeforeEdit = tokenBeforeEdit;
	}
}