/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.FilterPanel;
import org.eaglei.datatools.client.ui.FormsPanel;
import org.eaglei.datatools.client.ui.LeftListPanel;
import org.eaglei.datatools.client.ui.MainPanel;
import org.eaglei.datatools.client.ui.OntologyDropdown;
import org.eaglei.datatools.client.ui.WorkFlowConstants;
import org.eaglei.model.EIClass;
import org.eaglei.suggest.client.SharedClassChooser;

public class FilterPanel
extends Composite {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    @UiField
    HorizontalPanel subTypeFilter;
    @UiField
    ListBox statusFilter;
    @UiField
    ListBox resourceTypeFilter;
    @UiField
    ListBox labFilter;
    @UiField
    Label statusLabel;
    @UiField
    Label labLabel;
    @UiField
    Label resourceTypeLabel;
    @UiField
    Label filterLabel;
    @UiField
    Label wfLabel;
    @UiField
    Label totalResources;
    @UiField
    Label formControlLabel;
    @UiField
    Button curationButton;
    @UiField
    Button saveButton;
    @UiField
    Button publishButton;
    @UiField
    Button backToDraftButton;
    @UiField
    Button withdrawButton;
    @UiField
    Button goButton;
    @UiField
    Button editButton;
    @UiField
    Button cancelButton;
    @UiField
    Button copyResourceButton;
    WorkFlowConstants workFlowConstants;
    FormsPanel formsPanel = new FormsPanel();
    private String wfState;
    private String tokenBeforeEdit;
    private MainPanel mainPanel;
    SharedClassChooser<OntologyDropdown> classChooser;

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public void setMainPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
    }

    public FilterPanel() {
    }

    public SharedClassChooser<OntologyDropdown> getClassChooser() {
        return this.classChooser;
    }

    public void setClassChooser(SharedClassChooser<OntologyDropdown> classChooser) {
        this.classChooser = classChooser;
    }

    public FilterPanel(String instanceWFState) {
        this(instanceWFState, false);
    }

    public FilterPanel(String instanceWFState, boolean instanceHasOwner) {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.workFlowConstants = new WorkFlowConstants();
        this.wfState = instanceWFState;
        Log.info((String)("filter wfstate: " + this.wfState));
        this.setButtonState(this.saveButton);
        this.setTransitionButtonState(this.curationButton, "In curation");
        this.setTransitionButtonState(this.publishButton, "Published");
        this.setTransitionButtonState(this.backToDraftButton, "Draft");
        this.setTransitionButtonState(this.withdrawButton, "Withdrawn");
        if (this.claimRequired(instanceHasOwner)) {
            this.disable(this.editButton);
            this.disable(this.publishButton);
            this.disable(this.backToDraftButton);
        } else {
            this.setButtonState(this.editButton, instanceWFState);
        }
        this.setButtonState(this.copyResourceButton);
        this.cancelButton.setVisible(false);
        this.subTypeFilter.setVisible(false);
        this.statusFilter.setVisible(false);
        this.filterLabel.setVisible(false);
        this.statusLabel.setVisible(false);
        this.goButton.setVisible(false);
        this.resourceTypeLabel.setVisible(false);
        this.resourceTypeFilter.setVisible(false);
        this.labFilter.setVisible(false);
        this.labLabel.setVisible(false);
        this.saveButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.curationButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.publishButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.backToDraftButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.withdrawButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.copyResourceButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public FilterPanel(String labSelected, SharedClassChooser<OntologyDropdown> chooser) {
        this.initWidget((Widget)binder.createAndBindUi((Object)this));
        this.classChooser = chooser;
        if (this.classChooser != null) {
            this.subTypeFilter.add((Widget)this.classChooser);
            this.resourceTypeLabel.setVisible(false);
            this.resourceTypeFilter.setVisible(false);
        }
        this.populateStatusFilter();
        this.populateResourceTypeFilter();
        this.populateLabFilter();
        this.subTypeFilter.setVisible(true);
        this.curationButton.setVisible(false);
        this.saveButton.setVisible(false);
        this.editButton.setVisible(false);
        this.cancelButton.setVisible(false);
        this.publishButton.setVisible(false);
        this.copyResourceButton.setVisible(false);
        this.backToDraftButton.setVisible(false);
        this.withdrawButton.setVisible(false);
        this.statusFilter.setVisible(true);
        this.filterLabel.setVisible(true);
        this.statusLabel.setVisible(true);
        this.goButton.setVisible(true);
        this.wfLabel.setVisible(false);
        this.formControlLabel.setVisible(false);
        this.checkTokenAndSetVisibilityForLab();
    }

    private void checkTokenAndSetVisibilityForLab() {
        if (History.getToken().contains("mylaboratories")) {
            this.labLabel.setVisible(false);
            this.labFilter.setVisible(false);
        }
    }

    private void populateStatusFilter() {
        this.statusFilter.addItem("All States");
        this.statusFilter.addItem("Draft");
        this.statusFilter.addItem("In curation");
        this.statusFilter.addItem("Published");
        this.statusFilter.addItem("Withdrawn");
    }

    private void populateResourceTypeFilter() {
        this.resourceTypeFilter.addItem("All Resources");
        for (EIClass eiclass : LeftListPanel.resourceTypes) {
            this.resourceTypeFilter.addItem(eiclass.getEntity().getLabel(), eiclass.getEntity().getURI().toString());
        }
    }

    private void populateLabFilter() {
        this.labFilter.addItem("All Laboratories");
        this.labFilter.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setButtonState(Button workflowButton, String workflowConstantState) {
        workflowButton.setVisible(true);
        if (ClientRepositoryToolsManager.INSTANCE.canEdit(workflowConstantState)) {
            workflowButton.setEnabled(true);
        } else {
            this.disable(workflowButton);
        }
    }

    private void setButtonState(Button workflowButton) {
        workflowButton.setVisible(true);
        if (ClientRepositoryToolsManager.INSTANCE.getEditableStates().size() == 0) {
            this.disable(workflowButton);
        }
    }

    private void setTransitionButtonState(Button workflowButton, String workflowConstantState) {
        workflowButton.setVisible(true);
        if (Datatools.canUserChangeState((String)this.wfState, (String)workflowConstantState)) {
            workflowButton.setEnabled(true);
        } else {
            this.disable(workflowButton);
        }
    }

    private void disable(Button workflowButton) {
        workflowButton.setEnabled(false);
        workflowButton.addStyleName("btnDisabled");
    }

    public void changeDisplayAccordingToView(String token) {
        if (token.matches("myResources")) {
            this.resourceTypeFilter.setVisible(true);
            this.subTypeFilter.setVisible(false);
            this.resourceTypeLabel.setVisible(true);
            this.statusFilter.setVisible(true);
            this.filterLabel.setVisible(true);
            this.statusLabel.setVisible(true);
            this.goButton.setVisible(true);
            this.wfLabel.setVisible(false);
            this.formControlLabel.setVisible(false);
        } else if (token.matches("myResources/.*?$")) {
            this.resourceTypeLabel.setVisible(false);
            this.resourceTypeFilter.setVisible(false);
            if (this.classChooser != null) {
                this.subTypeFilter.setVisible(true);
                this.subTypeFilter.add((Widget)this.classChooser);
            }
            this.statusFilter.setVisible(true);
            this.filterLabel.setVisible(true);
            this.statusLabel.setVisible(true);
            this.goButton.setVisible(true);
            this.wfLabel.setVisible(false);
            this.formControlLabel.setVisible(false);
        } else if (token.contains("myLaboratories")) {
            this.subTypeFilter.setVisible(true);
            this.curationButton.setVisible(false);
            this.saveButton.setVisible(false);
            this.editButton.setVisible(false);
            this.cancelButton.setVisible(false);
            this.publishButton.setVisible(false);
            this.copyResourceButton.setVisible(false);
            this.backToDraftButton.setVisible(false);
            this.withdrawButton.setVisible(false);
            this.statusFilter.setVisible(true);
            this.filterLabel.setVisible(true);
            this.statusLabel.setVisible(true);
            this.goButton.setVisible(true);
            this.wfLabel.setVisible(false);
            this.formControlLabel.setVisible(false);
        }
    }

    private boolean claimRequired(boolean hasOwner) {
        if (this.wfState.equals("Withdrawn") || "Withdrawn".equals(new WorkFlowConstants().getStatusType(this.wfState)) || this.wfState.equals("Published") || "Published".equals(new WorkFlowConstants().getStatusType(this.wfState))) {
            return false;
        }
        return !hasOwner;
    }
}

