package org.eaglei.datatools.client;

import java.util.List;

import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.UserCallback;
import org.eaglei.datatools.client.ui.HistoryRootPanel;
import org.eaglei.datatools.client.ui.MainPanel;
import org.eaglei.datatools.client.ui.TopPanel;
import org.eaglei.datatools.client.ui.WorkFlowConstants;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.FooterPanel;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DecoratedTabPanel;
import com.google.gwt.user.client.ui.RootPanel;

/**
 * This is the Entry point class, mainly responsible for creating the Top level
 * Tabs
 * 
 * @author pp101
 * 
 */
public class Datatools implements ClientRepositoryToolsManager.SessionListener {
	public static String	currentUser;
	final DecoratedTabPanel	tabPanel	= new DecoratedTabPanel();
	public static MainPanel	mainPanel;
	public static boolean isRefresh;
	private TopPanel topPanel = null;
	
	private static WorkFlowConstants wfc = new WorkFlowConstants();
	
	private boolean initialized = false;
	
	/**
	 * Entry point method
	 */ 
	public void onModuleLoad() {
		initialized = false;
		
		RootPanel footerSlot = RootPanel.get("footer_container");
        String version = footerSlot.getElement().getInnerText();
        footerSlot.getElement().setInnerText("");
        final FooterPanel footerPanel = new FooterPanel(version);
        footerSlot.add(footerPanel);
//		Window.addCloseHandler(new CloseHandler<Window>() {
//			@Override
//			public void onClose(CloseEvent<Window> event) {
//				DatatoolsCookies.removeCookies();
//				ClientRepositoryToolsManager.INSTANCE.logOut();
//			}		
//		});
		currentUser = DatatoolsCookies.getUserName();
		
		// If there are cookies, check that they're real by talking to the client manager.  If not, reset user & user URI to null.
		// Since userUri is necessarily a mutable local variable, do this by checking currentUser and *then* nulling userUri afterward.
		if (currentUser != null)
		{
			//Window.alert("Datatools current user: " + currentUser);
			//Window.alert("do we have a manager? " + (ClientRepositoryToolsManager.INSTANCE == null ? "no" : "yes"));
			try {
				ClientRepositoryToolsManager.INSTANCE.whoami(new UserCallback(){
					@Override
					public void onSuccess(String[] userInfo) {
						if (userInfo == null)
						{
							Log.debug("failed to get any user info from whoami");
							handleNotLoggedIn();
							initialize();
							return;
						}
						String user = userInfo[0];
						if (user == null)
						{
							Log.debug("did whoami; user null, removing cookies");
							handleNotLoggedIn();
							initialize();
							return;
						}
						
						if (! user.equals(currentUser))
						{
							Log.debug("did whoami; user not same as current user, removing cookies");
							handleNotLoggedIn();
							initialize();
							return;
						}
						
						Log.debug("did whoami: confirms signed in as " + user + "; had " + (userInfo.length - 3) + " workflow states");
						
						initialize();
						return;
					}

					@Override
					public void loginRequired() {
						Log.debug("did whoami; login required, removing cookies");
						
						handleNotLoggedIn();
						initialize();
						return;
					}
				});
			} catch (Exception e) {
				Log.warn("did whoami; exception thrown--setting user to null & removing cookies");
				Log.warn(e.getMessage());
				handleNotLoggedIn();
				initialize();
			}
			
		}
	
		else
		{
			//Window.alert("Datatools: no user; is initialized? " + initialized);
			if (! initialized)
			{
				initialize();
				return;
			}
		}
	}

	private void initialize() {
		initialized = true;
		
		String userUri = DatatoolsCookies.getUserUri();
		if (currentUser == null)
		{
			userUri = null;
		}
		
		if (topPanel == null)
		{
			topPanel = new TopPanel();
			RootPanel.get("header_container").add(topPanel);
		}
		
		mainPanel = new MainPanel();
		HistoryRootPanel.getInstance().add(mainPanel);
		if (userUri != null) {
			topPanel.onLogIn(currentUser, userUri);
			mainPanel.onLogIn(currentUser, userUri);
			//RootPanel.get("footer_container").add(new FooterPanel());
		}
		
//		 RootPanel footerSlot = RootPanel.get("footer_container");
//	        String version = footerSlot.getElement().getInnerText();
//	        footerSlot.getElement().setInnerText("");
//	        final FooterPanel footerPanel = new FooterPanel(version);
//	        footerSlot.add(footerPanel);
		
		ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
		if (!Window.Location.getHash().equals("")) { //  && (userUri != null)?
			isRefresh=true;
		}
	}

	private void handleNotLoggedIn() {
		currentUser = null;
		DatatoolsCookies.removeCookies();
		isRefresh = false;
		
		ClientRepositoryToolsManager.INSTANCE.logOut();
	}
		
	private void updateEnabledState() {
		
	}
	
	// TODO: have these affect whether the relevant UI elements are enabled or
	// not
	@Override
	public void onLogIn(String username, String userUri) {
		updateEnabledState();
	}
	
	@Override
	public void onLogOut() {
		Log.info("datatools logging out; redirecting to " + GWT.getModuleBaseURL());
		HistoryRootPanel.getInstance().changeDisplayByToken("", false);
		Window.Location.assign("");
	}
	
	public static boolean canUserChangeState(String currentWFState)
	{
		if (currentWFState == null)
			return false;
		
		String status = wfc.getStatusType(currentWFState);
		return ClientRepositoryToolsManager.INSTANCE.canEdit(currentWFState);
	}
	
	public static boolean canUserChangeState(EIInstance instance, String newWFState)
	{
		if (instance.getWFState() == null)
			return false;
		
		if (instance.getWFOwner() == null)
			return false;
			
		return canUserChangeState(instance.getWFState().toString(), newWFState);
	}
	
	public static boolean canUserChangeState(String currentWFState, String newWFState)
	{
		if ((currentWFState == null) || (newWFState == null))
			return false;
		
		String status = wfc.getStatusType(currentWFState);
		List<String> transitions = WorkFlowConstants.ALLOWED_TRANSITIONS.get(status);
		return ClientRepositoryToolsManager.INSTANCE.canEdit(currentWFState)
			&& transitions.contains(wfc.getStatusType(newWFState));
	}
}
