package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.List;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class EditWidgetCollection extends Composite {
	// TODO: style the vertical panel
	protected VerticalPanel widgetPanel = new VerticalPanel();
	protected List<EditWidget> editWidgets = new ArrayList<EditWidget>();

	protected EIInstance eiInstance;
	protected EIEntity propertyEntity;

	public EditWidgetCollection(EIInstance eiInstance, EIEntity propertyEntity) {
		initWidget(widgetPanel);
		this.eiInstance = eiInstance;
		this.propertyEntity = propertyEntity;
	}
	
	public EditWidgetCollection(EIInstance eiInstance, EIEntity propertyEntity, EditWidget original) {
		this(eiInstance, propertyEntity);
		addWidget(original);
	}
	
	public void addWithoutModifiers(final Widget radioButtonWidget) {
		widgetPanel.add(radioButtonWidget);
	}
	
	public void addWidget(final EditWidget newWidget) {
		addWidget(newWidget, false);
	}
	
	public void addWidget(final EditWidget newWidget, boolean skipPlusMinus) {
		final HorizontalPanel widgetWithDecorator = new HorizontalPanel();
		editWidgets.add(newWidget);
		widgetWithDecorator.add(newWidget);
		widgetPanel.add(widgetWithDecorator);
		if (skipPlusMinus)
			return;
		if (editWidgets.size() == 1) {
			//Log.info("adding " + newWidget.getClass().getName() + " with plus");
			Label addField = new Label("+");
			widgetWithDecorator.add(addField);
			newWidget.setShouldShowLabel(true);
			addField.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					addWidget(newWidget.duplicateBlank());
				}
			});
		} else {
			final Label minusField = new Label("-");
			widgetWithDecorator.add(minusField);
			newWidget.setShouldShowLabel(false);
			minusField.addClickHandler(new ClickHandler() {			
				@Override
				public void onClick(ClickEvent event) {
					newWidget.removeValue();
					widgetPanel.remove(widgetWithDecorator);
					editWidgets.remove(newWidget);
					minusField.removeFromParent();
				}
			});
		}
	}
}
