package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EISuperClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.PropertyCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstancesCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.LabelsCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.NewInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.SharedClassChooser;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * This is a utility class for creating form and form fields
 * 
 * @author pp101
 * 
 */
public class FormUtils {
	public String								formName;
	public EIURI								subType;
	public String								dialogFormName;
	public EIURI								dialogSubType;
	private boolean								isView;
	public boolean								isDialog;
	public SharedClassChooser<OntologyDropdown>	classChooser;
	public List<TextBox>						dataList;
	public List<ListBox>						objList;
	//public Map<EIEntity, Set<String>>			nonOntLiteralList;
	//public Map<EIEntity, Set<EIURI>>			nonOntResourceList;
	final VerticalPanel							formFieldsPanel;
	final VerticalPanel							dialogFieldsPanel;
	public boolean								isPhoneValid;
	public boolean								isEmailValid;
	public FormsPanel							frmPanel;

	protected interface TextFieldCallback {
		public void valueChanged(String oldValue, String newValue);
	}

	public FormUtils(FormsPanel frmPanel) {
		formName = "";
		subType = null;
		dialogFormName = "";
		dataList = new ArrayList<TextBox>();
		objList = new ArrayList<ListBox>();
		//		nonOntLiteralList = new HashMap<EIEntity, Set<String>>();
		//		nonOntResourceList = new HashMap<EIEntity, Set<EIURI>>();
		/*
		 * dataListDialog = new ArrayList<TextBox>(); objListDialog = new
		 * ArrayList<ListBox>();
		 */
		formFieldsPanel = new VerticalPanel();
		formFieldsPanel.setStyleName("formPanel");
		dialogFieldsPanel = new VerticalPanel();
		this.frmPanel = frmPanel;
		isPhoneValid = true;
		isEmailValid = true;
	}
	/**
	 * Creates a Text field from the given entity value is passed when the
	 * formType is 'edit'
	 * 
	 * @param entity
	 * @param value
	 */
	public VerticalPanel createTextField(final EIInstance instance, final EIEntity entity, final Set<String> values, final String propertyLabel, boolean isPresent, final TextFieldCallback callback) {
		final VerticalPanel vPanel = new VerticalPanel();
		final HorizontalPanel hPanel = new HorizontalPanel();
		vPanel.add(hPanel);
		Label label = new Label(propertyLabel);
		final Label errLabel = new Label();
		errLabel.setStyleName("errorMsg");
		label.setStyleName("formLabel");
		hPanel.add(label);
		if (values != null) {
			int item = 0;
			for (final String value : values) {
				final HorizontalPanel hp = new HorizontalPanel();
				Label l = new Label("");
				l.setStyleName("formLabel");
				final TextBox textBox = new TextBox();
				final Hidden oldValue = new Hidden();
				textBox.setStyleName("formText");
				if (!isDialog) {
					textBox.setValue(formatText(value));
					oldValue.setValue(formatText(value));
				}
				textBox.setName(entity.getURI() + "|" + entity.getLabel());
				if (isDialog)
					dataList.add(textBox);
				else
					dataList.add(textBox);
				textBox.addValueChangeHandler(new ValueChangeHandler<String>() {
					@Override
					public void onValueChange(ValueChangeEvent<String> event) {
						callback.valueChanged(oldValue.getValue(), event.getValue());
						oldValue.setValue(formatText(event.getValue()));
					}
				});
				if (propertyLabel.equalsIgnoreCase("phone number")) {
					textBox.setMaxLength(13);
					addPhoneValidations(propertyLabel, errLabel, textBox);
				} else if (propertyLabel.equalsIgnoreCase("email")) {
					addEmailValidations(propertyLabel, errLabel, textBox);
				}
				if (item > 0) {
					hp.add(l);
					hp.add(textBox);
					hp.add(oldValue);
					Label deleteField = new Label("-");
					hp.add(deleteField);
					deleteField.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent arg0) {
							callback.valueChanged(textBox.getValue(), null);
							vPanel.remove(hp);
							dataList.remove(textBox);
						}
					});
					vPanel.add(hp);
				} else {
					// Widget to add more fields for a particular type
					Label addField = new Label("+");
					addField.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent arg0) {
							VerticalPanel vtemp = createTextField(instance, entity, null, "", true, callback);
							HorizontalPanel hptem = (HorizontalPanel) vtemp.getWidget(0);
							final Label temperrLabel = new Label();
							temperrLabel.setStyleName("errorMsg");
							hptem.add(temperrLabel);
							TextBox txttemp = (TextBox) hptem.getWidget(1);
							if (propertyLabel.equalsIgnoreCase("phone number")) {
								txttemp.setMaxLength(13);
								addPhoneValidations(propertyLabel, temperrLabel, txttemp);
							} else if (propertyLabel.equalsIgnoreCase("email")) {
								addEmailValidations(propertyLabel, temperrLabel, txttemp);
							}
							vPanel.add(vtemp);
							vPanel.setStyleName("formFieldGroup");
						}
					});
					hPanel.add(textBox);
					hPanel.add(addField);
					hPanel.add(errLabel);
				}
				item++;
			}
		} else {
			final TextBox textBox = new TextBox();
			final Hidden oldValue = new Hidden();
			textBox.setStyleName("formText");
			hPanel.add(textBox);
			hPanel.add(oldValue);
			hPanel.add(errLabel);
			boolean isValid = true;
			textBox.addValueChangeHandler(new ValueChangeHandler<String>() {
				@Override
				public void onValueChange(ValueChangeEvent<String> event) {
					textBox.setValue(formatText(event.getValue()));
					textBox.setName(entity.getURI() + "|" + entity.getLabel());
					if (isDialog)
						dataList.add(textBox);
					else
						dataList.add(textBox);
					callback.valueChanged(oldValue.getValue(), event.getValue());
				}
			});
			if (propertyLabel.equalsIgnoreCase("phone number")) {
				// if errLabel contains text, the validation failed
				textBox.setMaxLength(13);
				addPhoneValidations(propertyLabel, errLabel, textBox);
			} else if (propertyLabel.equalsIgnoreCase("email")) {
				addEmailValidations(propertyLabel, errLabel, textBox);
			}
			// Only if validation from previous fields succeeds
			if (isValid && !isPresent) {
				// Widget to add more fields for a particular type
				if (!propertyLabel.equals("Term request")) {
					Label addField = new Label("+");
					hPanel.add(addField);
					addField.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent arg0) {
							vPanel.setStyleName("formFieldGroup");
							VerticalPanel vtemp = createTextField(instance, entity, values, "", true, callback);
							HorizontalPanel hptem = (HorizontalPanel) vtemp.getWidget(0);
							final Label temperrLabel = new Label();
							temperrLabel.setStyleName("errorMsg");
							hptem.add(temperrLabel);
							TextBox txttemp = (TextBox) hptem.getWidget(1);
							if (propertyLabel.equalsIgnoreCase("phone number")) {
								txttemp.setMaxLength(13);
								addPhoneValidations(propertyLabel, temperrLabel, txttemp);
							} else if (propertyLabel.equalsIgnoreCase("email")) {
								addEmailValidations(propertyLabel, temperrLabel, txttemp);
							}
							vPanel.add(vtemp);
						}
					});
				}
			} else {
				Label deleteField = new Label("-");
				if (!propertyLabel.equals("Term request")) {
					hPanel.add(deleteField);
					deleteField.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent arg0) {
							vPanel.remove(hPanel);
							if (isDialog)
								dataList.remove(textBox);
							else
								dataList.remove(textBox);
						}
					});
				}
			}
		}
		return vPanel;
	}
	private Label addPhoneValidations(String propertyLabel, final Label errLabel, TextBox textBox) {
		textBox.addKeyUpHandler(new KeyUpHandler() {
			@Override
			public void onKeyUp(KeyUpEvent event) {
				TextBox txtFeild = (TextBox) event.getSource();
				if (!Validations.OnlyPhoneFormat(txtFeild.getValue())) {
					//errLabel.setText("Only numbers are allowed in this feild");
					txtFeild.setText(txtFeild.getText().replace(txtFeild.getText().toCharArray()[txtFeild.getText().length() - 1] + "", ""));
					return;
					//isPhoneValid = false;
				}
				Validations.jsniPhoneValidation(txtFeild.getElement());
			}
		});
		return errLabel;
	}
	private Label addEmailValidations(String propertyLabel, final Label errLabel, TextBox textBox) {
		textBox.addBlurHandler(new BlurHandler() {
			@Override
			public void onBlur(BlurEvent event) {
				TextBox txtFeild = (TextBox) event.getSource();
				if (!Validations.IsEmailBox(txtFeild.getValue()) && !txtFeild.getValue().equals("")) {
					errLabel.setText("Only emails are allowed");
					isEmailValid = false;
				} else {
					errLabel.setText("");
					isEmailValid = true;
				}
			}
		});
		return errLabel;
	}
	public VerticalPanel createLabelforView(final EIEntity entity, final Set<String> values, String propertyLabel, boolean isPresent) {
		final VerticalPanel vPanel = new VerticalPanel();
		final HorizontalPanel hPanel = new HorizontalPanel();
		vPanel.add(hPanel);
		Label label = new Label(propertyLabel);
		label.setStyleName("formLabel");
		/*
		 * ClickHandler clickhandler = new ClickHandler() {
		 * 
		 * @Override public void onClick(ClickEvent event) {
		 * nonOntResourceList.remove(key)
		 * 
		 * 
		 * }
		 * 
		 * }
		 */
		int item = 0;
		if (values != null) {
			hPanel.add(label);
			for (final String value : values) {
				final HorizontalPanel hp = new HorizontalPanel();
				Label l = new Label("");
				l.setStyleName("formLabel");
				Anchor resourceURL = null; // For values that have external URIs
				Label valueField = new Label();
				valueField.setStyleName("formLabelValue");
				if (value.startsWith("www") || value.startsWith("http")) {
					resourceURL = new Anchor(formatText(value), formatText(value), "_blank");
				} else
					valueField.setText(formatText(value));
				if (item > 0) {
					hp.add(l);
					hp.add(resourceURL == null ? valueField : resourceURL);
					vPanel.add(hp);
				} else {
					hPanel.add(resourceURL == null ? valueField : resourceURL);
				}
				item++;
			}
		} else {
			hPanel.add(new Label(""));
		}
		return vPanel;
	}
	/**
	 * Creates a RadioButton
	 * 
	 * @param lbl
	 * @param uri
	 */
	public HorizontalPanel createRadioButon(final EIInstance instance, final EIEntity entity, String value) {
		HorizontalPanel hPanel = new HorizontalPanel();
		Label label = new Label(entity.getLabel());
		label.setStyleName("formLabel");
		CheckBox checkBox = new CheckBox();
		final TextBox textBox = new TextBox();
		textBox.setName(entity.getURI() + "|" + entity.getLabel());
		textBox.setValue("false");
		if (value != null) {
			checkBox.setValue(Boolean.valueOf(value));
			textBox.setValue(value);
		}
		hPanel.add(label);
		hPanel.add(checkBox);
		if (isView)
			checkBox.setEnabled(false);
		checkBox.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
			@Override
			public void onValueChange(ValueChangeEvent<Boolean> arg0) {
				textBox.setValue(arg0.getValue().toString());
				textBox.setName(entity.getURI() + "|" + entity.getLabel());
				dataList.add(textBox);
				Boolean oldValue = !(arg0.getValue());
				instance.replaceDatatypePropertyValue(entity, oldValue.toString(), arg0.getValue().toString());
			}
		});
		return hPanel;
	}
	/**
	 * Every form will have ' ' & 'Sub-Type' fields even though they are not
	 * defined in the ontology When the user selects an item from the Sub-type
	 * drop down, the properties displayed on the form will change depending
	 * upon the class of the selected item
	 * 
	 * @param EIClass
	 */
	public VerticalPanel displayDefaultFields(final EIInstance modelInstance, final EIClass eClass, final String nameValue, final String eagleIURI, final EIURI subTypeUri, final boolean isTypeView) {
		final VerticalPanel vPanel = new VerticalPanel();
		vPanel.setStyleName("formPanel");
		HorizontalPanel namepanel = new HorizontalPanel();
		if (!nameValue.equals(""))
			formName = nameValue;
		isView = isTypeView;
		TextBox name = new TextBox();
		name.setStyleName("formText");
		name.setValue(nameValue);
		if (isView) {
			name.setEnabled(false);
		}
		Label lb = new Label("Resource Name");
		lb.setStyleName("formLabel");
		Label required = new Label("*");
		required.setStyleName("fieldRequired");
		namepanel.add(required);
		namepanel.add(lb);
		namepanel.add(name);
		vPanel.add(namepanel);
		name.addValueChangeHandler(new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> newName) {
				modelInstance.setLabel(newName.getValue());
				Log.info("set instance name to " + newName.getValue());
				if (isDialog) {
					dialogFormName = newName.getValue();
				} else {
					formName = newName.getValue();
					Log.info("set form name to " + newName.getValue());
				}
			}
		});
		if (subTypeUri != null) {
			try {
				ClientOntologyToolsManager.INSTANCE.getEIClass(subTypeUri, new EIClassCallback() {
					@Override
					public void onFailure(String result) {
						Log.warn("failed to get ei class for " + subTypeUri);
					}
					@Override
					public void onSuccess(EIClass result) {
						Log.info("creating term widget for " + eClass + " with subclass " + result);
						vPanel.add(createTermWidget(modelInstance, eClass, result, null, null, null));
					}
				});
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			Log.info("creating term widget for " + eClass);
			vPanel.add(createTermWidget(modelInstance, eClass, null, null, null, true));
		}
		return vPanel;
	}
	/**
	 * 
	 * @param rangeList
	 * @param propertyEntity
	 * @param propertyValues
	 * @return
	 */
	public VerticalPanel handleObjectProperty(final EIInstance instance, final List<EIClass> rangeList, final EIEntity propertyEntity, final Set<EIURI> propertyValues) {
		final VerticalPanel vPanel = new VerticalPanel();
		if (propertyValues != null) {
			if (isView) {
				viewObjectProperty(propertyEntity, propertyValues, vPanel);
			} else { //Edit Form
				Label lbl = new Label(propertyEntity.getLabel());
				lbl.setStyleName("formLabel");
				vPanel.add(lbl);
				final List<EIClass> classList = new ArrayList<EIClass>();
				for (final EIURI uri : propertyValues) {
					try {
						ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new EIInstanceCallback() {
							@Override
							public void onSuccess(final EIInstance listValueInstance) {
								if (listValueInstance != null) {	
									EIClass listValueInstanceClass = listValueInstance.getInstanceClass();
									classList.add(listValueInstanceClass);
									if (listValueInstanceClass.hasSuperClass()) {
										ClientOntologyToolsManager.INSTANCE.getRootSuperClass(listValueInstanceClass, new EISuperClassCallback() {
											@Override
											public void onSuccess(EIClass range) {
												vPanel.add(createWidgetForEIResource(instance, range, propertyEntity, listValueInstance.getInstanceLabel(), ""));
											}
										});
									} else
										vPanel.add(createWidgetForEIResource(instance, listValueInstanceClass, propertyEntity, listValueInstance.getInstanceLabel(), ""));
								} else {
									ClientOntologyToolsManager.INSTANCE.getEIClass(uri, new EIClassCallback() {
										@Override
										public void onSuccess(final EIClass result) {
											ClientOntologyToolsManager.INSTANCE.getRootSuperClass(result, new EISuperClassCallback() {
												@Override
												public void onSuccess(EIClass range) {
													boolean addField = true;
													if (classList.contains(range))
														addField = false;
													classList.add(range);
													vPanel.add(createTermWidget(instance, range, result, propertyEntity, "", addField));
												}
											});
										}
										@Override
										public void onFailure(String result) {
											Log.warn("failed " + result);
										}
									});
								}
							}
							@Override
							public void loginRequired() {
								handleLoginRequired();
							}
						});
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
				// Needs to be inside a callback but not inside a list
				// Or just make a different widget to avoid this
				Timer timer = new Timer() {
				public void run() {
					for (final EIClass range : rangeList) {
						if (!classList.contains(range)) {
							if (range.isEagleIResource()) {
								vPanel.add(createWidgetForEIResource(instance, range, propertyEntity, "", ""));
							} else
								vPanel.add(createTermWidget(instance, range, null, propertyEntity, "", true));
						}
					}
				}
			};
			timer.schedule(2000); 

			}
		} else { //New Form
			VerticalPanel vp = new VerticalPanel();
			String label = "";
			for (EIClass range : rangeList) {
				if (rangeList.indexOf(range) == 0)
					label = propertyEntity.getLabel();
				else
					label = "";
				if (range.isEagleIResource())
					vp.add(createWidgetForEIResource(instance, range, propertyEntity, "", label));
				else
					vp.add(createTermWidget(instance, range, null, propertyEntity, label, true));
			}
			vPanel.add(vp);
		}
		return vPanel;
	}
	private void viewObjectProperty(final EIEntity propertyEntity,
			final Set<EIURI> propertyValues, final VerticalPanel vPanel) {
		final List<EIURI> list = new ArrayList<EIURI>();
		list.addAll(propertyValues);
		/*
		 * ClientRepositoryToolsManager.INSTANCE.retrieveUriLabels(list,
		 * new UriLabelsCallback() {
		 * 
		 * @Override public void onSuccess(Map<EIURI, String> labelMap)
		 * { for (final EIURI uri : list) { String propLabel; if
		 * (list.indexOf(uri) > 0) { propLabel = ""; } else propLabel =
		 * propertyEntity.getLabel(); HorizontalPanel hPanel = new
		 * HorizontalPanel();
		 * 
		 * Label label = new Label(propLabel);
		 * label.setStyleName("formLabel"); hPanel.add(label); Anchor a
		 * = new Anchor(labelMap.get(uri)); hPanel.add(a);
		 * a.addClickHandler(new ClickHandler() {
		 * 
		 * @Override public void onClick(ClickEvent arg0) { try {
		 * ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new
		 * EIInstanceCallback() {
		 * 
		 * @Override public void loginRequired() {
		 * handleLoginRequired(); }
		 * 
		 * @Override public void onSuccess(EIInstance eiInstance) {
		 * if(eiInstance!=null){ MainPanel.dataPanel.clear();
		 * MainPanel.instanceUri =
		 * eiInstance.getInstanceURI().toString(); FilterPanel fp = new
		 * FilterPanel(FormsPanel.getWFStateString(eiInstance),
		 * (eiInstance.getWFOwner() != null));
		 * MainPanel.dataPanel.add(fp); fp.editButton.setVisible(true);
		 * fp.saveButton.setVisible(false);
		 * MainPanel.dataPanel.add(frmPanel
		 * .generateViewForm(eiInstance)); for (int i = 0; i <
		 * LeftListPanel.resourcesTable.getRowCount(); i++) {
		 * LeftListPanel
		 * .resourcesTable.getRowFormatter().setStyleName(i,
		 * "panelNotSelected"); } for (int i = 0; i <
		 * LeftListPanel.labsTable.getRowCount(); i++) {
		 * LeftListPanel.labsTable.getRowFormatter().setStyleName(i,
		 * "panelNotSelected"); } } else {
		 * Window.open("http://search.eagle-i.net/model/#t="
		 * +uri.toString(),"",""); } } }); } catch (Exception e) {
		 * e.printStackTrace(); } } });
		 * 
		 * 
		 * vPanel.add(hPanel); }
		 * 
		 * } });
		 */
		for (final EIURI uri : list) {
			ClientRepositoryToolsManager.INSTANCE.retrieveLabel(uri, new ResultsCallback() {
				@Override
				public void onSuccess(String[] arg0) {
					// Deliberate no-op
				}
				@Override
				public void onSuccess(String arg0) {
					String propLabel;
					if (list.indexOf(uri) > 0) {
						propLabel = "";
					} else
						propLabel = propertyEntity.getLabel();
					HorizontalPanel hPanel = new HorizontalPanel();
					Label label = new Label(propLabel);
					label.setStyleName("formLabel");
					hPanel.add(label);
					Anchor a = new Anchor(arg0);
					hPanel.add(a);
					a.addClickHandler(new ClickHandler() {
						@Override
						public void onClick(ClickEvent arg0) {
							try {
								ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new EIInstanceCallback() {
									@Override
									public void loginRequired() {
										handleLoginRequired();
									}
									@Override
									public void onSuccess(EIInstance eiInstance) {
										if (eiInstance != null) {
											MainPanel.dataPanel.clear();
											MainPanel.instanceUri = eiInstance.getInstanceURI().toString();
											FilterPanel fp = new FilterPanel(WidgetUtils.getWFStateString(eiInstance), (eiInstance.getWFOwner() != null));
											MainPanel.dataPanel.add(fp);
											fp.editButton.setVisible(true);
											fp.saveButton.setVisible(false);
											MainPanel.dataPanel.add(frmPanel.generateViewForm(eiInstance));
											for (int i = 0; i < LeftListPanel.resourcesTable.getRowCount(); i++) {
												LeftListPanel.resourcesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
											}
											for (int i = 0; i < LeftListPanel.labsTable.getRowCount(); i++) {
												LeftListPanel.labsTable.getRowFormatter().setStyleName(i, "panelNotSelected");
											}
										} else {
											Window.open("http://search.eagle-i.net/model/#t=" + uri.toString(), "", "");
										}
									}
								});
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					});
					vPanel.add(hPanel);
				}
				@Override
				public void loginRequired() {
					handleLoginRequired();
				}
			});
		}
	}
	/**
	 * Gets the class properties and displays appropriate UI field based on the
	 * property type
	 * 
	 * @param eClass
	 * @param VerticalPanel
	 *            - if this is the main formPanel pass null, if it is a 'create
	 *            new' term widget panel, pass the panel
	 * @return
	 */
	public VerticalPanel displayFormFields(final EIClass eClass, final EIInstance instance, boolean isTypeView) {
		isView = isTypeView;
		final Map<EIEntity, Set<String>> dataTypeProperties = instance.getDatatypeProperties();
		final Map<EIEntity, Set<EIURI>> objectTypeProperties = instance.getObjectProperties();
		if (isDialog) {
			dialogFieldsPanel.clear();
		} else {
			formFieldsPanel.clear();
			// Priti added
			dataList.clear();
			objList.clear();
		}
		final VerticalPanel vp = new VerticalPanel();
		//		MainPanel.filterPanel.saveButton.setEnabled(false);
		DeferredCommand.addCommand(new Command() {
			@Override
			public void execute() {
				ClientOntologyToolsManager.INSTANCE.getProperties(eClass, new PropertyCallback() {
					@Override
					public void onSuccess(EIClass result) {
						List<EIProperty> propList = result.getProperties();
						for (final EIProperty property : propList) {
							if (property instanceof EIDatatypeProperty) {
								if (((EIDatatypeProperty) property).getTypeLabel().equals("boolean")) {
									Set<String> values = null;
									if (dataTypeProperties != null && dataTypeProperties.containsKey(property.getEntity())) {
										values = dataTypeProperties.get(property.getEntity());
									}
									if (!isView) {
										vp.add(createRadioButon(instance, property.getEntity(), values == null ? "false" : values.iterator().next()));
									} else {
										if (values != null && values.iterator().next().equals("true"))
											vp.add(createRadioButon(instance, property.getEntity(), "true"));
									}
								} else {
									Set<String> values = null;
									if (dataTypeProperties != null && dataTypeProperties.containsKey(property.getEntity())) {
										values = dataTypeProperties.get(property.getEntity());
									}
									if (!isView)
										vp.add(createTextField(instance, property.getEntity(), values, property.getEntity().getLabel(), false, new TextFieldCallback() {
											@Override
											public void valueChanged(String oldValue, String newValue) {
												instance.replaceDatatypePropertyValue(property.getEntity(), oldValue, newValue);
											}
										}));
									else
										vp.add(createLabelforView(property.getEntity(), values, property.getEntity().getLabel(), false));
								}
							} else if (property instanceof EIObjectProperty) {
								Set<EIURI> values = null;
								if (objectTypeProperties != null && objectTypeProperties.containsKey(property.getEntity())) {
									values = objectTypeProperties.get(property.getEntity());
								}
								vp.add(handleObjectProperty(instance, ((EIObjectProperty) property).getRangeList(), property.getEntity(), values));
							}
						}
						// add hard-coded datatype properties
						/*
						 * Label = Comments property =
						 * http://www.w3.org/2000/01/rdf-schema#comments Label =
						 * Curator's comments property =
						 * http://purl.obolibrary.org/obo/IAO_0000232
						 */
						EIEntity comments = EIEntity.create(WorkFlowConstants.COMMENTS, WorkFlowConstants.COMMENTS_LABEL);
						EIEntity curatorComments = EIEntity.create(WorkFlowConstants.CURATOR_NOTE, WorkFlowConstants.CURATOR_LABEL);
						if (!isView) {
							if (instance != null) {
								vp.add(createTextArea(instance, comments, instance.getNonOntologyLiteralProperty(comments)));
								vp.add(createTextArea(instance, curatorComments, instance.getNonOntologyLiteralProperty(curatorComments)));
							} else {
								Window.alert("null instance!");
							}
						}
					}
				});
			}
		});
		if (isDialog) {
			dialogFieldsPanel.add(vp);
			return dialogFieldsPanel;
		} else {
			formFieldsPanel.add(vp);
			return formFieldsPanel;
		}
	}
	private String getEntityLabel(EIEntity entity, Map<EIEntity, String> retrievedLabels) {
		final String retrieved = retrievedLabels.get(entity);
		return ((retrieved == null || retrieved.equals("")) ? entity.getLabel() : retrieved);
	}
	/**
	 * Displays the properties that are removed from the new Ontology but still
	 * have some values associated
	 * 
	 * @param instance
	 * @return
	 */
	public DisclosurePanel displayNonOntologyProperties(final EIInstance instance) {
		DisclosurePanel mainPanel = new DisclosurePanel("Information for data curators");
		final VerticalPanel metaPanel = new VerticalPanel();
		final VerticalPanel otherPanel = new VerticalPanel();
		final VerticalPanel vp = new VerticalPanel();
		HorizontalPanel h = new HorizontalPanel();
		h.setStyleName("formPanel");
		Label uriLabel = new Label("eagle-i unique ID");
		uriLabel.setStyleName("formLabel");
		Anchor id = new Anchor(instance.getInstanceURI().toString(), instance.getInstanceURI().toString(), "_blank");
		h.add(uriLabel);
		h.add(id);
		vp.add(h);
		vp.add(metaPanel);
		vp.add(otherPanel);
		metaPanel.setStyleName("formPanel");
		otherPanel.setStyleName("formPanel");
		final Map<EIEntity, Set<String>> nonOntLiteralList = instance.getNonOntologyLiteralProperties();
		final Map<EIEntity, Set<EIURI>> nonOntResourceList = instance.getNonOntologyResourceProperties();
		if (isView) {
			Label metaProps = new Label("Metadata properties:");
			metaProps.setStyleName("nonOntologyPropertyLabel");
			metaPanel.add(metaProps);
			final List<EIEntity> entityList = new ArrayList<EIEntity>();
			final Map<EIURI, EIEntity> valuesEntityMap = new HashMap<EIURI, EIEntity>();
			entityList.addAll(instance.getReadOnlyLiteralProperties().keySet());
			entityList.addAll(instance.getReadOnlyResourceProperties().keySet());
			entityList.addAll(nonOntResourceList.keySet());
			entityList.addAll(nonOntLiteralList.keySet());
			/*for (final EIEntity entity : nonOntResourceList.keySet()) {
				if (!instance.getReadOnlyResourceProperties().containsKey(entity)) {
					Set<EIURI> uriList = nonOntResourceList.get(entity);
					for (final EIURI uri : uriList) {
						EIEntity valueEntity = EIEntity.create(uri, "");
						valuesEntityMap.put(uri, valueEntity);
						entityList.add(valueEntity);
					}
				}
			} */
			ClientRepositoryToolsManager.INSTANCE.retrieveLabels(entityList, new LabelsCallback() {
				@Override
				public void onSuccess(Map<EIEntity, String> labelMap) {
					// handle read-only literals
					for (EIEntity entity : instance.getReadOnlyLiteralProperties().keySet()) {
						final Set<String> set = new HashSet<String>();
						set.add(instance.getReadOnlyLiteralProperties().get(entity));
						metaPanel.add(createLabelforView(entity, set, getEntityLabel(entity, labelMap), false));
					}
					// handle read-only resources
					for (final EIEntity entity : instance.getReadOnlyResourceProperties().keySet()) {
						final HorizontalPanel hp = new HorizontalPanel();
						final Label l = new Label(entity.getLabel());
						l.setStyleName("formLabel");
						Anchor val = new Anchor(getEntityLabel(entity, labelMap), instance.getReadOnlyResourceProperties().get(entity).toString(), "_blank");
						hp.add(l);
						hp.add(val);
						metaPanel.add(hp);
					}
					Label otherProps = new Label("Other properties:");
					otherProps.setStyleName("nonOntologyPropertyLabel");
					otherPanel.add(otherProps);
					for (EIEntity entity : nonOntLiteralList.keySet()) {
						otherPanel.add(createLabelforView(entity, nonOntLiteralList.get(entity), getEntityLabel(entity, labelMap), false));
					}
					for (final EIEntity entity : nonOntResourceList.keySet()) {
						if (!instance.getReadOnlyResourceProperties().containsKey(entity)) {
							Set<EIURI> uriList = nonOntResourceList.get(entity);
							final HorizontalPanel hp = new HorizontalPanel();
							for (final EIURI uri : uriList) {
								Label l = new Label(getEntityLabel(entity, labelMap));
								l.setStyleName("formLabel");
								Anchor val = new Anchor(getEntityLabel(valuesEntityMap.get(uri), labelMap), uri.toString(), "_blank");
								hp.add(l);
								hp.add(val);
							}
							otherPanel.add(hp);
						}
					}
				}
			});
		} else {
			for (final EIEntity entity : nonOntLiteralList.keySet()) {
				if (!instance.getReadOnlyLiteralProperties().containsKey(entity) && (!entity.getURI().toString().equals(WorkFlowConstants.COMMENTS) && !entity.getURI().toString().equals(WorkFlowConstants.CURATOR_NOTE))) {
					HorizontalPanel hp = new HorizontalPanel();
					Label lbl = new Label(entity.getLabel());
					lbl.setStyleName("formLabel");
					TextBox t = new TextBox();
					t.setStyleName("formText");
					Set<String> values = nonOntLiteralList.get(entity);
					if (values != null) {
						String value = values.iterator().next();
						t.setValue(value);
					}
					final String oldValue = t.getValue().equals("") ? null : t.getValue();
					t.addValueChangeHandler(new ValueChangeHandler<String>() {
						@Override
						public void onValueChange(ValueChangeEvent<String> arg0) {
							Set<String> set = nonOntLiteralList.get(entity);
							set.clear();
							set.add(arg0.getValue());
							Log.info("replacing " + entity + " old " + oldValue + " new " + arg0.getValue());
							instance.replaceNonOntologyLiteralProperty(entity, oldValue, arg0.getValue());
						}
					});
					hp.add(lbl);
					hp.add(t);
					otherPanel.add(hp);
				}
			}
			// TODO: make sure this fills in right
			for (final EIEntity entity : nonOntResourceList.keySet()) {
				if (!instance.getReadOnlyResourceProperties().containsKey(entity)) {
					for (EIURI uri : nonOntResourceList.get(entity)) {
						final HorizontalPanel hp = new HorizontalPanel();
						final Label l = new Label(entity.getLabel());
						l.setStyleName("formLabel");
						TextBox t = new TextBox();
						t.setStyleName("formText");
						t.setValue(uri.toString());
						final EIURI oldValue = uri;
						hp.add(l);
						hp.add(t);
						t.addValueChangeHandler(new ValueChangeHandler<String>() {
							@Override
							public void onValueChange(ValueChangeEvent<String> arg0) {
								Set<EIURI> set = nonOntResourceList.get(entity);
								set.clear();
								final EIURI newValue = EIURI.create(arg0.getValue());
								set.add(newValue);
								instance.replaceNonOntologyResourcePropertyValue(entity, oldValue, newValue);
							}
						});
						otherPanel.add(hp);
					}
				}
			}
		}
		mainPanel.add(vp);
		return mainPanel;
	}
	/**
	 * Creates a text area for adding Comments & Curators Comments
	 * 
	 * @param entity
	 * @param values
	 * @return
	 */
	private HorizontalPanel createTextArea(final EIInstance instance, final EIEntity entity, final Set<String> values) {
		Log.info("creating text area for " + entity.getLabel() + " with " + (values == null ? "0" : values.size()) + " values");
		HorizontalPanel hp = new HorizontalPanel();
		final Label lbl = new Label(entity.getLabel());
		lbl.setStyleName("formLabel");
		if (entity.getURI().toString().equals(WorkFlowConstants.CURATOR_NOTE)) {
			lbl.setText(WorkFlowConstants.CURATOR_LABEL);
		}
		if (entity.getURI().toString().equals(WorkFlowConstants.COMMENTS)) {
			lbl.setText(WorkFlowConstants.COMMENTS_LABEL);
		}
		final TextArea ta = new TextArea();
		if (values != null) {
			for (String value : values) {
				if (!isDialog) {
					ta.setText(value);
					Log.info(" interim text area value" + ta.getValue());
				}
			}
			Log.info("final text area value" + ta.getValue());
		}
		ta.addValueChangeHandler(new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> event) {
				if (values == null) { // For New form
					TextBox tb = new TextBox();
					tb.setValue(event.getValue());
					tb.setName(entity.getURI() + "|" + entity.getLabel());
					boolean found = false;
					for (TextBox t : dataList) {
						if (t.getName().equals(tb.getName())) {
							dataList.remove(t);
							dataList.add(tb);
							found = true;
							String oldValue = values.iterator().next();
							//Log.info("replacing " + entity + " " + oldValue + " with " + event.getValue());
							//instance.replaceNonOntologyLiteralProperty(entity, oldValue, event.getValue());
							break;
						}
					}
					if (!found) {
						dataList.add(tb);
					}
					instance.addNonOntologyLiteralProperty(entity, event.getValue());
				} else { //For edit form
					Set<String> values = instance.getNonOntologyLiteralProperty(entity);
					if (values.size() > 0) {
						String oldValue = new ArrayList<String>(values).get(0);
						Log.info("replacing " + oldValue + " with " + event.getValue());
						instance.replaceNonOntologyLiteralProperty(entity, oldValue, event.getValue());
					} else {
						instance.addNonOntologyLiteralProperty(entity, event.getValue());
					}
					values.clear();
					values.add(event.getValue());
				}
			}
		});
		hp.add(lbl);
		hp.add(ta);
		return hp;
	}
	/**
	 * Creates a Term widget that displays the subclasses in a hierarchical form
	 * in a drop down list
	 * 
	 * @param rangeURI
	 * @param propertyEntity
	 * @return
	 */
	// Check for Resource URI and sub-type uri. If same no superclass
	public VerticalPanel createTermWidget(final EIInstance instance, final EIClass range, final EIClass selectedClass, final EIEntity propertyEntity, String label, Boolean isAddfield) {
		final HorizontalPanel hPanel = new HorizontalPanel();
		final VerticalPanel vPanel = new VerticalPanel();
		Label pLabel = new Label();
		final ListBox lb = new ListBox();
		final Hidden oldValue = new Hidden();
		if (propertyEntity != null) {
			if (label == null)
				pLabel.setText(propertyEntity.getLabel());
			else
				pLabel.setText(label);
			lb.setName(propertyEntity.getURI() + "|" + propertyEntity.getLabel());
		} else
			// Special case for Sub-type field
			pLabel.setText("Type");
		pLabel.setStyleName("formLabel");
		classChooser = new SharedClassChooser<OntologyDropdown>(new OntologyDropdown());
		classChooser.setTextBoxStyle("textSuggest");
		if (!isView) {
			hPanel.add(pLabel);
			if (!isDialog && propertyEntity == null) {
				if (selectedClass != null)
					subType = selectedClass.getEntity().getURI();
				else
					subType = range.getEntity().getURI();
			}
			classChooser.setClass(range, false);
			// If the value is not selected from the term widget list, set the default value to parent type
			if (propertyEntity != null) { // Not for sub-types
				if (selectedClass != null) {
					classChooser.setSelectedEntity(selectedClass.getEntity());
					lb.addItem(selectedClass.getEntity().getURI().toString());
					oldValue.setValue(selectedClass.getEntity().getURI().toString());
				} else {
					lb.addItem(range.getEntity().getURI().toString());
				}
			} else if (selectedClass != null) // For Subtype field in new form
				classChooser.setSelectedEntity(selectedClass.getEntity());
			hPanel.add(classChooser);
		} else {
			if (selectedClass != null) {
				hPanel.add(pLabel);
				classChooser.setClass(selectedClass, false);
				hPanel.add(classChooser);
			}
			classChooser.setEnabled(false);
		}
		classChooser.addSelectionListener(new EntitySelectionListener() {
			@Override
			public void onSelection(final EIEntity selectedEntity) {
				if (!isView) {
					if (propertyEntity != null) {
						if (lb.getItemCount() > 0)
							lb.removeItem(0);
						lb.addItem(selectedEntity.getURI().toString());
						objList.add(lb);
						;
						 if ((oldValue.getValue() == null) || (oldValue.getValue().equals(""))) {
                             instance.addObjectProperty(makeEntityFromWidgetName(lb.getName()), selectedEntity.getURI());
	                     }
	                     else {
	                    	 instance.replaceObjectPropertyValue(makeEntityFromWidgetName(lb.getName()), EIURI.create(oldValue.getValue()), selectedEntity.getURI());
	                     }		
						 oldValue.setValue(selectedEntity.getURI().toString());
					} else { // Null propertyEntity => setting instance type
						if (isDialog) {
							dialogFieldsPanel.clear();
							dialogSubType = selectedEntity.getURI();
						} else {
							formFieldsPanel.clear();
							subType = selectedEntity.getURI();
						}
						Log.info("setting instance type for " + instance.getInstanceLabel() + " to " + selectedEntity);
						// TODO: don't do this here; call updateInstanceType in onSuccess instead, assuming we can ditch the irrelevant properties now
						instance.setInstanceType(selectedEntity);
						ClientOntologyToolsManager.INSTANCE.getEIClass(selectedEntity.getURI(), new EIClassCallback() {
							@Override
							public void onFailure(String result) {
								Log.warn(result);
							}
							@Override
							public void onSuccess(EIClass result) {
								Log.info("setting class on " + instance.getInstanceLabel() + " to " + result);
								instance.setInstanceClass(result);
								displayFormFields(result, instance, false);
							}
						});
					}
				}
			}
		});
		final EIEntity termRequestEntity = EIEntity.create("http://eagle-i.org/ont/datatools/1.0/has_term_request", "has term request");
		if (!isView) {
			hPanel.add(createTextField(instance, termRequestEntity, null, "Term request", false, new TextFieldCallback() {
				@Override
				public void valueChanged(String oldValue, String newValue) {
					// add because term requests are always cumulative
					instance.addNonOntologyLiteralProperty(termRequestEntity, newValue);
				}
			}));
			if (propertyEntity != null) {
				Label addNew = new Label("+");
				addNew.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent arg0) {
						vPanel.setStyleName("formFieldGroup");
						vPanel.add(createTermWidget(instance, range, selectedClass, propertyEntity, "", false));
					}
				});
				Label removeItem = new Label("-");
				removeItem.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent arg0) {
						vPanel.remove(hPanel);
						objList.remove(lb);
						instance.replaceObjectPropertyValue(makeEntityFromWidgetName(lb.getName()), EIURI.create(oldValue.getValue()), null);
					}
				});
				if (!isAddfield)
					hPanel.add(removeItem);
				else
					hPanel.add(addNew);
			}
		}
		vPanel.add(hPanel);
		return vPanel;
	}
	/**
	 * If the property class is an eagle-i resource, then this method is called
	 * to craete a drop down list populated with data obtained by querying the
	 * instances
	 * 
	 * @param rangeURI
	 * @param propertyEntity
	 * @param propertyValue
	 * @return
	 */
	private VerticalPanel createWidgetForEIResource(final EIInstance instance, final EIClass range, final EIEntity propertyEntity, final String propertyValue, final String propLabel) {
		final HorizontalPanel hPanel = new HorizontalPanel();
		final VerticalPanel vp = new VerticalPanel();
		final ListBox subClassList = new ListBox();
		subClassList.setWidth("70");
		subClassList.addItem("<select>", null);
		subClassList.addItem("<create new>", null);
		final Label lbl = new Label(propLabel);
		lbl.setStyleName("formLabel");
		final TextBox valueBox = new TextBox();
		valueBox.setStyleName("formText");
		
		final Hidden oldValue = new Hidden();
		
		if ("".equals(propertyValue)) {
			valueBox.setStyleName("textSuggest");
			valueBox.setValue(range.getEntity().getLabel());
		} else {
			valueBox.setValue(propertyValue);
		}
			
		valueBox.addValueChangeHandler(new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> arg0) {
				boolean itemFound = false;
				for (int i = 0; i < subClassList.getItemCount(); i++) {
					if (arg0.getValue().equals(subClassList.getItemText(i))) {
						itemFound = true;
						break;
					}
				}
				if (!itemFound) {
					Window.alert(WorkFlowConstants.NOT_IN_LIST);
					valueBox.setFocus(true);
				}
			}
		});
		subClassList.setName(propertyEntity.getURI() + "|" + propertyEntity.getLabel());
		objList.add(subClassList);
		oldValue.setValue(subClassList.getValue(subClassList.getSelectedIndex()));
		hPanel.setSpacing(25);
		final Anchor link = new Anchor();
		if (!isView) {
			hPanel.add(lbl);
			hPanel.add(valueBox);
			hPanel.add(subClassList);
			//hPanel.add(link);
			final Label addField = new Label("+");
			addField.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent arg0) {
					vp.setStyleName("formFieldGroup");
					vp.add(createWidgetForEIResource(instance, range, propertyEntity, propertyValue, null));
				}
			});
			final Label removeField = new Label("-");
			removeField.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent arg0) {
					EIURI removeValue = EIURI.create(subClassList.getValue(subClassList.getSelectedIndex()));
					vp.remove(hPanel);
					objList.remove(subClassList);
					// TODO: right?
					Log.info("removing object property value for " + propertyEntity + " removed value " + removeValue);
					instance.replaceObjectPropertyValue(propertyEntity, removeValue, null);
				}
			});
			if (propLabel != null)
				hPanel.add(addField);
			else
				hPanel.add(removeField);
		} else {
			if (!propertyValue.equals("")) {
				Label label = new Label(propLabel);
				label.setStyleName("formLabel");
				hPanel.add(label);
				hPanel.add(new Label(propertyValue));
			}
		}
//		link.setHTML("Create new");
//		link.setStyleName("formText");
//		link.addClickHandler(new ClickHandler() {
//			@Override
//			public void onClick(ClickEvent arg0) {
//				frmPanel.onCreateNewClicked(instance, propertyEntity, range, subClassList, valueBox);
//			}
//		});
		ClientRepositoryToolsManager.INSTANCE.getResourcesOfClass(MainPanel.userUri, range.getEntity().getURI(), new EIInstancesCallback() {
			public void onSuccess(final List<EIInstance> result) {
				for (EIInstance valueInstance : result) {
					String instanceLabel = valueInstance.getEntity().getLabel();
					// TODO use URIs instead of labels
					if ((range.getEntity().getLabel().equalsIgnoreCase("laboratory") || range.getEntity().getLabel().equalsIgnoreCase("core laboratory")) && frmPanel.labUri.equals(valueInstance.getInstanceURI().toString())) {
						subClassList.clear();
						subClassList.addItem(instanceLabel, valueInstance.getInstanceURI().toString());
						subClassList.setEnabled(false);
						valueBox.setText(instanceLabel);
						valueBox.setEnabled(false);
						if (instance.getObjectProperty(propertyEntity) == null || (instance.getObjectProperty(propertyEntity).size() == 0)) {
							instance.addObjectProperty(propertyEntity, valueInstance.getInstanceURI());
						}
					} else {
						subClassList.addItem(instanceLabel + " <" + valueInstance.getInstanceType().getLabel() + ">", valueInstance.getInstanceURI().toString());
						if (instanceLabel.equals(propertyValue))
							subClassList.setSelectedIndex(subClassList.getItemCount() - 1);
					}
				}
				if ((range.getEntity().getLabel().equalsIgnoreCase("laboratory") || range.getEntity().getLabel().equalsIgnoreCase("core laboratory")) && (instance.getObjectProperty(propertyEntity).size() > 0)) {
					subClassList.setEnabled(false);
					valueBox.setEnabled(false);
				}
			}
			@Override
			public void loginRequired() {
				handleLoginRequired();
			}
		});
		subClassList.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				final int index = subClassList.getSelectedIndex();
				subClassList.clear();
				ClientRepositoryToolsManager.INSTANCE.getResourcesOfClass(MainPanel.userUri, range.getEntity().getURI(), new EIInstancesCallback() {
					public void onSuccess(final List<EIInstance> result) {
						subClassList.addItem("<select>", null);
						subClassList.addItem("<create new>", null);
						for (EIInstance instance : result) {
							String instanceLabel = instance.getEntity().getLabel();
							subClassList.addItem(instanceLabel + " <" + instance.getInstanceType().getLabel() + ">", instance.getInstanceURI().toString());
							if (instanceLabel.equals(propertyValue))
								subClassList.setSelectedIndex(subClassList.getItemCount() - 1);
						}
						subClassList.setSelectedIndex(index);
						if ((oldValue.getValue() == null) || (oldValue.getValue().equals(""))) {
                            instance.addObjectProperty(makeEntityFromWidgetName(subClassList.getName()), EIURI.create(subClassList.getValue(subClassList.getSelectedIndex())));
	                    }
	                    else {
	                    	 instance.replaceObjectPropertyValue(makeEntityFromWidgetName(subClassList.getName()), EIURI.create(oldValue.getValue()),  EIURI.create(subClassList.getValue(subClassList.getSelectedIndex())));
	                     }
						oldValue.setValue(subClassList.getValue(subClassList.getSelectedIndex()));
					}
					@Override
					public void loginRequired() {
						handleLoginRequired();
					}
				});
			}
		});
		subClassList.addChangeHandler(new ChangeHandler() {
			@Override
			public void onChange(ChangeEvent arg0) {
				doOnChange(instance, range, propertyEntity, propertyValue, subClassList, valueBox, oldValue);
			}
		});
		vp.add(hPanel);
		return vp;
	}
	protected String getUriForValue(ListBox listBox, String oldValue) {
		Log.info("  list box length " + listBox.getItemCount());
		for (int i = 0; i < listBox.getItemCount(); i++) {
			if (listBox.getItemText(i).startsWith(oldValue)) {
				Log.info("  old value " + listBox.getValue(i));
				return listBox.getValue(i);
			}
		}
		Log.info("  failed to find " + oldValue);
		return "";
	}
	/**
	 * Creates a popup window to create a new resource
	 * 
	 * @param range
	 * @param propertyValue
	 * @param subClassList
	 */
	// TODO: need to clean this up (move it out? merge with forms panel?) 
	public void createDialog(final EIInstance parentInstance, final EIEntity property, final EIClass range, final ListBox subClassList, final TextBox textBox, final Hidden oldValue) {
		final HorizontalPanel hpanel = new HorizontalPanel();
		final PopupPanel window = new PopupPanel();
		final VerticalPanel vPanel = new VerticalPanel();
		final Button save = new Button("Save");
		final Button closeButton = new Button("Close");
		window.setModal(true);
		isDialog = true;
		ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(range.getEntity().getURI(), new EIInstanceCallback() {
			@Override
			public void onSuccess(EIInstance newInstance) {
				if (newInstance == null) {
					Log.warn("new instance is null!");
					return;
				}
				Log.info("forms panel got dialog EIInstance for: " + newInstance.getInstanceClass());
				vPanel.add(displayDefaultFields(newInstance, newInstance.getInstanceClass(), "", "", null, false));
				vPanel.add(displayFormFields(newInstance.getInstanceClass(), newInstance, false));
				DeferredCommand.addCommand(new Command() {
					@Override
					public void execute() {
						hpanel.add(save);
						hpanel.add(closeButton);
						vPanel.add(hpanel);
					}
				});
			}
			@Override
			public void loginRequired() {
				handleLoginRequired();
			}
		});
		closeButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				window.hide();
				if (subClassList.getItemText(subClassList.getSelectedIndex()).equals("<create new>")) {
					for (int i = 0; i < subClassList.getItemCount(); i++) {
						if (subClassList.getItemText(i).startsWith(textBox.getValue())) {
							subClassList.setSelectedIndex(i);
							break;
						}
					}
				}
			}
		});
		save.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				try {
					EIURI uri = range.getEntity().getURI();
					if (dialogSubType != null)
						uri = dialogSubType;
					ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(uri, new EIInstanceCallback() {
						@Override
						public void onSuccess(final EIInstance instance) {
							instance.setLabel(dialogFormName);
							Map<EIEntity, Set<String>> dataMap = new HashMap<EIEntity, Set<String>>();
							for (TextBox tb : dataList) {
								String name = tb.getName();
								EIEntity entity = makeEntityFromWidgetName(name);
								if (dataMap.containsKey(entity)) {
									Set<String> st = dataMap.get(entity);
									st.add(tb.getText());
								} else {
									Set<String> st = new HashSet<String>();
									st.add(tb.getText());
									dataMap.put(entity, st);
								}
							}
							for (EIEntity entity : dataMap.keySet()) {
								for (String value : dataMap.get(entity)) {
									instance.addDatattypeProperty(entity, value);
								}
							}
							Map<EIEntity, Set<EIURI>> objMap = new HashMap<EIEntity, Set<EIURI>>();
							for (ListBox lb : objList) {
								String name = lb.getName();
								EIEntity entity = makeEntityFromWidgetName(name);
								if (!lb.getValue(lb.getSelectedIndex()).equals("")) {
									if (objMap.containsKey(entity)) {
										Set<EIURI> st = objMap.get(entity);
										st.add(EIURI.create(lb.getValue(lb.getSelectedIndex())));
									} else {
										Set<EIURI> st = new HashSet<EIURI>();
										st.add(EIURI.create(lb.getValue(lb.getSelectedIndex())));
										objMap.put(entity, st);
									}
								}
							}
							for (EIEntity entity : objMap.keySet()) {
								for (EIURI uri : objMap.get(entity)) {
									instance.addObjectProperty(entity, uri);
								}
							}
							ClientRepositoryToolsManager.INSTANCE.createInstance(instance, new NewInstanceCallback() {
								@Override
								public void onSuccess(Object o) {
									isDialog = false;
									if (dialogFormName != null && dialogFormName != "") {
										//lb.addItem(dialogFormName); 
										subClassList.clear();
										// Populate the list with the newly added resource
										ClientRepositoryToolsManager.INSTANCE.getResourcesOfClass(MainPanel.userUri, range.getEntity().getURI(), new EIInstancesCallback() {
											public void onSuccess(List<EIInstance> result) {
												for (EIInstance instance : result) {
													String instanceLabel = instance.getEntity().getLabel();
													subClassList.addItem(instanceLabel, instance.getInstanceURI().toString());
													if (dialogFormName.equals(instanceLabel)) {
														textBox.setValue(dialogFormName);
														subClassList.setSelectedIndex(subClassList.getItemCount() - 1);
														dialogFormName = "";
													}
												}
												// TODO: probably really replace
												if(oldValue!=null && !oldValue.equals("")) {
													parentInstance.replaceObjectPropertyValue(property, EIURI.create(oldValue.getValue()), instance.getInstanceURI());
												} else {
													parentInstance.addObjectProperty(property, instance.getInstanceURI());
												}
											}
											@Override
											public void loginRequired() {
												handleLoginRequired();
											}
										});
									}
									window.hide();
									dataList.clear();
									objList.clear();
								}
								@Override
								public void loginRequired() {
									handleLoginRequired();
								}
							});
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		int left = (Window.getClientWidth()) / 2;
		int top = (Window.getClientHeight()) / 3;
		window.setWidget(vPanel);
		window.setStyleName("dialogWindow");
		window.setPopupPosition(left, top);
		//window.
		window.show();
		Style style = window.getElement().getStyle();
		style.clearOverflow();
	}
	private void handleLoginRequired() {
		// TODO: what's the real behavior?
		Window.alert(WorkFlowConstants.PLEASE_LOGIN);
		// setLoggedOut();
	}
	/**
	 * @return
	 */
	private String formatText(String value) {
		if (value.indexOf("^") > 0) {
			return value.substring(0, value.indexOf("^"));
		}
		return value;
	}
	public boolean isFormValid() {
		if (isPhoneValid && isEmailValid) {
			return true;
		} else
			return false;
	}
	public void clearAll() {
		dataList.clear();
		objList.clear();
		//nonOntLiteralList.clear();
		//nonOntResourceList.clear();
		dataList.clear();
		objList.clear();
	}
	protected EIEntity makeEntityFromWidgetName(String name) {
		return EIEntity.create(name.substring(0, name.indexOf("|")), name.substring(name.indexOf("|") + 1));
	}
	private void doOnChange(final EIInstance instance, final EIClass range, final EIEntity propertyEntity, final String propertyValue, final ListBox subClassList, final TextBox valueBox, Hidden oldValue) {
		if (subClassList.getItemText(subClassList.getSelectedIndex()) == "<select>") {
			Window.alert(WorkFlowConstants.INVALID_VALUE + propertyEntity.getLabel());
		} else if (subClassList.getItemText(subClassList.getSelectedIndex()).equals("<create new>")) {
			frmPanel.onCreateNewClicked(instance, propertyEntity, range, subClassList, valueBox, oldValue);
		} else {
			Log.info("replacing object property value  for " + propertyEntity + " old value " + propertyValue + " new value " + subClassList.getValue(subClassList.getSelectedIndex()));
			instance.replaceObjectPropertyValue(propertyEntity, EIURI.create(getUriForValue(subClassList, valueBox.getText())), EIURI.create(subClassList.getValue(subClassList.getSelectedIndex())));
			Log.info("new object property value list is " + instance.getObjectProperty(propertyEntity));
			valueBox.setValue(getTextValue(subClassList));
		}
	}
	
	private String getTextValue(ListBox subClassList) {
		String currentValue = subClassList.getItemText(subClassList.getSelectedIndex());
		if (currentValue.indexOf(" <") < 0) {
			return currentValue;
		}
		return currentValue.substring(0, currentValue.indexOf(" <"));
	}
	protected void updateInstanceType(final EIInstance instance, final EIEntity newInstanceType, final EIClass newClass) {
		ClientOntologyToolsManager.INSTANCE.getProperties(newClass, new PropertyCallback() {
			@Override
			public void onSuccess(EIClass result) {
				ArrayList<EIEntity> classDatatypeProperties = new ArrayList<EIEntity>(result.getProperties().size());
				ArrayList<EIEntity> classObjectProperties = new ArrayList<EIEntity>(result.getProperties().size());
				
				for (EIProperty property : result.getProperties()) {
					if (property instanceof EIDatatypeProperty) {
						classDatatypeProperties.add(property.getEntity());
					}
					else if (property instanceof EIObjectProperty) {
						classObjectProperties.add(property.getEntity());
					}
				} 
				for (EIEntity datatypeProperty : instance.getDatatypeProperties().keySet()) {
					if (! classDatatypeProperties.contains(datatypeProperty)) {
						//Set<String> empty = Collections.emptySet();
						instance.replaceDatatypePropertyAllValues(datatypeProperty, null);
					}
					else {
						Log.info("found datatype property " + datatypeProperty);
					}
				}
				
				for (EIEntity objectProperty : instance.getObjectProperties().keySet()) {
					if (! classObjectProperties.contains(objectProperty)) {
						//Set<EIURI> empty = Collections.emptySet();
						instance.replaceObjectPropertyAllValues(objectProperty, null);
					}
					else {
						Log.info("found object property " + objectProperty);
					}
				}
				
				Log.info("updating instance type to " + newInstanceType);
				instance.setInstanceClass(result);
				instance.setInstanceType(newInstanceType);
			}
		}); 
		//instance.setInstanceType(newInstanceType);
	}
}
