package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EISuperClassCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;

public class ObjectWidget extends EditWidget {

	private ListBox rangePicker = new ListBox();
	private List<EIClass> rangeList = new ArrayList<EIClass>();
	private String selectedURI;
	private EIClass selectedClass;
	private EIClass instanceRootClass;
	private EditWidget innerWidget;
	
	private Map<EIURI,EIClass> uriRangeMap = new HashMap<EIURI,EIClass>();
	
	ObjectWidget(EIInstance eiInstance, EIEntity propertyEntity, List<EIClass>rangeList, String selectedUri) {
		super(eiInstance, propertyEntity);
		Log.info("range list has " + rangeList.size() + " entries");
		this.rangeList = rangeList;
		this.selectedURI = selectedUri;
		
		getInstanceRootClass(); 
		
	}

	private void setup() {
		widgetPanel.add(rangePicker);
		rangePicker.addItem("<select>",null);
		
		for(EIClass range:rangeList) {
			uriRangeMap.put(range.getEntity().getURI(), range);
			rangePicker.addItem(range.getEntity().getLabel(), range.getEntity().getURI().toString());
			if(instanceRootClass != null && range.getEntity().getURI().equals(instanceRootClass.getEntity().getURI())) {
				rangePicker.setSelectedIndex(rangePicker.getItemCount() - 1);
			}
		}
		
		if(rangePicker.getSelectedIndex()>0) {
			EIURI selectedRange = getSelectedRangeUri();
			if (uriRangeMap.get(selectedRange).isEagleIResource()) {
				innerWidget = new EIResourceWidget(eiInstance, propertyEntity, instanceRootClass, selectedURI, false);
				widgetPanel.add(innerWidget);
			}
			else {
				innerWidget = new TermWidget(eiInstance, propertyEntity, instanceRootClass, selectedClass, false);
				widgetPanel.add(innerWidget);
			}
		} 
		
		rangePicker.addChangeHandler(new ChangeHandler() { 
			@Override
			public void onChange(ChangeEvent arg0) {
				if (rangePicker.getItemText(rangePicker.getSelectedIndex()).equals("<select>")) {
					if (hasOldValue())
						removeValue();
				} else {
					if(widgetPanel.getWidgetCount()>2) {
						if (getInnerWidget().hasOldValue())
							eiInstance.replaceObjectPropertyValue(propertyEntity, getInnerWidget().getOldEIURIValue(), null);
						widgetPanel.remove(2);
						innerWidget = null;
					}
					EIURI selectedRange = getSelectedRangeUri();
					updateOldValue(selectedRange);
					if(uriRangeMap.get(selectedRange).isEagleIResource()) {
						innerWidget = new EIResourceWidget(eiInstance, propertyEntity, uriRangeMap.get(selectedRange), "", false);
						widgetPanel.add(innerWidget);
					} else {
						EIClass range = uriRangeMap.get(selectedRange);
						final HorizontalPanel tempPanel = new HorizontalPanel();
						widgetPanel.add(tempPanel);
						
						// TODO: inner callback to set the inner panel to the term widget created this way
						WidgetUtils.addTermWidgetToPanel(eiInstance, propertyEntity, range, selectedURI, tempPanel, false);
					}
				}
			}
		});
	}

	private void getInstanceRootClass() {
		if (selectedURI == null || selectedURI.equals("")){
			setup();
			return;
		}
		
		if (WidgetUtils.isInstanceUri(selectedURI)) {
			ClientRepositoryToolsManager.INSTANCE.getRootSuperclassForInstanceUri(EIURI.create(selectedURI), new EIClassCallback(){
				@Override
				public void onSuccess(EIClass result) {
					instanceRootClass = result;
					setup();
				}
				
				@Override
				public void onFailure(String result) {
					Log.error("Server call getRootSuperclassForInstanceUri failed : "+result);
					setup();
				}
				
			});
		}
		else {
			Log.info("in getInstanceRootClass for " + selectedURI);
			ClientOntologyToolsManager.INSTANCE.getEIClass(EIURI.create(selectedURI), new EIClassCallback() {
				
				@Override
				public void onSuccess(EIClass result) {
					selectedClass = result;
					ClientOntologyToolsManager.INSTANCE.getRootSuperClass(result, new EISuperClassCallback() {					
						@Override
						public void onSuccess(EIClass superclass) {
							instanceRootClass = superclass;
							setup();
						}
					});
				}
				
				@Override
				public void onFailure(String result) {
					Log.error("Server getEIClass call failed : "+result);
					setup();
				}
			});
		}
	}

	private EIURI getSelectedRangeUri() {
		return WidgetUtils.getSelectedUri(rangePicker);
	}
	
	protected EditWidget getInnerWidget() {
		if (innerWidget != null)
			return innerWidget;
		else if (widgetPanel.getWidgetCount() > 2){ 
			Widget widget = widgetPanel.getWidget(2);
			if (widget instanceof HorizontalPanel) {
				widget = ((HorizontalPanel)widget).getWidget(0); // ?
			}
			
			if (widget instanceof EditWidget) {
				EditWidget inner = ((EditWidget) widget);
				return inner;
			} else {
				Window.alert("you failed to get an editWidget, dummy!"); // TODO: remove
			}
		}
		
		return null;
	}
	
	@Override
	protected void removeValue() {
		getInnerWidget().removeValue();
	}

	@Override
	public EditWidget duplicateBlank() {
		return new ObjectWidget(eiInstance, propertyEntity, rangeList, "");
	}
}
